/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.src.client.player.EntityPlayerSP;
import net.minecraft.src.client.renderer.RenderBlocks;
import net.minecraft.src.client.renderer.RenderHelper;
import net.minecraft.src.client.renderer.Tessellator;
import net.minecraft.src.client.renderer.TextureDimensions;
import net.minecraft.src.client.renderer.entity.Render;
import net.minecraft.src.client.renderer.entity.RenderManager;
import net.minecraft.src.client.renderer.entity.RenderPlayer;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.entity.player.EnumPlayerAction;
import net.minecraft.src.game.item.EnumAction;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.map.MapData;
import net.minecraft.src.game.level.map.MapItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderer {
    private Minecraft mc;
    private ItemStack itemToRender = null;
    private float equippedProgress = 0.0f;
    private float prevEquippedProgress = 0.0f;
    private RenderBlocks renderBlocksInstance = new RenderBlocks();
    private MapItemRenderer field_28131_f;
    private int field_20099_f = -1;

    public ItemRenderer(Minecraft var1) {
        this.mc = var1;
        this.field_28131_f = new MapItemRenderer(var1.fontRenderer, var1.gameSettings, var1.renderEngine);
    }

    public void renderItem(EntityLiving var1, ItemStack var2, int i) {
        GL11.glPushMatrix();
        if (var2.itemID < 256 && RenderBlocks.renderItemIn3d(Block.blocksList[var2.itemID].getRenderType())) {
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            this.renderBlocksInstance.renderBlockOnInventory(Block.blocksList[var2.itemID], var2.getItemDamage(), var1.getEntityBrightness(1.0f));
        } else {
            if (var2.itemID < 256) {
                GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            } else {
                GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/items.png"));
            }
            Tessellator tessellator = Tessellator.instance;
            int j = var1.getItemIcon(var2, i);
            float f = ((float)(j % 16 * 16) + 0.0f) / 256.0f;
            float f1 = ((float)(j % 16 * 16) + 15.99f) / 256.0f;
            float f2 = ((float)(j / 16 * 16) + 0.0f) / 512.0f;
            float f3 = ((float)(j / 16 * 16) + 15.99f) / 512.0f;
            float f4 = 0.0f;
            float f5 = 0.3f;
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)(-f4), (float)(-f5), (float)0.0f);
            float f6 = 1.5f;
            GL11.glScalef((float)f6, (float)f6, (float)f6);
            GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
            this.func_40686_a(tessellator, f1, f2, f, f3);
            boolean enableGlow = false;
            if (var2 != null && i == 0 && enableGlow) {
                GL11.glDepthFunc((int)514);
                GL11.glDisable((int)2896);
                this.mc.renderEngine.bindTexture(this.mc.renderEngine.getTexture("%blur%/armor/power.png"));
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
                float f7 = 0.76f;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glMatrixMode((int)5890);
                GL11.glPushMatrix();
                float f8 = 0.3f;
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                float f9 = (float)(System.currentTimeMillis() % 3000L) / 3000.0f * 8.0f;
                GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.func_40686_a(tessellator, 0.0f, 0.0f, 1.0f, 1.0f);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                f9 = (float)(System.currentTimeMillis() % 4873L) / 4873.0f * 8.0f;
                GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.func_40686_a(tessellator, 0.0f, 0.0f, 1.0f, 1.0f);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
                GL11.glDepthFunc((int)515);
            }
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
    }

    private void func_40686_a(Tessellator tessellator, float f, float f1, float f2, float f3) {
        float f4 = 1.0f;
        float f5 = 0.0625f;
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, f, f3);
        tessellator.addVertexWithUV(f4, 0.0, 0.0, f2, f3);
        tessellator.addVertexWithUV(f4, 1.0, 0.0, f2, f1);
        tessellator.addVertexWithUV(0.0, 1.0, 0.0, f, f1);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        tessellator.addVertexWithUV(0.0, 1.0, 0.0f - f5, f, f1);
        tessellator.addVertexWithUV(f4, 1.0, 0.0f - f5, f2, f1);
        tessellator.addVertexWithUV(f4, 0.0, 0.0f - f5, f2, f3);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0f - f5, f, f3);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        int i = 0;
        while (i < 16) {
            float f6 = (float)i / 16.0f;
            float f10 = f + (f2 - f) * f6 - 9.765625E-4f;
            float f14 = f4 * f6;
            tessellator.addVertexWithUV(f14, 0.0, 0.0f - f5, f10, f3);
            tessellator.addVertexWithUV(f14, 0.0, 0.0, f10, f3);
            tessellator.addVertexWithUV(f14, 1.0, 0.0, f10, f1);
            tessellator.addVertexWithUV(f14, 1.0, 0.0f - f5, f10, f1);
            ++i;
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        int j = 0;
        while (j < 16) {
            float f7 = (float)j / 16.0f;
            float f11 = f + (f2 - f) * f7 - 9.765625E-4f;
            float f15 = f4 * f7 + 0.0625f;
            tessellator.addVertexWithUV(f15, 1.0, 0.0f - f5, f11, f1);
            tessellator.addVertexWithUV(f15, 1.0, 0.0, f11, f1);
            tessellator.addVertexWithUV(f15, 0.0, 0.0, f11, f3);
            tessellator.addVertexWithUV(f15, 0.0, 0.0f - f5, f11, f3);
            ++j;
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        int k = 0;
        while (k < 16) {
            float f8 = (float)k / 16.0f;
            float f12 = f3 + (f1 - f3) * f8 - 9.765625E-4f;
            float f16 = f4 * f8 + 0.0625f;
            tessellator.addVertexWithUV(0.0, f16, 0.0, f, f12);
            tessellator.addVertexWithUV(f4, f16, 0.0, f2, f12);
            tessellator.addVertexWithUV(f4, f16, 0.0f - f5, f2, f12);
            tessellator.addVertexWithUV(0.0, f16, 0.0f - f5, f, f12);
            ++k;
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        int l = 0;
        while (l < 16) {
            float f9 = (float)l / 16.0f;
            float f13 = f3 + (f1 - f3) * f9 - 9.765625E-4f;
            float f17 = f4 * f9;
            tessellator.addVertexWithUV(f4, f17, 0.0, f2, f13);
            tessellator.addVertexWithUV(0.0, f17, 0.0, f, f13);
            tessellator.addVertexWithUV(0.0, f17, 0.0f - f5, f, f13);
            tessellator.addVertexWithUV(f4, f17, 0.0f - f5, f2, f13);
            ++l;
        }
        tessellator.draw();
    }

    public void renderItemPotion(EntityLiving var1, ItemStack var2, int i) {
        GL11.glPushMatrix();
        if (var2.itemID < 256 && RenderBlocks.renderItemIn3d(Block.blocksList[var2.itemID].getRenderType())) {
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            this.renderBlocksInstance.renderBlockOnInventory(Block.blocksList[var2.itemID], var2.getItemDamage(), var1.getEntityBrightness(1.0f));
        } else {
            float var17;
            float var16;
            float var15;
            if (var2.itemID < 256) {
                GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            } else {
                GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/items.png"));
            }
            Tessellator var3 = Tessellator.instance;
            int var4 = 259;
            float var5 = ((float)(var4 % 16 * 16) + 0.0f) / 256.0f;
            float var6 = ((float)(var4 % 16 * 16) + 15.99f) / 256.0f;
            float var7 = ((float)(var4 / 16 * 16) + 0.0f) / 512.0f;
            float var8 = ((float)(var4 / 16 * 16) + 15.99f) / 512.0f;
            float var9 = 1.0f;
            float var10 = 0.0f;
            float var11 = 0.3f;
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)(-var10), (float)(-var11), (float)0.0f);
            float var12 = 1.5f;
            boolean blocking = false;
            if (var1 instanceof EntityPlayer) {
                blocking = ((EntityPlayer)var1).getAction().equals((Object)EnumPlayerAction.BLOCKING);
                var12 = 1.75f;
            } else {
                var12 = 1.5f;
            }
            GL11.glScalef((float)var12, (float)var12, (float)var12);
            if (blocking) {
                GL11.glTranslatef((float)-0.76f, (float)0.01f, (float)-0.5f);
                GL11.glRotatef((float)-70.0f, (float)1.0f, (float)2.0f, (float)0.0f);
            } else {
                GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
            }
            float var13 = 0.0625f;
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 0.0f, 1.0f);
            var3.addVertexWithUV(0.0, 0.0, 0.0, var6, var8);
            var3.addVertexWithUV(var9, 0.0, 0.0, var5, var8);
            var3.addVertexWithUV(var9, 1.0, 0.0, var5, var7);
            var3.addVertexWithUV(0.0, 1.0, 0.0, var6, var7);
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 0.0f, -1.0f);
            var3.addVertexWithUV(0.0, 1.0, 0.0f - var13, var6, var7);
            var3.addVertexWithUV(var9, 1.0, 0.0f - var13, var5, var7);
            var3.addVertexWithUV(var9, 0.0, 0.0f - var13, var5, var8);
            var3.addVertexWithUV(0.0, 0.0, 0.0f - var13, var6, var8);
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(-1.0f, 0.0f, 0.0f);
            int var14 = 0;
            while (var14 < 16) {
                var15 = (float)var14 / 16.0f;
                var16 = var6 + (var5 - var6) * var15 - 0.001953125f;
                var17 = var9 * var15;
                var3.addVertexWithUV(var17, 0.0, 0.0f - var13, var16, var8);
                var3.addVertexWithUV(var17, 0.0, 0.0, var16, var8);
                var3.addVertexWithUV(var17, 1.0, 0.0, var16, var7);
                var3.addVertexWithUV(var17, 1.0, 0.0f - var13, var16, var7);
                ++var14;
            }
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(1.0f, 0.0f, 0.0f);
            var14 = 0;
            while (var14 < 16) {
                var15 = (float)var14 / 16.0f;
                var16 = var6 + (var5 - var6) * var15 - 0.001953125f;
                var17 = var9 * var15 + 0.0625f;
                var3.addVertexWithUV(var17, 1.0, 0.0f - var13, var16, var7);
                var3.addVertexWithUV(var17, 1.0, 0.0, var16, var7);
                var3.addVertexWithUV(var17, 0.0, 0.0, var16, var8);
                var3.addVertexWithUV(var17, 0.0, 0.0f - var13, var16, var8);
                ++var14;
            }
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 1.0f, 0.0f);
            var14 = 0;
            while (var14 < 16) {
                var15 = (float)var14 / 16.0f;
                var16 = var8 + (var7 - var8) * var15 - 9.765625E-4f;
                var17 = var9 * var15 + 0.0625f;
                var3.addVertexWithUV(0.0, var17, 0.0, var6, var16);
                var3.addVertexWithUV(var9, var17, 0.0, var5, var16);
                var3.addVertexWithUV(var9, var17, 0.0f - var13, var5, var16);
                var3.addVertexWithUV(0.0, var17, 0.0f - var13, var6, var16);
                ++var14;
            }
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, -1.0f, 0.0f);
            var14 = 0;
            while (var14 < 16) {
                var15 = (float)var14 / 16.0f;
                var16 = var8 + (var7 - var8) * var15 - 9.765625E-4f;
                var17 = var9 * var15;
                var3.addVertexWithUV(var9, var17, 0.0, var5, var16);
                var3.addVertexWithUV(0.0, var17, 0.0, var6, var16);
                var3.addVertexWithUV(0.0, var17, 0.0f - var13, var6, var16);
                var3.addVertexWithUV(var9, var17, 0.0f - var13, var5, var16);
                ++var14;
            }
            var3.draw();
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
    }

    public void renderItemInFirstPerson(float var1) {
        float var10;
        float var9;
        float var8;
        float var70;
        Object var5;
        float var2 = this.prevEquippedProgress + (this.equippedProgress - this.prevEquippedProgress) * var1;
        EntityPlayerSP var3 = this.mc.thePlayer;
        float var4 = var3.prevRotationPitch + (var3.rotationPitch - var3.prevRotationPitch) * var1;
        GL11.glPushMatrix();
        GL11.glRotatef((float)var4, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(var3.prevRotationYaw + (var3.rotationYaw - var3.prevRotationYaw) * var1), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.enableStandardItemLighting();
        GL11.glPopMatrix();
        if (var3 instanceof EntityPlayerSP) {
            var5 = var3;
            float var60 = ((EntityPlayerSP)var5).prevRotationPitch + (((EntityPlayerSP)var5).rotationPitch - ((EntityPlayerSP)var5).prevRotationPitch) * var1;
            var70 = ((EntityPlayerSP)var5).prevRotationYaw + (((EntityPlayerSP)var5).rotationYaw - ((EntityPlayerSP)var5).prevRotationYaw) * var1;
            GL11.glRotatef((float)((var3.rotationPitch - var60) * 0.1f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)((var3.rotationYaw - var70) * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        var5 = this.itemToRender;
        float var6 = this.mc.theWorld.getLightBrightness(MathHelper.floor_double(var3.posX), MathHelper.floor_double(var3.posY), MathHelper.floor_double(var3.posZ));
        if (var5 != null) {
            int var7 = Item.itemsList[((ItemStack)var5).itemID].getColorFromDamage(((ItemStack)var5).getItemDamage());
            var8 = (float)(var7 >> 16 & 0xFF) / 255.0f;
            var9 = (float)(var7 >> 8 & 0xFF) / 255.0f;
            var10 = (float)(var7 & 0xFF) / 255.0f;
            GL11.glColor4f((float)(var6 * var8), (float)(var6 * var9), (float)(var6 * var10), (float)1.0f);
        } else {
            GL11.glColor4f((float)var6, (float)var6, (float)var6, (float)1.0f);
        }
        if (var5 != null && ((ItemStack)var5).itemID == Item.mapItem.itemID) {
            GL11.glPushMatrix();
            float var14 = 0.8f;
            var8 = var3.getSwingProgress(var1);
            var9 = MathHelper.sin(var8 * (float)Math.PI);
            var10 = MathHelper.sin(MathHelper.sqrt_float(var8) * (float)Math.PI);
            GL11.glTranslatef((float)(-var10 * 0.4f), (float)(MathHelper.sin(MathHelper.sqrt_float(var8) * (float)Math.PI * 2.0f) * 0.2f), (float)(-var9 * 0.2f));
            var8 = 1.0f - var4 / 45.0f + 0.1f;
            if (var8 < 0.0f) {
                var8 = 0.0f;
            }
            if (var8 > 1.0f) {
                var8 = 1.0f;
            }
            var8 = -MathHelper.cos(var8 * (float)Math.PI) * 0.5f + 0.5f;
            GL11.glTranslatef((float)0.0f, (float)(0.0f * var14 - (1.0f - var2) * 1.2f - var8 * 0.5f + 0.04f), (float)(-0.9f * var14));
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(var8 * -85.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glEnable((int)32826);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTextureForDownloadableImage(this.mc.thePlayer.skinUrl, this.mc.thePlayer.getEntityTexture()));
            int var17 = 0;
            while (var17 < 2) {
                int var21 = var17 * 2 - 1;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)-0.0f, (float)-0.6f, (float)(1.1f * (float)var21));
                GL11.glRotatef((float)(-45 * var21), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)59.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(-65 * var21), (float)0.0f, (float)1.0f, (float)0.0f);
                Render var11 = RenderManager.instance.getEntityRenderObject(this.mc.thePlayer);
                RenderPlayer var12 = (RenderPlayer)var11;
                float var13 = 1.0f;
                GL11.glScalef((float)var13, (float)var13, (float)var13);
                var12.drawFirstPersonHand(this.mc.thePlayer);
                GL11.glPopMatrix();
                ++var17;
            }
            var9 = var3.getSwingProgress(var1);
            var10 = MathHelper.sin(var9 * var9 * (float)Math.PI);
            float var18 = MathHelper.sin(MathHelper.sqrt_float(var9) * (float)Math.PI);
            GL11.glRotatef((float)(-var10 * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-var18 * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-var18 * 80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            var9 = 0.38f;
            GL11.glScalef((float)var9, (float)var9, (float)var9);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-1.0f, (float)-1.0f, (float)0.0f);
            var10 = 0.015625f;
            GL11.glScalef((float)var10, (float)var10, (float)var10);
            this.mc.renderEngine.bindTexture(this.mc.renderEngine.getTexture("/misc/mapbg.png"));
            Tessellator var19 = Tessellator.instance;
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            var19.startDrawingQuads();
            int var20 = 7;
            var19.addVertexWithUV(0 - var20, 128 + var20, 0.0, 0.0, 1.0);
            var19.addVertexWithUV(128 + var20, 128 + var20, 0.0, 1.0, 1.0);
            var19.addVertexWithUV(128 + var20, 0 - var20, 0.0, 1.0, 0.0);
            var19.addVertexWithUV(0 - var20, 0 - var20, 0.0, 0.0, 0.0);
            var19.draw();
            MapData var22 = Item.mapItem.func_28012_a((ItemStack)var5, this.mc.theWorld);
            this.field_28131_f.func_28157_a(this.mc.thePlayer, this.mc.renderEngine, var22);
            GL11.glPopMatrix();
        } else if (var5 != null && ((ItemStack)var5).itemID == Item.potion.itemID) {
            GL11.glPushMatrix();
            float var14 = 0.8f;
            var8 = var3.getSwingProgress(var1);
            var9 = MathHelper.sin(var8 * (float)Math.PI);
            var10 = MathHelper.sin(MathHelper.sqrt_float(var8) * (float)Math.PI);
            GL11.glTranslatef((float)(-var10 * 0.4f), (float)(MathHelper.sin(MathHelper.sqrt_float(var8) * (float)Math.PI * 2.0f) * 0.2f), (float)(-var9 * 0.2f));
            GL11.glTranslatef((float)(0.7f * var14), (float)(-0.65f * var14 - (1.0f - var2) * 0.6f), (float)(-0.9f * var14));
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)32826);
            var8 = var3.getSwingProgress(var1);
            var9 = MathHelper.sin(var8 * var8 * (float)Math.PI);
            var10 = MathHelper.sin(MathHelper.sqrt_float(var8) * (float)Math.PI);
            GL11.glRotatef((float)(-var9 * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-var10 * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-var10 * 80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            var8 = 0.4f;
            GL11.glScalef((float)var8, (float)var8, (float)var8);
            if (((ItemStack)var5).getItem().shouldRotateAroundWhenRendering()) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            this.renderItem(var3, (ItemStack)var5, 0);
            GL11.glColor4f((float)var6, (float)var6, (float)var6, (float)1.0f);
            this.renderItemPotion(var3, (ItemStack)var5, 0);
            GL11.glPopMatrix();
        } else if (var5 != null) {
            float var12;
            float var18;
            GL11.glPushMatrix();
            var70 = 0.8f;
            if (var3.getItemInUseCount() > 0) {
                EnumAction var17 = ((ItemStack)var5).getItemUseAction();
                if (var17 == EnumAction.eat || var17 == EnumAction.drink) {
                    var18 = (float)var3.getItemInUseCount() - var1 + 1.0f;
                    var10 = 1.0f - var18 / (float)((ItemStack)var5).getMaxItemUseDuration();
                    var12 = 1.0f - var10;
                    var12 = var12 * var12 * var12;
                    var12 = var12 * var12 * var12;
                    var12 = var12 * var12 * var12;
                    float var13 = 1.0f - var12;
                    GL11.glTranslatef((float)0.0f, (float)(MathHelper.abs(MathHelper.cos(var18 / 4.0f * (float)Math.PI) * 0.1f) * (float)((double)var10 > 0.2 ? 1 : 0)), (float)0.0f);
                    GL11.glTranslatef((float)(var13 * 0.6f), (float)(-var13 * 0.5f), (float)0.0f);
                    GL11.glRotatef((float)(var13 * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(var13 * 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)(var13 * 30.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
            } else {
                var8 = var3.getSwingProgress(var1);
                var18 = MathHelper.sin(var8 * (float)Math.PI);
                var10 = MathHelper.sin(MathHelper.sqrt_float(var8) * (float)Math.PI);
                GL11.glTranslatef((float)(-var10 * 0.4f), (float)(MathHelper.sin(MathHelper.sqrt_float(var8) * (float)Math.PI * 2.0f) * 0.2f), (float)(-var18 * 0.2f));
            }
            GL11.glTranslatef((float)(0.7f * var70), (float)(-0.65f * var70 - (1.0f - var2) * 0.6f), (float)(-0.9f * var70));
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)32826);
            var8 = var3.getSwingProgress(var1);
            var18 = MathHelper.sin(var8 * var8 * (float)Math.PI);
            var10 = MathHelper.sin(MathHelper.sqrt_float(var8) * (float)Math.PI);
            GL11.glRotatef((float)(-var18 * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-var10 * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-var10 * 80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            var8 = 0.4f;
            GL11.glScalef((float)var8, (float)var8, (float)var8);
            if (var3.getItemInUseCount() > 0) {
                EnumAction var20 = ((ItemStack)var5).getItemUseAction();
                if (var20 == EnumAction.block) {
                    GL11.glTranslatef((float)-0.5f, (float)0.2f, (float)0.0f);
                    GL11.glRotatef((float)30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)-80.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                } else if (var20 == EnumAction.bow) {
                    GL11.glRotatef((float)-18.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)-12.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)-8.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)-0.9f, (float)0.2f, (float)0.0f);
                    var10 = (float)((ItemStack)var5).getMaxItemUseDuration() - ((float)var3.getItemInUseCount() - var1 + 1.0f);
                    float var14 = var10 / 20.0f;
                    var14 = (var14 * var14 + var14 * 2.0f) / 3.0f;
                    if (var14 > 1.0f) {
                        var14 = 1.0f;
                    }
                    if (var14 > 0.1f) {
                        GL11.glTranslatef((float)0.0f, (float)(MathHelper.sin((var10 - 0.1f) * 1.3f) * 0.01f * (var14 - 0.1f)), (float)0.0f);
                    }
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(var14 * 0.1f));
                    GL11.glRotatef((float)-335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)-50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
                    var12 = 1.0f + var14 * 0.2f;
                    GL11.glScalef((float)1.0f, (float)1.0f, (float)var12);
                    GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
                    GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
            }
            if (((ItemStack)var5).getItem().shouldRotateAroundWhenRendering()) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            this.renderItem(var3, (ItemStack)var5, 0);
            GL11.glPopMatrix();
        } else {
            GL11.glPushMatrix();
            float var14 = 0.8f;
            var8 = var3.getSwingProgress(var1);
            var9 = MathHelper.sin(var8 * (float)Math.PI);
            var10 = MathHelper.sin(MathHelper.sqrt_float(var8) * (float)Math.PI);
            GL11.glTranslatef((float)(-var10 * 0.3f), (float)(MathHelper.sin(MathHelper.sqrt_float(var8) * (float)Math.PI * 2.0f) * 0.4f), (float)(-var9 * 0.4f));
            GL11.glTranslatef((float)(0.8f * var14), (float)(-0.75f * var14 - (1.0f - var2) * 0.6f), (float)(-0.9f * var14));
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)32826);
            var8 = var3.getSwingProgress(var1);
            var9 = MathHelper.sin(var8 * var8 * (float)Math.PI);
            var10 = MathHelper.sin(MathHelper.sqrt_float(var8) * (float)Math.PI);
            GL11.glRotatef((float)(var10 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-var9 * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTextureForDownloadableImage(this.mc.thePlayer.skinUrl, this.mc.thePlayer.getEntityTexture()));
            GL11.glTranslatef((float)-1.0f, (float)3.6f, (float)3.5f);
            GL11.glRotatef((float)120.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)5.6f, (float)0.0f, (float)0.0f);
            Render var15 = RenderManager.instance.getEntityRenderObject(this.mc.thePlayer);
            RenderPlayer var16 = (RenderPlayer)var15;
            var10 = 1.0f;
            GL11.glScalef((float)var10, (float)var10, (float)var10);
            var16.drawFirstPersonHand(this.mc.thePlayer);
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)32826);
        RenderHelper.disableStandardItemLighting();
    }

    public void renderOverlays(float var1) {
        int var2;
        GL11.glDisable((int)3008);
        if (this.mc.thePlayer.isBurning()) {
            var2 = this.mc.renderEngine.getTexture("/terrain.png");
            GL11.glBindTexture((int)3553, (int)var2);
            this.renderFireInFirstPerson(var1);
        }
        if (this.mc.thePlayer.isInsideOfMaterial(Material.water)) {
            var2 = this.mc.renderEngine.getTexture("/misc/water.png");
            GL11.glBindTexture((int)3553, (int)var2);
            this.renderWarpedTextureOverlay(var1);
        }
        GL11.glEnable((int)3008);
    }

    private void renderInsideOfBlock(float var1, Block var2) {
        Tessellator tessellator = Tessellator.instance;
        float f1 = 0.0f;
        f1 = 1.0f;
        GL11.glColor4f((float)f1, (float)f1, (float)f1, (float)0.5f);
        GL11.glPushMatrix();
        float f2 = -1.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        float f5 = 1.0f;
        float f6 = -0.5f;
        float f7 = 0.0f;
        float f8 = (float)(var2.blockIndexInTexture % 16) / 256.0f - f7;
        float f9 = ((float)(var2.blockIndexInTexture % 16) + 15.99f) / 256.0f + f7;
        float f10 = (float)(var2.blockIndexInTexture / 16) / 256.0f - f7;
        float f11 = ((float)(var2.blockIndexInTexture / 16) + 15.99f) / 256.0f + f7;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(f2, f4, f6, f9, f11);
        tessellator.addVertexWithUV(f3, f4, f6, f8, f11);
        tessellator.addVertexWithUV(f3, f5, f6, f8, f10);
        tessellator.addVertexWithUV(f2, f5, f6, f9, f10);
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderWarpedTextureOverlay(float var1) {
        Tessellator var2 = Tessellator.instance;
        float var3 = this.mc.thePlayer.getEntityBrightness(var1);
        GL11.glColor4f((float)var3, (float)var3, (float)var3, (float)0.5f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        float var4 = 4.0f;
        float var5 = -1.0f;
        float var6 = 1.0f;
        float var7 = -1.0f;
        float var8 = 1.0f;
        float var9 = -0.5f;
        float var10 = -this.mc.thePlayer.rotationYaw / 64.0f;
        float var11 = this.mc.thePlayer.rotationPitch / 64.0f;
        var2.startDrawingQuads();
        var2.addVertexWithUV(var5, var7, var9, var4 + var10, var4 + var11);
        var2.addVertexWithUV(var6, var7, var9, 0.0f + var10, var4 + var11);
        var2.addVertexWithUV(var6, var8, var9, 0.0f + var10, 0.0f + var11);
        var2.addVertexWithUV(var5, var8, var9, var4 + var10, 0.0f + var11);
        var2.draw();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    private void renderFireInFirstPerson(float var1) {
        Tessellator var2 = Tessellator.instance;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float var3 = 1.0f;
        int var4 = 0;
        while (var4 < 2) {
            GL11.glPushMatrix();
            int var5 = Block.fire.blockIndexInTexture + var4 * 16;
            int var6 = (var5 & 0xF) << 4;
            int var7 = var5 & TextureDimensions.ATLAS;
            float var8 = (float)var6 / TextureDimensions.WIDTH;
            float var9 = ((float)var6 + 15.99f) / TextureDimensions.WIDTH;
            float var10 = (float)var7 / TextureDimensions.HEIGHT;
            float var11 = ((float)var7 + 15.99f) / TextureDimensions.HEIGHT;
            float var12 = (0.0f - var3) / 2.0f;
            float var13 = var12 + var3;
            float var14 = 0.0f - var3 / 2.0f;
            float var15 = var14 + var3;
            float var16 = -0.5f;
            GL11.glTranslatef((float)((float)(-(var4 * 2 - 1)) * 0.24f), (float)-0.3f, (float)0.0f);
            GL11.glRotatef((float)((float)(var4 * 2 - 1) * 10.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            var2.startDrawingQuads();
            var2.addVertexWithUV(var12, var14, var16, var9, var11);
            var2.addVertexWithUV(var13, var14, var16, var8, var11);
            var2.addVertexWithUV(var13, var15, var16, var8, var10);
            var2.addVertexWithUV(var12, var15, var16, var9, var10);
            var2.draw();
            GL11.glPopMatrix();
            ++var4;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    public void updateEquippedItem() {
        float var5;
        float var6;
        float var7;
        boolean var4;
        this.prevEquippedProgress = this.equippedProgress;
        EntityPlayerSP var1 = this.mc.thePlayer;
        ItemStack var2 = var1.inventory.getCurrentItem();
        boolean bl = var4 = this.field_20099_f == var1.inventory.currentItem && var2 == this.itemToRender;
        if (this.itemToRender == null && var2 == null) {
            var4 = true;
        }
        if (var2 != null && this.itemToRender != null && var2 != this.itemToRender && var2.itemID == this.itemToRender.itemID && var2.getItemDamage() == this.itemToRender.getItemDamage()) {
            this.itemToRender = var2;
            var4 = true;
        }
        if ((var7 = (var6 = var4 ? 1.0f : 0.0f) - this.equippedProgress) < -(var5 = 0.4f)) {
            var7 = -var5;
        }
        if (var7 > var5) {
            var7 = var5;
        }
        this.equippedProgress += var7;
        if (this.equippedProgress < 0.1f) {
            this.itemToRender = var2;
            this.field_20099_f = var1.inventory.currentItem;
        }
    }

    public void func_9449_b() {
        this.equippedProgress = 0.0f;
    }

    public void func_9450_c() {
        this.equippedProgress = 0.0f;
    }

    public void renderItemBow(EntityLiving var1, ItemStack var2, int i) {
        GL11.glPushMatrix();
        if (var2.itemID < 256 && RenderBlocks.renderItemIn3d(Block.blocksList[var2.itemID].getRenderType())) {
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            this.renderBlocksInstance.renderBlockOnInventory(Block.blocksList[var2.itemID], var2.getItemDamage(), var1.getEntityBrightness(1.0f));
        } else {
            float var17;
            float var16;
            float var15;
            if (var2.itemID < 256) {
                GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            } else {
                GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/items.png"));
            }
            Tessellator var3 = Tessellator.instance;
            int var4 = var1.getItemIcon(var2, i);
            float var5 = ((float)(var4 % 16 * 16) + 0.0f) / 256.0f;
            float var6 = ((float)(var4 % 16 * 16) + 15.99f) / 256.0f;
            float var7 = ((float)(var4 / 16 * 16) + 0.0f) / 512.0f;
            float var8 = ((float)(var4 / 16 * 16) + 15.99f) / 512.0f;
            float var9 = 1.0f;
            float var10 = 0.0f;
            float var11 = 0.3f;
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)(-var10), (float)(-var11), (float)0.0f);
            float var12 = 1.5f;
            boolean blocking = false;
            if (var1 instanceof EntityPlayer) {
                blocking = ((EntityPlayer)var1).getAction().equals((Object)EnumPlayerAction.BOW);
                var12 = 10.75f;
            } else {
                var12 = 1.5f;
            }
            GL11.glScalef((float)var12, (float)var12, (float)var12);
            if (blocking) {
                GL11.glTranslatef((float)-0.76f, (float)1.0f, (float)-0.5f);
                GL11.glRotatef((float)-70.0f, (float)1.0f, (float)2.0f, (float)0.0f);
            } else {
                GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
            }
            float var13 = 0.0625f;
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 0.0f, 1.0f);
            var3.addVertexWithUV(0.0, 0.0, 0.0, var6, var8);
            var3.addVertexWithUV(var9, 0.0, 0.0, var5, var8);
            var3.addVertexWithUV(var9, 1.0, 0.0, var5, var7);
            var3.addVertexWithUV(0.0, 1.0, 0.0, var6, var7);
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 0.0f, -1.0f);
            var3.addVertexWithUV(0.0, 1.0, 0.0f - var13, var6, var7);
            var3.addVertexWithUV(var9, 1.0, 0.0f - var13, var5, var7);
            var3.addVertexWithUV(var9, 0.0, 0.0f - var13, var5, var8);
            var3.addVertexWithUV(0.0, 0.0, 0.0f - var13, var6, var8);
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(-1.0f, 0.0f, 0.0f);
            int var14 = 0;
            while (var14 < 16) {
                var15 = (float)var14 / 16.0f;
                var16 = var6 + (var5 - var6) * var15 - 0.001953125f;
                var17 = var9 * var15;
                var3.addVertexWithUV(var17, 0.0, 0.0f - var13, var16, var8);
                var3.addVertexWithUV(var17, 0.0, 0.0, var16, var8);
                var3.addVertexWithUV(var17, 1.0, 0.0, var16, var7);
                var3.addVertexWithUV(var17, 1.0, 0.0f - var13, var16, var7);
                ++var14;
            }
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(1.0f, 0.0f, 0.0f);
            var14 = 0;
            while (var14 < 16) {
                var15 = (float)var14 / 16.0f;
                var16 = var6 + (var5 - var6) * var15 - 0.001953125f;
                var17 = var9 * var15 + 0.0625f;
                var3.addVertexWithUV(var17, 1.0, 0.0f - var13, var16, var7);
                var3.addVertexWithUV(var17, 1.0, 0.0, var16, var7);
                var3.addVertexWithUV(var17, 0.0, 0.0, var16, var8);
                var3.addVertexWithUV(var17, 0.0, 0.0f - var13, var16, var8);
                ++var14;
            }
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 1.0f, 0.0f);
            var14 = 0;
            while (var14 < 16) {
                var15 = (float)var14 / 16.0f;
                var16 = var8 + (var7 - var8) * var15 - 9.765625E-4f;
                var17 = var9 * var15 + 0.0625f;
                var3.addVertexWithUV(0.0, var17, 0.0, var6, var16);
                var3.addVertexWithUV(var9, var17, 0.0, var5, var16);
                var3.addVertexWithUV(var9, var17, 0.0f - var13, var5, var16);
                var3.addVertexWithUV(0.0, var17, 0.0f - var13, var6, var16);
                ++var14;
            }
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, -1.0f, 0.0f);
            var14 = 0;
            while (var14 < 16) {
                var15 = (float)var14 / 16.0f;
                var16 = var8 + (var7 - var8) * var15 - 9.765625E-4f;
                var17 = var9 * var15;
                var3.addVertexWithUV(var9, var17, 0.0, var5, var16);
                var3.addVertexWithUV(0.0, var17, 0.0, var6, var16);
                var3.addVertexWithUV(0.0, var17, 0.0f - var13, var6, var16);
                var3.addVertexWithUV(var9, var17, 0.0f - var13, var5, var16);
                ++var14;
            }
            var3.draw();
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
    }
}

