/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.src.client.model.ModelBed;
import net.minecraft.src.client.renderer.EntityRenderer;
import net.minecraft.src.client.renderer.Tessellator;
import net.minecraft.src.client.renderer.Vec3D;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockAnvil;
import net.minecraft.src.game.block.BlockBed;
import net.minecraft.src.game.block.BlockDoor;
import net.minecraft.src.game.block.BlockFence;
import net.minecraft.src.game.block.BlockFluid;
import net.minecraft.src.game.block.BlockGearCircuit;
import net.minecraft.src.game.block.BlockGearRelay;
import net.minecraft.src.game.block.BlockPistonBase;
import net.minecraft.src.game.block.BlockPistonExtension;
import net.minecraft.src.game.block.BlockRail;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.tileentity.TileEntityCauldron;
import net.minecraft.src.game.effect.Effect;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;
import org.lwjgl.opengl.GL11;

public class RenderBlocks {
    private IBlockAccess blockAccess;
    private int overrideBlockTexture = -1;
    private boolean flipTexture = false;
    private boolean renderAllFaces = false;
    public static int distortion = 0;
    public boolean field_31088_b = true;
    private int uvRotateEast = 0;
    private int uvRotateWest = 0;
    private int uvRotateSouthFace = 0;
    private int uvRotateNorth = 0;
    private int uvRotateTop = 0;
    private int uvRotateBottom = 0;
    private boolean enableAO;
    private float lightValueOwn;
    private float aoLightValueXNeg;
    private float aoLightValueYNeg;
    private float aoLightValueZNeg;
    private float aoLightValueXPos;
    private float aoLightValueYPos;
    private float aoLightValueZPos;
    private float aoBrightnessXYZNNN;
    private float aoBrightnessXYNN;
    private float aoBrightnessXYZNNP;
    private float aoBrightnessYZNN;
    private float aoBrightnessYZNP;
    private float aoBrightnessXYZPNN;
    private float aoBrightnessXYPN;
    private float aoBrightnessXYZPNP;
    private float aoBrightnessXYZNPN;
    private float aoBrightnessXYNP;
    private float aoBrightnessXYZNPP;
    private float aoBrightnessYZPN;
    private float aoBrightnessXYZPPN;
    private float aoBrightnessXYPP;
    private float aoBrightnessYZPP;
    private float aoBrightnessXYZPPP;
    private float aoBrightnessXZNN;
    private float aoBrightnessXZPN;
    private float aoBrightnessXZNP;
    private float aoBrightnessXZPP;
    private int aoType = 1;
    private float colorRedTopLeft;
    private float colorRedBottomLeft;
    private float colorRedBottomRight;
    private float colorRedTopRight;
    private float colorGreenTopLeft;
    private float colorGreenBottomLeft;
    private float colorGreenBottomRight;
    private float colorGreenTopRight;
    private float colorBlueTopLeft;
    private float colorBlueBottomLeft;
    private float colorBlueBottomRight;
    private float colorBlueTopRight;
    private boolean aoGrassXYZCPN;
    private boolean aoGrassXYZPPC;
    private boolean aoGrassXYZNPC;
    private boolean aoGrassXYZCPP;
    private boolean aoGrassXYZNCN;
    private boolean aoGrassXYZPCP;
    private boolean aoGrassXYZNCP;
    private boolean aoGrassXYZPCN;
    private boolean aoGrassXYZCNN;
    private boolean aoGrassXYZPNC;
    private boolean aoGrassXYZNNC;
    private boolean aoGrassXYZCNP;

    public RenderBlocks(IBlockAccess var1) {
        this.blockAccess = var1;
    }

    public RenderBlocks() {
    }

    public void renderBlockUsingTexture(Block var1, int var2, int var3, int var4, int var5) {
        this.overrideBlockTexture = var5;
        this.renderBlockByRenderType(var1, var2, var3, var4);
        this.overrideBlockTexture = -1;
    }

    public void func_31075_a(Block var1, int var2, int var3, int var4) {
        this.renderAllFaces = true;
        this.renderBlockByRenderType(var1, var2, var3, var4);
        this.renderAllFaces = false;
    }

    public boolean renderBlockByRenderType(Block var1, int var2, int var3, int var4) {
        int var5 = var1.getRenderType();
        var1.setBlockBoundsBasedOnState(this.blockAccess, var2, var3, var4);
        if (var5 == 0) {
            return this.renderStandardBlock(var1, var2, var3, var4);
        }
        if (var5 == 4) {
            return this.renderBlockFluids(var1, var2, var3, var4);
        }
        if (var5 == 13) {
            return this.renderBlockCactus(var1, var2, var3, var4);
        }
        if (var5 == 1) {
            return this.renderBlockPlant(var1, var2, var3, var4);
        }
        if (var5 == 6) {
            return this.renderBlockCrops(var1, var2, var3, var4);
        }
        if (var5 == 2) {
            return this.renderBlockTorch(var1, var2, var3, var4);
        }
        if (var5 == 3) {
            return this.renderBlockFire(var1, var2, var3, var4);
        }
        if (var5 == 8) {
            return this.renderBlockLadder(var1, var2, var3, var4);
        }
        if (var5 == 7) {
            return this.renderBlockDoor(var1, var2, var3, var4);
        }
        if (var5 == 9) {
            return this.renderBlockMinecartTrack((BlockRail)var1, var2, var3, var4);
        }
        if (var5 == 10) {
            return this.renderBlockStairs(var1, var2, var3, var4);
        }
        if (var5 == 11) {
            return this.renderBlockFence((BlockFence)var1, var2, var3, var4);
        }
        if (var5 == 12) {
            return this.renderBlockLever(var1, var2, var3, var4);
        }
        if (var5 == 14) {
            return this.renderBlockBed(var1, var2, var3, var4);
        }
        if (var5 == 15) {
            return this.renderRelayAndTreadmill(var1, var2, var3, var4);
        }
        if (var5 == 16) {
            return this.renderDirectional(var1, var2, var3, var4, false);
        }
        if (var5 == 18) {
            return this.renderGearIThink(var1, var2, var3, var4);
        }
        if (var5 == 25) {
            return this.renderGearPowered(var1, var2, var3, var4);
        }
        if (var5 == 20) {
            return this.renderBlockBush(var1, var2, var3, var4);
        }
        if (var5 == 21) {
            return this.renderBlockLilyPadWithFlower(var1, var2, var3, var4);
        }
        if (var5 == 22) {
            return this.renderBlockLilyPad(var1, var2, var3, var4);
        }
        if (var5 == 23) {
            return this.renderBlockLeafPile(var1, var2, var3, var4);
        }
        if (var5 == 24) {
            return this.renderBlockShelfMushroom(var1, var2, var3, var4);
        }
        if (var5 == 26) {
            return this.renderBlockLavender(var1, var2, var3, var4);
        }
        if (var5 == 27) {
            return this.renderBlockBouquet(var1, var2, var3, var4);
        }
        if (var5 == 28) {
            return this.renderBlockAlwaysLit(var1, var2, var3, var4);
        }
        if (var5 == 30) {
            return this.renderCampfire(var1, var2, var3, var4);
        }
        if (var5 == 31) {
            return this.renderBlockFourLeafClover(var1, var2, var3, var4);
        }
        if (var5 == 69) {
            return this.renderCauldron(var1, var2, var3, var4);
        }
        if (var5 == 35) {
            return this.renderBlockAnvil((BlockAnvil)var1, var2, var3, var4);
        }
        return var5 == 17 ? this.func_31080_c(var1, var2, var3, var4, true) : false;
    }

    private boolean renderBlockBed(Block var1, int var2, int var3, int var4) {
        float var66;
        Tessellator var5 = Tessellator.instance;
        int var6 = this.blockAccess.getBlockMetadata(var2, var3, var4);
        int var7 = BlockBed.getDirectionFromMetadata(var6);
        boolean var8 = BlockBed.isBlockFootOfBed(var6);
        float var9 = 0.5f;
        float var10 = 1.0f;
        float var11 = 0.8f;
        float var12 = 0.6f;
        float var25 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4);
        var5.setColorOpaque_F(var9 * var25, var9 * var25, var9 * var25);
        int var26 = var1.getBlockTexture(this.blockAccess, var2, var3, var4, 0);
        int var27 = (var26 & 0xF) << 4;
        int var28 = var26 & 0xFF0;
        double var29 = (float)var27 / 256.0f;
        double var31 = ((double)(var27 + 16) - 0.01) / 256.0;
        double var33 = (float)var28 / 512.0f;
        double var35 = ((double)(var28 + 16) - 0.01) / 512.0;
        double var37 = (double)var2 + var1.minX;
        double var39 = (double)var2 + var1.maxX;
        double var41 = (double)var3 + var1.minY + 0.1875;
        double var43 = (double)var4 + var1.minZ;
        double var45 = (double)var4 + var1.maxZ;
        var5.addVertexWithUV(var37, var41, var45, var29, var35);
        var5.addVertexWithUV(var37, var41, var43, var29, var33);
        var5.addVertexWithUV(var39, var41, var43, var31, var33);
        var5.addVertexWithUV(var39, var41, var45, var31, var35);
        float var64 = var1.getBlockBrightness(this.blockAccess, var2, var3 + 1, var4);
        var5.setColorOpaque_F(var10 * var64, var10 * var64, var10 * var64);
        var27 = var1.getBlockTexture(this.blockAccess, var2, var3, var4, 1);
        var28 = (var27 & 0xF) << 4;
        int var67 = var27 & 0xFF0;
        double var30 = (float)var28 / 256.0f;
        double var32 = ((double)(var28 + 16) - 0.01) / 256.0;
        double var34 = (float)var67 / 512.0f;
        double var36 = ((double)(var67 + 16) - 0.01) / 512.0;
        double var38 = var30;
        double var40 = var32;
        double var42 = var34;
        double var44 = var34;
        double var46 = var30;
        double var48 = var32;
        double var50 = var36;
        double var52 = var36;
        if (var7 == 0) {
            var40 = var30;
            var42 = var36;
            var46 = var32;
            var52 = var34;
        } else if (var7 == 2) {
            var38 = var32;
            var44 = var36;
            var48 = var30;
            var50 = var34;
        } else if (var7 == 3) {
            var38 = var32;
            var44 = var36;
            var48 = var30;
            var50 = var34;
            var40 = var30;
            var42 = var36;
            var46 = var32;
            var52 = var34;
        }
        double var54 = (double)var2 + var1.minX;
        double var56 = (double)var2 + var1.maxX;
        double var58 = (double)var3 + var1.maxY;
        double var60 = (double)var4 + var1.minZ;
        double var62 = (double)var4 + var1.maxZ;
        var5.addVertexWithUV(var56, var58, var62, var46, var50);
        var5.addVertexWithUV(var56, var58, var60, var38, var42);
        var5.addVertexWithUV(var54, var58, var60, var40, var44);
        var5.addVertexWithUV(var54, var58, var62, var48, var52);
        var26 = ModelBed.field_22280_a[var7];
        if (var8) {
            var26 = ModelBed.field_22280_a[ModelBed.field_22279_b[var7]];
        }
        int var65 = 4;
        switch (var7) {
            case 0: {
                var65 = 5;
                break;
            }
            case 1: {
                var65 = 3;
            }
            default: {
                break;
            }
            case 3: {
                var65 = 2;
            }
        }
        if (var26 != 2 && (this.renderAllFaces || var1.shouldSideBeRendered(this.blockAccess, var2, var3, var4 - 1, 2))) {
            var66 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 - 1);
            if (var1.minZ > 0.0) {
                var66 = var25;
            }
            var5.setColorOpaque_F(var11 * var66, var11 * var66, var11 * var66);
            this.flipTexture = var65 == 2;
            this.renderEastFace(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 2));
        }
        if (var26 != 3 && (this.renderAllFaces || var1.shouldSideBeRendered(this.blockAccess, var2, var3, var4 + 1, 3))) {
            var66 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 + 1);
            if (var1.maxZ < 1.0) {
                var66 = var25;
            }
            var5.setColorOpaque_F(var11 * var66, var11 * var66, var11 * var66);
            this.flipTexture = var65 == 3;
            this.renderWestFace(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 3));
        }
        if (var26 != 4 && (this.renderAllFaces || var1.shouldSideBeRendered(this.blockAccess, var2 - 1, var3, var4, 4))) {
            var66 = var1.getBlockBrightness(this.blockAccess, var2 - 1, var3, var4);
            if (var1.minX > 0.0) {
                var66 = var25;
            }
            var5.setColorOpaque_F(var12 * var66, var12 * var66, var12 * var66);
            this.flipTexture = var65 == 4;
            this.renderNorthFace(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 4));
        }
        if (var26 != 5 && (this.renderAllFaces || var1.shouldSideBeRendered(this.blockAccess, var2 + 1, var3, var4, 5))) {
            var66 = var1.getBlockBrightness(this.blockAccess, var2 + 1, var3, var4);
            if (var1.maxX < 1.0) {
                var66 = var25;
            }
            var5.setColorOpaque_F(var12 * var66, var12 * var66, var12 * var66);
            this.flipTexture = var65 == 5;
            this.renderSouthFace(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 5));
        }
        this.flipTexture = false;
        return true;
    }

    public boolean renderBlockTorch(Block block, int xCoord, int yCoord, int zCoord) {
        int metadata = this.blockAccess.getBlockMetadata(xCoord, yCoord, zCoord);
        Tessellator tesellator = Tessellator.instance;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        if (Block.lightValue[block.blockID] > 0) {
            lightFloat = 1.0f;
        }
        tesellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        double var8 = 0.4f;
        double var10 = 0.5 - var8;
        double var12 = 0.2f;
        if (metadata == 1) {
            this.renderTorchAtAngle(block, (double)xCoord - var10, (double)yCoord + var12, zCoord, -var8, 0.0, false);
        } else if (metadata == 2) {
            this.renderTorchAtAngle(block, (double)xCoord + var10, (double)yCoord + var12, zCoord, var8, 0.0, false);
        } else if (metadata == 3) {
            this.renderTorchAtAngle(block, xCoord, (double)yCoord + var12, (double)zCoord - var10, 0.0, -var8, false);
        } else if (metadata == 4) {
            this.renderTorchAtAngle(block, xCoord, (double)yCoord + var12, (double)zCoord + var10, 0.0, var8, false);
        } else if (this.blockAccess.getBlockId(xCoord, yCoord - 1, zCoord) == Block.slabSingleRock.blockID || this.blockAccess.getBlockId(xCoord, yCoord - 1, zCoord) == Block.slabSingleWood.blockID) {
            this.renderTorchAtAngle(block, xCoord, (double)yCoord - 0.5, zCoord, 0.0, 0.0, false);
        } else if (metadata == 6) {
            this.renderTorchAtAngle(block, xCoord, (double)yCoord + 0.375, zCoord, 0.0, 0.0, true);
        } else {
            this.renderTorchAtAngle(block, xCoord, yCoord, zCoord, 0.0, 0.0, false);
        }
        return true;
    }

    private boolean renderRelayAndTreadmill(Block var1, int x, int var3, int z) {
        int var5 = this.blockAccess.getBlockMetadata(x, var3, z);
        int var6 = var5 & 3;
        int var7 = (var5 & 0xC) >> 2;
        Tessellator instance = Tessellator.instance;
        float light = var1.getBlockBrightness(this.blockAccess, x, var3, z);
        if (Block.lightValue[var1.blockID] > 0) {
            light = (light + 1.0f) * 0.5f;
        }
        instance.setColorOpaque_F(light, light, light);
        double var10 = -0.1875;
        double var14 = 0.0;
        double var16 = 0.0;
        double var18 = 0.0;
        switch (var6) {
            case 0: {
                var18 = -0.3125;
                var14 = BlockGearRelay.field_22024_a[var7];
                break;
            }
            case 1: {
                var16 = 0.3125;
                break;
            }
            case 2: {
                var18 = 0.3125;
                var14 = -BlockGearRelay.field_22024_a[var7];
                break;
            }
            case 3: {
                var16 = -0.3125;
            }
        }
        int topTexture = var1.getBlockTextureFromSideAndMetadata(1, var5);
        int xTop = (topTexture & 0xF) << 4;
        int yTop = topTexture & 0xFF0;
        double minXTop = (float)xTop / 256.0f;
        double maxXTop = ((float)xTop + 15.99f) / 256.0f;
        double minYTop = (float)yTop / 512.0f;
        double maxYTop = ((float)yTop + 15.99f) / 512.0f;
        int bottomTexture = var1.getBlockTextureFromSideAndMetadata(0, var5);
        int xBottom = (bottomTexture & 0xF) << 4;
        int yBottom = bottomTexture & 0xFF0;
        double minXBottom = (float)xBottom / 256.0f;
        double maxXBottom = ((float)xBottom + 15.99f) / 256.0f;
        double minYBottom = (float)yBottom / 512.0f;
        double maxYBottom = ((float)yBottom + 15.99f) / 512.0f;
        int negXTexture = var1.getBlockTextureFromSideAndMetadata(4, var5);
        int xNegX = (negXTexture & 0xF) << 4;
        int yNegX = negXTexture & 0xFF0;
        double minXNeg = (float)xNegX / 256.0f;
        double maxXNeg = ((float)xNegX + 15.99f) / 256.0f;
        double minYNeg = (float)yNegX / 512.0f;
        double maxYNeg = ((float)yNegX + 15.99f) / 512.0f;
        int negZTexture = var1.getBlockTextureFromSideAndMetadata(2, var5);
        int xNegZ = (negZTexture & 0xF) << 4;
        int yNegZ = negZTexture & 0xFF0;
        double minXNegZ = (float)xNegZ / 256.0f;
        double maxXNegZ = ((float)xNegZ + 15.99f) / 256.0f;
        double minYNegZ = (float)yNegZ / 512.0f;
        double maxYNegZ = ((float)yNegZ + 15.99f) / 512.0f;
        int posXTexture = var1.getBlockTextureFromSideAndMetadata(5, var5);
        int xPosX = (posXTexture & 0xF) << 4;
        int yPosX = posXTexture & 0xFF0;
        double minXPos = (float)xPosX / 256.0f;
        double maxXPos = ((float)xPosX + 15.99f) / 256.0f;
        double minYPos = (float)yPosX / 512.0f;
        double maxYPos = ((float)yPosX + 15.99f) / 512.0f;
        int posZTexture = var1.getBlockTextureFromSideAndMetadata(3, var5);
        int xPosZ = (posZTexture & 0xF) << 4;
        int yPosZ = posZTexture & 0xFF0;
        double minXPosZ = (float)xPosZ / 256.0f;
        double maxXPosZ = ((float)xPosZ + 15.99f) / 256.0f;
        double minYPosZ = (float)yPosZ / 512.0f;
        double maxYPosZ = ((float)yPosZ + 15.99f) / 512.0f;
        float var31 = 0.125f;
        float var32 = x + 1;
        float var33 = x + 1;
        float var34 = x + 0;
        float var35 = x + 0;
        float var36 = z + 0;
        float var37 = z + 1;
        float var38 = z + 1;
        float var39 = z + 0;
        float yBl = 0.0f;
        float yBlTr = 0.0f;
        if (var6 == 2) {
            var32 = var33 = (float)(x + 0);
            var34 = var35 = (float)(x + 1);
            var36 = var39 = (float)(z + 1);
            var37 = var38 = (float)(z + 0);
        } else if (var6 == 3) {
            var32 = var35 = (float)(x + 0);
            var33 = var34 = (float)(x + 1);
            var36 = var37 = (float)(z + 0);
            var38 = var39 = (float)(z + 1);
        } else if (var6 == 1) {
            var32 = var35 = (float)(x + 1);
            var33 = var34 = (float)(x + 0);
            var36 = var37 = (float)(z + 1);
            var38 = var39 = (float)(z + 0);
        }
        if (var1 == Block.gearRelayIdle || var1 == Block.gearRelayActive || var1 == Block.gearWaitIdle || var1 == Block.gearWaitActive || var1 == Block.gearNotGateIdle || var1 == Block.gearNotGateActive) {
            yBl = (float)var3 + 0.5f;
            yBlTr = (float)var3 + 1.0f;
        } else if (var1 == Block.treadmillIdle || var1 == Block.treadmillActive) {
            yBl = (float)var3 + 0.5f;
            yBlTr = (float)var3 + 0.5f;
        }
        float lBelow = 0.5f;
        float lAbove = 1.0f;
        float lNE = 0.8f;
        float lEW = 0.6f;
        float var110 = var1.getBlockBrightness(this.blockAccess, x, var3, z);
        float var120 = var1.getBlockBrightness(this.blockAccess, x + 1, var3, z);
        if (var120 < var110) {
            var120 = var110;
        }
        instance.setColorOpaque_F(lEW * var120, lEW * var120, lEW * var120);
        instance.addVertexWithUV((double)x + 1.0, (double)yBl - 0.5 + 1.0, (double)z + 1.0, minXPos, minYPos);
        instance.addVertexWithUV((double)x + 1.0, (double)yBl - 0.5, (double)z + 1.0, minXPos, maxYPos);
        instance.addVertexWithUV((double)x + 1.0, (double)yBl - 0.5, z, maxXPos, maxYPos);
        instance.addVertexWithUV((double)x + 1.0, (double)yBl - 0.5 + 1.0, z, maxXPos, minYPos);
        var120 = var1.getBlockBrightness(this.blockAccess, x - 1, var3, z);
        if (var120 < var110) {
            var120 = var110;
        }
        instance.setColorOpaque_F(lEW * var120, lEW * var120, lEW * var120);
        instance.addVertexWithUV(x, (double)yBl - 0.5 + 1.0, z, minXNeg, minYNeg);
        instance.addVertexWithUV(x, (double)yBl - 0.5, z, minXNeg, maxYNeg);
        instance.addVertexWithUV(x, (double)yBl - 0.5, (double)z + 1.0, maxXNeg, maxYNeg);
        instance.addVertexWithUV(x, (double)yBl - 0.5 + 1.0, (double)z + 1.0, maxXNeg, minYNeg);
        var120 = var1.getBlockBrightness(this.blockAccess, x, var3, z + 1);
        if (var120 < var110) {
            var120 = var110;
        }
        instance.setColorOpaque_F(lNE * var120, lNE * var120, lNE * var120);
        instance.addVertexWithUV(x, (double)yBl - 0.5 + 1.0, (double)z + 1.0, minXPosZ, minYPosZ);
        instance.addVertexWithUV(x, (double)yBl - 0.5, (double)z + 1.0, minXPosZ, maxYPosZ);
        instance.addVertexWithUV((double)x + 1.0, (double)yBl - 0.5, (double)z + 1.0, maxXPosZ, maxYPosZ);
        instance.addVertexWithUV((double)x + 1.0, (double)yBl - 0.5 + 1.0, (double)z + 1.0, maxXPosZ, minYPosZ);
        var120 = var1.getBlockBrightness(this.blockAccess, x, var3, z - 1);
        if (var120 < var110) {
            var120 = var110;
        }
        instance.setColorOpaque_F(lNE * var120, lNE * var120, lNE * var120);
        instance.addVertexWithUV((double)x + 1.0, (double)yBl - 0.5 + 1.0, z, minXNegZ, minYNegZ);
        instance.addVertexWithUV((double)x + 1.0, (double)yBl - 0.5, z, minXNegZ, maxYNegZ);
        instance.addVertexWithUV(x, (double)yBl - 0.5, z, maxXNegZ, maxYNegZ);
        instance.addVertexWithUV(x, (double)yBl - 0.5 + 1.0, z, maxXNegZ, minYNegZ);
        var120 = var1.getBlockBrightness(this.blockAccess, x, var3 + 1, z);
        if (var120 < var110) {
            var120 = var110;
        }
        instance.setColorOpaque_F(lAbove * var120, lAbove * var120, lAbove * var120);
        instance.addVertexWithUV(var35, yBlTr, var39, minXTop, minYTop);
        instance.addVertexWithUV(var34, yBlTr, var38, minXTop, maxYTop);
        instance.addVertexWithUV(var33, yBlTr, var37, maxXTop, maxYTop);
        instance.addVertexWithUV(var32, yBlTr, var36, maxXTop, minYTop);
        var120 = var1.getBlockBrightness(this.blockAccess, x, var3 - 1, z);
        if (var120 < var110) {
            var120 = var110;
        }
        instance.setColorOpaque_F(lBelow * var120, lBelow * var120, lBelow * var120);
        instance.addVertexWithUV(var32, var3, var36, minXBottom, minYBottom);
        instance.addVertexWithUV(var33, var3, var37, minXBottom, maxYBottom);
        instance.addVertexWithUV(var34, var3, var38, maxXBottom, maxYBottom);
        instance.addVertexWithUV(var35, var3, var39, maxXBottom, minYBottom);
        return true;
    }

    private boolean renderCampfire(Block var1, int x, int y, int z) {
        this.renderStandardBlock(var1, x, y, z);
        Tessellator instance = Tessellator.instance;
        instance.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        this.renderPlantTextureOnly(var1, 323, x, y, z);
        return true;
    }

    public void func_31078_d(Block var1, int var2, int var3, int var4) {
        this.renderAllFaces = true;
        this.renderDirectional(var1, var2, var3, var4, true);
        this.renderAllFaces = false;
    }

    private boolean renderDirectional(Block var1, int var2, int var3, int var4, boolean var5) {
        int var6 = this.blockAccess.getBlockMetadata(var2, var3, var4);
        boolean var7 = var5 || (var6 & 8) != 0;
        int var8 = BlockPistonBase.func_31044_d(var6);
        if (var7) {
            switch (var8) {
                case 0: {
                    this.uvRotateEast = 3;
                    this.uvRotateWest = 3;
                    this.uvRotateSouthFace = 3;
                    this.uvRotateNorth = 3;
                    var1.setBlockBounds(0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    var1.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
                    break;
                }
                case 2: {
                    this.uvRotateSouthFace = 1;
                    this.uvRotateNorth = 2;
                    var1.setBlockBounds(0.0f, 0.0f, 0.25f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 3: {
                    this.uvRotateSouthFace = 2;
                    this.uvRotateNorth = 1;
                    this.uvRotateTop = 3;
                    this.uvRotateBottom = 3;
                    var1.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.75f);
                    break;
                }
                case 4: {
                    this.uvRotateEast = 1;
                    this.uvRotateWest = 2;
                    this.uvRotateTop = 2;
                    this.uvRotateBottom = 1;
                    var1.setBlockBounds(0.25f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    this.uvRotateEast = 2;
                    this.uvRotateWest = 1;
                    this.uvRotateTop = 1;
                    this.uvRotateBottom = 2;
                    var1.setBlockBounds(0.0f, 0.0f, 0.0f, 0.75f, 1.0f, 1.0f);
                }
            }
            this.renderStandardBlock(var1, var2, var3, var4);
            this.uvRotateEast = 0;
            this.uvRotateWest = 0;
            this.uvRotateSouthFace = 0;
            this.uvRotateNorth = 0;
            this.uvRotateTop = 0;
            this.uvRotateBottom = 0;
            var1.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            switch (var8) {
                case 0: {
                    this.uvRotateEast = 3;
                    this.uvRotateWest = 3;
                    this.uvRotateSouthFace = 3;
                    this.uvRotateNorth = 3;
                }
                default: {
                    break;
                }
                case 2: {
                    this.uvRotateSouthFace = 1;
                    this.uvRotateNorth = 2;
                    break;
                }
                case 3: {
                    this.uvRotateSouthFace = 2;
                    this.uvRotateNorth = 1;
                    this.uvRotateTop = 3;
                    this.uvRotateBottom = 3;
                    break;
                }
                case 4: {
                    this.uvRotateEast = 1;
                    this.uvRotateWest = 2;
                    this.uvRotateTop = 2;
                    this.uvRotateBottom = 1;
                    break;
                }
                case 5: {
                    this.uvRotateEast = 2;
                    this.uvRotateWest = 1;
                    this.uvRotateTop = 1;
                    this.uvRotateBottom = 2;
                }
            }
            this.renderStandardBlock(var1, var2, var3, var4);
            this.uvRotateEast = 0;
            this.uvRotateWest = 0;
            this.uvRotateSouthFace = 0;
            this.uvRotateNorth = 0;
            this.uvRotateTop = 0;
            this.uvRotateBottom = 0;
        }
        return true;
    }

    private void renderPistonRodSN(double var1, double var3, double var5, double var7, double var9, double var11, float var13, double var14) {
        int var16 = 108;
        if (this.overrideBlockTexture >= 0) {
            var16 = this.overrideBlockTexture;
        }
        int var17 = (var16 & 0xF) << 4;
        int var18 = var16 & 0xFF0;
        Tessellator var19 = Tessellator.instance;
        double var20 = (float)(var17 + 0) / 256.0f;
        double var22 = (float)(var18 + 0) / 512.0f;
        double var24 = ((double)var17 + var14 - 0.01) / 256.0;
        double var26 = ((double)((float)var18 + 4.0f) - 0.01) / 512.0;
        var19.setColorOpaque_F(var13, var13, var13);
        var19.addVertexWithUV(var1, var7, var9, var24, var22);
        var19.addVertexWithUV(var1, var5, var9, var20, var22);
        var19.addVertexWithUV(var3, var5, var11, var20, var26);
        var19.addVertexWithUV(var3, var7, var11, var24, var26);
    }

    private void renderPistonRodEW(double var1, double var3, double var5, double var7, double var9, double var11, float var13, double var14) {
        int var16 = 108;
        if (this.overrideBlockTexture >= 0) {
            var16 = this.overrideBlockTexture;
        }
        int var17 = (var16 & 0xF) << 4;
        int var18 = var16 & 0xFF0;
        Tessellator var19 = Tessellator.instance;
        double var20 = (float)(var17 + 0) / 256.0f;
        double var22 = (float)(var18 + 0) / 512.0f;
        double var24 = ((double)var17 + var14 - 0.01) / 256.0;
        double var26 = ((double)((float)var18 + 4.0f) - 0.01) / 512.0;
        var19.setColorOpaque_F(var13, var13, var13);
        var19.addVertexWithUV(var1, var5, var11, var24, var22);
        var19.addVertexWithUV(var1, var5, var9, var20, var22);
        var19.addVertexWithUV(var3, var7, var9, var20, var26);
        var19.addVertexWithUV(var3, var7, var11, var24, var26);
    }

    private void func_31077_c(double var1, double var3, double var5, double var7, double var9, double var11, float var13, double var14) {
        int var16 = 108;
        if (this.overrideBlockTexture >= 0) {
            var16 = this.overrideBlockTexture;
        }
        int var17 = (var16 & 0xF) << 4;
        int var18 = var16 & 0xFF0;
        Tessellator var19 = Tessellator.instance;
        double var20 = (float)(var17 + 0) / 256.0f;
        double var22 = (float)(var18 + 0) / 512.0f;
        double var24 = ((double)var17 + var14 - 0.01) / 256.0;
        double var26 = ((double)((float)var18 + 4.0f) - 0.01) / 512.0;
        var19.setColorOpaque_F(var13, var13, var13);
        var19.addVertexWithUV(var3, var5, var9, var24, var22);
        var19.addVertexWithUV(var1, var5, var9, var20, var22);
        var19.addVertexWithUV(var1, var7, var11, var20, var26);
        var19.addVertexWithUV(var3, var7, var11, var24, var26);
    }

    public void func_31079_a(Block var1, int var2, int var3, int var4, boolean var5) {
        this.renderAllFaces = true;
        this.func_31080_c(var1, var2, var3, var4, var5);
        this.renderAllFaces = false;
    }

    private boolean func_31080_c(Block var1, int var2, int var3, int var4, boolean var5) {
        int var6 = this.blockAccess.getBlockMetadata(var2, var3, var4);
        int var7 = BlockPistonExtension.func_31050_c(var6);
        float var11 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4);
        float var12 = var5 ? 1.0f : 0.5f;
        double var13 = var5 ? 16.0 : 8.0;
        switch (var7) {
            case 0: {
                this.uvRotateEast = 3;
                this.uvRotateWest = 3;
                this.uvRotateSouthFace = 3;
                this.uvRotateNorth = 3;
                var1.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1.0f);
                this.renderStandardBlock(var1, var2, var3, var4);
                this.renderPistonRodSN((float)var2 + 0.375f, (float)var2 + 0.625f, (float)var3 + 0.25f, (float)var3 + 0.25f + var12, (float)var4 + 0.625f, (float)var4 + 0.625f, var11 * 0.8f, var13);
                this.renderPistonRodSN((float)var2 + 0.625f, (float)var2 + 0.375f, (float)var3 + 0.25f, (float)var3 + 0.25f + var12, (float)var4 + 0.375f, (float)var4 + 0.375f, var11 * 0.8f, var13);
                this.renderPistonRodSN((float)var2 + 0.375f, (float)var2 + 0.375f, (float)var3 + 0.25f, (float)var3 + 0.25f + var12, (float)var4 + 0.375f, (float)var4 + 0.625f, var11 * 0.6f, var13);
                this.renderPistonRodSN((float)var2 + 0.625f, (float)var2 + 0.625f, (float)var3 + 0.25f, (float)var3 + 0.25f + var12, (float)var4 + 0.625f, (float)var4 + 0.375f, var11 * 0.6f, var13);
                break;
            }
            case 1: {
                var1.setBlockBounds(0.0f, 0.75f, 0.0f, 1.0f, 1.0f, 1.0f);
                this.renderStandardBlock(var1, var2, var3, var4);
                this.renderPistonRodSN((float)var2 + 0.375f, (float)var2 + 0.625f, (float)var3 - 0.25f + 1.0f - var12, (float)var3 - 0.25f + 1.0f, (float)var4 + 0.625f, (float)var4 + 0.625f, var11 * 0.8f, var13);
                this.renderPistonRodSN((float)var2 + 0.625f, (float)var2 + 0.375f, (float)var3 - 0.25f + 1.0f - var12, (float)var3 - 0.25f + 1.0f, (float)var4 + 0.375f, (float)var4 + 0.375f, var11 * 0.8f, var13);
                this.renderPistonRodSN((float)var2 + 0.375f, (float)var2 + 0.375f, (float)var3 - 0.25f + 1.0f - var12, (float)var3 - 0.25f + 1.0f, (float)var4 + 0.375f, (float)var4 + 0.625f, var11 * 0.6f, var13);
                this.renderPistonRodSN((float)var2 + 0.625f, (float)var2 + 0.625f, (float)var3 - 0.25f + 1.0f - var12, (float)var3 - 0.25f + 1.0f, (float)var4 + 0.625f, (float)var4 + 0.375f, var11 * 0.6f, var13);
                break;
            }
            case 2: {
                this.uvRotateSouthFace = 1;
                this.uvRotateNorth = 2;
                var1.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.25f);
                this.renderStandardBlock(var1, var2, var3, var4);
                this.renderPistonRodEW((float)var2 + 0.375f, (float)var2 + 0.375f, (float)var3 + 0.625f, (float)var3 + 0.375f, (float)var4 + 0.25f, (float)var4 + 0.25f + var12, var11 * 0.6f, var13);
                this.renderPistonRodEW((float)var2 + 0.625f, (float)var2 + 0.625f, (float)var3 + 0.375f, (float)var3 + 0.625f, (float)var4 + 0.25f, (float)var4 + 0.25f + var12, var11 * 0.6f, var13);
                this.renderPistonRodEW((float)var2 + 0.375f, (float)var2 + 0.625f, (float)var3 + 0.375f, (float)var3 + 0.375f, (float)var4 + 0.25f, (float)var4 + 0.25f + var12, var11 * 0.5f, var13);
                this.renderPistonRodEW((float)var2 + 0.625f, (float)var2 + 0.375f, (float)var3 + 0.625f, (float)var3 + 0.625f, (float)var4 + 0.25f, (float)var4 + 0.25f + var12, var11, var13);
                break;
            }
            case 3: {
                this.uvRotateSouthFace = 2;
                this.uvRotateNorth = 1;
                this.uvRotateTop = 3;
                this.uvRotateBottom = 3;
                var1.setBlockBounds(0.0f, 0.0f, 0.75f, 1.0f, 1.0f, 1.0f);
                this.renderStandardBlock(var1, var2, var3, var4);
                this.renderPistonRodEW((float)var2 + 0.375f, (float)var2 + 0.375f, (float)var3 + 0.625f, (float)var3 + 0.375f, (float)var4 - 0.25f + 1.0f - var12, (float)var4 - 0.25f + 1.0f, var11 * 0.6f, var13);
                this.renderPistonRodEW((float)var2 + 0.625f, (float)var2 + 0.625f, (float)var3 + 0.375f, (float)var3 + 0.625f, (float)var4 - 0.25f + 1.0f - var12, (float)var4 - 0.25f + 1.0f, var11 * 0.6f, var13);
                this.renderPistonRodEW((float)var2 + 0.375f, (float)var2 + 0.625f, (float)var3 + 0.375f, (float)var3 + 0.375f, (float)var4 - 0.25f + 1.0f - var12, (float)var4 - 0.25f + 1.0f, var11 * 0.5f, var13);
                this.renderPistonRodEW((float)var2 + 0.625f, (float)var2 + 0.375f, (float)var3 + 0.625f, (float)var3 + 0.625f, (float)var4 - 0.25f + 1.0f - var12, (float)var4 - 0.25f + 1.0f, var11, var13);
                break;
            }
            case 4: {
                this.uvRotateEast = 1;
                this.uvRotateWest = 2;
                this.uvRotateTop = 2;
                this.uvRotateBottom = 1;
                var1.setBlockBounds(0.0f, 0.0f, 0.0f, 0.25f, 1.0f, 1.0f);
                this.renderStandardBlock(var1, var2, var3, var4);
                this.func_31077_c((float)var2 + 0.25f, (float)var2 + 0.25f + var12, (float)var3 + 0.375f, (float)var3 + 0.375f, (float)var4 + 0.625f, (float)var4 + 0.375f, var11 * 0.5f, var13);
                this.func_31077_c((float)var2 + 0.25f, (float)var2 + 0.25f + var12, (float)var3 + 0.625f, (float)var3 + 0.625f, (float)var4 + 0.375f, (float)var4 + 0.625f, var11, var13);
                this.func_31077_c((float)var2 + 0.25f, (float)var2 + 0.25f + var12, (float)var3 + 0.375f, (float)var3 + 0.625f, (float)var4 + 0.375f, (float)var4 + 0.375f, var11 * 0.6f, var13);
                this.func_31077_c((float)var2 + 0.25f, (float)var2 + 0.25f + var12, (float)var3 + 0.625f, (float)var3 + 0.375f, (float)var4 + 0.625f, (float)var4 + 0.625f, var11 * 0.6f, var13);
                break;
            }
            case 5: {
                this.uvRotateEast = 2;
                this.uvRotateWest = 1;
                this.uvRotateTop = 1;
                this.uvRotateBottom = 2;
                var1.setBlockBounds(0.75f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                this.renderStandardBlock(var1, var2, var3, var4);
                this.func_31077_c((float)var2 - 0.25f + 1.0f - var12, (float)var2 - 0.25f + 1.0f, (float)var3 + 0.375f, (float)var3 + 0.375f, (float)var4 + 0.625f, (float)var4 + 0.375f, var11 * 0.5f, var13);
                this.func_31077_c((float)var2 - 0.25f + 1.0f - var12, (float)var2 - 0.25f + 1.0f, (float)var3 + 0.625f, (float)var3 + 0.625f, (float)var4 + 0.375f, (float)var4 + 0.625f, var11, var13);
                this.func_31077_c((float)var2 - 0.25f + 1.0f - var12, (float)var2 - 0.25f + 1.0f, (float)var3 + 0.375f, (float)var3 + 0.625f, (float)var4 + 0.375f, (float)var4 + 0.375f, var11 * 0.6f, var13);
                this.func_31077_c((float)var2 - 0.25f + 1.0f - var12, (float)var2 - 0.25f + 1.0f, (float)var3 + 0.625f, (float)var3 + 0.375f, (float)var4 + 0.625f, (float)var4 + 0.625f, var11 * 0.6f, var13);
            }
        }
        this.uvRotateEast = 0;
        this.uvRotateWest = 0;
        this.uvRotateSouthFace = 0;
        this.uvRotateNorth = 0;
        this.uvRotateTop = 0;
        this.uvRotateBottom = 0;
        var1.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return true;
    }

    public boolean renderBlockLever(Block block, int xCoord, int yCoord, int zCoord) {
        boolean var9;
        int getMeta = this.blockAccess.getBlockMetadata(xCoord, yCoord, zCoord);
        int metadata = getMeta & 7;
        boolean var7 = (getMeta & 8) > 0;
        Tessellator instance = Tessellator.instance;
        boolean bl = var9 = this.overrideBlockTexture >= 0;
        if (!var9) {
            this.overrideBlockTexture = Block.cobblestone.blockIndexInTexture;
        }
        float var10 = 0.25f;
        float var11 = 0.1875f;
        float var12 = 0.1875f;
        if (metadata == 5) {
            block.setBlockBounds(0.5f - var11, 0.0f, 0.5f - var10, 0.5f + var11, var12, 0.5f + var10);
        } else if (metadata == 6) {
            block.setBlockBounds(0.5f - var10, 0.0f, 0.5f - var11, 0.5f + var10, var12, 0.5f + var11);
        } else if (metadata == 4) {
            block.setBlockBounds(0.5f - var11, 0.5f - var10, 1.0f - var12, 0.5f + var11, 0.5f + var10, 1.0f);
        } else if (metadata == 3) {
            block.setBlockBounds(0.5f - var11, 0.5f - var10, 0.0f, 0.5f + var11, 0.5f + var10, var12);
        } else if (metadata == 2) {
            block.setBlockBounds(1.0f - var12, 0.5f - var10, 0.5f - var11, 1.0f, 0.5f + var10, 0.5f + var11);
        } else if (metadata == 1) {
            block.setBlockBounds(0.0f, 0.5f - var10, 0.5f - var11, var12, 0.5f + var10, 0.5f + var11);
        }
        this.renderStandardBlock(block, xCoord, yCoord, zCoord);
        if (!var9) {
            this.overrideBlockTexture = -1;
        }
        float light = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        if (Block.lightValue[block.blockID] > 0) {
            light = 1.0f;
        }
        instance.setColorOpaque_F(light, light, light);
        int texture = block.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xTexture = (texture & 0xF) << 4;
        int index = texture & 0xFF0;
        float minX = (float)xTexture / 256.0f;
        float maxX = ((float)xTexture + 15.99f) / 256.0f;
        float minY = (float)index / 512.0f;
        float maxY = ((float)index + 15.99f) / 512.0f;
        Vec3D[] vector3d = new Vec3D[8];
        float var22 = 0.0625f;
        float var23 = 0.0625f;
        float var24 = 0.625f;
        vector3d[0] = Vec3D.createVector(-var22, 0.0, -var23);
        vector3d[1] = Vec3D.createVector(var22, 0.0, -var23);
        vector3d[2] = Vec3D.createVector(var22, 0.0, var23);
        vector3d[3] = Vec3D.createVector(-var22, 0.0, var23);
        vector3d[4] = Vec3D.createVector(-var22, var24, -var23);
        vector3d[5] = Vec3D.createVector(var22, var24, -var23);
        vector3d[6] = Vec3D.createVector(var22, var24, var23);
        vector3d[7] = Vec3D.createVector(-var22, var24, var23);
        int i = 0;
        while (i < 8) {
            if (var7) {
                vector3d[i].zCoord -= 0.0625;
                vector3d[i].rotateAroundX(0.69813174f);
            } else {
                vector3d[i].zCoord += 0.0625;
                vector3d[i].rotateAroundX(-0.69813174f);
            }
            if (metadata == 6) {
                vector3d[i].rotateAroundY(1.5707964f);
            }
            if (metadata < 5) {
                vector3d[i].yCoord -= 0.375;
                vector3d[i].rotateAroundX(1.5707964f);
                if (metadata == 4) {
                    vector3d[i].rotateAroundY(0.0f);
                }
                if (metadata == 3) {
                    vector3d[i].rotateAroundY((float)Math.PI);
                }
                if (metadata == 2) {
                    vector3d[i].rotateAroundY(1.5707964f);
                }
                if (metadata == 1) {
                    vector3d[i].rotateAroundY(-1.5707964f);
                }
                vector3d[i].xCoord += (double)xCoord + 0.5;
                vector3d[i].yCoord += (double)((float)yCoord + 0.5f);
                vector3d[i].zCoord += (double)zCoord + 0.5;
            } else {
                vector3d[i].xCoord += (double)xCoord + 0.5;
                vector3d[i].yCoord += (double)((float)yCoord + 0.125f);
                vector3d[i].zCoord += (double)zCoord + 0.5;
            }
            ++i;
        }
        Vec3D var30 = null;
        Vec3D var26 = null;
        Vec3D var27 = null;
        Vec3D var28 = null;
        int var29 = 0;
        while (var29 < 6) {
            if (var29 == 0) {
                minX = (float)(xTexture + 7) / 256.0f;
                maxX = ((float)(xTexture + 9) - 0.01f) / 256.0f;
                minY = (float)(index + 6) / 512.0f;
                maxY = ((float)(index + 8) - 0.01f) / 512.0f;
            } else if (var29 == 2) {
                minX = (float)(xTexture + 7) / 256.0f;
                maxX = ((float)(xTexture + 9) - 0.01f) / 256.0f;
                minY = (float)(index + 6) / 512.0f;
                maxY = ((float)(index + 16) - 0.01f) / 512.0f;
            }
            if (var29 == 0) {
                var30 = vector3d[0];
                var26 = vector3d[1];
                var27 = vector3d[2];
                var28 = vector3d[3];
            } else if (var29 == 1) {
                var30 = vector3d[7];
                var26 = vector3d[6];
                var27 = vector3d[5];
                var28 = vector3d[4];
            } else if (var29 == 2) {
                var30 = vector3d[1];
                var26 = vector3d[0];
                var27 = vector3d[4];
                var28 = vector3d[5];
            } else if (var29 == 3) {
                var30 = vector3d[2];
                var26 = vector3d[1];
                var27 = vector3d[5];
                var28 = vector3d[6];
            } else if (var29 == 4) {
                var30 = vector3d[3];
                var26 = vector3d[2];
                var27 = vector3d[6];
                var28 = vector3d[7];
            } else if (var29 == 5) {
                var30 = vector3d[0];
                var26 = vector3d[3];
                var27 = vector3d[7];
                var28 = vector3d[4];
            }
            instance.addVertexWithUV(var30.xCoord, var30.yCoord, var30.zCoord, minX, maxY);
            instance.addVertexWithUV(var26.xCoord, var26.yCoord, var26.zCoord, maxX, maxY);
            instance.addVertexWithUV(var27.xCoord, var27.yCoord, var27.zCoord, maxX, minY);
            instance.addVertexWithUV(var28.xCoord, var28.yCoord, var28.zCoord, minX, minY);
            ++var29;
        }
        return true;
    }

    public boolean renderBlockFire(Block var1, int var2, int var3, int var4) {
        Tessellator var5 = Tessellator.instance;
        int var6 = var1.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            var6 = this.overrideBlockTexture;
        }
        float var7 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4);
        var5.setColorOpaque_F(var7, var7, var7);
        int var8 = (var6 & 0xF) << 4;
        int var9 = var6 & 0xFF0;
        double var10 = (float)var8 / 256.0f;
        double var12 = ((float)var8 + 15.99f) / 256.0f;
        double var14 = (float)var9 / 512.0f;
        double var16 = ((float)var9 + 15.99f) / 512.0f;
        float var18 = 1.4f;
        if (!this.blockAccess.isBlockNormalCube(var2, var3 - 1, var4) && !Block.fire.canBlockCatchFire(this.blockAccess, var2, var3 - 1, var4)) {
            double var21;
            float var37 = 0.2f;
            float var20 = 0.0625f;
            if ((var2 + var3 + var4 & 1) == 1) {
                var10 = (float)var8 / 256.0f;
                var12 = ((float)var8 + 15.99f) / 256.0f;
                var14 = (float)(var9 + 16) / 512.0f;
                var16 = ((float)var9 + 15.99f + 16.0f) / 512.0f;
            }
            if ((var2 / 2 + var3 / 2 + var4 / 2 & 1) == 1) {
                var21 = var12;
                var12 = var10;
                var10 = var21;
            }
            if (Block.fire.canBlockCatchFire(this.blockAccess, var2 - 1, var3, var4)) {
                if (distortion == 0) {
                    var5.addVertexWithUV((float)var2 + var37, (float)var3 + var18 + var20, var4 + 1, var12, var14);
                    var5.addVertexWithUV(var2 + 0, (float)(var3 + 0) + var20, var4 + 1, var12, var16);
                    var5.addVertexWithUV(var2 + 0, (float)(var3 + 0) + var20, var4 + 0, var10, var16);
                    var5.addVertexWithUV((float)var2 + var37, (float)var3 + var18 + var20, var4 + 0, var10, var14);
                    var5.addVertexWithUV((float)var2 + var37, (float)var3 + var18 + var20, var4 + 0, var10, var14);
                    var5.addVertexWithUV(var2 + 0, (float)(var3 + 0) + var20, var4 + 0, var10, var16);
                    var5.addVertexWithUV(var2 + 0, (float)(var3 + 0) + var20, var4 + 1, var12, var16);
                    var5.addVertexWithUV((float)var2 + var37, (float)var3 + var18 + var20, var4 + 1, var12, var14);
                } else if (distortion > 0) {
                    var5.addDistortedVertexWithUV((float)var2 + var37, (float)var3 + var18 + var20, var4 + 1, var12, var14);
                    var5.addDistortedVertexWithUV(var2 + 0, (float)(var3 + 0) + var20, var4 + 1, var12, var16);
                    var5.addDistortedVertexWithUV(var2 + 0, (float)(var3 + 0) + var20, var4 + 0, var10, var16);
                    var5.addDistortedVertexWithUV((float)var2 + var37, (float)var3 + var18 + var20, var4 + 0, var10, var14);
                    var5.addDistortedVertexWithUV((float)var2 + var37, (float)var3 + var18 + var20, var4 + 0, var10, var14);
                    var5.addDistortedVertexWithUV(var2 + 0, (float)(var3 + 0) + var20, var4 + 0, var10, var16);
                    var5.addDistortedVertexWithUV(var2 + 0, (float)(var3 + 0) + var20, var4 + 1, var12, var16);
                    var5.addDistortedVertexWithUV((float)var2 + var37, (float)var3 + var18 + var20, var4 + 1, var12, var14);
                }
            }
            if (Block.fire.canBlockCatchFire(this.blockAccess, var2 + 1, var3, var4)) {
                if (distortion == 0) {
                    var5.addVertexWithUV((float)(var2 + 1) - var37, (float)var3 + var18 + var20, var4 + 0, var10, var14);
                    var5.addVertexWithUV(var2 + 1 - 0, (float)(var3 + 0) + var20, var4 + 0, var10, var16);
                    var5.addVertexWithUV(var2 + 1 - 0, (float)(var3 + 0) + var20, var4 + 1, var12, var16);
                    var5.addVertexWithUV((float)(var2 + 1) - var37, (float)var3 + var18 + var20, var4 + 1, var12, var14);
                    var5.addVertexWithUV((float)(var2 + 1) - var37, (float)var3 + var18 + var20, var4 + 1, var12, var14);
                    var5.addVertexWithUV(var2 + 1 - 0, (float)(var3 + 0) + var20, var4 + 1, var12, var16);
                    var5.addVertexWithUV(var2 + 1 - 0, (float)(var3 + 0) + var20, var4 + 0, var10, var16);
                    var5.addVertexWithUV((float)(var2 + 1) - var37, (float)var3 + var18 + var20, var4 + 0, var10, var14);
                } else if (distortion > 0) {
                    var5.addDistortedVertexWithUV((float)(var2 + 1) - var37, (float)var3 + var18 + var20, var4 + 0, var10, var14);
                    var5.addDistortedVertexWithUV(var2 + 1 - 0, (float)(var3 + 0) + var20, var4 + 0, var10, var16);
                    var5.addDistortedVertexWithUV(var2 + 1 - 0, (float)(var3 + 0) + var20, var4 + 1, var12, var16);
                    var5.addDistortedVertexWithUV((float)(var2 + 1) - var37, (float)var3 + var18 + var20, var4 + 1, var12, var14);
                    var5.addDistortedVertexWithUV((float)(var2 + 1) - var37, (float)var3 + var18 + var20, var4 + 1, var12, var14);
                    var5.addDistortedVertexWithUV(var2 + 1 - 0, (float)(var3 + 0) + var20, var4 + 1, var12, var16);
                    var5.addDistortedVertexWithUV(var2 + 1 - 0, (float)(var3 + 0) + var20, var4 + 0, var10, var16);
                    var5.addDistortedVertexWithUV((float)(var2 + 1) - var37, (float)var3 + var18 + var20, var4 + 0, var10, var14);
                }
            }
            if (Block.fire.canBlockCatchFire(this.blockAccess, var2, var3, var4 - 1)) {
                if (distortion == 0) {
                    var5.addVertexWithUV(var2 + 0, (float)var3 + var18 + var20, (float)var4 + var37, var12, var14);
                    var5.addVertexWithUV(var2 + 0, (float)(var3 + 0) + var20, var4 + 0, var12, var16);
                    var5.addVertexWithUV(var2 + 1, (float)(var3 + 0) + var20, var4 + 0, var10, var16);
                    var5.addVertexWithUV(var2 + 1, (float)var3 + var18 + var20, (float)var4 + var37, var10, var14);
                    var5.addVertexWithUV(var2 + 1, (float)var3 + var18 + var20, (float)var4 + var37, var10, var14);
                    var5.addVertexWithUV(var2 + 1, (float)(var3 + 0) + var20, var4 + 0, var10, var16);
                    var5.addVertexWithUV(var2 + 0, (float)(var3 + 0) + var20, var4 + 0, var12, var16);
                    var5.addVertexWithUV(var2 + 0, (float)var3 + var18 + var20, (float)var4 + var37, var12, var14);
                } else if (distortion > 0) {
                    var5.addDistortedVertexWithUV(var2 + 0, (float)var3 + var18 + var20, (float)var4 + var37, var12, var14);
                    var5.addDistortedVertexWithUV(var2 + 0, (float)(var3 + 0) + var20, var4 + 0, var12, var16);
                    var5.addDistortedVertexWithUV(var2 + 1, (float)(var3 + 0) + var20, var4 + 0, var10, var16);
                    var5.addDistortedVertexWithUV(var2 + 1, (float)var3 + var18 + var20, (float)var4 + var37, var10, var14);
                    var5.addDistortedVertexWithUV(var2 + 1, (float)var3 + var18 + var20, (float)var4 + var37, var10, var14);
                    var5.addDistortedVertexWithUV(var2 + 1, (float)(var3 + 0) + var20, var4 + 0, var10, var16);
                    var5.addDistortedVertexWithUV(var2 + 0, (float)(var3 + 0) + var20, var4 + 0, var12, var16);
                    var5.addDistortedVertexWithUV(var2 + 0, (float)var3 + var18 + var20, (float)var4 + var37, var12, var14);
                }
            }
            if (Block.fire.canBlockCatchFire(this.blockAccess, var2, var3, var4 + 1)) {
                if (distortion == 0) {
                    var5.addVertexWithUV(var2 + 1, (float)var3 + var18 + var20, (float)(var4 + 1) - var37, var10, var14);
                    var5.addVertexWithUV(var2 + 1, (float)(var3 + 0) + var20, var4 + 1 - 0, var10, var16);
                    var5.addVertexWithUV(var2 + 0, (float)(var3 + 0) + var20, var4 + 1 - 0, var12, var16);
                    var5.addVertexWithUV(var2 + 0, (float)var3 + var18 + var20, (float)(var4 + 1) - var37, var12, var14);
                    var5.addVertexWithUV(var2 + 0, (float)var3 + var18 + var20, (float)(var4 + 1) - var37, var12, var14);
                    var5.addVertexWithUV(var2 + 0, (float)(var3 + 0) + var20, var4 + 1 - 0, var12, var16);
                    var5.addVertexWithUV(var2 + 1, (float)(var3 + 0) + var20, var4 + 1 - 0, var10, var16);
                    var5.addVertexWithUV(var2 + 1, (float)var3 + var18 + var20, (float)(var4 + 1) - var37, var10, var14);
                } else if (distortion > 0) {
                    var5.addDistortedVertexWithUV(var2 + 1, (float)var3 + var18 + var20, (float)(var4 + 1) - var37, var10, var14);
                    var5.addDistortedVertexWithUV(var2 + 1, (float)(var3 + 0) + var20, var4 + 1 - 0, var10, var16);
                    var5.addDistortedVertexWithUV(var2 + 0, (float)(var3 + 0) + var20, var4 + 1 - 0, var12, var16);
                    var5.addDistortedVertexWithUV(var2 + 0, (float)var3 + var18 + var20, (float)(var4 + 1) - var37, var12, var14);
                    var5.addDistortedVertexWithUV(var2 + 0, (float)var3 + var18 + var20, (float)(var4 + 1) - var37, var12, var14);
                    var5.addDistortedVertexWithUV(var2 + 0, (float)(var3 + 0) + var20, var4 + 1 - 0, var12, var16);
                    var5.addDistortedVertexWithUV(var2 + 1, (float)(var3 + 0) + var20, var4 + 1 - 0, var10, var16);
                    var5.addDistortedVertexWithUV(var2 + 1, (float)var3 + var18 + var20, (float)(var4 + 1) - var37, var10, var14);
                }
            }
            if (Block.fire.canBlockCatchFire(this.blockAccess, var2, var3 + 1, var4)) {
                var21 = (double)var2 + 0.5 + 0.5;
                double var23 = (double)var2 + 0.5 - 0.5;
                double var25 = (double)var4 + 0.5 + 0.5;
                double var27 = (double)var4 + 0.5 - 0.5;
                double var29 = (double)var2 + 0.5 - 0.5;
                double var31 = (double)var2 + 0.5 + 0.5;
                double var33 = (double)var4 + 0.5 - 0.5;
                double var35 = (double)var4 + 0.5 + 0.5;
                var10 = (float)var8 / 256.0f;
                var12 = ((float)var8 + 15.99f) / 256.0f;
                var14 = (float)var9 / 512.0f;
                var16 = ((float)var9 + 15.99f) / 512.0f;
                var18 = -0.2f;
                if ((var2 + ++var3 + var4 & 1) == 0) {
                    if (distortion == 0) {
                        var5.addVertexWithUV(var29, (float)var3 + var18, var4 + 0, var12, var14);
                        var5.addVertexWithUV(var21, var3 + 0, var4 + 0, var12, var16);
                        var5.addVertexWithUV(var21, var3 + 0, var4 + 1, var10, var16);
                        var5.addVertexWithUV(var29, (float)var3 + var18, var4 + 1, var10, var14);
                    } else if (distortion > 0) {
                        var5.addDistortedVertexWithUV(var29, (float)var3 + var18, var4 + 0, var12, var14);
                        var5.addDistortedVertexWithUV(var21, var3 + 0, var4 + 0, var12, var16);
                        var5.addDistortedVertexWithUV(var21, var3 + 0, var4 + 1, var10, var16);
                        var5.addDistortedVertexWithUV(var29, (float)var3 + var18, var4 + 1, var10, var14);
                    }
                    var10 = (float)var8 / 256.0f;
                    var12 = ((float)var8 + 15.99f) / 256.0f;
                    var14 = (float)(var9 + 16) / 512.0f;
                    var16 = ((float)var9 + 15.99f + 16.0f) / 512.0f;
                    if (distortion == 0) {
                        var5.addVertexWithUV(var31, (float)var3 + var18, var4 + 1, var12, var14);
                        var5.addVertexWithUV(var23, var3 + 0, var4 + 1, var12, var16);
                        var5.addVertexWithUV(var23, var3 + 0, var4 + 0, var10, var16);
                        var5.addVertexWithUV(var31, (float)var3 + var18, var4 + 0, var10, var14);
                    } else if (distortion > 0) {
                        var5.addDistortedVertexWithUV(var31, (float)var3 + var18, var4 + 1, var12, var14);
                        var5.addDistortedVertexWithUV(var23, var3 + 0, var4 + 1, var12, var16);
                        var5.addDistortedVertexWithUV(var23, var3 + 0, var4 + 0, var10, var16);
                        var5.addDistortedVertexWithUV(var31, (float)var3 + var18, var4 + 0, var10, var14);
                    }
                } else {
                    if (distortion == 0) {
                        var5.addVertexWithUV(var2 + 0, (float)var3 + var18, var35, var12, var14);
                        var5.addVertexWithUV(var2 + 0, var3 + 0, var27, var12, var16);
                        var5.addVertexWithUV(var2 + 1, var3 + 0, var27, var10, var16);
                        var5.addVertexWithUV(var2 + 1, (float)var3 + var18, var35, var10, var14);
                    } else if (distortion > 0) {
                        var5.addDistortedVertexWithUV(var2 + 0, (float)var3 + var18, var35, var12, var14);
                        var5.addDistortedVertexWithUV(var2 + 0, var3 + 0, var27, var12, var16);
                        var5.addDistortedVertexWithUV(var2 + 1, var3 + 0, var27, var10, var16);
                        var5.addDistortedVertexWithUV(var2 + 1, (float)var3 + var18, var35, var10, var14);
                    }
                    var10 = (float)var8 / 256.0f;
                    var12 = ((float)var8 + 15.99f) / 256.0f;
                    var14 = (float)(var9 + 16) / 512.0f;
                    var16 = ((float)var9 + 15.99f + 16.0f) / 512.0f;
                    if (distortion == 0) {
                        var5.addVertexWithUV(var2 + 1, (float)var3 + var18, var33, var12, var14);
                        var5.addVertexWithUV(var2 + 1, var3 + 0, var25, var12, var16);
                        var5.addVertexWithUV(var2 + 0, var3 + 0, var25, var10, var16);
                        var5.addVertexWithUV(var2 + 0, (float)var3 + var18, var33, var10, var14);
                    } else if (distortion > 0) {
                        var5.addDistortedVertexWithUV(var2 + 1, (float)var3 + var18, var33, var12, var14);
                        var5.addDistortedVertexWithUV(var2 + 1, var3 + 0, var25, var12, var16);
                        var5.addDistortedVertexWithUV(var2 + 0, var3 + 0, var25, var10, var16);
                        var5.addDistortedVertexWithUV(var2 + 0, (float)var3 + var18, var33, var10, var14);
                    }
                }
            }
        } else {
            double var19 = (double)var2 + 0.5 + 0.2;
            double var21 = (double)var2 + 0.5 - 0.2;
            double var23 = (double)var4 + 0.5 + 0.2;
            double var25 = (double)var4 + 0.5 - 0.2;
            double var27 = (double)var2 + 0.5 - 0.3;
            double var29 = (double)var2 + 0.5 + 0.3;
            double var31 = (double)var4 + 0.5 - 0.3;
            double var33 = (double)var4 + 0.5 + 0.3;
            if (distortion == 0) {
                var5.addVertexWithUV(var27, (float)var3 + var18, var4 + 1, var12, var14);
                var5.addVertexWithUV(var19, var3 + 0, var4 + 1, var12, var16);
                var5.addVertexWithUV(var19, var3 + 0, var4 + 0, var10, var16);
                var5.addVertexWithUV(var27, (float)var3 + var18, var4 + 0, var10, var14);
                var5.addVertexWithUV(var29, (float)var3 + var18, var4 + 0, var12, var14);
                var5.addVertexWithUV(var21, var3 + 0, var4 + 0, var12, var16);
                var5.addVertexWithUV(var21, var3 + 0, var4 + 1, var10, var16);
                var5.addVertexWithUV(var29, (float)var3 + var18, var4 + 1, var10, var14);
            } else if (distortion > 0) {
                var5.addDistortedVertexWithUV(var27, (float)var3 + var18, var4 + 1, var12, var14);
                var5.addDistortedVertexWithUV(var19, var3 + 0, var4 + 1, var12, var16);
                var5.addDistortedVertexWithUV(var19, var3 + 0, var4 + 0, var10, var16);
                var5.addDistortedVertexWithUV(var27, (float)var3 + var18, var4 + 0, var10, var14);
                var5.addDistortedVertexWithUV(var29, (float)var3 + var18, var4 + 0, var12, var14);
                var5.addDistortedVertexWithUV(var21, var3 + 0, var4 + 0, var12, var16);
                var5.addDistortedVertexWithUV(var21, var3 + 0, var4 + 1, var10, var16);
                var5.addDistortedVertexWithUV(var29, (float)var3 + var18, var4 + 1, var10, var14);
            }
            var10 = (float)var8 / 256.0f;
            var12 = ((float)var8 + 15.99f) / 256.0f;
            var14 = (float)(var9 + 16) / 512.0f;
            var16 = ((float)var9 + 15.99f + 16.0f) / 512.0f;
            if (distortion == 0) {
                var5.addVertexWithUV(var2 + 1, (float)var3 + var18, var33, var12, var14);
                var5.addVertexWithUV(var2 + 1, var3 + 0, var25, var12, var16);
                var5.addVertexWithUV(var2 + 0, var3 + 0, var25, var10, var16);
                var5.addVertexWithUV(var2 + 0, (float)var3 + var18, var33, var10, var14);
                var5.addVertexWithUV(var2 + 0, (float)var3 + var18, var31, var12, var14);
                var5.addVertexWithUV(var2 + 0, var3 + 0, var23, var12, var16);
                var5.addVertexWithUV(var2 + 1, var3 + 0, var23, var10, var16);
                var5.addVertexWithUV(var2 + 1, (float)var3 + var18, var31, var10, var14);
            } else if (distortion > 0) {
                var5.addDistortedVertexWithUV(var2 + 1, (float)var3 + var18, var33, var12, var14);
                var5.addDistortedVertexWithUV(var2 + 1, var3 + 0, var25, var12, var16);
                var5.addDistortedVertexWithUV(var2 + 0, var3 + 0, var25, var10, var16);
                var5.addDistortedVertexWithUV(var2 + 0, (float)var3 + var18, var33, var10, var14);
                var5.addDistortedVertexWithUV(var2 + 0, (float)var3 + var18, var31, var12, var14);
                var5.addDistortedVertexWithUV(var2 + 0, var3 + 0, var23, var12, var16);
                var5.addDistortedVertexWithUV(var2 + 1, var3 + 0, var23, var10, var16);
                var5.addDistortedVertexWithUV(var2 + 1, (float)var3 + var18, var31, var10, var14);
            }
            var19 = (double)var2 + 0.5 - 0.5;
            var21 = (double)var2 + 0.5 + 0.5;
            var23 = (double)var4 + 0.5 - 0.5;
            var25 = (double)var4 + 0.5 + 0.5;
            var27 = (double)var2 + 0.5 - 0.4;
            var29 = (double)var2 + 0.5 + 0.4;
            var31 = (double)var4 + 0.5 - 0.4;
            var33 = (double)var4 + 0.5 + 0.4;
            if (distortion == 0) {
                var5.addVertexWithUV(var27, (float)var3 + var18, var4 + 0, var10, var14);
                var5.addVertexWithUV(var19, var3 + 0, var4 + 0, var10, var16);
                var5.addVertexWithUV(var19, var3 + 0, var4 + 1, var12, var16);
                var5.addVertexWithUV(var27, (float)var3 + var18, var4 + 1, var12, var14);
                var5.addVertexWithUV(var29, (float)var3 + var18, var4 + 1, var10, var14);
                var5.addVertexWithUV(var21, var3 + 0, var4 + 1, var10, var16);
                var5.addVertexWithUV(var21, var3 + 0, var4 + 0, var12, var16);
                var5.addVertexWithUV(var29, (float)var3 + var18, var4 + 0, var12, var14);
            } else if (distortion > 0) {
                var5.addDistortedVertexWithUV(var27, (float)var3 + var18, var4 + 0, var10, var14);
                var5.addDistortedVertexWithUV(var19, var3 + 0, var4 + 0, var10, var16);
                var5.addDistortedVertexWithUV(var19, var3 + 0, var4 + 1, var12, var16);
                var5.addDistortedVertexWithUV(var27, (float)var3 + var18, var4 + 1, var12, var14);
                var5.addDistortedVertexWithUV(var29, (float)var3 + var18, var4 + 1, var10, var14);
                var5.addDistortedVertexWithUV(var21, var3 + 0, var4 + 1, var10, var16);
                var5.addDistortedVertexWithUV(var21, var3 + 0, var4 + 0, var12, var16);
                var5.addDistortedVertexWithUV(var29, (float)var3 + var18, var4 + 0, var12, var14);
            }
            var10 = (float)var8 / 256.0f;
            var12 = ((float)var8 + 15.99f) / 256.0f;
            var14 = (float)var9 / 512.0f;
            var16 = ((float)var9 + 15.99f) / 512.0f;
            if (distortion == 0) {
                var5.addVertexWithUV(var2 + 0, (float)var3 + var18, var33, var10, var14);
                var5.addVertexWithUV(var2 + 0, var3 + 0, var25, var10, var16);
                var5.addVertexWithUV(var2 + 1, var3 + 0, var25, var12, var16);
                var5.addVertexWithUV(var2 + 1, (float)var3 + var18, var33, var12, var14);
                var5.addVertexWithUV(var2 + 1, (float)var3 + var18, var31, var10, var14);
                var5.addVertexWithUV(var2 + 1, var3 + 0, var23, var10, var16);
                var5.addVertexWithUV(var2 + 0, var3 + 0, var23, var12, var16);
                var5.addVertexWithUV(var2 + 0, (float)var3 + var18, var31, var12, var14);
            } else if (distortion > 0) {
                var5.addDistortedVertexWithUV(var2 + 0, (float)var3 + var18, var33, var10, var14);
                var5.addDistortedVertexWithUV(var2 + 0, var3 + 0, var25, var10, var16);
                var5.addDistortedVertexWithUV(var2 + 1, var3 + 0, var25, var12, var16);
                var5.addDistortedVertexWithUV(var2 + 1, (float)var3 + var18, var33, var12, var14);
                var5.addDistortedVertexWithUV(var2 + 1, (float)var3 + var18, var31, var10, var14);
                var5.addDistortedVertexWithUV(var2 + 1, var3 + 0, var23, var10, var16);
                var5.addDistortedVertexWithUV(var2 + 0, var3 + 0, var23, var12, var16);
                var5.addDistortedVertexWithUV(var2 + 0, (float)var3 + var18, var31, var12, var14);
            }
        }
        return true;
    }

    public boolean renderBlockRedstoneWire(Block block, int x, int y, int z) {
        boolean var23;
        Tessellator instance = Tessellator.instance;
        int texture = block.getBlockTextureFromSideAndMetadata(2, this.blockAccess.getBlockMetadata(x, y, z));
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        float light = block.getBlockBrightness(this.blockAccess, x, y, z);
        instance.setColorOpaque_F(light, light, light);
        int var8 = (texture & 0xF) << 4;
        int var9 = texture & 0xFF0;
        double minX = (float)var8 / 256.0f;
        double maxX = ((float)var8 + 15.99f) / 256.0f;
        double minY = (float)var9 / 512.0f;
        double maxY = ((float)var9 + 15.99f) / 512.0f;
        float var18 = 0.0f;
        float var19 = 0.015625f;
        boolean var20 = BlockGearCircuit.isPowerProviderOrWire(this.blockAccess, x - 1, y, z, -1) || !this.blockAccess.isBlockOpaqueCube(x - 1, y, z) && BlockGearCircuit.isPowerProviderOrWire(this.blockAccess, x - 1, y - 1, z, -1);
        boolean var21 = BlockGearCircuit.isPowerProviderOrWire(this.blockAccess, x + 1, y, z, -1) || !this.blockAccess.isBlockOpaqueCube(x + 1, y, z) && BlockGearCircuit.isPowerProviderOrWire(this.blockAccess, x + 1, y - 1, z, -1);
        boolean var22 = BlockGearCircuit.isPowerProviderOrWire(this.blockAccess, x, y, z - 1, -1) || !this.blockAccess.isBlockOpaqueCube(x, y, z - 1) && BlockGearCircuit.isPowerProviderOrWire(this.blockAccess, x, y - 1, z - 1, -1);
        boolean bl = var23 = BlockGearCircuit.isPowerProviderOrWire(this.blockAccess, x, y, z + 1, -1) || !this.blockAccess.isBlockOpaqueCube(x, y, z + 1) && BlockGearCircuit.isPowerProviderOrWire(this.blockAccess, x, y - 1, z + 1, -1);
        if (!this.blockAccess.isBlockOpaqueCube(x, y + 1, z)) {
            if (this.blockAccess.isBlockOpaqueCube(x - 1, y, z) && BlockGearCircuit.isPowerProviderOrWire(this.blockAccess, x - 1, y + 1, z, -1)) {
                var20 = true;
            }
            if (this.blockAccess.isBlockOpaqueCube(x + 1, y, z) && BlockGearCircuit.isPowerProviderOrWire(this.blockAccess, x + 1, y + 1, z, -1)) {
                var21 = true;
            }
            if (this.blockAccess.isBlockOpaqueCube(x, y, z - 1) && BlockGearCircuit.isPowerProviderOrWire(this.blockAccess, x, y + 1, z - 1, -1)) {
                var22 = true;
            }
            if (this.blockAccess.isBlockOpaqueCube(x, y, z + 1) && BlockGearCircuit.isPowerProviderOrWire(this.blockAccess, x, y + 1, z + 1, -1)) {
                var23 = true;
            }
        }
        float var24 = 0.15625f;
        float var25 = x + 0;
        float var26 = x + 1;
        float var27 = z + 0;
        float var28 = z + 1;
        int var29 = 0;
        if ((var20 || var21) && !var22 && !var23) {
            var29 = 1;
        }
        if ((var22 || var23) && !var21 && !var20) {
            var29 = 2;
        }
        if (var29 != 0) {
            minX = (float)(var8 + 16) / 256.0f;
            maxX = ((float)(var8 + 16) + 15.99f) / 256.0f;
            minY = (float)var9 / 512.0f;
            maxY = ((float)var9 + 15.99f) / 512.0f;
        }
        if (var29 == 0) {
            if (var21 || var22 || var23 || var20) {
                if (!var20) {
                    var25 += var24;
                }
                if (!var20) {
                    minX += (double)(var24 / 16.0f);
                }
                if (!var21) {
                    var26 -= var24;
                }
                if (!var21) {
                    maxX -= (double)(var24 / 16.0f);
                }
                if (!var22) {
                    var27 += var24;
                }
                if (!var22) {
                    minY += (double)(var24 / 32.0f);
                }
                if (!var23) {
                    var28 -= var24;
                }
                if (!var23) {
                    maxY -= (double)(var24 / 32.0f);
                }
            }
            instance.addVertexWithUV(var26, (float)y + var19, var28, maxX, maxY);
            instance.addVertexWithUV(var26, (float)y + var19, var27, maxX, minY);
            instance.addVertexWithUV(var25, (float)y + var19, var27, minX, minY);
            instance.addVertexWithUV(var25, (float)y + var19, var28, minX, maxY);
            instance.addVertexWithUV(var26, (float)y + var19, var27, maxX, maxY);
            instance.addVertexWithUV(var26, (float)y + var19, var28, maxX, minY);
            instance.addVertexWithUV(var25, (float)y + var19, var28, minX, minY);
            instance.addVertexWithUV(var25, (float)y + var19, var27, minX, maxY);
        }
        if (var29 == 1) {
            instance.addVertexWithUV(var26, (float)y + var19, var28, maxX, maxY);
            instance.addVertexWithUV(var26, (float)y + var19, var27, maxX, minY);
            instance.addVertexWithUV(var25, (float)y + var19, var27, minX, minY);
            instance.addVertexWithUV(var25, (float)y + var19, var28, minX, maxY);
            instance.addVertexWithUV(var26, (float)y + var19, var27, maxX, maxY);
            instance.addVertexWithUV(var26, (float)y + var19, var28, maxX, minY);
            instance.addVertexWithUV(var25, (float)y + var19, var28, minX, minY);
            instance.addVertexWithUV(var25, (float)y + var19, var27, minX, maxY);
        }
        if (var29 == 2) {
            instance.addVertexWithUV(var26, (float)y + var19, var28, maxX, maxY);
            instance.addVertexWithUV(var26, (float)y + var19, var27, minX, maxY);
            instance.addVertexWithUV(var25, (float)y + var19, var27, minX, minY);
            instance.addVertexWithUV(var25, (float)y + var19, var28, maxX, minY);
            instance.addVertexWithUV(var26, (float)y + var19, var27, maxX, maxY);
            instance.addVertexWithUV(var26, (float)y + var19, var28, minX, maxY);
            instance.addVertexWithUV(var25, (float)y + var19, var28, minX, minY);
            instance.addVertexWithUV(var25, (float)y + var19, var27, maxX, minY);
        }
        return true;
    }

    public boolean renderBlockMinecartTrack(BlockRail var1, int var2, int var3, int var4) {
        Tessellator var5 = Tessellator.instance;
        int var6 = this.blockAccess.getBlockMetadata(var2, var3, var4);
        int var7 = var1.getBlockTextureFromSideAndMetadata(0, var6);
        if (this.overrideBlockTexture >= 0) {
            var7 = this.overrideBlockTexture;
        }
        if (var1.getIsPowered()) {
            var6 &= 7;
        }
        float var8 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4);
        var5.setColorOpaque_F(var8, var8, var8);
        int var9 = (var7 & 0xF) << 4;
        int var10 = var7 & 0xFF0;
        double var11 = (float)var9 / 256.0f;
        double var13 = ((float)var9 + 15.99f) / 256.0f;
        double var15 = (float)var10 / 512.0f;
        double var17 = ((float)var10 + 15.99f) / 512.0f;
        float var19 = 0.0625f;
        float var20 = var2 + 1;
        float var21 = var2 + 1;
        float var22 = var2 + 0;
        float var23 = var2 + 0;
        float var24 = var4 + 0;
        float var25 = var4 + 1;
        float var26 = var4 + 1;
        float var27 = var4 + 0;
        float var28 = (float)var3 + var19;
        float var29 = (float)var3 + var19;
        float var30 = (float)var3 + var19;
        float var31 = (float)var3 + var19;
        if (var6 != 1 && var6 != 2 && var6 != 3 && var6 != 7) {
            if (var6 == 8) {
                var20 = var21 = (float)(var2 + 0);
                var22 = var23 = (float)(var2 + 1);
                var24 = var27 = (float)(var4 + 1);
                var25 = var26 = (float)(var4 + 0);
            } else if (var6 == 9) {
                var20 = var23 = (float)(var2 + 0);
                var21 = var22 = (float)(var2 + 1);
                var24 = var25 = (float)(var4 + 0);
                var26 = var27 = (float)(var4 + 1);
            }
        } else {
            var20 = var23 = (float)(var2 + 1);
            var21 = var22 = (float)(var2 + 0);
            var24 = var25 = (float)(var4 + 1);
            var26 = var27 = (float)(var4 + 0);
        }
        if (var6 != 2 && var6 != 4) {
            if (var6 == 3 || var6 == 5) {
                var29 += 1.0f;
                var30 += 1.0f;
            }
        } else {
            var28 += 1.0f;
            var31 += 1.0f;
        }
        if (distortion == 0) {
            var5.addVertexWithUV(var20, var28, var24, var13, var15);
            var5.addVertexWithUV(var21, var29, var25, var13, var17);
            var5.addVertexWithUV(var22, var30, var26, var11, var17);
            var5.addVertexWithUV(var23, var31, var27, var11, var15);
            var5.addVertexWithUV(var23, var31, var27, var11, var15);
            var5.addVertexWithUV(var22, var30, var26, var11, var17);
            var5.addVertexWithUV(var21, var29, var25, var13, var17);
            var5.addVertexWithUV(var20, var28, var24, var13, var15);
        } else if (distortion > 0) {
            var5.addDistortedVertexWithUV(var20, var28, var24, var13, var15);
            var5.addDistortedVertexWithUV(var21, var29, var25, var13, var17);
            var5.addDistortedVertexWithUV(var22, var30, var26, var11, var17);
            var5.addDistortedVertexWithUV(var23, var31, var27, var11, var15);
            var5.addDistortedVertexWithUV(var23, var31, var27, var11, var15);
            var5.addDistortedVertexWithUV(var22, var30, var26, var11, var17);
            var5.addDistortedVertexWithUV(var21, var29, var25, var13, var17);
            var5.addDistortedVertexWithUV(var20, var28, var24, var13, var15);
        }
        return true;
    }

    public boolean renderBlockLadder(Block var1, int var2, int var3, int var4) {
        Tessellator var5 = Tessellator.instance;
        int var6 = var1.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            var6 = this.overrideBlockTexture;
        }
        float var7 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4);
        var5.setColorOpaque_F(var7, var7, var7);
        int var8 = (var6 & 0xF) << 4;
        int var9 = var6 & 0xFF0;
        double var10 = (float)var8 / 256.0f;
        double var12 = ((float)var8 + 15.99f) / 256.0f;
        double var14 = (float)var9 / 512.0f;
        double var16 = ((float)var9 + 15.99f) / 512.0f;
        int var18 = this.blockAccess.getBlockMetadata(var2, var3, var4);
        float var19 = 0.0f;
        float var20 = 0.05f;
        if (var18 == 5) {
            var5.addVertexWithUV((float)var2 + var20, (float)(var3 + 1) + var19, (float)(var4 + 1) + var19, var10, var14);
            var5.addVertexWithUV((float)var2 + var20, (float)(var3 + 0) - var19, (float)(var4 + 1) + var19, var10, var16);
            var5.addVertexWithUV((float)var2 + var20, (float)(var3 + 0) - var19, (float)(var4 + 0) - var19, var12, var16);
            var5.addVertexWithUV((float)var2 + var20, (float)(var3 + 1) + var19, (float)(var4 + 0) - var19, var12, var14);
            if (distortion == 2) {
                var5.addDistortedVertexWithUV((float)var2 + var20, (float)(var3 + 1) + var19, (float)(var4 + 1) + var19, var10, var14);
                var5.addDistortedVertexWithUV((float)var2 + var20, (float)(var3 + 0) - var19, (float)(var4 + 1) + var19, var10, var16);
                var5.addDistortedVertexWithUV((float)var2 + var20, (float)(var3 + 0) - var19, (float)(var4 + 0) - var19, var12, var16);
                var5.addDistortedVertexWithUV((float)var2 + var20, (float)(var3 + 1) + var19, (float)(var4 + 0) - var19, var12, var14);
            }
        }
        if (var18 == 4) {
            var5.addVertexWithUV((float)(var2 + 1) - var20, (float)(var3 + 0) - var19, (float)(var4 + 1) + var19, var12, var16);
            var5.addVertexWithUV((float)(var2 + 1) - var20, (float)(var3 + 1) + var19, (float)(var4 + 1) + var19, var12, var14);
            var5.addVertexWithUV((float)(var2 + 1) - var20, (float)(var3 + 1) + var19, (float)(var4 + 0) - var19, var10, var14);
            var5.addVertexWithUV((float)(var2 + 1) - var20, (float)(var3 + 0) - var19, (float)(var4 + 0) - var19, var10, var16);
            if (distortion == 2) {
                var5.addDistortedVertexWithUV((float)(var2 + 1) - var20, (float)(var3 + 0) - var19, (float)(var4 + 1) + var19, var12, var16);
                var5.addDistortedVertexWithUV((float)(var2 + 1) - var20, (float)(var3 + 1) + var19, (float)(var4 + 1) + var19, var12, var14);
                var5.addDistortedVertexWithUV((float)(var2 + 1) - var20, (float)(var3 + 1) + var19, (float)(var4 + 0) - var19, var10, var14);
                var5.addDistortedVertexWithUV((float)(var2 + 1) - var20, (float)(var3 + 0) - var19, (float)(var4 + 0) - var19, var10, var16);
            }
        }
        if (var18 == 3) {
            var5.addVertexWithUV((float)(var2 + 1) + var19, (float)(var3 + 0) - var19, (float)var4 + var20, var12, var16);
            var5.addVertexWithUV((float)(var2 + 1) + var19, (float)(var3 + 1) + var19, (float)var4 + var20, var12, var14);
            var5.addVertexWithUV((float)(var2 + 0) - var19, (float)(var3 + 1) + var19, (float)var4 + var20, var10, var14);
            var5.addVertexWithUV((float)(var2 + 0) - var19, (float)(var3 + 0) - var19, (float)var4 + var20, var10, var16);
            if (distortion == 2) {
                var5.addDistortedVertexWithUV((float)(var2 + 1) + var19, (float)(var3 + 0) - var19, (float)var4 + var20, var12, var16);
                var5.addDistortedVertexWithUV((float)(var2 + 1) + var19, (float)(var3 + 1) + var19, (float)var4 + var20, var12, var14);
                var5.addDistortedVertexWithUV((float)(var2 + 0) - var19, (float)(var3 + 1) + var19, (float)var4 + var20, var10, var14);
                var5.addDistortedVertexWithUV((float)(var2 + 0) - var19, (float)(var3 + 0) - var19, (float)var4 + var20, var10, var16);
            }
        }
        if (var18 == 2) {
            var5.addVertexWithUV((float)(var2 + 1) + var19, (float)(var3 + 1) + var19, (float)(var4 + 1) - var20, var10, var14);
            var5.addVertexWithUV((float)(var2 + 1) + var19, (float)(var3 + 0) - var19, (float)(var4 + 1) - var20, var10, var16);
            var5.addVertexWithUV((float)(var2 + 0) - var19, (float)(var3 + 0) - var19, (float)(var4 + 1) - var20, var12, var16);
            var5.addVertexWithUV((float)(var2 + 0) - var19, (float)(var3 + 1) + var19, (float)(var4 + 1) - var20, var12, var14);
            if (distortion == 2) {
                var5.addDistortedVertexWithUV((float)(var2 + 1) + var19, (float)(var3 + 1) + var19, (float)(var4 + 1) - var20, var10, var14);
                var5.addDistortedVertexWithUV((float)(var2 + 1) + var19, (float)(var3 + 0) - var19, (float)(var4 + 1) - var20, var10, var16);
                var5.addDistortedVertexWithUV((float)(var2 + 0) - var19, (float)(var3 + 0) - var19, (float)(var4 + 1) - var20, var12, var16);
                var5.addDistortedVertexWithUV((float)(var2 + 0) - var19, (float)(var3 + 1) + var19, (float)(var4 + 1) - var20, var12, var14);
            }
        }
        return true;
    }

    public boolean renderBlockPlant(Block var1, int var2, int var3, int var4) {
        Tessellator var5 = Tessellator.instance;
        float var6 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4);
        int var7 = var1.colorMultiplier(this.blockAccess, var2, var3, var4);
        float var8 = (float)(var7 >> 16 & 0xFF) / 255.0f;
        float var9 = (float)(var7 >> 8 & 0xFF) / 255.0f;
        float var10 = (float)(var7 & 0xFF) / 255.0f;
        if (EntityRenderer.field_28135_a) {
            float var11 = (var8 * 30.0f + var9 * 59.0f + var10 * 11.0f) / 100.0f;
            float var12 = (var8 * 30.0f + var9 * 70.0f) / 100.0f;
            float var13 = (var8 * 30.0f + var10 * 70.0f) / 100.0f;
            var8 = var11;
            var9 = var12;
            var10 = var13;
        }
        var5.setColorOpaque_F(var6 * var8, var6 * var9, var6 * var10);
        double var19 = var2;
        double var20 = var3;
        double var15 = var4;
        this.renderCrossedSquares(var1, this.blockAccess.getBlockMetadata(var2, var3, var4), var19, var20, var15);
        return true;
    }

    public boolean renderBlockCrops(Block var1, int var2, int var3, int var4) {
        Tessellator var5 = Tessellator.instance;
        float var6 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4);
        var5.setColorOpaque_F(var6, var6, var6);
        if (distortion == 0) {
            this.renderCropBase(var1, this.blockAccess.getBlockMetadata(var2, var3, var4), var2, (float)var3 - 0.0625f, var4);
        } else if (distortion > 0) {
            this.renderCropBaseDistorted(var1, this.blockAccess.getBlockMetadata(var2, var3, var4), var2, (float)var3 - 0.0625f, var4);
        }
        return true;
    }

    public void renderTorchAtAngle(Block block, double xCoord, double yCoord, double zCoord, double xRot, double zRot, boolean isTorchUpsideDown) {
        Tessellator instance = Tessellator.instance;
        int texture = block.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int texture2 = block.blockID == Block.torch.blockID ? 288 : 30;
        if (this.overrideBlockTexture >= 0) {
            texture2 = this.overrideBlockTexture;
        }
        int textureTorchTopReversed = 289;
        if (this.overrideBlockTexture >= 0) {
            textureTorchTopReversed = this.overrideBlockTexture;
        }
        int textureTorchReversed = 13;
        if (this.overrideBlockTexture >= 0) {
            textureTorchReversed = this.overrideBlockTexture;
        }
        int var14 = (texture & 0xF) << 4;
        int var15 = texture & 0xFF0;
        float minX = (float)var14 / 256.0f;
        float maxX = ((float)var14 + 15.99f) / 256.0f;
        float minY = (float)var15 / 512.0f;
        float maxY = ((float)var15 + 15.99f) / 512.0f;
        double var20 = (double)minX + 0.02734375;
        double var22 = (double)minY + 0.01171875;
        double var24 = (double)minX + 0.03515625;
        double var26 = (double)minY + 0.015625;
        int var140 = (texture2 & 0xF) << 4;
        int var150 = texture2 & 0xFF0;
        float minX2 = (float)var140 / 256.0f;
        float maxX2 = ((float)var140 + 15.99f) / 256.0f;
        float minY2 = (float)var150 / 512.0f;
        float maxY2 = ((float)var150 + 15.99f) / 512.0f;
        double var200 = (double)minX2 + 0.02734375;
        double var220 = (double)minY2 + 0.01171875;
        double var240 = (double)minX2 + 0.03515625;
        double var260 = (double)minY2 + 0.015625;
        int var1400 = (textureTorchTopReversed & 0xF) << 4;
        int var1500 = textureTorchTopReversed & 0xFF0;
        float minX20 = (float)var1400 / 256.0f;
        float maxX20 = ((float)var1400 + 15.99f) / 256.0f;
        float minY20 = (float)var1500 / 512.0f;
        float maxY20 = ((float)var1500 + 15.99f) / 512.0f;
        double var2000 = (double)minX20 + 0.02734375;
        double var2200 = (double)minY20 + 0.01171875;
        double var2400 = (double)minX20 + 0.03515625;
        double var2600 = (double)minY20 + 0.015625;
        int var14000 = (textureTorchReversed & 0xF) << 4;
        int var15000 = textureTorchReversed & 0xFF0;
        float minX200 = (float)var14000 / 256.0f;
        float maxX200 = ((float)var14000 + 15.99f) / 256.0f;
        float minY200 = (float)var15000 / 512.0f;
        float maxY200 = ((float)var15000 + 15.99f) / 512.0f;
        double var20000 = (double)minX200 + 0.02734375;
        double var22000 = (double)minY200 + 0.01171875;
        double var24000 = (double)minX200 + 0.03515625;
        double var26000 = (double)minY200 + 0.015625;
        double var28 = (xCoord += 0.5) - 0.5;
        double var30 = xCoord + 0.5;
        double var32 = (zCoord += 0.5) - 0.5;
        double var34 = zCoord + 0.5;
        double var36 = 0.0625;
        double var38 = 0.625;
        if (!isTorchUpsideDown) {
            instance.addVertexWithUV(xCoord + xRot * (1.0 - var38) - var36, yCoord + var38, zCoord + zRot * (1.0 - var38) - var36, var20, var22);
            instance.addVertexWithUV(xCoord + xRot * (1.0 - var38) - var36, yCoord + var38, zCoord + zRot * (1.0 - var38) + var36, var20, var26);
            instance.addVertexWithUV(xCoord + xRot * (1.0 - var38) + var36, yCoord + var38, zCoord + zRot * (1.0 - var38) + var36, var24, var26);
            instance.addVertexWithUV(xCoord + xRot * (1.0 - var38) + var36, yCoord + var38, zCoord + zRot * (1.0 - var38) - var36, var24, var22);
            instance.addVertexWithUV(xCoord + xRot * 1.0 - var36, yCoord, zCoord + zRot * 1.0 + var36, var200, var220);
            instance.addVertexWithUV(xCoord + xRot * 1.0 - var36, yCoord, zCoord + zRot * 1.0 - var36, var200, var260);
            instance.addVertexWithUV(xCoord + xRot * 1.0 + var36, yCoord, zCoord + zRot * 1.0 - var36, var240, var260);
            instance.addVertexWithUV(xCoord + xRot * 1.0 + var36, yCoord, zCoord + zRot * 1.0 + var36, var240, var220);
            instance.addVertexWithUV(xCoord - var36, yCoord + 1.0, var32, minX, minY);
            instance.addVertexWithUV(xCoord - var36 + xRot, yCoord + 0.0, var32 + zRot, minX, maxY);
            instance.addVertexWithUV(xCoord - var36 + xRot, yCoord + 0.0, var34 + zRot, maxX, maxY);
            instance.addVertexWithUV(xCoord - var36, yCoord + 1.0, var34, maxX, minY);
            instance.addVertexWithUV(xCoord + var36, yCoord + 1.0, var34, minX, minY);
            instance.addVertexWithUV(xCoord + xRot + var36, yCoord + 0.0, var34 + zRot, minX, maxY);
            instance.addVertexWithUV(xCoord + xRot + var36, yCoord + 0.0, var32 + zRot, maxX, maxY);
            instance.addVertexWithUV(xCoord + var36, yCoord + 1.0, var32, maxX, minY);
            instance.addVertexWithUV(var28, yCoord + 1.0, zCoord + var36, minX, minY);
            instance.addVertexWithUV(var28 + xRot, yCoord + 0.0, zCoord + var36 + zRot, minX, maxY);
            instance.addVertexWithUV(var30 + xRot, yCoord + 0.0, zCoord + var36 + zRot, maxX, maxY);
            instance.addVertexWithUV(var30, yCoord + 1.0, zCoord + var36, maxX, minY);
            instance.addVertexWithUV(var30, yCoord + 1.0, zCoord - var36, minX, minY);
            instance.addVertexWithUV(var30 + xRot, yCoord + 0.0, zCoord - var36 + zRot, minX, maxY);
            instance.addVertexWithUV(var28 + xRot, yCoord + 0.0, zCoord - var36 + zRot, maxX, maxY);
            instance.addVertexWithUV(var28, yCoord + 1.0, zCoord - var36, maxX, minY);
        } else {
            instance.addVertexWithUV(xCoord + xRot * (1.0 - var38) - var36, yCoord + var38, zCoord + zRot * (1.0 - var38) - var36, var200, var220);
            instance.addVertexWithUV(xCoord + xRot * (1.0 - var38) - var36, yCoord + var38, zCoord + zRot * (1.0 - var38) + var36, var200, var260);
            instance.addVertexWithUV(xCoord + xRot * (1.0 - var38) + var36, yCoord + var38, zCoord + zRot * (1.0 - var38) + var36, var240, var260);
            instance.addVertexWithUV(xCoord + xRot * (1.0 - var38) + var36, yCoord + var38, zCoord + zRot * (1.0 - var38) - var36, var240, var220);
            instance.addVertexWithUV(xCoord + xRot * 1.0 - var36, yCoord, zCoord + zRot * 1.0 + var36, var2000, var2200);
            instance.addVertexWithUV(xCoord + xRot * 1.0 - var36, yCoord, zCoord + zRot * 1.0 - var36, var2000, var2600);
            instance.addVertexWithUV(xCoord + xRot * 1.0 + var36, yCoord, zCoord + zRot * 1.0 - var36, var2400, var2600);
            instance.addVertexWithUV(xCoord + xRot * 1.0 + var36, yCoord, zCoord + zRot * 1.0 + var36, var2400, var2200);
            instance.addVertexWithUV(xCoord - var36, yCoord + 1.0, var32, minX200, minY200);
            instance.addVertexWithUV(xCoord - var36 + xRot, yCoord + 0.0, var32 + zRot, minX200, maxY200);
            instance.addVertexWithUV(xCoord - var36 + xRot, yCoord + 0.0, var34 + zRot, maxX200, maxY200);
            instance.addVertexWithUV(xCoord - var36, yCoord + 1.0, var34, maxX200, minY200);
            instance.addVertexWithUV(xCoord + var36, yCoord + 1.0, var34, minX200, minY200);
            instance.addVertexWithUV(xCoord + xRot + var36, yCoord + 0.0, var34 + zRot, minX200, maxY200);
            instance.addVertexWithUV(xCoord + xRot + var36, yCoord + 0.0, var32 + zRot, maxX200, maxY200);
            instance.addVertexWithUV(xCoord + var36, yCoord + 1.0, var32, maxX200, minY200);
            instance.addVertexWithUV(var28, yCoord + 1.0, zCoord + var36, minX200, minY200);
            instance.addVertexWithUV(var28 + xRot, yCoord + 0.0, zCoord + var36 + zRot, minX200, maxY200);
            instance.addVertexWithUV(var30 + xRot, yCoord + 0.0, zCoord + var36 + zRot, maxX200, maxY200);
            instance.addVertexWithUV(var30, yCoord + 1.0, zCoord + var36, maxX200, minY200);
            instance.addVertexWithUV(var30, yCoord + 1.0, zCoord - var36, minX200, minY200);
            instance.addVertexWithUV(var30 + xRot, yCoord + 0.0, zCoord - var36 + zRot, minX200, maxY200);
            instance.addVertexWithUV(var28 + xRot, yCoord + 0.0, zCoord - var36 + zRot, maxX200, maxY200);
            instance.addVertexWithUV(var28, yCoord + 1.0, zCoord - var36, maxX200, minY200);
        }
    }

    public void renderCrossedSquares(Block var1, int var2, double var3, double var5, double var7) {
        Tessellator var9 = Tessellator.instance;
        int var10 = var1.getBlockTextureFromSideAndMetadata(0, var2);
        if (this.overrideBlockTexture >= 0) {
            var10 = this.overrideBlockTexture;
        }
        int var11 = (var10 & 0xF) << 4;
        int var12 = var10 & 0xFF0;
        double var13 = (float)var11 / 256.0f;
        double var15 = ((float)var11 + 15.99f) / 256.0f;
        double var17 = (float)var12 / 512.0f;
        double var19 = ((float)var12 + 15.99f) / 512.0f;
        double var21 = var3 + 0.5 - (double)0.45f;
        double var23 = var3 + 0.5 + (double)0.45f;
        double var25 = var7 + 0.5 - (double)0.45f;
        double var27 = var7 + 0.5 + (double)0.45f;
        if (distortion == 0) {
            var9.addVertexWithUV(var21, var5 + 1.0, var25, var13, var17);
            var9.addVertexWithUV(var21, var5 + 0.0, var25, var13, var19);
            var9.addVertexWithUV(var23, var5 + 0.0, var27, var15, var19);
            var9.addVertexWithUV(var23, var5 + 1.0, var27, var15, var17);
            var9.addVertexWithUV(var23, var5 + 1.0, var27, var13, var17);
            var9.addVertexWithUV(var23, var5 + 0.0, var27, var13, var19);
            var9.addVertexWithUV(var21, var5 + 0.0, var25, var15, var19);
            var9.addVertexWithUV(var21, var5 + 1.0, var25, var15, var17);
            var9.addVertexWithUV(var21, var5 + 1.0, var27, var13, var17);
            var9.addVertexWithUV(var21, var5 + 0.0, var27, var13, var19);
            var9.addVertexWithUV(var23, var5 + 0.0, var25, var15, var19);
            var9.addVertexWithUV(var23, var5 + 1.0, var25, var15, var17);
            var9.addVertexWithUV(var23, var5 + 1.0, var25, var13, var17);
            var9.addVertexWithUV(var23, var5 + 0.0, var25, var13, var19);
            var9.addVertexWithUV(var21, var5 + 0.0, var27, var15, var19);
            var9.addVertexWithUV(var21, var5 + 1.0, var27, var15, var17);
        } else if (distortion > 0) {
            var9.addDistortedVertexWithUV(var21, var5 + 1.0 - 0.05325, var25, var13, var17);
            var9.addDistortedVertexWithUV(var21, var5 + 0.0 - 0.05325, var25, var13, var19);
            var9.addDistortedVertexWithUV(var23, var5 + 0.0 - 0.05325, var27, var15, var19);
            var9.addDistortedVertexWithUV(var23, var5 + 1.0 - 0.05325, var27, var15, var17);
            var9.addDistortedVertexWithUV(var23, var5 + 1.0 - 0.05325, var27, var13, var17);
            var9.addDistortedVertexWithUV(var23, var5 + 0.0 - 0.05325, var27, var13, var19);
            var9.addDistortedVertexWithUV(var21, var5 + 0.0 - 0.05325, var25, var15, var19);
            var9.addDistortedVertexWithUV(var21, var5 + 1.0 - 0.05325, var25, var15, var17);
            var9.addDistortedVertexWithUV(var21, var5 + 1.0 - 0.05325, var27, var13, var17);
            var9.addDistortedVertexWithUV(var21, var5 + 0.0 - 0.05325, var27, var13, var19);
            var9.addDistortedVertexWithUV(var23, var5 + 0.0 - 0.05325, var25, var15, var19);
            var9.addDistortedVertexWithUV(var23, var5 + 1.0 - 0.05325, var25, var15, var17);
            var9.addDistortedVertexWithUV(var23, var5 + 1.0 - 0.05325, var25, var13, var17);
            var9.addDistortedVertexWithUV(var23, var5 + 0.0 - 0.05325, var25, var13, var19);
            var9.addDistortedVertexWithUV(var21, var5 + 0.0 - 0.05325, var27, var15, var19);
            var9.addDistortedVertexWithUV(var21, var5 + 1.0 - 0.05325, var27, var15, var17);
        }
    }

    public void renderCropBase(Block var1, int var2, double var3, double var5, double var7) {
        Tessellator var9 = Tessellator.instance;
        int var10 = var1.getBlockTextureFromSideAndMetadata(0, var2);
        if (this.overrideBlockTexture >= 0) {
            var10 = this.overrideBlockTexture;
        }
        int var11 = (var10 & 0xF) << 4;
        int var12 = var10 & 0xFF0;
        double var13 = (float)var11 / 256.0f;
        double var15 = ((float)var11 + 15.99f) / 256.0f;
        double var17 = (float)var12 / 512.0f;
        double var19 = ((float)var12 + 15.99f) / 512.0f;
        double var21 = var3 + 0.5 - 0.25;
        double var23 = var3 + 0.5 + 0.25;
        double var25 = var7 + 0.5 - 0.5;
        double var27 = var7 + 0.5 + 0.5;
        var9.addVertexWithUV(var21, var5 + 1.0, var25, var13, var17);
        var9.addVertexWithUV(var21, var5 + 0.0, var25, var13, var19);
        var9.addVertexWithUV(var21, var5 + 0.0, var27, var15, var19);
        var9.addVertexWithUV(var21, var5 + 1.0, var27, var15, var17);
        var9.addVertexWithUV(var21, var5 + 1.0, var27, var13, var17);
        var9.addVertexWithUV(var21, var5 + 0.0, var27, var13, var19);
        var9.addVertexWithUV(var21, var5 + 0.0, var25, var15, var19);
        var9.addVertexWithUV(var21, var5 + 1.0, var25, var15, var17);
        var9.addVertexWithUV(var23, var5 + 1.0, var27, var13, var17);
        var9.addVertexWithUV(var23, var5 + 0.0, var27, var13, var19);
        var9.addVertexWithUV(var23, var5 + 0.0, var25, var15, var19);
        var9.addVertexWithUV(var23, var5 + 1.0, var25, var15, var17);
        var9.addVertexWithUV(var23, var5 + 1.0, var25, var13, var17);
        var9.addVertexWithUV(var23, var5 + 0.0, var25, var13, var19);
        var9.addVertexWithUV(var23, var5 + 0.0, var27, var15, var19);
        var9.addVertexWithUV(var23, var5 + 1.0, var27, var15, var17);
        var21 = var3 + 0.5 - 0.5;
        var23 = var3 + 0.5 + 0.5;
        var25 = var7 + 0.5 - 0.25;
        var27 = var7 + 0.5 + 0.25;
        var9.addVertexWithUV(var21, var5 + 1.0, var25, var13, var17);
        var9.addVertexWithUV(var21, var5 + 0.0, var25, var13, var19);
        var9.addVertexWithUV(var23, var5 + 0.0, var25, var15, var19);
        var9.addVertexWithUV(var23, var5 + 1.0, var25, var15, var17);
        var9.addVertexWithUV(var23, var5 + 1.0, var25, var13, var17);
        var9.addVertexWithUV(var23, var5 + 0.0, var25, var13, var19);
        var9.addVertexWithUV(var21, var5 + 0.0, var25, var15, var19);
        var9.addVertexWithUV(var21, var5 + 1.0, var25, var15, var17);
        var9.addVertexWithUV(var23, var5 + 1.0, var27, var13, var17);
        var9.addVertexWithUV(var23, var5 + 0.0, var27, var13, var19);
        var9.addVertexWithUV(var21, var5 + 0.0, var27, var15, var19);
        var9.addVertexWithUV(var21, var5 + 1.0, var27, var15, var17);
        var9.addVertexWithUV(var21, var5 + 1.0, var27, var13, var17);
        var9.addVertexWithUV(var21, var5 + 0.0, var27, var13, var19);
        var9.addVertexWithUV(var23, var5 + 0.0, var27, var15, var19);
        var9.addVertexWithUV(var23, var5 + 1.0, var27, var15, var17);
    }

    public void renderCropBaseDistorted(Block var1, int var2, double var3, double var5, double var7) {
        Tessellator var9 = Tessellator.instance;
        int var10 = var1.getBlockTextureFromSideAndMetadata(0, var2);
        if (this.overrideBlockTexture >= 0) {
            var10 = this.overrideBlockTexture;
        }
        int var11 = (var10 & 0xF) << 4;
        int var12 = var10 & 0xFF0;
        double var13 = (float)var11 / 256.0f;
        double var15 = ((float)var11 + 15.99f) / 256.0f;
        double var17 = (float)var12 / 512.0f;
        double var19 = ((float)var12 + 15.99f) / 512.0f;
        double var21 = var3 + 0.5 - 0.25;
        double var23 = var3 + 0.5 + 0.25;
        double var25 = var7 + 0.5 - 0.5;
        double var27 = var7 + 0.5 + 0.5;
        var9.addDistortedVertexWithUV(var21, var5 + 1.0, var25, var13, var17);
        var9.addDistortedVertexWithUV(var21, var5 + 0.0, var25, var13, var19);
        var9.addDistortedVertexWithUV(var21, var5 + 0.0, var27, var15, var19);
        var9.addDistortedVertexWithUV(var21, var5 + 1.0, var27, var15, var17);
        var9.addDistortedVertexWithUV(var21, var5 + 1.0, var27, var13, var17);
        var9.addDistortedVertexWithUV(var21, var5 + 0.0, var27, var13, var19);
        var9.addDistortedVertexWithUV(var21, var5 + 0.0, var25, var15, var19);
        var9.addDistortedVertexWithUV(var21, var5 + 1.0, var25, var15, var17);
        var9.addDistortedVertexWithUV(var23, var5 + 1.0, var27, var13, var17);
        var9.addDistortedVertexWithUV(var23, var5 + 0.0, var27, var13, var19);
        var9.addDistortedVertexWithUV(var23, var5 + 0.0, var25, var15, var19);
        var9.addDistortedVertexWithUV(var23, var5 + 1.0, var25, var15, var17);
        var9.addDistortedVertexWithUV(var23, var5 + 1.0, var25, var13, var17);
        var9.addDistortedVertexWithUV(var23, var5 + 0.0, var25, var13, var19);
        var9.addDistortedVertexWithUV(var23, var5 + 0.0, var27, var15, var19);
        var9.addDistortedVertexWithUV(var23, var5 + 1.0, var27, var15, var17);
        var21 = var3 + 0.5 - 0.5;
        var23 = var3 + 0.5 + 0.5;
        var25 = var7 + 0.5 - 0.25;
        var27 = var7 + 0.5 + 0.25;
        var9.addDistortedVertexWithUV(var21, var5 + 1.0, var25, var13, var17);
        var9.addDistortedVertexWithUV(var21, var5 + 0.0, var25, var13, var19);
        var9.addDistortedVertexWithUV(var23, var5 + 0.0, var25, var15, var19);
        var9.addDistortedVertexWithUV(var23, var5 + 1.0, var25, var15, var17);
        var9.addDistortedVertexWithUV(var23, var5 + 1.0, var25, var13, var17);
        var9.addDistortedVertexWithUV(var23, var5 + 0.0, var25, var13, var19);
        var9.addDistortedVertexWithUV(var21, var5 + 0.0, var25, var15, var19);
        var9.addDistortedVertexWithUV(var21, var5 + 1.0, var25, var15, var17);
        var9.addDistortedVertexWithUV(var23, var5 + 1.0, var27, var13, var17);
        var9.addDistortedVertexWithUV(var23, var5 + 0.0, var27, var13, var19);
        var9.addDistortedVertexWithUV(var21, var5 + 0.0, var27, var15, var19);
        var9.addDistortedVertexWithUV(var21, var5 + 1.0, var27, var15, var17);
        var9.addDistortedVertexWithUV(var21, var5 + 1.0, var27, var13, var17);
        var9.addDistortedVertexWithUV(var21, var5 + 0.0, var27, var13, var19);
        var9.addDistortedVertexWithUV(var23, var5 + 0.0, var27, var15, var19);
        var9.addDistortedVertexWithUV(var23, var5 + 1.0, var27, var15, var17);
    }

    public boolean renderBlockFluids(Block var1, int var2, int var3, int var4) {
        float var38;
        float var37;
        float var36;
        int var31;
        int var28;
        Tessellator var5 = Tessellator.instance;
        int var6 = var1.colorMultiplier(this.blockAccess, var2, var3, var4);
        float var7 = (float)(var6 >> 16 & 0xFF) / 255.0f;
        float var8 = (float)(var6 >> 8 & 0xFF) / 255.0f;
        float var9 = (float)(var6 & 0xFF) / 255.0f;
        boolean var10 = var1.shouldSideBeRendered(this.blockAccess, var2, var3 + 1, var4, 1);
        boolean var11 = var1.shouldSideBeRendered(this.blockAccess, var2, var3 - 1, var4, 0);
        boolean[] var12 = new boolean[]{var1.shouldSideBeRendered(this.blockAccess, var2, var3, var4 - 1, 2), var1.shouldSideBeRendered(this.blockAccess, var2, var3, var4 + 1, 3), var1.shouldSideBeRendered(this.blockAccess, var2 - 1, var3, var4, 4), var1.shouldSideBeRendered(this.blockAccess, var2 + 1, var3, var4, 5)};
        if (!(var10 || var11 || var12[0] || var12[1] || var12[2] || var12[3])) {
            return false;
        }
        boolean var13 = false;
        float var14 = 0.5f;
        float var15 = 1.0f;
        float var16 = 0.8f;
        float var17 = 0.6f;
        double var18 = 0.0;
        double var20 = 1.0;
        Material var22 = var1.blockMaterial;
        int var23 = this.blockAccess.getBlockMetadata(var2, var3, var4);
        float var24 = this.func_1224_a(var2, var3, var4, var22);
        float var25 = this.func_1224_a(var2, var3, var4 + 1, var22);
        float var26 = this.func_1224_a(var2 + 1, var3, var4 + 1, var22);
        float var27 = this.func_1224_a(var2 + 1, var3, var4, var22);
        if (this.renderAllFaces || var10) {
            var13 = true;
            var28 = var1.getBlockTextureFromSideAndMetadata(1, var23);
            float var29 = (float)BlockFluid.func_293_a(this.blockAccess, var2, var3, var4, var22);
            if (var29 > -999.0f) {
                var28 = var1.getBlockTextureFromSideAndMetadata(2, var23);
            }
            int var30 = (var28 & 0xF) << 4;
            var31 = var28 & 0xFF0;
            double var32 = ((double)var30 + 8.0) / 256.0;
            double var34 = ((double)var31 + 8.0) / 512.0;
            if (var29 < -999.0f) {
                var29 = 0.0f;
            } else {
                var32 = (float)(var30 + 16) / 256.0f;
                var34 = (float)(var31 + 16) / 512.0f;
            }
            var36 = MathHelper.sin(var29) * 8.0f / 256.0f;
            var37 = MathHelper.cos(var29) * 8.0f / 256.0f;
            float var360 = MathHelper.sin(var29) * 8.0f / 512.0f;
            float var370 = MathHelper.cos(var29) * 8.0f / 512.0f;
            var38 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4);
            var5.setColorOpaque_F(var15 * var38 * var7, var15 * var38 * var8, var15 * var38 * var9);
            if (distortion != 2) {
                var5.addVertexWithUV(var2 + 0, (float)var3 + var24, var4 + 0, var32 - (double)var37 - (double)var36, var34 - (double)var370 + (double)var360);
                var5.addVertexWithUV(var2 + 0, (float)var3 + var25, var4 + 1, var32 - (double)var37 + (double)var36, var34 + (double)var370 + (double)var360);
                var5.addVertexWithUV(var2 + 1, (float)var3 + var26, var4 + 1, var32 + (double)var37 + (double)var36, var34 + (double)var370 - (double)var360);
                var5.addVertexWithUV(var2 + 1, (float)var3 + var27, var4 + 0, var32 + (double)var37 - (double)var36, var34 - (double)var370 - (double)var360);
            } else if (distortion == 2) {
                var5.addDistortedVertexWithUV(var2 + 0, (float)var3 + var24, var4 + 0, var32 - (double)var37 - (double)var36, var34 - (double)var370 + (double)var360);
                var5.addDistortedVertexWithUV(var2 + 0, (float)var3 + var25, var4 + 1, var32 - (double)var37 + (double)var36, var34 + (double)var370 + (double)var360);
                var5.addDistortedVertexWithUV(var2 + 1, (float)var3 + var26, var4 + 1, var32 + (double)var37 + (double)var36, var34 + (double)var370 - (double)var360);
                var5.addDistortedVertexWithUV(var2 + 1, (float)var3 + var27, var4 + 0, var32 + (double)var37 - (double)var36, var34 - (double)var370 - (double)var360);
            }
        }
        if (this.renderAllFaces || var11) {
            float var52 = var1.getBlockBrightness(this.blockAccess, var2, var3 - 1, var4);
            var5.setColorOpaque_F(var14 * var52, var14 * var52, var14 * var52);
            this.renderBottomFace(var1, var2, var3, var4, var1.getBlockTextureFromSide(0));
            var13 = true;
        }
        var28 = 0;
        while (var28 < 4) {
            int var53 = var2;
            var31 = var4;
            if (var28 == 0) {
                var31 = var4 - 1;
            }
            if (var28 == 1) {
                ++var31;
            }
            if (var28 == 2) {
                var53 = var2 - 1;
            }
            if (var28 == 3) {
                ++var53;
            }
            int var54 = var1.getBlockTextureFromSideAndMetadata(var28 + 2, var23);
            int var33 = (var54 & 0xF) << 4;
            int var55 = var54 & 0xFF0;
            if (this.renderAllFaces || var12[var28]) {
                float var40;
                float var39;
                float var35;
                if (var28 == 0) {
                    var35 = var24;
                    var36 = var27;
                    var37 = var2;
                    var39 = var2 + 1;
                    var38 = var4;
                    var40 = var4;
                } else if (var28 == 1) {
                    var35 = var26;
                    var36 = var25;
                    var37 = var2 + 1;
                    var39 = var2;
                    var38 = var4 + 1;
                    var40 = var4 + 1;
                } else if (var28 == 2) {
                    var35 = var25;
                    var36 = var24;
                    var37 = var2;
                    var39 = var2;
                    var38 = var4 + 1;
                    var40 = var4;
                } else {
                    var35 = var27;
                    var36 = var26;
                    var37 = var2 + 1;
                    var39 = var2 + 1;
                    var38 = var4;
                    var40 = var4 + 1;
                }
                var13 = true;
                double var41 = (float)(var33 + 0) / 256.0f;
                double var43 = ((double)(var33 + 16) - 0.01) / 256.0;
                double var45 = ((float)var55 + (1.0f - var35) * 16.0f) / 512.0f;
                double var47 = ((float)var55 + (1.0f - var36) * 16.0f) / 512.0f;
                double var49 = ((double)(var55 + 16) - 0.01) / 512.0;
                float var51 = var1.getBlockBrightness(this.blockAccess, var53, var3, var31);
                var51 = var28 < 2 ? (var51 *= var16) : (var51 *= var17);
                var5.setColorOpaque_F(var15 * var51 * var7, var15 * var51 * var8, var15 * var51 * var9);
                if (distortion != 2) {
                    var5.addVertexWithUV(var37, (float)var3 + var35, var38, var41, var45);
                    var5.addVertexWithUV(var39, (float)var3 + var36, var40, var43, var47);
                    var5.addVertexWithUV(var39, var3 + 0, var40, var43, var49);
                    var5.addVertexWithUV(var37, var3 + 0, var38, var41, var49);
                } else if (distortion == 2) {
                    var5.addDistortedVertexWithUV(var37, (float)var3 + var35, var38, var41, var45);
                    var5.addDistortedVertexWithUV(var39, (float)var3 + var36, var40, var43, var47);
                    var5.addDistortedVertexWithUV(var39, var3 + 0, var40, var43, var49);
                    var5.addDistortedVertexWithUV(var37, var3 + 0, var38, var41, var49);
                }
            }
            ++var28;
        }
        var1.minY = var18;
        var1.maxY = var20;
        return var13;
    }

    private float func_1224_a(int var1, int var2, int var3, Material var4) {
        int var5 = 0;
        float var6 = 0.0f;
        int var7 = 0;
        while (var7 < 4) {
            int var8 = var1 - (var7 & 1);
            int var10 = var3 - (var7 >> 1 & 1);
            if (this.blockAccess.getBlockMaterial(var8, var2 + 1, var10) == var4) {
                return 1.0f;
            }
            Material var11 = this.blockAccess.getBlockMaterial(var8, var2, var10);
            if (var11 != var4) {
                if (!var11.isSolid()) {
                    var6 += 1.0f;
                    ++var5;
                }
            } else {
                int var12 = this.blockAccess.getBlockMetadata(var8, var2, var10);
                if (var12 >= 8 || var12 == 0) {
                    var6 += BlockFluid.getPercentAir(var12) * 10.0f;
                    var5 += 10;
                }
                var6 += BlockFluid.getPercentAir(var12);
                ++var5;
            }
            ++var7;
        }
        return 1.0f - var6 / (float)var5;
    }

    public void renderBlockFallingSand(Block var1, World var2, int var3, int var4, int var5, int metadata) {
        float var6 = 0.5f;
        float var7 = 1.0f;
        float var8 = 0.8f;
        float var9 = 0.6f;
        Tessellator var10 = Tessellator.instance;
        var10.startDrawingQuads();
        float var11 = var1.getBlockBrightness(var2, var3, var4, var5);
        float var12 = var1.getBlockBrightness(var2, var3, var4 - 1, var5);
        if (var12 < var11) {
            var12 = var11;
        }
        var10.setColorOpaque_F(var6 * var12, var6 * var12, var6 * var12);
        this.renderBottomFace(var1, -0.5, -0.5, -0.5, var1.getBlockTextureFromSideAndMetadata(0, metadata));
        var12 = var1.getBlockBrightness(var2, var3, var4 + 1, var5);
        if (var12 < var11) {
            var12 = var11;
        }
        var10.setColorOpaque_F(var7 * var12, var7 * var12, var7 * var12);
        this.renderTopFace(var1, -0.5, -0.5, -0.5, var1.getBlockTextureFromSideAndMetadata(1, metadata));
        var12 = var1.getBlockBrightness(var2, var3, var4, var5 - 1);
        if (var12 < var11) {
            var12 = var11;
        }
        var10.setColorOpaque_F(var8 * var12, var8 * var12, var8 * var12);
        this.renderEastFace(var1, -0.5, -0.5, -0.5, var1.getBlockTextureFromSideAndMetadata(2, metadata));
        var12 = var1.getBlockBrightness(var2, var3, var4, var5 + 1);
        if (var12 < var11) {
            var12 = var11;
        }
        var10.setColorOpaque_F(var8 * var12, var8 * var12, var8 * var12);
        this.renderWestFace(var1, -0.5, -0.5, -0.5, var1.getBlockTextureFromSideAndMetadata(3, metadata));
        var12 = var1.getBlockBrightness(var2, var3 - 1, var4, var5);
        if (var12 < var11) {
            var12 = var11;
        }
        var10.setColorOpaque_F(var9 * var12, var9 * var12, var9 * var12);
        this.renderNorthFace(var1, -0.5, -0.5, -0.5, var1.getBlockTextureFromSideAndMetadata(4, metadata));
        var12 = var1.getBlockBrightness(var2, var3 + 1, var4, var5);
        if (var12 < var11) {
            var12 = var11;
        }
        var10.setColorOpaque_F(var9 * var12, var9 * var12, var9 * var12);
        this.renderSouthFace(var1, -0.5, -0.5, -0.5, var1.getBlockTextureFromSideAndMetadata(5, metadata));
        var10.draw();
    }

    public boolean renderStandardBlock(Block var1, int var2, int var3, int var4) {
        int var5 = var1.colorMultiplier(this.blockAccess, var2, var3, var4);
        float var6 = (float)(var5 >> 16 & 0xFF) / 255.0f;
        float var7 = (float)(var5 >> 8 & 0xFF) / 255.0f;
        float var8 = (float)(var5 & 0xFF) / 255.0f;
        if (EntityRenderer.field_28135_a) {
            float var9 = (var6 * 30.0f + var7 * 59.0f + var8 * 11.0f) / 100.0f;
            float var10 = (var6 * 30.0f + var7 * 70.0f) / 100.0f;
            float var11 = (var6 * 30.0f + var8 * 70.0f) / 100.0f;
            var6 = var9;
            var7 = var10;
            var8 = var11;
        }
        return Minecraft.isAmbientOcclusionEnabled() ? this.renderStandardBlockWithAmbientOcclusion(var1, var2, var3, var4, var6, var7, var8) : this.renderStandardBlockWithColorMultiplier(var1, var2, var3, var4, var6, var7, var8);
    }

    private int getAoBrightness(int var1, int var2, int var3, int var4) {
        if (var1 == 0) {
            var1 = var4;
        }
        if (var2 == 0) {
            var2 = var4;
        }
        if (var3 == 0) {
            var3 = var4;
        }
        return var1 + var2 + var3 + var4 >> 2 & 0xFF00FF;
    }

    public boolean renderStandardBlockWithAmbientOcclusion(Block var1, int var2, int var3, int var4, float var5, float var6, float var7) {
        int var19;
        this.enableAO = true;
        boolean var8 = false;
        float var9 = this.lightValueOwn;
        float var10 = this.lightValueOwn;
        float var11 = this.lightValueOwn;
        float var12 = this.lightValueOwn;
        boolean var13 = true;
        boolean var14 = true;
        boolean var15 = true;
        boolean var16 = true;
        boolean var17 = true;
        boolean var18 = true;
        this.lightValueOwn = var1.getBlockBrightness(this.blockAccess, var2, var3, var4);
        this.aoLightValueXNeg = var1.getBlockBrightness(this.blockAccess, var2 - 1, var3, var4);
        this.aoLightValueYNeg = var1.getBlockBrightness(this.blockAccess, var2, var3 - 1, var4);
        this.aoLightValueZNeg = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 - 1);
        this.aoLightValueXPos = var1.getBlockBrightness(this.blockAccess, var2 + 1, var3, var4);
        this.aoLightValueYPos = var1.getBlockBrightness(this.blockAccess, var2, var3 + 1, var4);
        this.aoLightValueZPos = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 + 1);
        this.aoGrassXYZPPC = Block.canBlockGrass[this.blockAccess.getBlockId(var2 + 1, var3 + 1, var4)];
        this.aoGrassXYZPNC = Block.canBlockGrass[this.blockAccess.getBlockId(var2 + 1, var3 - 1, var4)];
        this.aoGrassXYZPCP = Block.canBlockGrass[this.blockAccess.getBlockId(var2 + 1, var3, var4 + 1)];
        this.aoGrassXYZPCN = Block.canBlockGrass[this.blockAccess.getBlockId(var2 + 1, var3, var4 - 1)];
        this.aoGrassXYZNPC = Block.canBlockGrass[this.blockAccess.getBlockId(var2 - 1, var3 + 1, var4)];
        this.aoGrassXYZNNC = Block.canBlockGrass[this.blockAccess.getBlockId(var2 - 1, var3 - 1, var4)];
        this.aoGrassXYZNCN = Block.canBlockGrass[this.blockAccess.getBlockId(var2 - 1, var3, var4 - 1)];
        this.aoGrassXYZNCP = Block.canBlockGrass[this.blockAccess.getBlockId(var2 - 1, var3, var4 + 1)];
        this.aoGrassXYZCPP = Block.canBlockGrass[this.blockAccess.getBlockId(var2, var3 + 1, var4 + 1)];
        this.aoGrassXYZCPN = Block.canBlockGrass[this.blockAccess.getBlockId(var2, var3 + 1, var4 - 1)];
        this.aoGrassXYZCNP = Block.canBlockGrass[this.blockAccess.getBlockId(var2, var3 - 1, var4 + 1)];
        this.aoGrassXYZCNN = Block.canBlockGrass[this.blockAccess.getBlockId(var2, var3 - 1, var4 - 1)];
        Material material = this.blockAccess.getBlockMaterial(var2, var3 + 1, var4);
        if (var1.blockIndexInTexture == 3) {
            var18 = false;
            var17 = false;
            var16 = false;
            var15 = false;
            var13 = false;
        }
        if (this.overrideBlockTexture >= 0) {
            var18 = false;
            var17 = false;
            var16 = false;
            var15 = false;
            var13 = false;
        }
        if (this.renderAllFaces || var1.shouldSideBeRendered(this.blockAccess, var2, var3 - 1, var4, 0)) {
            if (this.aoType <= 0) {
                var11 = var12 = this.aoLightValueYNeg;
                var10 = var12;
                var9 = var12;
            } else {
                this.aoBrightnessXYNN = var1.getBlockBrightness(this.blockAccess, var2 - 1, --var3, var4);
                this.aoBrightnessYZNN = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 - 1);
                this.aoBrightnessYZNP = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 + 1);
                this.aoBrightnessXYPN = var1.getBlockBrightness(this.blockAccess, var2 + 1, var3, var4);
                this.aoBrightnessXYZNNN = !this.aoGrassXYZCNN && !this.aoGrassXYZNNC ? this.aoBrightnessXYNN : var1.getBlockBrightness(this.blockAccess, var2 - 1, var3, var4 - 1);
                this.aoBrightnessXYZNNP = !this.aoGrassXYZCNP && !this.aoGrassXYZNNC ? this.aoBrightnessXYNN : var1.getBlockBrightness(this.blockAccess, var2 - 1, var3, var4 + 1);
                this.aoBrightnessXYZPNN = !this.aoGrassXYZCNN && !this.aoGrassXYZPNC ? this.aoBrightnessXYPN : var1.getBlockBrightness(this.blockAccess, var2 + 1, var3, var4 - 1);
                this.aoBrightnessXYZPNP = !this.aoGrassXYZCNP && !this.aoGrassXYZPNC ? this.aoBrightnessXYPN : var1.getBlockBrightness(this.blockAccess, var2 + 1, var3, var4 + 1);
                ++var3;
                var9 = (this.aoBrightnessXYZNNP + this.aoBrightnessXYNN + this.aoBrightnessYZNP + this.aoLightValueYNeg) / 4.0f;
                var12 = (this.aoBrightnessYZNP + this.aoLightValueYNeg + this.aoBrightnessXYZPNP + this.aoBrightnessXYPN) / 4.0f;
                var11 = (this.aoLightValueYNeg + this.aoBrightnessYZNN + this.aoBrightnessXYPN + this.aoBrightnessXYZPNN) / 4.0f;
                var10 = (this.aoBrightnessXYNN + this.aoBrightnessXYZNNN + this.aoLightValueYNeg + this.aoBrightnessYZNN) / 4.0f;
            }
            this.colorRedBottomRight = this.colorRedTopRight = (var13 ? var5 : 1.0f) * 0.5f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = (var13 ? var6 : 1.0f) * 0.5f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = (var13 ? var7 : 1.0f) * 0.5f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= var9;
            this.colorGreenTopLeft *= var9;
            this.colorBlueTopLeft *= var9;
            this.colorRedBottomLeft *= var10;
            this.colorGreenBottomLeft *= var10;
            this.colorBlueBottomLeft *= var10;
            this.colorRedBottomRight *= var11;
            this.colorGreenBottomRight *= var11;
            this.colorBlueBottomRight *= var11;
            this.colorRedTopRight *= var12;
            this.colorGreenTopRight *= var12;
            this.colorBlueTopRight *= var12;
            if (distortion != 2) {
                this.renderBottomFace(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 0));
            } else if (distortion == 2) {
                this.renderBottomFaceDistorted(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 0));
            }
            var8 = true;
        }
        if (this.renderAllFaces || var1.shouldSideBeRendered(this.blockAccess, var2, var3 + 1, var4, 1)) {
            if (this.aoType <= 0) {
                var11 = var12 = this.aoLightValueYPos;
                var10 = var12;
                var9 = var12;
            } else {
                this.aoBrightnessXYNP = var1.getBlockBrightness(this.blockAccess, var2 - 1, ++var3, var4);
                this.aoBrightnessXYPP = var1.getBlockBrightness(this.blockAccess, var2 + 1, var3, var4);
                this.aoBrightnessYZPN = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 - 1);
                this.aoBrightnessYZPP = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 + 1);
                this.aoBrightnessXYZNPN = !this.aoGrassXYZCPN && !this.aoGrassXYZNPC ? this.aoBrightnessXYNP : var1.getBlockBrightness(this.blockAccess, var2 - 1, var3, var4 - 1);
                this.aoBrightnessXYZPPN = !this.aoGrassXYZCPN && !this.aoGrassXYZPPC ? this.aoBrightnessXYPP : var1.getBlockBrightness(this.blockAccess, var2 + 1, var3, var4 - 1);
                this.aoBrightnessXYZNPP = !this.aoGrassXYZCPP && !this.aoGrassXYZNPC ? this.aoBrightnessXYNP : var1.getBlockBrightness(this.blockAccess, var2 - 1, var3, var4 + 1);
                this.aoBrightnessXYZPPP = !this.aoGrassXYZCPP && !this.aoGrassXYZPPC ? this.aoBrightnessXYPP : var1.getBlockBrightness(this.blockAccess, var2 + 1, var3, var4 + 1);
                --var3;
                var12 = (this.aoBrightnessXYZNPP + this.aoBrightnessXYNP + this.aoBrightnessYZPP + this.aoLightValueYPos) / 4.0f;
                var9 = (this.aoBrightnessYZPP + this.aoLightValueYPos + this.aoBrightnessXYZPPP + this.aoBrightnessXYPP) / 4.0f;
                var10 = (this.aoLightValueYPos + this.aoBrightnessYZPN + this.aoBrightnessXYPP + this.aoBrightnessXYZPPN) / 4.0f;
                var11 = (this.aoBrightnessXYNP + this.aoBrightnessXYZNPN + this.aoLightValueYPos + this.aoBrightnessYZPN) / 4.0f;
            }
            this.colorRedTopRight = var14 ? var5 : 1.0f;
            this.colorRedBottomRight = this.colorRedTopRight;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenTopRight = var14 ? var6 : 1.0f;
            this.colorGreenBottomRight = this.colorGreenTopRight;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueTopRight = var14 ? var7 : 1.0f;
            this.colorBlueBottomRight = this.colorBlueTopRight;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= var9;
            this.colorGreenTopLeft *= var9;
            this.colorBlueTopLeft *= var9;
            this.colorRedBottomLeft *= var10;
            this.colorGreenBottomLeft *= var10;
            this.colorBlueBottomLeft *= var10;
            this.colorRedBottomRight *= var11;
            this.colorGreenBottomRight *= var11;
            this.colorBlueBottomRight *= var11;
            this.colorRedTopRight *= var12;
            this.colorGreenTopRight *= var12;
            this.colorBlueTopRight *= var12;
            if (distortion != 2) {
                this.renderTopFace(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 1));
            } else if (distortion == 2) {
                this.renderTopFaceDistorted(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 1));
            }
            var8 = true;
        }
        if (this.renderAllFaces || var1.shouldSideBeRendered(this.blockAccess, var2, var3, var4 - 1, 2)) {
            if (this.aoType <= 0) {
                var11 = var12 = this.aoLightValueZNeg;
                var10 = var12;
                var9 = var12;
            } else {
                this.aoBrightnessXZNN = var1.getBlockBrightness(this.blockAccess, var2 - 1, var3, --var4);
                this.aoBrightnessYZNN = var1.getBlockBrightness(this.blockAccess, var2, var3 - 1, var4);
                this.aoBrightnessYZPN = var1.getBlockBrightness(this.blockAccess, var2, var3 + 1, var4);
                this.aoBrightnessXZPN = var1.getBlockBrightness(this.blockAccess, var2 + 1, var3, var4);
                this.aoBrightnessXYZNNN = !this.aoGrassXYZNCN && !this.aoGrassXYZCNN ? this.aoBrightnessXZNN : var1.getBlockBrightness(this.blockAccess, var2 - 1, var3 - 1, var4);
                this.aoBrightnessXYZNPN = !this.aoGrassXYZNCN && !this.aoGrassXYZCPN ? this.aoBrightnessXZNN : var1.getBlockBrightness(this.blockAccess, var2 - 1, var3 + 1, var4);
                this.aoBrightnessXYZPNN = !this.aoGrassXYZPCN && !this.aoGrassXYZCNN ? this.aoBrightnessXZPN : var1.getBlockBrightness(this.blockAccess, var2 + 1, var3 - 1, var4);
                this.aoBrightnessXYZPPN = !this.aoGrassXYZPCN && !this.aoGrassXYZCPN ? this.aoBrightnessXZPN : var1.getBlockBrightness(this.blockAccess, var2 + 1, var3 + 1, var4);
                ++var4;
                var9 = (this.aoBrightnessXZNN + this.aoBrightnessXYZNPN + this.aoLightValueZNeg + this.aoBrightnessYZPN) / 4.0f;
                var10 = (this.aoLightValueZNeg + this.aoBrightnessYZPN + this.aoBrightnessXZPN + this.aoBrightnessXYZPPN) / 4.0f;
                var11 = (this.aoBrightnessYZNN + this.aoLightValueZNeg + this.aoBrightnessXYZPNN + this.aoBrightnessXZPN) / 4.0f;
                var12 = (this.aoBrightnessXYZNNN + this.aoBrightnessXZNN + this.aoBrightnessYZNN + this.aoLightValueZNeg) / 4.0f;
            }
            this.colorRedBottomRight = this.colorRedTopRight = (var15 ? var5 : 1.0f) * 0.8f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = (var15 ? var6 : 1.0f) * 0.8f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = (var15 ? var7 : 1.0f) * 0.8f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= var9;
            this.colorGreenTopLeft *= var9;
            this.colorBlueTopLeft *= var9;
            this.colorRedBottomLeft *= var10;
            this.colorGreenBottomLeft *= var10;
            this.colorBlueBottomLeft *= var10;
            this.colorRedBottomRight *= var11;
            this.colorGreenBottomRight *= var11;
            this.colorBlueBottomRight *= var11;
            this.colorRedTopRight *= var12;
            this.colorGreenTopRight *= var12;
            this.colorBlueTopRight *= var12;
            var19 = var1.getBlockTexture(this.blockAccess, var2, var3, var4, 2);
            if (distortion != 2) {
                this.renderEastFace(var1, var2, var3, var4, var19);
                if (material == Material.builtSnow && this.overrideBlockTexture < 0 || material == Material.snow && this.overrideBlockTexture < 0) {
                    this.renderEastFace(var1, var2, var3, var4, 68);
                }
                if (material == Material.ash && this.overrideBlockTexture < 0) {
                    this.renderEastFace(var1, var2, var3, var4, 12);
                }
            } else if (distortion == 2) {
                this.renderEastFaceDistorted(var1, var2, var3, var4, var19);
                if (material == Material.builtSnow && this.overrideBlockTexture < 0 || material == Material.snow && this.overrideBlockTexture < 0) {
                    this.renderEastFaceDistorted(var1, var2, var3, var4, 68);
                }
                if (material == Material.ash && this.overrideBlockTexture < 0) {
                    this.renderEastFaceDistorted(var1, var2, var3, var4, 12);
                }
            }
            var8 = true;
        }
        if (this.renderAllFaces || var1.shouldSideBeRendered(this.blockAccess, var2, var3, var4 + 1, 3)) {
            if (this.aoType <= 0) {
                var11 = var12 = this.aoLightValueZPos;
                var10 = var12;
                var9 = var12;
            } else {
                this.aoBrightnessXZNP = var1.getBlockBrightness(this.blockAccess, var2 - 1, var3, ++var4);
                this.aoBrightnessXZPP = var1.getBlockBrightness(this.blockAccess, var2 + 1, var3, var4);
                this.aoBrightnessYZNP = var1.getBlockBrightness(this.blockAccess, var2, var3 - 1, var4);
                this.aoBrightnessYZPP = var1.getBlockBrightness(this.blockAccess, var2, var3 + 1, var4);
                this.aoBrightnessXYZNNP = !this.aoGrassXYZNCP && !this.aoGrassXYZCNP ? this.aoBrightnessXZNP : var1.getBlockBrightness(this.blockAccess, var2 - 1, var3 - 1, var4);
                this.aoBrightnessXYZNPP = !this.aoGrassXYZNCP && !this.aoGrassXYZCPP ? this.aoBrightnessXZNP : var1.getBlockBrightness(this.blockAccess, var2 - 1, var3 + 1, var4);
                this.aoBrightnessXYZPNP = !this.aoGrassXYZPCP && !this.aoGrassXYZCNP ? this.aoBrightnessXZPP : var1.getBlockBrightness(this.blockAccess, var2 + 1, var3 - 1, var4);
                this.aoBrightnessXYZPPP = !this.aoGrassXYZPCP && !this.aoGrassXYZCPP ? this.aoBrightnessXZPP : var1.getBlockBrightness(this.blockAccess, var2 + 1, var3 + 1, var4);
                --var4;
                var9 = (this.aoBrightnessXZNP + this.aoBrightnessXYZNPP + this.aoLightValueZPos + this.aoBrightnessYZPP) / 4.0f;
                var12 = (this.aoLightValueZPos + this.aoBrightnessYZPP + this.aoBrightnessXZPP + this.aoBrightnessXYZPPP) / 4.0f;
                var11 = (this.aoBrightnessYZNP + this.aoLightValueZPos + this.aoBrightnessXYZPNP + this.aoBrightnessXZPP) / 4.0f;
                var10 = (this.aoBrightnessXYZNNP + this.aoBrightnessXZNP + this.aoBrightnessYZNP + this.aoLightValueZPos) / 4.0f;
            }
            this.colorRedBottomRight = this.colorRedTopRight = (var16 ? var5 : 1.0f) * 0.8f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = (var16 ? var6 : 1.0f) * 0.8f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = (var16 ? var7 : 1.0f) * 0.8f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= var9;
            this.colorGreenTopLeft *= var9;
            this.colorBlueTopLeft *= var9;
            this.colorRedBottomLeft *= var10;
            this.colorGreenBottomLeft *= var10;
            this.colorBlueBottomLeft *= var10;
            this.colorRedBottomRight *= var11;
            this.colorGreenBottomRight *= var11;
            this.colorBlueBottomRight *= var11;
            this.colorRedTopRight *= var12;
            this.colorGreenTopRight *= var12;
            this.colorBlueTopRight *= var12;
            var19 = var1.getBlockTexture(this.blockAccess, var2, var3, var4, 3);
            if (distortion != 2) {
                this.renderWestFace(var1, var2, var3, var4, var19);
                if (material == Material.builtSnow && this.overrideBlockTexture < 0 || material == Material.snow && this.overrideBlockTexture < 0) {
                    this.renderWestFace(var1, var2, var3, var4, 68);
                }
                if (material == Material.ash && this.overrideBlockTexture < 0) {
                    this.renderWestFace(var1, var2, var3, var4, 12);
                }
            } else if (distortion == 2) {
                this.renderWestFaceDistorted(var1, var2, var3, var4, var19);
                if (material == Material.builtSnow && this.overrideBlockTexture < 0 || material == Material.snow && this.overrideBlockTexture < 0) {
                    this.renderWestFaceDistorted(var1, var2, var3, var4, 68);
                }
                if (material == Material.ash && this.overrideBlockTexture < 0) {
                    this.renderWestFaceDistorted(var1, var2, var3, var4, 12);
                }
            }
            var8 = true;
        }
        if (this.renderAllFaces || var1.shouldSideBeRendered(this.blockAccess, var2 - 1, var3, var4, 4)) {
            if (this.aoType <= 0) {
                var11 = var12 = this.aoLightValueXNeg;
                var10 = var12;
                var9 = var12;
            } else {
                this.aoBrightnessXYNN = var1.getBlockBrightness(this.blockAccess, --var2, var3 - 1, var4);
                this.aoBrightnessXZNN = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 - 1);
                this.aoBrightnessXZNP = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 + 1);
                this.aoBrightnessXYNP = var1.getBlockBrightness(this.blockAccess, var2, var3 + 1, var4);
                this.aoBrightnessXYZNNN = !this.aoGrassXYZNCN && !this.aoGrassXYZNNC ? this.aoBrightnessXZNN : var1.getBlockBrightness(this.blockAccess, var2, var3 - 1, var4 - 1);
                this.aoBrightnessXYZNNP = !this.aoGrassXYZNCP && !this.aoGrassXYZNNC ? this.aoBrightnessXZNP : var1.getBlockBrightness(this.blockAccess, var2, var3 - 1, var4 + 1);
                this.aoBrightnessXYZNPN = !this.aoGrassXYZNCN && !this.aoGrassXYZNPC ? this.aoBrightnessXZNN : var1.getBlockBrightness(this.blockAccess, var2, var3 + 1, var4 - 1);
                this.aoBrightnessXYZNPP = !this.aoGrassXYZNCP && !this.aoGrassXYZNPC ? this.aoBrightnessXZNP : var1.getBlockBrightness(this.blockAccess, var2, var3 + 1, var4 + 1);
                ++var2;
                var12 = (this.aoBrightnessXYNN + this.aoBrightnessXYZNNP + this.aoLightValueXNeg + this.aoBrightnessXZNP) / 4.0f;
                var9 = (this.aoLightValueXNeg + this.aoBrightnessXZNP + this.aoBrightnessXYNP + this.aoBrightnessXYZNPP) / 4.0f;
                var10 = (this.aoBrightnessXZNN + this.aoLightValueXNeg + this.aoBrightnessXYZNPN + this.aoBrightnessXYNP) / 4.0f;
                var11 = (this.aoBrightnessXYZNNN + this.aoBrightnessXYNN + this.aoBrightnessXZNN + this.aoLightValueXNeg) / 4.0f;
            }
            this.colorRedBottomRight = this.colorRedTopRight = (var17 ? var5 : 1.0f) * 0.6f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = (var17 ? var6 : 1.0f) * 0.6f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = (var17 ? var7 : 1.0f) * 0.6f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= var9;
            this.colorGreenTopLeft *= var9;
            this.colorBlueTopLeft *= var9;
            this.colorRedBottomLeft *= var10;
            this.colorGreenBottomLeft *= var10;
            this.colorBlueBottomLeft *= var10;
            this.colorRedBottomRight *= var11;
            this.colorGreenBottomRight *= var11;
            this.colorBlueBottomRight *= var11;
            this.colorRedTopRight *= var12;
            this.colorGreenTopRight *= var12;
            this.colorBlueTopRight *= var12;
            var19 = var1.getBlockTexture(this.blockAccess, var2, var3, var4, 4);
            if (distortion != 2) {
                this.renderNorthFace(var1, var2, var3, var4, var19);
                if (material == Material.builtSnow && this.overrideBlockTexture < 0 || material == Material.snow && this.overrideBlockTexture < 0) {
                    this.renderNorthFace(var1, var2, var3, var4, 68);
                }
                if (material == Material.ash && this.overrideBlockTexture < 0) {
                    this.renderNorthFace(var1, var2, var3, var4, 12);
                }
            } else if (distortion == 2) {
                this.renderNorthFaceDistorted(var1, var2, var3, var4, var19);
                if (material == Material.builtSnow && this.overrideBlockTexture < 0 || material == Material.snow && this.overrideBlockTexture < 0) {
                    this.renderNorthFaceDistorted(var1, var2, var3, var4, 68);
                }
                if (material == Material.ash && this.overrideBlockTexture < 0) {
                    this.renderNorthFaceDistorted(var1, var2, var3, var4, 12);
                }
            }
            var8 = true;
        }
        if (this.renderAllFaces || var1.shouldSideBeRendered(this.blockAccess, var2 + 1, var3, var4, 5)) {
            if (this.aoType <= 0) {
                var11 = var12 = this.aoLightValueXPos;
                var10 = var12;
                var9 = var12;
            } else {
                this.aoBrightnessXYPN = var1.getBlockBrightness(this.blockAccess, ++var2, var3 - 1, var4);
                this.aoBrightnessXZPN = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 - 1);
                this.aoBrightnessXZPP = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 + 1);
                this.aoBrightnessXYPP = var1.getBlockBrightness(this.blockAccess, var2, var3 + 1, var4);
                this.aoBrightnessXYZPNN = !this.aoGrassXYZPNC && !this.aoGrassXYZPCN ? this.aoBrightnessXZPN : var1.getBlockBrightness(this.blockAccess, var2, var3 - 1, var4 - 1);
                this.aoBrightnessXYZPNP = !this.aoGrassXYZPNC && !this.aoGrassXYZPCP ? this.aoBrightnessXZPP : var1.getBlockBrightness(this.blockAccess, var2, var3 - 1, var4 + 1);
                this.aoBrightnessXYZPPN = !this.aoGrassXYZPPC && !this.aoGrassXYZPCN ? this.aoBrightnessXZPN : var1.getBlockBrightness(this.blockAccess, var2, var3 + 1, var4 - 1);
                this.aoBrightnessXYZPPP = !this.aoGrassXYZPPC && !this.aoGrassXYZPCP ? this.aoBrightnessXZPP : var1.getBlockBrightness(this.blockAccess, var2, var3 + 1, var4 + 1);
                --var2;
                var9 = (this.aoBrightnessXYPN + this.aoBrightnessXYZPNP + this.aoLightValueXPos + this.aoBrightnessXZPP) / 4.0f;
                var12 = (this.aoLightValueXPos + this.aoBrightnessXZPP + this.aoBrightnessXYPP + this.aoBrightnessXYZPPP) / 4.0f;
                var11 = (this.aoBrightnessXZPN + this.aoLightValueXPos + this.aoBrightnessXYZPPN + this.aoBrightnessXYPP) / 4.0f;
                var10 = (this.aoBrightnessXYZPNN + this.aoBrightnessXYPN + this.aoBrightnessXZPN + this.aoLightValueXPos) / 4.0f;
            }
            this.colorRedBottomRight = this.colorRedTopRight = (var18 ? var5 : 1.0f) * 0.6f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = (var18 ? var6 : 1.0f) * 0.6f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = (var18 ? var7 : 1.0f) * 0.6f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= var9;
            this.colorGreenTopLeft *= var9;
            this.colorBlueTopLeft *= var9;
            this.colorRedBottomLeft *= var10;
            this.colorGreenBottomLeft *= var10;
            this.colorBlueBottomLeft *= var10;
            this.colorRedBottomRight *= var11;
            this.colorGreenBottomRight *= var11;
            this.colorBlueBottomRight *= var11;
            this.colorRedTopRight *= var12;
            this.colorGreenTopRight *= var12;
            this.colorBlueTopRight *= var12;
            var19 = var1.getBlockTexture(this.blockAccess, var2, var3, var4, 5);
            if (distortion != 2) {
                this.renderSouthFace(var1, var2, var3, var4, var19);
                if (material == Material.builtSnow && this.overrideBlockTexture < 0 || material == Material.snow && this.overrideBlockTexture < 0) {
                    this.renderSouthFace(var1, var2, var3, var4, 68);
                }
                if (material == Material.ash && this.overrideBlockTexture < 0) {
                    this.renderSouthFace(var1, var2, var3, var4, 12);
                }
            } else if (distortion == 2) {
                this.renderSouthFaceDistorted(var1, var2, var3, var4, var19);
                if (material == Material.builtSnow && this.overrideBlockTexture < 0 || material == Material.snow && this.overrideBlockTexture < 0) {
                    this.renderSouthFaceDistorted(var1, var2, var3, var4, 68);
                }
                if (material == Material.ash && this.overrideBlockTexture < 0) {
                    this.renderSouthFaceDistorted(var1, var2, var3, var4, 12);
                }
            }
            var8 = true;
        }
        this.enableAO = false;
        return var8;
    }

    public boolean renderStandardBlockWithColorMultiplier(Block block, int xCoord, int yCoord, int zCoord, float var5, float var6, float var7) {
        int texture;
        float lightFloat;
        this.enableAO = false;
        Tessellator tessellator = Tessellator.instance;
        boolean var9 = false;
        float var10 = 0.5f;
        float var11 = 1.0f;
        float var12 = 0.8f;
        float var13 = 0.6f;
        float var14 = var11 * var5;
        float var15 = var11 * var6;
        float var16 = var11 * var7;
        float var17 = var10;
        float var18 = var12;
        float var19 = var13;
        float var20 = var10;
        float var21 = var12;
        float var22 = var13;
        float var23 = var10;
        float var24 = var12;
        float var25 = var13;
        if (block != Block.grass) {
            var17 = var10 * var5;
            var18 = var12 * var5;
            var19 = var13 * var5;
            var20 = var10 * var6;
            var21 = var12 * var6;
            var22 = var13 * var6;
            var23 = var10 * var7;
            var24 = var12 * var7;
            var25 = var13 * var7;
        }
        Material material = this.blockAccess.getBlockMaterial(xCoord, yCoord + 1, zCoord);
        float var26 = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, xCoord, yCoord - 1, zCoord, 0)) {
            lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord - 1, zCoord);
            if (block instanceof BlockFence) {
                lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
            }
            tessellator.setColorOpaque_F(var17 * lightFloat, var20 * lightFloat, var23 * lightFloat);
            if (distortion != 2) {
                this.renderBottomFace(block, xCoord, yCoord, zCoord, block.getBlockTexture(this.blockAccess, xCoord, yCoord, zCoord, 0));
            } else if (distortion == 2) {
                this.renderBottomFaceDistorted(block, xCoord, yCoord, zCoord, block.getBlockTexture(this.blockAccess, xCoord, yCoord, zCoord, 0));
            }
            var9 = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, xCoord, yCoord + 1, zCoord, 1)) {
            lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord + 1, zCoord);
            if (block.maxY != 1.0 && !block.blockMaterial.getIsLiquid()) {
                lightFloat = var26;
            }
            tessellator.setColorOpaque_F(var14 * lightFloat, var15 * lightFloat, var16 * lightFloat);
            if (distortion != 2) {
                this.renderTopFace(block, xCoord, yCoord, zCoord, block.getBlockTexture(this.blockAccess, xCoord, yCoord, zCoord, 1));
            } else if (distortion == 2) {
                this.renderTopFaceDistorted(block, xCoord, yCoord, zCoord, block.getBlockTexture(this.blockAccess, xCoord, yCoord, zCoord, 1));
            }
            var9 = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, xCoord, yCoord, zCoord - 1, 2)) {
            lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord - 1);
            if (block.minZ > 0.0) {
                lightFloat = var26;
            }
            tessellator.setColorOpaque_F(var18 * lightFloat, var21 * lightFloat, var24 * lightFloat);
            texture = block.getBlockTexture(this.blockAccess, xCoord, yCoord, zCoord, 2);
            if (distortion != 2) {
                this.renderEastFace(block, xCoord, yCoord, zCoord, texture);
                if (material == Material.builtSnow && this.overrideBlockTexture < 0 || material == Material.snow && this.overrideBlockTexture < 0) {
                    this.renderEastFace(block, xCoord, yCoord, zCoord, 68);
                }
                if (material == Material.ash && this.overrideBlockTexture < 0) {
                    this.renderEastFace(block, xCoord, yCoord, zCoord, 12);
                }
            } else if (distortion == 2) {
                this.renderEastFaceDistorted(block, xCoord, yCoord, zCoord, texture);
                if (material == Material.builtSnow && this.overrideBlockTexture < 0 || material == Material.snow && this.overrideBlockTexture < 0) {
                    this.renderEastFaceDistorted(block, xCoord, yCoord, zCoord, 68);
                }
                if (material == Material.ash && this.overrideBlockTexture < 0) {
                    this.renderEastFaceDistorted(block, xCoord, yCoord, zCoord, 12);
                }
            }
            var9 = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, xCoord, yCoord, zCoord + 1, 3)) {
            lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord + 1);
            if (block.maxZ < 1.0) {
                lightFloat = var26;
            }
            tessellator.setColorOpaque_F(var18 * lightFloat, var21 * lightFloat, var24 * lightFloat);
            texture = block.getBlockTexture(this.blockAccess, xCoord, yCoord, zCoord, 3);
            if (distortion != 2) {
                this.renderWestFace(block, xCoord, yCoord, zCoord, texture);
                if (material == Material.builtSnow && this.overrideBlockTexture < 0 || material == Material.snow && this.overrideBlockTexture < 0) {
                    this.renderWestFace(block, xCoord, yCoord, zCoord, 68);
                }
                if (material == Material.ash && this.overrideBlockTexture < 0) {
                    this.renderWestFace(block, xCoord, yCoord, zCoord, 12);
                }
            } else if (distortion == 2) {
                this.renderWestFaceDistorted(block, xCoord, yCoord, zCoord, texture);
                if (material == Material.builtSnow && this.overrideBlockTexture < 0 || material == Material.snow && this.overrideBlockTexture < 0) {
                    this.renderWestFaceDistorted(block, xCoord, yCoord, zCoord, 68);
                }
                if (material == Material.ash && this.overrideBlockTexture < 0) {
                    this.renderWestFaceDistorted(block, xCoord, yCoord, zCoord, 12);
                }
            }
            var9 = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, xCoord - 1, yCoord, zCoord, 4)) {
            lightFloat = block.getBlockBrightness(this.blockAccess, xCoord - 1, yCoord, zCoord);
            if (block.minX > 0.0) {
                lightFloat = var26;
            }
            tessellator.setColorOpaque_F(var19 * lightFloat, var22 * lightFloat, var25 * lightFloat);
            texture = block.getBlockTexture(this.blockAccess, xCoord, yCoord, zCoord, 4);
            if (distortion != 2) {
                this.renderNorthFace(block, xCoord, yCoord, zCoord, texture);
                if (material == Material.builtSnow && this.overrideBlockTexture < 0 || material == Material.snow && this.overrideBlockTexture < 0) {
                    this.renderNorthFace(block, xCoord, yCoord, zCoord, 68);
                }
                if (material == Material.ash && this.overrideBlockTexture < 0) {
                    this.renderNorthFace(block, xCoord, yCoord, zCoord, 12);
                }
            } else if (distortion == 2) {
                this.renderNorthFaceDistorted(block, xCoord, yCoord, zCoord, texture);
                if (material == Material.builtSnow && this.overrideBlockTexture < 0 || material == Material.snow && this.overrideBlockTexture < 0) {
                    this.renderNorthFaceDistorted(block, xCoord, yCoord, zCoord, 68);
                }
                if (material == Material.ash && this.overrideBlockTexture < 0) {
                    this.renderNorthFaceDistorted(block, xCoord, yCoord, zCoord, 12);
                }
            }
            var9 = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, xCoord + 1, yCoord, zCoord, 5)) {
            lightFloat = block.getBlockBrightness(this.blockAccess, xCoord + 1, yCoord, zCoord);
            if (block.maxX < 1.0) {
                lightFloat = var26;
            }
            tessellator.setColorOpaque_F(var19 * lightFloat, var22 * lightFloat, var25 * lightFloat);
            texture = block.getBlockTexture(this.blockAccess, xCoord, yCoord, zCoord, 5);
            if (distortion != 2) {
                this.renderSouthFace(block, xCoord, yCoord, zCoord, texture);
                if (material == Material.builtSnow && this.overrideBlockTexture < 0 || material == Material.snow && this.overrideBlockTexture < 0) {
                    this.renderSouthFace(block, xCoord, yCoord, zCoord, 68);
                }
                if (material == Material.ash && this.overrideBlockTexture < 0) {
                    this.renderSouthFace(block, xCoord, yCoord, zCoord, 12);
                }
            } else if (distortion == 2) {
                this.renderSouthFaceDistorted(block, xCoord, yCoord, zCoord, texture);
                if (material == Material.builtSnow && this.overrideBlockTexture < 0 || material == Material.snow && this.overrideBlockTexture < 0) {
                    this.renderSouthFaceDistorted(block, xCoord, yCoord, zCoord, 68);
                }
                if (material == Material.ash && this.overrideBlockTexture < 0) {
                    this.renderSouthFaceDistorted(block, xCoord, yCoord, zCoord, 12);
                }
            }
            var9 = true;
        }
        return var9;
    }

    public boolean renderBlockCactus(Block block, int var2, int var3, int var4) {
        int var5 = block.colorMultiplier(this.blockAccess, var2, var3, var4);
        float var6 = (float)(var5 >> 16 & 0xFF) / 255.0f;
        float var7 = (float)(var5 >> 8 & 0xFF) / 255.0f;
        float var8 = (float)(var5 & 0xFF) / 255.0f;
        if (EntityRenderer.field_28135_a) {
            float var9 = (var6 * 30.0f + var7 * 59.0f + var8 * 11.0f) / 100.0f;
            float var10 = (var6 * 30.0f + var7 * 70.0f) / 100.0f;
            float var11 = (var6 * 30.0f + var8 * 70.0f) / 100.0f;
            var6 = var9;
            var7 = var10;
            var8 = var11;
        }
        return this.func_1230_b(block, var2, var3, var4, var6, var7, var8);
    }

    public boolean func_1230_b(Block var1, int var2, int var3, int var4, float var5, float var6, float var7) {
        float var28;
        Tessellator var8 = Tessellator.instance;
        boolean var9 = false;
        float var10 = 0.5f;
        float var11 = 1.0f;
        float var12 = 0.8f;
        float var13 = 0.6f;
        float var14 = var10 * var5;
        float var15 = var11 * var5;
        float var16 = var12 * var5;
        float var17 = var13 * var5;
        float var18 = var10 * var6;
        float var19 = var11 * var6;
        float var20 = var12 * var6;
        float var21 = var13 * var6;
        float var22 = var10 * var7;
        float var23 = var11 * var7;
        float var24 = var12 * var7;
        float var25 = var13 * var7;
        float var26 = 0.0625f;
        float var27 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4);
        if (this.renderAllFaces || var1.shouldSideBeRendered(this.blockAccess, var2, var3 - 1, var4, 0)) {
            var28 = var1.getBlockBrightness(this.blockAccess, var2, var3 - 1, var4);
            var8.setColorOpaque_F(var14 * var28, var18 * var28, var22 * var28);
            if (distortion != 2) {
                this.renderBottomFace(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 0));
            } else if (distortion == 2) {
                this.renderBottomFaceDistorted(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 0));
            }
            var9 = true;
        }
        if (this.renderAllFaces || var1.shouldSideBeRendered(this.blockAccess, var2, var3 + 1, var4, 1)) {
            var28 = var1.getBlockBrightness(this.blockAccess, var2, var3 + 1, var4);
            if (var1.maxY != 1.0 && !var1.blockMaterial.getIsLiquid()) {
                var28 = var27;
            }
            var8.setColorOpaque_F(var15 * var28, var19 * var28, var23 * var28);
            if (distortion != 2) {
                this.renderTopFace(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 1));
            } else if (distortion == 2) {
                this.renderTopFaceDistorted(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 1));
            }
            var9 = true;
        }
        if (this.renderAllFaces || var1.shouldSideBeRendered(this.blockAccess, var2, var3, var4 - 1, 2)) {
            var28 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 - 1);
            if (var1.minZ > 0.0) {
                var28 = var27;
            }
            var8.setColorOpaque_F(var16 * var28, var20 * var28, var24 * var28);
            var8.setTranslationF(0.0f, 0.0f, var26);
            if (distortion != 2) {
                this.renderEastFace(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 2));
            } else if (distortion == 2) {
                this.renderEastFaceDistorted(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 2));
            }
            var8.setTranslationF(0.0f, 0.0f, -var26);
            var9 = true;
        }
        if (this.renderAllFaces || var1.shouldSideBeRendered(this.blockAccess, var2, var3, var4 + 1, 3)) {
            var28 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 + 1);
            if (var1.maxZ < 1.0) {
                var28 = var27;
            }
            var8.setColorOpaque_F(var16 * var28, var20 * var28, var24 * var28);
            var8.setTranslationF(0.0f, 0.0f, -var26);
            if (distortion != 2) {
                this.renderWestFace(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 3));
            } else if (distortion == 2) {
                this.renderWestFaceDistorted(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 3));
            }
            var8.setTranslationF(0.0f, 0.0f, var26);
            var9 = true;
        }
        if (this.renderAllFaces || var1.shouldSideBeRendered(this.blockAccess, var2 - 1, var3, var4, 4)) {
            var28 = var1.getBlockBrightness(this.blockAccess, var2 - 1, var3, var4);
            if (var1.minX > 0.0) {
                var28 = var27;
            }
            var8.setColorOpaque_F(var17 * var28, var21 * var28, var25 * var28);
            var8.setTranslationF(var26, 0.0f, 0.0f);
            if (distortion != 2) {
                this.renderNorthFace(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 4));
            } else if (distortion == 2) {
                this.renderNorthFaceDistorted(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 4));
            }
            var8.setTranslationF(-var26, 0.0f, 0.0f);
            var9 = true;
        }
        if (this.renderAllFaces || var1.shouldSideBeRendered(this.blockAccess, var2 + 1, var3, var4, 5)) {
            var28 = var1.getBlockBrightness(this.blockAccess, var2 + 1, var3, var4);
            if (var1.maxX < 1.0) {
                var28 = var27;
            }
            var8.setColorOpaque_F(var17 * var28, var21 * var28, var25 * var28);
            var8.setTranslationF(-var26, 0.0f, 0.0f);
            if (distortion != 2) {
                this.renderSouthFace(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 5));
            } else if (distortion == 2) {
                this.renderSouthFaceDistorted(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 5));
            }
            var8.setTranslationF(var26, 0.0f, 0.0f);
            var9 = true;
        }
        return var9;
    }

    public boolean renderBlockFence(BlockFence blockfence, int i, int j, int k) {
        float f7;
        boolean flag = false;
        float f = 0.375f;
        float f1 = 0.625f;
        blockfence.setBlockBounds(f, 0.0f, f, f1, 1.0f, f1);
        this.renderStandardBlock(blockfence, i, j, k);
        flag = true;
        boolean flag1 = false;
        boolean flag2 = false;
        if (blockfence.isFenceAt(this.blockAccess, i - 1, j, k) || blockfence.isFenceAt(this.blockAccess, i + 1, j, k)) {
            flag1 = true;
        }
        if (blockfence.isFenceAt(this.blockAccess, i, j, k - 1) || blockfence.isFenceAt(this.blockAccess, i, j, k + 1)) {
            flag2 = true;
        }
        boolean flag3 = blockfence.isFenceAt(this.blockAccess, i - 1, j, k);
        boolean flag4 = blockfence.isFenceAt(this.blockAccess, i + 1, j, k);
        boolean flag5 = blockfence.isFenceAt(this.blockAccess, i, j, k - 1);
        boolean flag6 = blockfence.isFenceAt(this.blockAccess, i, j, k + 1);
        if (!flag1 && !flag2) {
            flag1 = true;
        }
        f = 0.4375f;
        f1 = 0.5625f;
        float f2 = 0.75f;
        float f3 = 0.9375f;
        float f4 = flag3 ? 0.0f : f;
        float f5 = flag4 ? 1.0f : f1;
        float f6 = flag5 ? 0.0f : f;
        float f8 = f7 = flag6 ? 1.0f : f1;
        if (flag1) {
            blockfence.setBlockBounds(f4, f2, f, f5, f3, f1);
            this.renderStandardBlock(blockfence, i, j, k);
            flag = true;
        }
        if (flag2) {
            blockfence.setBlockBounds(f, f2, f6, f1, f3, f7);
            this.renderStandardBlock(blockfence, i, j, k);
            flag = true;
        }
        f2 = 0.375f;
        f3 = 0.5625f;
        if (flag1) {
            blockfence.setBlockBounds(f4, f2, f, f5, f3, f1);
            this.renderStandardBlock(blockfence, i, j, k);
            flag = true;
        }
        if (flag2) {
            blockfence.setBlockBounds(f, f2, f6, f1, f3, f7);
            this.renderStandardBlock(blockfence, i, j, k);
            flag = true;
        }
        blockfence.setBlockBoundsBasedOnState(this.blockAccess, i, j, k);
        return flag;
    }

    public boolean renderBlockStairs(Block var1, int var2, int var3, int var4) {
        int var5 = this.blockAccess.getBlockMetadata(var2, var3, var4);
        int var6 = var5 & 3;
        float var7 = 0.0f;
        float var8 = 0.5f;
        float var9 = 0.5f;
        float var10 = 1.0f;
        if ((var5 & 4) != 0) {
            var7 = 0.5f;
            var8 = 1.0f;
            var9 = 0.0f;
            var10 = 0.5f;
        }
        var1.setBlockBounds(0.0f, var7, 0.0f, 1.0f, var8, 1.0f);
        this.renderStandardBlock(var1, var2, var3, var4);
        if (var6 == 0) {
            var1.setBlockBounds(0.5f, var9, 0.0f, 1.0f, var10, 1.0f);
            this.renderStandardBlock(var1, var2, var3, var4);
        } else if (var6 == 1) {
            var1.setBlockBounds(0.0f, var9, 0.0f, 0.5f, var10, 1.0f);
            this.renderStandardBlock(var1, var2, var3, var4);
        } else if (var6 == 2) {
            var1.setBlockBounds(0.0f, var9, 0.5f, 1.0f, var10, 1.0f);
            this.renderStandardBlock(var1, var2, var3, var4);
        } else if (var6 == 3) {
            var1.setBlockBounds(0.0f, var9, 0.0f, 1.0f, var10, 0.5f);
            this.renderStandardBlock(var1, var2, var3, var4);
        }
        var1.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return true;
    }

    public boolean renderBlockDoor(Block var1, int var2, int var3, int var4) {
        Tessellator var5 = Tessellator.instance;
        BlockDoor var6 = (BlockDoor)var1;
        boolean var7 = false;
        float var8 = 0.5f;
        float var9 = 1.0f;
        float var10 = 0.8f;
        float var11 = 0.6f;
        float var12 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4);
        float var13 = var1.getBlockBrightness(this.blockAccess, var2, var3 - 1, var4);
        if (var6.minY > 0.0) {
            var13 = var12;
        }
        if (Block.lightValue[var1.blockID] > 0) {
            var13 = 1.0f;
        }
        var5.setColorOpaque_F(var8 * var13, var8 * var13, var8 * var13);
        if (distortion != 2) {
            this.renderBottomFace(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 0));
        } else if (distortion == 2) {
            this.renderBottomFaceDistorted(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 0));
        }
        var7 = true;
        var13 = var1.getBlockBrightness(this.blockAccess, var2, var3 + 1, var4);
        if (var6.maxY < 1.0) {
            var13 = var12;
        }
        if (Block.lightValue[var1.blockID] > 0) {
            var13 = 1.0f;
        }
        var5.setColorOpaque_F(var9 * var13, var9 * var13, var9 * var13);
        if (distortion != 2) {
            this.renderTopFace(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 1));
        } else if (distortion == 2) {
            this.renderTopFaceDistorted(var1, var2, var3, var4, var1.getBlockTexture(this.blockAccess, var2, var3, var4, 1));
        }
        var7 = true;
        var13 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 - 1);
        if (var6.minZ > 0.0) {
            var13 = var12;
        }
        if (Block.lightValue[var1.blockID] > 0) {
            var13 = 1.0f;
        }
        var5.setColorOpaque_F(var10 * var13, var10 * var13, var10 * var13);
        int var14 = var1.getBlockTexture(this.blockAccess, var2, var3, var4, 2);
        if (var14 < 0) {
            this.flipTexture = true;
            var14 = -var14;
        }
        if (distortion != 2) {
            this.renderEastFace(var1, var2, var3, var4, var14);
        } else if (distortion == 2) {
            this.renderEastFaceDistorted(var1, var2, var3, var4, var14);
        }
        var7 = true;
        this.flipTexture = false;
        var13 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 + 1);
        if (var6.maxZ < 1.0) {
            var13 = var12;
        }
        if (Block.lightValue[var1.blockID] > 0) {
            var13 = 1.0f;
        }
        var5.setColorOpaque_F(var10 * var13, var10 * var13, var10 * var13);
        var14 = var1.getBlockTexture(this.blockAccess, var2, var3, var4, 3);
        if (var14 < 0) {
            this.flipTexture = true;
            var14 = -var14;
        }
        if (distortion != 2) {
            this.renderWestFace(var1, var2, var3, var4, var14);
        } else if (distortion == 2) {
            this.renderWestFaceDistorted(var1, var2, var3, var4, var14);
        }
        var7 = true;
        this.flipTexture = false;
        var13 = var1.getBlockBrightness(this.blockAccess, var2 - 1, var3, var4);
        if (var6.minX > 0.0) {
            var13 = var12;
        }
        if (Block.lightValue[var1.blockID] > 0) {
            var13 = 1.0f;
        }
        var5.setColorOpaque_F(var11 * var13, var11 * var13, var11 * var13);
        var14 = var1.getBlockTexture(this.blockAccess, var2, var3, var4, 4);
        if (var14 < 0) {
            this.flipTexture = true;
            var14 = -var14;
        }
        if (distortion != 2) {
            this.renderNorthFace(var1, var2, var3, var4, var14);
        } else if (distortion == 2) {
            this.renderNorthFaceDistorted(var1, var2, var3, var4, var14);
        }
        var7 = true;
        this.flipTexture = false;
        var13 = var1.getBlockBrightness(this.blockAccess, var2 + 1, var3, var4);
        if (var6.maxX < 1.0) {
            var13 = var12;
        }
        if (Block.lightValue[var1.blockID] > 0) {
            var13 = 1.0f;
        }
        var5.setColorOpaque_F(var11 * var13, var11 * var13, var11 * var13);
        var14 = var1.getBlockTexture(this.blockAccess, var2, var3, var4, 5);
        if (var14 < 0) {
            this.flipTexture = true;
            var14 = -var14;
        }
        if (distortion != 2) {
            this.renderSouthFace(var1, var2, var3, var4, var14);
        } else if (distortion == 2) {
            this.renderSouthFaceDistorted(var1, var2, var3, var4, var14);
        }
        var7 = true;
        this.flipTexture = false;
        return var7;
    }

    public void renderBottomFace(Block var1, double var2, double var4, double var6, int var8) {
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xFF0;
        double var12 = ((double)var10 + var1.minX * 16.0) / 256.0;
        double var14 = ((double)var10 + var1.maxX * 16.0 - 0.01) / 256.0;
        double var16 = ((double)var11 + var1.minZ * 16.0) / 512.0;
        double var18 = ((double)var11 + var1.maxZ * 16.0 - 0.01) / 512.0;
        if (var1.minX < 0.0 || var1.maxX > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (var1.minZ < 0.0 || var1.maxZ > 1.0) {
            var16 = ((float)var11 + 0.0f) / 512.0f;
            var18 = ((float)var11 + 15.99f) / 512.0f;
        }
        double var20 = var14;
        double var22 = var12;
        double var24 = var16;
        double var26 = var18;
        if (this.uvRotateBottom == 2) {
            var12 = ((double)var10 + var1.minZ * 16.0) / 256.0;
            var16 = ((double)(var11 + 16) - var1.maxX * 16.0) / 512.0;
            var14 = ((double)var10 + var1.maxZ * 16.0) / 256.0;
            var18 = ((double)(var11 + 16) - var1.minX * 16.0) / 512.0;
            var24 = var16;
            var26 = var18;
            var20 = var12;
            var22 = var14;
            var16 = var18;
            var18 = var24;
        } else if (this.uvRotateBottom == 1) {
            var12 = ((double)(var10 + 16) - var1.maxZ * 16.0) / 256.0;
            var16 = ((double)var11 + var1.minX * 16.0) / 512.0;
            var14 = ((double)(var10 + 16) - var1.minZ * 16.0) / 256.0;
            var18 = ((double)var11 + var1.maxX * 16.0) / 512.0;
            var20 = var14;
            var22 = var12;
            var12 = var14;
            var14 = var22;
            var24 = var18;
            var26 = var16;
        } else if (this.uvRotateBottom == 3) {
            var12 = ((double)(var10 + 16) - var1.minX * 16.0) / 256.0;
            var14 = ((double)(var10 + 16) - var1.maxX * 16.0 - 0.01) / 256.0;
            var16 = ((double)(var11 + 16) - var1.minZ * 16.0) / 512.0;
            var18 = ((double)(var11 + 16) - var1.maxZ * 16.0 - 0.01) / 512.0;
            var20 = var14;
            var22 = var12;
            var24 = var16;
            var26 = var18;
        }
        double var28 = var2 + var1.minX;
        double var30 = var2 + var1.maxX;
        double var32 = var4 + var1.minY;
        double var34 = var6 + var1.minZ;
        double var36 = var6 + var1.maxZ;
        if (this.enableAO) {
            var9.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            var9.addVertexWithUV(var28, var32, var36, var22, var26);
            var9.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            var9.addVertexWithUV(var28, var32, var34, var12, var16);
            var9.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            var9.addVertexWithUV(var30, var32, var34, var20, var24);
            var9.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            var9.addVertexWithUV(var30, var32, var36, var14, var18);
        } else {
            var9.addVertexWithUV(var28, var32, var36, var22, var26);
            var9.addVertexWithUV(var28, var32, var34, var12, var16);
            var9.addVertexWithUV(var30, var32, var34, var20, var24);
            var9.addVertexWithUV(var30, var32, var36, var14, var18);
        }
    }

    public void renderBottomFaceDistorted(Block var1, double var2, double var4, double var6, int var8) {
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xFF0;
        double var12 = ((double)var10 + var1.minX * 16.0) / 256.0;
        double var14 = ((double)var10 + var1.maxX * 16.0 - 0.01) / 256.0;
        double var16 = ((double)var11 + var1.minZ * 16.0) / 512.0;
        double var18 = ((double)var11 + var1.maxZ * 16.0 - 0.01) / 512.0;
        if (var1.minX < 0.0 || var1.maxX > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (var1.minZ < 0.0 || var1.maxZ > 1.0) {
            var16 = ((float)var11 + 0.0f) / 512.0f;
            var18 = ((float)var11 + 15.99f) / 512.0f;
        }
        double var20 = var14;
        double var22 = var12;
        double var24 = var16;
        double var26 = var18;
        if (this.uvRotateBottom == 2) {
            var12 = ((double)var10 + var1.minZ * 16.0) / 256.0;
            var16 = ((double)(var11 + 16) - var1.maxX * 16.0) / 512.0;
            var14 = ((double)var10 + var1.maxZ * 16.0) / 256.0;
            var18 = ((double)(var11 + 16) - var1.minX * 16.0) / 512.0;
            var24 = var16;
            var26 = var18;
            var20 = var12;
            var22 = var14;
            var16 = var18;
            var18 = var24;
        } else if (this.uvRotateBottom == 1) {
            var12 = ((double)(var10 + 16) - var1.maxZ * 16.0) / 256.0;
            var16 = ((double)var11 + var1.minX * 16.0) / 512.0;
            var14 = ((double)(var10 + 16) - var1.minZ * 16.0) / 256.0;
            var18 = ((double)var11 + var1.maxX * 16.0) / 512.0;
            var20 = var14;
            var22 = var12;
            var12 = var14;
            var14 = var22;
            var24 = var18;
            var26 = var16;
        } else if (this.uvRotateBottom == 3) {
            var12 = ((double)(var10 + 16) - var1.minX * 16.0) / 256.0;
            var14 = ((double)(var10 + 16) - var1.maxX * 16.0 - 0.01) / 256.0;
            var16 = ((double)(var11 + 16) - var1.minZ * 16.0) / 512.0;
            var18 = ((double)(var11 + 16) - var1.maxZ * 16.0 - 0.01) / 512.0;
            var20 = var14;
            var22 = var12;
            var24 = var16;
            var26 = var18;
        }
        double var28 = var2 + var1.minX;
        double var30 = var2 + var1.maxX;
        double var32 = var4 + var1.minY;
        double var34 = var6 + var1.minZ;
        double var36 = var6 + var1.maxZ;
        if (this.enableAO) {
            var9.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            var9.addDistortedVertexWithUV(var28, var32, var36, var22, var26);
            var9.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            var9.addDistortedVertexWithUV(var28, var32, var34, var12, var16);
            var9.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            var9.addDistortedVertexWithUV(var30, var32, var34, var20, var24);
            var9.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            var9.addDistortedVertexWithUV(var30, var32, var36, var14, var18);
        } else {
            var9.addDistortedVertexWithUV(var28, var32, var36, var22, var26);
            var9.addDistortedVertexWithUV(var28, var32, var34, var12, var16);
            var9.addDistortedVertexWithUV(var30, var32, var34, var20, var24);
            var9.addDistortedVertexWithUV(var30, var32, var36, var14, var18);
        }
    }

    public void renderTopFace(Block var1, double var2, double var4, double var6, int var8) {
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xFF0;
        double var12 = ((double)var10 + var1.minX * 16.0) / 256.0;
        double var14 = ((double)var10 + var1.maxX * 16.0 - 0.01) / 256.0;
        double var16 = ((double)var11 + var1.minZ * 16.0) / 512.0;
        double var18 = ((double)var11 + var1.maxZ * 16.0 - 0.01) / 512.0;
        if (var1.minX < 0.0 || var1.maxX > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (var1.minZ < 0.0 || var1.maxZ > 1.0) {
            var16 = ((float)var11 + 0.0f) / 512.0f;
            var18 = ((float)var11 + 15.99f) / 512.0f;
        }
        double var20 = var14;
        double var22 = var12;
        double var24 = var16;
        double var26 = var18;
        if (this.uvRotateTop == 1) {
            var12 = ((double)var10 + var1.minZ * 16.0) / 256.0;
            var16 = ((double)(var11 + 16) - var1.maxX * 16.0) / 512.0;
            var14 = ((double)var10 + var1.maxZ * 16.0) / 256.0;
            var18 = ((double)(var11 + 16) - var1.minX * 16.0) / 512.0;
            var24 = var16;
            var26 = var18;
            var20 = var12;
            var22 = var14;
            var16 = var18;
            var18 = var24;
        } else if (this.uvRotateTop == 2) {
            var12 = ((double)(var10 + 16) - var1.maxZ * 16.0) / 256.0;
            var16 = ((double)var11 + var1.minX * 16.0) / 512.0;
            var14 = ((double)(var10 + 16) - var1.minZ * 16.0) / 256.0;
            var18 = ((double)var11 + var1.maxX * 16.0) / 512.0;
            var20 = var14;
            var22 = var12;
            var12 = var14;
            var14 = var22;
            var24 = var18;
            var26 = var16;
        } else if (this.uvRotateTop == 3) {
            var12 = ((double)(var10 + 16) - var1.minX * 16.0) / 256.0;
            var14 = ((double)(var10 + 16) - var1.maxX * 16.0 - 0.01) / 256.0;
            var16 = ((double)(var11 + 16) - var1.minZ * 16.0) / 512.0;
            var18 = ((double)(var11 + 16) - var1.maxZ * 16.0 - 0.01) / 512.0;
            var20 = var14;
            var22 = var12;
            var24 = var16;
            var26 = var18;
        }
        double var28 = var2 + var1.minX;
        double var30 = var2 + var1.maxX;
        double var32 = var4 + var1.maxY;
        double var34 = var6 + var1.minZ;
        double var36 = var6 + var1.maxZ;
        if (this.enableAO) {
            var9.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            var9.addVertexWithUV(var30, var32, var36, var14, var18);
            var9.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            var9.addVertexWithUV(var30, var32, var34, var20, var24);
            var9.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            var9.addVertexWithUV(var28, var32, var34, var12, var16);
            var9.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            var9.addVertexWithUV(var28, var32, var36, var22, var26);
        } else {
            var9.addVertexWithUV(var30, var32, var36, var14, var18);
            var9.addVertexWithUV(var30, var32, var34, var20, var24);
            var9.addVertexWithUV(var28, var32, var34, var12, var16);
            var9.addVertexWithUV(var28, var32, var36, var22, var26);
        }
    }

    public void renderTopFaceDistorted(Block var1, double var2, double var4, double var6, int var8) {
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xFF0;
        double var12 = ((double)var10 + var1.minX * 16.0) / 256.0;
        double var14 = ((double)var10 + var1.maxX * 16.0 - 0.01) / 256.0;
        double var16 = ((double)var11 + var1.minZ * 16.0) / 512.0;
        double var18 = ((double)var11 + var1.maxZ * 16.0 - 0.01) / 512.0;
        if (var1.minX < 0.0 || var1.maxX > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (var1.minZ < 0.0 || var1.maxZ > 1.0) {
            var16 = ((float)var11 + 0.0f) / 512.0f;
            var18 = ((float)var11 + 15.99f) / 512.0f;
        }
        double var20 = var14;
        double var22 = var12;
        double var24 = var16;
        double var26 = var18;
        if (this.uvRotateTop == 1) {
            var12 = ((double)var10 + var1.minZ * 16.0) / 256.0;
            var16 = ((double)(var11 + 16) - var1.maxX * 16.0) / 512.0;
            var14 = ((double)var10 + var1.maxZ * 16.0) / 256.0;
            var18 = ((double)(var11 + 16) - var1.minX * 16.0) / 512.0;
            var24 = var16;
            var26 = var18;
            var20 = var12;
            var22 = var14;
            var16 = var18;
            var18 = var24;
        } else if (this.uvRotateTop == 2) {
            var12 = ((double)(var10 + 16) - var1.maxZ * 16.0) / 256.0;
            var16 = ((double)var11 + var1.minX * 16.0) / 512.0;
            var14 = ((double)(var10 + 16) - var1.minZ * 16.0) / 256.0;
            var18 = ((double)var11 + var1.maxX * 16.0) / 512.0;
            var20 = var14;
            var22 = var12;
            var12 = var14;
            var14 = var22;
            var24 = var18;
            var26 = var16;
        } else if (this.uvRotateTop == 3) {
            var12 = ((double)(var10 + 16) - var1.minX * 16.0) / 256.0;
            var14 = ((double)(var10 + 16) - var1.maxX * 16.0 - 0.01) / 256.0;
            var16 = ((double)(var11 + 16) - var1.minZ * 16.0) / 512.0;
            var18 = ((double)(var11 + 16) - var1.maxZ * 16.0 - 0.01) / 512.0;
            var20 = var14;
            var22 = var12;
            var24 = var16;
            var26 = var18;
        }
        double var28 = var2 + var1.minX;
        double var30 = var2 + var1.maxX;
        double var32 = var4 + var1.maxY;
        double var34 = var6 + var1.minZ;
        double var36 = var6 + var1.maxZ;
        if (this.enableAO) {
            var9.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            var9.addDistortedVertexWithUV(var30, var32, var36, var14, var18);
            var9.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            var9.addDistortedVertexWithUV(var30, var32, var34, var20, var24);
            var9.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            var9.addDistortedVertexWithUV(var28, var32, var34, var12, var16);
            var9.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            var9.addDistortedVertexWithUV(var28, var32, var36, var22, var26);
        } else {
            var9.addDistortedVertexWithUV(var30, var32, var36, var14, var18);
            var9.addDistortedVertexWithUV(var30, var32, var34, var20, var24);
            var9.addDistortedVertexWithUV(var28, var32, var34, var12, var16);
            var9.addDistortedVertexWithUV(var28, var32, var36, var22, var26);
        }
    }

    public void renderEastFace(Block var1, double var2, double var4, double var6, int var8) {
        double var20;
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xFF0;
        double var12 = ((double)var10 + var1.minX * 16.0) / 256.0;
        double var14 = ((double)var10 + var1.maxX * 16.0 - 0.01) / 256.0;
        double var16 = ((double)(var11 + 16) - var1.maxY * 16.0) / 512.0;
        double var18 = ((double)(var11 + 16) - var1.minY * 16.0 - 0.01) / 512.0;
        if (this.flipTexture) {
            var20 = var12;
            var12 = var14;
            var14 = var20;
        }
        if (var1.minX < 0.0 || var1.maxX > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (var1.minY < 0.0 || var1.maxY > 1.0) {
            var16 = ((float)var11 + 0.0f) / 512.0f;
            var18 = ((float)var11 + 15.99f) / 512.0f;
        }
        var20 = var14;
        double var22 = var12;
        double var24 = var16;
        double var26 = var18;
        if (this.uvRotateEast == 2) {
            var12 = ((double)var10 + var1.minY * 16.0) / 256.0;
            var16 = ((double)(var11 + 16) - var1.minX * 16.0) / 512.0;
            var14 = ((double)var10 + var1.maxY * 16.0) / 256.0;
            var18 = ((double)(var11 + 16) - var1.maxX * 16.0) / 512.0;
            var24 = var16;
            var26 = var18;
            var20 = var12;
            var22 = var14;
            var16 = var18;
            var18 = var24;
        } else if (this.uvRotateEast == 1) {
            var12 = ((double)(var10 + 16) - var1.maxY * 16.0) / 256.0;
            var16 = ((double)var11 + var1.maxX * 16.0) / 512.0;
            var14 = ((double)(var10 + 16) - var1.minY * 16.0) / 256.0;
            var18 = ((double)var11 + var1.minX * 16.0) / 512.0;
            var20 = var14;
            var22 = var12;
            var12 = var14;
            var14 = var22;
            var24 = var18;
            var26 = var16;
        } else if (this.uvRotateEast == 3) {
            var12 = ((double)(var10 + 16) - var1.minX * 16.0) / 256.0;
            var14 = ((double)(var10 + 16) - var1.maxX * 16.0 - 0.01) / 256.0;
            var16 = ((double)var11 + var1.maxY * 16.0) / 512.0;
            var18 = ((double)var11 + var1.minY * 16.0 - 0.01) / 512.0;
            var20 = var14;
            var22 = var12;
            var24 = var16;
            var26 = var18;
        }
        double var28 = var2 + var1.minX;
        double var30 = var2 + var1.maxX;
        double var32 = var4 + var1.minY;
        double var34 = var4 + var1.maxY;
        double var36 = var6 + var1.minZ;
        if (this.enableAO) {
            var9.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            var9.addVertexWithUV(var28, var34, var36, var20, var24);
            var9.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            var9.addVertexWithUV(var30, var34, var36, var12, var16);
            var9.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            var9.addVertexWithUV(var30, var32, var36, var22, var26);
            var9.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            var9.addVertexWithUV(var28, var32, var36, var14, var18);
        } else {
            var9.addVertexWithUV(var28, var34, var36, var20, var24);
            var9.addVertexWithUV(var30, var34, var36, var12, var16);
            var9.addVertexWithUV(var30, var32, var36, var22, var26);
            var9.addVertexWithUV(var28, var32, var36, var14, var18);
        }
    }

    public void renderEastFaceDistorted(Block var1, double var2, double var4, double var6, int var8) {
        double var20;
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xFF0;
        double var12 = ((double)var10 + var1.minX * 16.0) / 256.0;
        double var14 = ((double)var10 + var1.maxX * 16.0 - 0.01) / 256.0;
        double var16 = ((double)(var11 + 16) - var1.maxY * 16.0) / 512.0;
        double var18 = ((double)(var11 + 16) - var1.minY * 16.0 - 0.01) / 512.0;
        if (this.flipTexture) {
            var20 = var12;
            var12 = var14;
            var14 = var20;
        }
        if (var1.minX < 0.0 || var1.maxX > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (var1.minY < 0.0 || var1.maxY > 1.0) {
            var16 = ((float)var11 + 0.0f) / 512.0f;
            var18 = ((float)var11 + 15.99f) / 512.0f;
        }
        var20 = var14;
        double var22 = var12;
        double var24 = var16;
        double var26 = var18;
        if (this.uvRotateEast == 2) {
            var12 = ((double)var10 + var1.minY * 16.0) / 256.0;
            var16 = ((double)(var11 + 16) - var1.minX * 16.0) / 512.0;
            var14 = ((double)var10 + var1.maxY * 16.0) / 256.0;
            var18 = ((double)(var11 + 16) - var1.maxX * 16.0) / 512.0;
            var24 = var16;
            var26 = var18;
            var20 = var12;
            var22 = var14;
            var16 = var18;
            var18 = var24;
        } else if (this.uvRotateEast == 1) {
            var12 = ((double)(var10 + 16) - var1.maxY * 16.0) / 256.0;
            var16 = ((double)var11 + var1.maxX * 16.0) / 512.0;
            var14 = ((double)(var10 + 16) - var1.minY * 16.0) / 256.0;
            var18 = ((double)var11 + var1.minX * 16.0) / 512.0;
            var20 = var14;
            var22 = var12;
            var12 = var14;
            var14 = var22;
            var24 = var18;
            var26 = var16;
        } else if (this.uvRotateEast == 3) {
            var12 = ((double)(var10 + 16) - var1.minX * 16.0) / 256.0;
            var14 = ((double)(var10 + 16) - var1.maxX * 16.0 - 0.01) / 256.0;
            var16 = ((double)var11 + var1.maxY * 16.0) / 512.0;
            var18 = ((double)var11 + var1.minY * 16.0 - 0.01) / 512.0;
            var20 = var14;
            var22 = var12;
            var24 = var16;
            var26 = var18;
        }
        double var28 = var2 + var1.minX;
        double var30 = var2 + var1.maxX;
        double var32 = var4 + var1.minY;
        double var34 = var4 + var1.maxY;
        double var36 = var6 + var1.minZ;
        if (this.enableAO) {
            var9.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            var9.addDistortedVertexWithUV(var28, var34, var36, var20, var24);
            var9.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            var9.addDistortedVertexWithUV(var30, var34, var36, var12, var16);
            var9.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            var9.addDistortedVertexWithUV(var30, var32, var36, var22, var26);
            var9.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            var9.addDistortedVertexWithUV(var28, var32, var36, var14, var18);
        } else {
            var9.addDistortedVertexWithUV(var28, var34, var36, var20, var24);
            var9.addDistortedVertexWithUV(var30, var34, var36, var12, var16);
            var9.addDistortedVertexWithUV(var30, var32, var36, var22, var26);
            var9.addDistortedVertexWithUV(var28, var32, var36, var14, var18);
        }
    }

    public void renderWestFace(Block var1, double var2, double var4, double var6, int var8) {
        double var20;
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xFF0;
        double var12 = ((double)var10 + var1.minX * 16.0) / 256.0;
        double var14 = ((double)var10 + var1.maxX * 16.0 - 0.01) / 256.0;
        double var16 = ((double)(var11 + 16) - var1.maxY * 16.0) / 512.0;
        double var18 = ((double)(var11 + 16) - var1.minY * 16.0 - 0.01) / 512.0;
        if (this.flipTexture) {
            var20 = var12;
            var12 = var14;
            var14 = var20;
        }
        if (var1.minX < 0.0 || var1.maxX > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (var1.minY < 0.0 || var1.maxY > 1.0) {
            var16 = ((float)var11 + 0.0f) / 512.0f;
            var18 = ((float)var11 + 15.99f) / 512.0f;
        }
        var20 = var14;
        double var22 = var12;
        double var24 = var16;
        double var26 = var18;
        if (this.uvRotateWest == 1) {
            var12 = ((double)var10 + var1.minY * 16.0) / 256.0;
            var18 = ((double)(var11 + 16) - var1.minX * 16.0) / 512.0;
            var14 = ((double)var10 + var1.maxY * 16.0) / 256.0;
            var24 = var16 = ((double)(var11 + 16) - var1.maxX * 16.0) / 512.0;
            var26 = var18;
            var20 = var12;
            var22 = var14;
            var16 = var18;
            var18 = var24;
        } else if (this.uvRotateWest == 2) {
            var12 = ((double)(var10 + 16) - var1.maxY * 16.0) / 256.0;
            var16 = ((double)var11 + var1.minX * 16.0) / 512.0;
            var14 = ((double)(var10 + 16) - var1.minY * 16.0) / 256.0;
            var18 = ((double)var11 + var1.maxX * 16.0) / 512.0;
            var20 = var14;
            var22 = var12;
            var12 = var14;
            var14 = var22;
            var24 = var18;
            var26 = var16;
        } else if (this.uvRotateWest == 3) {
            var12 = ((double)(var10 + 16) - var1.minX * 16.0) / 256.0;
            var14 = ((double)(var10 + 16) - var1.maxX * 16.0 - 0.01) / 256.0;
            var16 = ((double)var11 + var1.maxY * 16.0) / 512.0;
            var18 = ((double)var11 + var1.minY * 16.0 - 0.01) / 512.0;
            var20 = var14;
            var22 = var12;
            var24 = var16;
            var26 = var18;
        }
        double var28 = var2 + var1.minX;
        double var30 = var2 + var1.maxX;
        double var32 = var4 + var1.minY;
        double var34 = var4 + var1.maxY;
        double var36 = var6 + var1.maxZ;
        if (this.enableAO) {
            var9.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            var9.addVertexWithUV(var28, var34, var36, var12, var16);
            var9.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            var9.addVertexWithUV(var28, var32, var36, var22, var26);
            var9.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            var9.addVertexWithUV(var30, var32, var36, var14, var18);
            var9.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            var9.addVertexWithUV(var30, var34, var36, var20, var24);
        } else {
            var9.addVertexWithUV(var28, var34, var36, var12, var16);
            var9.addVertexWithUV(var28, var32, var36, var22, var26);
            var9.addVertexWithUV(var30, var32, var36, var14, var18);
            var9.addVertexWithUV(var30, var34, var36, var20, var24);
        }
    }

    public void renderWestFaceDistorted(Block var1, double var2, double var4, double var6, int var8) {
        double var20;
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xFF0;
        double var12 = ((double)var10 + var1.minX * 16.0) / 256.0;
        double var14 = ((double)var10 + var1.maxX * 16.0 - 0.01) / 256.0;
        double var16 = ((double)(var11 + 16) - var1.maxY * 16.0) / 512.0;
        double var18 = ((double)(var11 + 16) - var1.minY * 16.0 - 0.01) / 512.0;
        if (this.flipTexture) {
            var20 = var12;
            var12 = var14;
            var14 = var20;
        }
        if (var1.minX < 0.0 || var1.maxX > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (var1.minY < 0.0 || var1.maxY > 1.0) {
            var16 = ((float)var11 + 0.0f) / 512.0f;
            var18 = ((float)var11 + 15.99f) / 512.0f;
        }
        var20 = var14;
        double var22 = var12;
        double var24 = var16;
        double var26 = var18;
        if (this.uvRotateWest == 1) {
            var12 = ((double)var10 + var1.minY * 16.0) / 256.0;
            var18 = ((double)(var11 + 16) - var1.minX * 16.0) / 512.0;
            var14 = ((double)var10 + var1.maxY * 16.0) / 256.0;
            var24 = var16 = ((double)(var11 + 16) - var1.maxX * 16.0) / 512.0;
            var26 = var18;
            var20 = var12;
            var22 = var14;
            var16 = var18;
            var18 = var24;
        } else if (this.uvRotateWest == 2) {
            var12 = ((double)(var10 + 16) - var1.maxY * 16.0) / 256.0;
            var16 = ((double)var11 + var1.minX * 16.0) / 512.0;
            var14 = ((double)(var10 + 16) - var1.minY * 16.0) / 256.0;
            var18 = ((double)var11 + var1.maxX * 16.0) / 512.0;
            var20 = var14;
            var22 = var12;
            var12 = var14;
            var14 = var22;
            var24 = var18;
            var26 = var16;
        } else if (this.uvRotateWest == 3) {
            var12 = ((double)(var10 + 16) - var1.minX * 16.0) / 256.0;
            var14 = ((double)(var10 + 16) - var1.maxX * 16.0 - 0.01) / 256.0;
            var16 = ((double)var11 + var1.maxY * 16.0) / 512.0;
            var18 = ((double)var11 + var1.minY * 16.0 - 0.01) / 512.0;
            var20 = var14;
            var22 = var12;
            var24 = var16;
            var26 = var18;
        }
        double var28 = var2 + var1.minX;
        double var30 = var2 + var1.maxX;
        double var32 = var4 + var1.minY;
        double var34 = var4 + var1.maxY;
        double var36 = var6 + var1.maxZ;
        if (this.enableAO) {
            var9.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            var9.addDistortedVertexWithUV(var28, var34, var36, var12, var16);
            var9.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            var9.addDistortedVertexWithUV(var28, var32, var36, var22, var26);
            var9.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            var9.addDistortedVertexWithUV(var30, var32, var36, var14, var18);
            var9.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            var9.addDistortedVertexWithUV(var30, var34, var36, var20, var24);
        } else {
            var9.addDistortedVertexWithUV(var28, var34, var36, var12, var16);
            var9.addDistortedVertexWithUV(var28, var32, var36, var22, var26);
            var9.addDistortedVertexWithUV(var30, var32, var36, var14, var18);
            var9.addDistortedVertexWithUV(var30, var34, var36, var20, var24);
        }
    }

    public void renderNorthFace(Block var1, double var2, double var4, double var6, int var8) {
        double var20;
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xFF0;
        double var12 = ((double)var10 + var1.minZ * 16.0) / 256.0;
        double var14 = ((double)var10 + var1.maxZ * 16.0 - 0.01) / 256.0;
        double var16 = ((double)(var11 + 16) - var1.maxY * 16.0) / 512.0;
        double var18 = ((double)(var11 + 16) - var1.minY * 16.0 - 0.01) / 512.0;
        if (this.flipTexture) {
            var20 = var12;
            var12 = var14;
            var14 = var20;
        }
        if (var1.minZ < 0.0 || var1.maxZ > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (var1.minY < 0.0 || var1.maxY > 1.0) {
            var16 = ((float)var11 + 0.0f) / 512.0f;
            var18 = ((float)var11 + 15.99f) / 512.0f;
        }
        var20 = var14;
        double var22 = var12;
        double var24 = var16;
        double var26 = var18;
        if (this.uvRotateNorth == 1) {
            var12 = ((double)var10 + var1.minY * 16.0) / 256.0;
            var16 = ((double)(var11 + 16) - var1.maxZ * 16.0) / 512.0;
            var14 = ((double)var10 + var1.maxY * 16.0) / 256.0;
            var18 = ((double)(var11 + 16) - var1.minZ * 16.0) / 512.0;
            var24 = var16;
            var26 = var18;
            var20 = var12;
            var22 = var14;
            var16 = var18;
            var18 = var24;
        } else if (this.uvRotateNorth == 2) {
            var12 = ((double)(var10 + 16) - var1.maxY * 16.0) / 256.0;
            var16 = ((double)var11 + var1.minZ * 16.0) / 512.0;
            var14 = ((double)(var10 + 16) - var1.minY * 16.0) / 256.0;
            var18 = ((double)var11 + var1.maxZ * 16.0) / 512.0;
            var20 = var14;
            var22 = var12;
            var12 = var14;
            var14 = var22;
            var24 = var18;
            var26 = var16;
        } else if (this.uvRotateNorth == 3) {
            var12 = ((double)(var10 + 16) - var1.minZ * 16.0) / 256.0;
            var14 = ((double)(var10 + 16) - var1.maxZ * 16.0 - 0.01) / 256.0;
            var16 = ((double)var11 + var1.maxY * 16.0) / 512.0;
            var18 = ((double)var11 + var1.minY * 16.0 - 0.01) / 512.0;
            var20 = var14;
            var22 = var12;
            var24 = var16;
            var26 = var18;
        }
        double var28 = var2 + var1.minX;
        double var30 = var4 + var1.minY;
        double var32 = var4 + var1.maxY;
        double var34 = var6 + var1.minZ;
        double var36 = var6 + var1.maxZ;
        if (this.enableAO) {
            var9.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            var9.addVertexWithUV(var28, var32, var36, var20, var24);
            var9.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            var9.addVertexWithUV(var28, var32, var34, var12, var16);
            var9.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            var9.addVertexWithUV(var28, var30, var34, var22, var26);
            var9.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            var9.addVertexWithUV(var28, var30, var36, var14, var18);
        } else {
            var9.addVertexWithUV(var28, var32, var36, var20, var24);
            var9.addVertexWithUV(var28, var32, var34, var12, var16);
            var9.addVertexWithUV(var28, var30, var34, var22, var26);
            var9.addVertexWithUV(var28, var30, var36, var14, var18);
        }
    }

    public void renderNorthFaceDistorted(Block var1, double var2, double var4, double var6, int var8) {
        double var20;
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xFF0;
        double var12 = ((double)var10 + var1.minZ * 16.0) / 256.0;
        double var14 = ((double)var10 + var1.maxZ * 16.0 - 0.01) / 256.0;
        double var16 = ((double)(var11 + 16) - var1.maxY * 16.0) / 512.0;
        double var18 = ((double)(var11 + 16) - var1.minY * 16.0 - 0.01) / 512.0;
        if (this.flipTexture) {
            var20 = var12;
            var12 = var14;
            var14 = var20;
        }
        if (var1.minZ < 0.0 || var1.maxZ > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (var1.minY < 0.0 || var1.maxY > 1.0) {
            var16 = ((float)var11 + 0.0f) / 512.0f;
            var18 = ((float)var11 + 15.99f) / 512.0f;
        }
        var20 = var14;
        double var22 = var12;
        double var24 = var16;
        double var26 = var18;
        if (this.uvRotateNorth == 1) {
            var12 = ((double)var10 + var1.minY * 16.0) / 256.0;
            var16 = ((double)(var11 + 16) - var1.maxZ * 16.0) / 512.0;
            var14 = ((double)var10 + var1.maxY * 16.0) / 256.0;
            var18 = ((double)(var11 + 16) - var1.minZ * 16.0) / 512.0;
            var24 = var16;
            var26 = var18;
            var20 = var12;
            var22 = var14;
            var16 = var18;
            var18 = var24;
        } else if (this.uvRotateNorth == 2) {
            var12 = ((double)(var10 + 16) - var1.maxY * 16.0) / 256.0;
            var16 = ((double)var11 + var1.minZ * 16.0) / 512.0;
            var14 = ((double)(var10 + 16) - var1.minY * 16.0) / 256.0;
            var18 = ((double)var11 + var1.maxZ * 16.0) / 512.0;
            var20 = var14;
            var22 = var12;
            var12 = var14;
            var14 = var22;
            var24 = var18;
            var26 = var16;
        } else if (this.uvRotateNorth == 3) {
            var12 = ((double)(var10 + 16) - var1.minZ * 16.0) / 256.0;
            var14 = ((double)(var10 + 16) - var1.maxZ * 16.0 - 0.01) / 256.0;
            var16 = ((double)var11 + var1.maxY * 16.0) / 512.0;
            var18 = ((double)var11 + var1.minY * 16.0 - 0.01) / 512.0;
            var20 = var14;
            var22 = var12;
            var24 = var16;
            var26 = var18;
        }
        double var28 = var2 + var1.minX;
        double var30 = var4 + var1.minY;
        double var32 = var4 + var1.maxY;
        double var34 = var6 + var1.minZ;
        double var36 = var6 + var1.maxZ;
        if (this.enableAO) {
            var9.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            var9.addDistortedVertexWithUV(var28, var32, var36, var20, var24);
            var9.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            var9.addDistortedVertexWithUV(var28, var32, var34, var12, var16);
            var9.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            var9.addDistortedVertexWithUV(var28, var30, var34, var22, var26);
            var9.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            var9.addDistortedVertexWithUV(var28, var30, var36, var14, var18);
        } else {
            var9.addDistortedVertexWithUV(var28, var32, var36, var20, var24);
            var9.addDistortedVertexWithUV(var28, var32, var34, var12, var16);
            var9.addDistortedVertexWithUV(var28, var30, var34, var22, var26);
            var9.addDistortedVertexWithUV(var28, var30, var36, var14, var18);
        }
    }

    public void renderSouthFace(Block var1, double var2, double var4, double var6, int var8) {
        double var20;
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xFF0;
        double var12 = ((double)var10 + var1.minZ * 16.0) / 256.0;
        double var14 = ((double)var10 + var1.maxZ * 16.0 - 0.01) / 256.0;
        double var16 = ((double)(var11 + 16) - var1.maxY * 16.0) / 512.0;
        double var18 = ((double)(var11 + 16) - var1.minY * 16.0 - 0.01) / 512.0;
        if (this.flipTexture) {
            var20 = var12;
            var12 = var14;
            var14 = var20;
        }
        if (var1.minZ < 0.0 || var1.maxZ > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (var1.minY < 0.0 || var1.maxY > 1.0) {
            var16 = ((float)var11 + 0.0f) / 512.0f;
            var18 = ((float)var11 + 15.99f) / 512.0f;
        }
        var20 = var14;
        double var22 = var12;
        double var24 = var16;
        double var26 = var18;
        if (this.uvRotateSouthFace == 2) {
            var12 = ((double)var10 + var1.minY * 16.0) / 256.0;
            var16 = ((double)(var11 + 16) - var1.minZ * 16.0) / 512.0;
            var14 = ((double)var10 + var1.maxY * 16.0) / 256.0;
            var18 = ((double)(var11 + 16) - var1.maxZ * 16.0) / 512.0;
            var24 = var16;
            var26 = var18;
            var20 = var12;
            var22 = var14;
            var16 = var18;
            var18 = var24;
        } else if (this.uvRotateSouthFace == 1) {
            var12 = ((double)(var10 + 16) - var1.maxY * 16.0) / 256.0;
            var16 = ((double)var11 + var1.maxZ * 16.0) / 512.0;
            var14 = ((double)(var10 + 16) - var1.minY * 16.0) / 256.0;
            var18 = ((double)var11 + var1.minZ * 16.0) / 512.0;
            var20 = var14;
            var22 = var12;
            var12 = var14;
            var14 = var22;
            var24 = var18;
            var26 = var16;
        } else if (this.uvRotateSouthFace == 3) {
            var12 = ((double)(var10 + 16) - var1.minZ * 16.0) / 256.0;
            var14 = ((double)(var10 + 16) - var1.maxZ * 16.0 - 0.01) / 256.0;
            var16 = ((double)var11 + var1.maxY * 16.0) / 512.0;
            var18 = ((double)var11 + var1.minY * 16.0 - 0.01) / 512.0;
            var20 = var14;
            var22 = var12;
            var24 = var16;
            var26 = var18;
        }
        double var28 = var2 + var1.maxX;
        double var30 = var4 + var1.minY;
        double var32 = var4 + var1.maxY;
        double var34 = var6 + var1.minZ;
        double var36 = var6 + var1.maxZ;
        if (this.enableAO) {
            var9.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            var9.addVertexWithUV(var28, var30, var36, var22, var26);
            var9.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            var9.addVertexWithUV(var28, var30, var34, var14, var18);
            var9.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            var9.addVertexWithUV(var28, var32, var34, var20, var24);
            var9.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            var9.addVertexWithUV(var28, var32, var36, var12, var16);
        } else {
            var9.addVertexWithUV(var28, var30, var36, var22, var26);
            var9.addVertexWithUV(var28, var30, var34, var14, var18);
            var9.addVertexWithUV(var28, var32, var34, var20, var24);
            var9.addVertexWithUV(var28, var32, var36, var12, var16);
        }
    }

    public void renderSouthFaceDistorted(Block var1, double var2, double var4, double var6, int var8) {
        double var20;
        Tessellator var9 = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            var8 = this.overrideBlockTexture;
        }
        int var10 = (var8 & 0xF) << 4;
        int var11 = var8 & 0xFF0;
        double var12 = ((double)var10 + var1.minZ * 16.0) / 256.0;
        double var14 = ((double)var10 + var1.maxZ * 16.0 - 0.01) / 256.0;
        double var16 = ((double)(var11 + 16) - var1.maxY * 16.0) / 512.0;
        double var18 = ((double)(var11 + 16) - var1.minY * 16.0 - 0.01) / 512.0;
        if (this.flipTexture) {
            var20 = var12;
            var12 = var14;
            var14 = var20;
        }
        if (var1.minZ < 0.0 || var1.maxZ > 1.0) {
            var12 = ((float)var10 + 0.0f) / 256.0f;
            var14 = ((float)var10 + 15.99f) / 256.0f;
        }
        if (var1.minY < 0.0 || var1.maxY > 1.0) {
            var16 = ((float)var11 + 0.0f) / 512.0f;
            var18 = ((float)var11 + 15.99f) / 512.0f;
        }
        var20 = var14;
        double var22 = var12;
        double var24 = var16;
        double var26 = var18;
        if (this.uvRotateSouthFace == 2) {
            var12 = ((double)var10 + var1.minY * 16.0) / 256.0;
            var16 = ((double)(var11 + 16) - var1.minZ * 16.0) / 512.0;
            var14 = ((double)var10 + var1.maxY * 16.0) / 256.0;
            var18 = ((double)(var11 + 16) - var1.maxZ * 16.0) / 512.0;
            var24 = var16;
            var26 = var18;
            var20 = var12;
            var22 = var14;
            var16 = var18;
            var18 = var24;
        } else if (this.uvRotateSouthFace == 1) {
            var12 = ((double)(var10 + 16) - var1.maxY * 16.0) / 256.0;
            var16 = ((double)var11 + var1.maxZ * 16.0) / 512.0;
            var14 = ((double)(var10 + 16) - var1.minY * 16.0) / 256.0;
            var18 = ((double)var11 + var1.minZ * 16.0) / 512.0;
            var20 = var14;
            var22 = var12;
            var12 = var14;
            var14 = var22;
            var24 = var18;
            var26 = var16;
        } else if (this.uvRotateSouthFace == 3) {
            var12 = ((double)(var10 + 16) - var1.minZ * 16.0) / 256.0;
            var14 = ((double)(var10 + 16) - var1.maxZ * 16.0 - 0.01) / 256.0;
            var16 = ((double)var11 + var1.maxY * 16.0) / 512.0;
            var18 = ((double)var11 + var1.minY * 16.0 - 0.01) / 512.0;
            var20 = var14;
            var22 = var12;
            var24 = var16;
            var26 = var18;
        }
        double var28 = var2 + var1.maxX;
        double var30 = var4 + var1.minY;
        double var32 = var4 + var1.maxY;
        double var34 = var6 + var1.minZ;
        double var36 = var6 + var1.maxZ;
        if (this.enableAO) {
            var9.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            var9.addDistortedVertexWithUV(var28, var30, var36, var22, var26);
            var9.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            var9.addDistortedVertexWithUV(var28, var30, var34, var14, var18);
            var9.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            var9.addDistortedVertexWithUV(var28, var32, var34, var20, var24);
            var9.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            var9.addDistortedVertexWithUV(var28, var32, var36, var12, var16);
        } else {
            var9.addDistortedVertexWithUV(var28, var30, var36, var22, var26);
            var9.addDistortedVertexWithUV(var28, var30, var34, var14, var18);
            var9.addDistortedVertexWithUV(var28, var32, var34, var20, var24);
            var9.addDistortedVertexWithUV(var28, var32, var36, var12, var16);
        }
    }

    public void renderBlockOnInventory(Block block, int var2, float var3) {
        float var7;
        float var6;
        int type;
        Tessellator instance = Tessellator.instance;
        if (this.field_31088_b) {
            type = block.getRenderColor(var2);
            var6 = (float)(type >> 16 & 0xFF) / 255.0f;
            var7 = (float)(type >> 8 & 0xFF) / 255.0f;
            float var8 = (float)(type & 0xFF) / 255.0f;
            GL11.glColor4f((float)(var6 * var3), (float)(var7 * var3), (float)(var8 * var3), (float)1.0f);
        }
        if ((type = block.getRenderType()) != 0 && type != 16) {
            if (type == 1) {
                instance.startDrawingQuads();
                instance.setNormal(0.0f, -1.0f, 0.0f);
                this.renderCrossedSquares(block, var2, -0.5, -0.5, -0.5);
                instance.draw();
            } else if (type == 13) {
                block.setBlockBoundsForItemRender();
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                var6 = 0.0625f;
                instance.startDrawingQuads();
                instance.setNormal(0.0f, -1.0f, 0.0f);
                this.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(0));
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 1.0f, 0.0f);
                this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(1));
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 0.0f, -1.0f);
                instance.setTranslationF(0.0f, 0.0f, var6);
                this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(2));
                instance.setTranslationF(0.0f, 0.0f, -var6);
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 0.0f, 1.0f);
                instance.setTranslationF(0.0f, 0.0f, -var6);
                this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(3));
                instance.setTranslationF(0.0f, 0.0f, var6);
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(-1.0f, 0.0f, 0.0f);
                instance.setTranslationF(var6, 0.0f, 0.0f);
                this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(4));
                instance.setTranslationF(-var6, 0.0f, 0.0f);
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(1.0f, 0.0f, 0.0f);
                instance.setTranslationF(-var6, 0.0f, 0.0f);
                this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(5));
                instance.setTranslationF(var6, 0.0f, 0.0f);
                instance.draw();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            } else if (type == 28) {
                block.setBlockBoundsForItemRender();
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                var6 = 0.0f;
                instance.startDrawingQuads();
                instance.setNormal(0.0f, -1.0f, 0.0f);
                this.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(0));
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 1.0f, 0.0f);
                this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(1));
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 0.0f, -1.0f);
                instance.setTranslationF(0.0f, 0.0f, var6);
                this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(2));
                instance.setTranslationF(0.0f, 0.0f, -var6);
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 0.0f, 1.0f);
                instance.setTranslationF(0.0f, 0.0f, -var6);
                this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(3));
                instance.setTranslationF(0.0f, 0.0f, var6);
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(-1.0f, 0.0f, 0.0f);
                instance.setTranslationF(var6, 0.0f, 0.0f);
                this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(4));
                instance.setTranslationF(-var6, 0.0f, 0.0f);
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(1.0f, 0.0f, 0.0f);
                instance.setTranslationF(-var6, 0.0f, 0.0f);
                this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(5));
                instance.setTranslationF(var6, 0.0f, 0.0f);
                instance.draw();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            } else if (type == 20) {
                block.setBlockBoundsForItemRender();
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                var6 = 0.0f;
                instance.startDrawingQuads();
                instance.setNormal(0.0f, -1.0f, 0.0f);
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 1.0f, 0.0f);
                this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(2));
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 0.0f, -1.0f);
                instance.setTranslationF(0.0f, 0.0f, var6);
                this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(0));
                instance.setTranslationF(0.0f, 0.0f, -var6);
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 0.0f, 1.0f);
                instance.setTranslationF(0.0f, 0.0f, -var6);
                this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(0));
                instance.setTranslationF(0.0f, 0.0f, var6);
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(-1.0f, 0.0f, 0.0f);
                instance.setTranslationF(var6, 0.0f, 0.0f);
                this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(0));
                instance.setTranslationF(-var6, 0.0f, 0.0f);
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(1.0f, 0.0f, 0.0f);
                instance.setTranslationF(-var6, 0.0f, 0.0f);
                this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(0));
                instance.setTranslationF(var6, 0.0f, 0.0f);
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 1.0f, 0.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
                this.renderPlantTextureOnly(block, block.getBlockTextureFromSide(1), 0.0, 0.0, 0.0);
                instance.draw();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            } else if (type == 15) {
                block.setBlockBoundsForItemRender();
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                var6 = 0.0f;
                instance.startDrawingQuads();
                instance.setNormal(0.0f, -1.0f, 0.0f);
                this.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(0));
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 1.0f, 0.0f);
                this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(1));
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 0.0f, -1.0f);
                instance.setTranslationF(0.0f, 0.0f, var6);
                this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(2));
                instance.setTranslationF(0.0f, 0.0f, -var6);
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 0.0f, 1.0f);
                instance.setTranslationF(0.0f, 0.0f, -var6);
                this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(3));
                instance.setTranslationF(0.0f, 0.0f, var6);
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(-1.0f, 0.0f, 0.0f);
                instance.setTranslationF(var6, 0.0f, 0.0f);
                this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(4));
                instance.setTranslationF(-var6, 0.0f, 0.0f);
                instance.draw();
                instance.startDrawingQuads();
                instance.setNormal(1.0f, 0.0f, 0.0f);
                instance.setTranslationF(-var6, 0.0f, 0.0f);
                this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(5));
                instance.setTranslationF(var6, 0.0f, 0.0f);
                instance.draw();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            } else if (type == 6) {
                instance.startDrawingQuads();
                instance.setNormal(0.0f, -1.0f, 0.0f);
                this.renderCropBase(block, var2, -0.5, -0.5, -0.5);
                instance.draw();
            } else if (type == 2) {
                instance.startDrawingQuads();
                instance.setNormal(0.0f, -1.0f, 0.0f);
                instance.setColorOpaque_F(4.0f, 4.0f, 4.0f);
                this.renderTorchAtAngle(block, -0.5, -0.5, -0.5, 0.0, 0.0, false);
                instance.draw();
            } else if (type == 35) {
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                this.renderBlockAnvilOrient((BlockAnvil)block, 0, 0, 0, var2, true);
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            } else if (type == 10) {
                int var9 = 0;
                while (var9 < 2) {
                    if (var9 == 0) {
                        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
                    }
                    if (var9 == 1) {
                        block.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
                    }
                    GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                    instance.startDrawingQuads();
                    instance.setNormal(0.0f, -1.0f, 0.0f);
                    this.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(0));
                    instance.draw();
                    instance.startDrawingQuads();
                    instance.setNormal(0.0f, 1.0f, 0.0f);
                    this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(1));
                    instance.draw();
                    instance.startDrawingQuads();
                    instance.setNormal(0.0f, 0.0f, -1.0f);
                    this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(2));
                    instance.draw();
                    instance.startDrawingQuads();
                    instance.setNormal(0.0f, 0.0f, 1.0f);
                    this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(3));
                    instance.draw();
                    instance.startDrawingQuads();
                    instance.setNormal(-1.0f, 0.0f, 0.0f);
                    this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(4));
                    instance.draw();
                    instance.startDrawingQuads();
                    instance.setNormal(1.0f, 0.0f, 0.0f);
                    this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(5));
                    instance.draw();
                    GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                    ++var9;
                }
            } else if (type == 11) {
                int var9 = 0;
                while (var9 < 4) {
                    var7 = 0.125f;
                    if (var9 == 0) {
                        block.setBlockBounds(0.5f - var7, 0.0f, 0.0f, 0.5f + var7, 1.0f, var7 * 2.0f);
                    }
                    if (var9 == 1) {
                        block.setBlockBounds(0.5f - var7, 0.0f, 1.0f - var7 * 2.0f, 0.5f + var7, 1.0f, 1.0f);
                    }
                    var7 = 0.0625f;
                    if (var9 == 2) {
                        block.setBlockBounds(0.5f - var7, 1.0f - var7 * 3.0f, -var7 * 2.0f, 0.5f + var7, 1.0f - var7, 1.0f + var7 * 2.0f);
                    }
                    if (var9 == 3) {
                        block.setBlockBounds(0.5f - var7, 0.5f - var7 * 3.0f, -var7 * 2.0f, 0.5f + var7, 0.5f - var7, 1.0f + var7 * 2.0f);
                    }
                    GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                    instance.startDrawingQuads();
                    instance.setNormal(0.0f, -1.0f, 0.0f);
                    this.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(0, var2));
                    instance.draw();
                    instance.startDrawingQuads();
                    instance.setNormal(0.0f, 1.0f, 0.0f);
                    this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(0, var2));
                    instance.draw();
                    instance.startDrawingQuads();
                    instance.setNormal(0.0f, 0.0f, -1.0f);
                    this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(0, var2));
                    instance.draw();
                    instance.startDrawingQuads();
                    instance.setNormal(0.0f, 0.0f, 1.0f);
                    this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(0, var2));
                    instance.draw();
                    instance.startDrawingQuads();
                    instance.setNormal(-1.0f, 0.0f, 0.0f);
                    this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(0, var2));
                    instance.draw();
                    instance.startDrawingQuads();
                    instance.setNormal(1.0f, 0.0f, 0.0f);
                    this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(0, var2));
                    instance.draw();
                    GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                    ++var9;
                }
                block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            if (type == 16) {
                var2 = 1;
            }
            block.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            instance.startDrawingQuads();
            instance.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(0, var2));
            instance.draw();
            instance.startDrawingQuads();
            instance.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(1, var2));
            instance.draw();
            instance.startDrawingQuads();
            instance.setNormal(0.0f, 0.0f, -1.0f);
            this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(2, var2));
            instance.draw();
            instance.startDrawingQuads();
            instance.setNormal(0.0f, 0.0f, 1.0f);
            this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(3, var2));
            instance.draw();
            instance.startDrawingQuads();
            instance.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(4, var2));
            instance.draw();
            instance.startDrawingQuads();
            instance.setNormal(1.0f, 0.0f, 0.0f);
            this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(5, var2));
            instance.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    public static boolean renderItemIn3d(int var0) {
        if (var0 == 0) {
            return true;
        }
        if (var0 == 13) {
            return true;
        }
        if (var0 == 35) {
            return true;
        }
        if (var0 == 10) {
            return true;
        }
        if (var0 == 20) {
            return true;
        }
        if (var0 == 15) {
            return true;
        }
        if (var0 == 11) {
            return true;
        }
        if (var0 == 28) {
            return true;
        }
        return var0 == 16;
    }

    private boolean renderGearIThink(Block block, int n, int n2, int n3) {
        int n29 = n;
        int n30 = n2;
        int renderType = n3;
        n3 = n30;
        n2 = n29;
        Tessellator tessellator = Tessellator.instance;
        int metadata = this.blockAccess.getBlockMetadata(n2, n3, renderType);
        int n18 = block.getBlockTextureFromSideAndMetadata(0, metadata);
        if (this.overrideBlockTexture >= 0) {
            n18 = this.overrideBlockTexture;
        }
        float n15 = block.getBlockBrightness(this.blockAccess, n2, n3, renderType);
        tessellator.setColorOpaque_F(n15, n15, n15);
        n = ((n18 & 0xF) << 4) + 16;
        int n19 = (n18 & 0xF) << 4;
        int n31 = n18 & 0xFF0;
        if ((n2 + n3 + renderType & 1) == 1) {
            n = (n18 & 0xF) << 4;
            n19 = ((n18 & 0xF) << 4) + 16;
        }
        float minY = (float)n / 256.0f;
        float maxY = ((float)n + 15.99f) / 256.0f;
        float n8 = (float)n31 / 512.0f;
        float n32 = ((float)n31 + 15.99f) / 512.0f;
        float n21 = (float)n19 / 256.0f;
        float n22 = ((float)n19 + 15.99f) / 256.0f;
        float n23 = (float)n31 / 512.0f;
        float n24 = ((float)n31 + 15.99f) / 512.0f;
        if (distortion != 2) {
            if (this.blockAccess.isBlockNormalCube(n2 - 1, n3, renderType) || this.blockAccess.getBlockMaterial(n2 - 1, n3, renderType) == Material.moveableCircuit && this.blockAccess.getBlockId(n2 - 1, n3, renderType) != Block.treadmillIdle.blockID && this.blockAccess.getBlockId(n2 - 1, n3, renderType) != Block.treadmillActive.blockID) {
                tessellator.addVertexWithUV((float)n2 + 0.05f, (float)(n3 + 1) + 0.125f, (float)(renderType + 1) + 0.125f, minY, n8);
                tessellator.addVertexWithUV((float)n2 + 0.05f, (float)n3 - 0.125f, (float)(renderType + 1) + 0.125f, minY, n32);
                tessellator.addVertexWithUV((float)n2 + 0.05f, (float)n3 - 0.125f, (float)renderType - 0.125f, maxY, n32);
                tessellator.addVertexWithUV((float)n2 + 0.05f, (float)(n3 + 1) + 0.125f, (float)renderType - 0.125f, maxY, n8);
            }
            if (this.blockAccess.isBlockNormalCube(n2 + 1, n3, renderType) || this.blockAccess.getBlockMaterial(n2 + 1, n3, renderType) == Material.moveableCircuit && this.blockAccess.getBlockId(n2 + 1, n3, renderType) != Block.treadmillIdle.blockID && this.blockAccess.getBlockId(n2 + 1, n3, renderType) != Block.treadmillActive.blockID) {
                tessellator.addVertexWithUV((float)(n2 + 1) - 0.05f, (float)n3 - 0.125f, (float)(renderType + 1) + 0.125f, maxY, n32);
                tessellator.addVertexWithUV((float)(n2 + 1) - 0.05f, (float)(n3 + 1) + 0.125f, (float)(renderType + 1) + 0.125f, maxY, n8);
                tessellator.addVertexWithUV((float)(n2 + 1) - 0.05f, (float)(n3 + 1) + 0.125f, (float)renderType - 0.125f, minY, n8);
                tessellator.addVertexWithUV((float)(n2 + 1) - 0.05f, (float)n3 - 0.125f, (float)renderType - 0.125f, minY, n32);
            }
            if (this.blockAccess.isBlockNormalCube(n2, n3, renderType - 1) || this.blockAccess.getBlockMaterial(n2, n3, renderType - 1) == Material.moveableCircuit && this.blockAccess.getBlockId(n2, n3, renderType - 1) != Block.treadmillIdle.blockID && this.blockAccess.getBlockId(n2, n3, renderType - 1) != Block.treadmillActive.blockID) {
                tessellator.addVertexWithUV((float)(n2 + 1) + 0.125f, (float)n3 - 0.125f, (float)renderType + 0.05f, n22, n24);
                tessellator.addVertexWithUV((float)(n2 + 1) + 0.125f, (float)(n3 + 1) + 0.125f, (float)renderType + 0.05f, n22, n23);
                tessellator.addVertexWithUV((float)n2 - 0.125f, (float)(n3 + 1) + 0.125f, (float)renderType + 0.05f, n21, n23);
                tessellator.addVertexWithUV((float)n2 - 0.125f, (float)n3 - 0.125f, (float)renderType + 0.05f, n21, n24);
            }
            if (this.blockAccess.isBlockNormalCube(n2, n3, renderType + 1) || this.blockAccess.getBlockMaterial(n2, n3, renderType + 1) == Material.moveableCircuit && this.blockAccess.getBlockId(n2, n3, renderType + 1) != Block.treadmillIdle.blockID && this.blockAccess.getBlockId(n2, n3, renderType + 1) != Block.treadmillActive.blockID) {
                tessellator.addVertexWithUV((float)(n2 + 1) + 0.125f, (float)(n3 + 1) + 0.125f, (float)(renderType + 1) - 0.05f, n21, n23);
                tessellator.addVertexWithUV((float)(n2 + 1) + 0.125f, (float)n3 - 0.125f, (float)(renderType + 1) - 0.05f, n21, n24);
                tessellator.addVertexWithUV((float)n2 - 0.125f, (float)n3 - 0.125f, (float)(renderType + 1) - 0.05f, n22, n24);
                tessellator.addVertexWithUV((float)n2 - 0.125f, (float)(n3 + 1) + 0.125f, (float)(renderType + 1) - 0.05f, n22, n23);
            }
        } else if (distortion == 2) {
            if (this.blockAccess.isBlockNormalCube(n2 - 1, n3, renderType)) {
                tessellator.addDistortedVertexWithUV((float)n2 + 0.05f, (float)(n3 + 1) + 0.125f, (float)(renderType + 1) + 0.125f, minY, n8);
                tessellator.addDistortedVertexWithUV((float)n2 + 0.05f, (float)n3 - 0.125f, (float)(renderType + 1) + 0.125f, minY, n32);
                tessellator.addDistortedVertexWithUV((float)n2 + 0.05f, (float)n3 - 0.125f, (float)renderType - 0.125f, maxY, n32);
                tessellator.addDistortedVertexWithUV((float)n2 + 0.05f, (float)(n3 + 1) + 0.125f, (float)renderType - 0.125f, maxY, n8);
            }
            if (this.blockAccess.isBlockNormalCube(n2 + 1, n3, renderType)) {
                tessellator.addDistortedVertexWithUV((float)(n2 + 1) - 0.05f, (float)n3 - 0.125f, (float)(renderType + 1) + 0.125f, maxY, n32);
                tessellator.addDistortedVertexWithUV((float)(n2 + 1) - 0.05f, (float)(n3 + 1) + 0.125f, (float)(renderType + 1) + 0.125f, maxY, n8);
                tessellator.addDistortedVertexWithUV((float)(n2 + 1) - 0.05f, (float)(n3 + 1) + 0.125f, (float)renderType - 0.125f, minY, n8);
                tessellator.addDistortedVertexWithUV((float)(n2 + 1) - 0.05f, (float)n3 - 0.125f, (float)renderType - 0.125f, minY, n32);
            }
            if (this.blockAccess.isBlockNormalCube(n2, n3, renderType - 1)) {
                tessellator.addDistortedVertexWithUV((float)(n2 + 1) + 0.125f, (float)n3 - 0.125f, (float)renderType + 0.05f, n22, n24);
                tessellator.addDistortedVertexWithUV((float)(n2 + 1) + 0.125f, (float)(n3 + 1) + 0.125f, (float)renderType + 0.05f, n22, n23);
                tessellator.addDistortedVertexWithUV((float)n2 - 0.125f, (float)(n3 + 1) + 0.125f, (float)renderType + 0.05f, n21, n23);
                tessellator.addDistortedVertexWithUV((float)n2 - 0.125f, (float)n3 - 0.125f, (float)renderType + 0.05f, n21, n24);
            }
            if (this.blockAccess.isBlockNormalCube(n2, n3, renderType + 1)) {
                tessellator.addDistortedVertexWithUV((float)(n2 + 1) + 0.125f, (float)(n3 + 1) + 0.125f, (float)(renderType + 1) - 0.05f, n21, n23);
                tessellator.addDistortedVertexWithUV((float)(n2 + 1) + 0.125f, (float)n3 - 0.125f, (float)(renderType + 1) - 0.05f, n21, n24);
                tessellator.addDistortedVertexWithUV((float)n2 - 0.125f, (float)n3 - 0.125f, (float)(renderType + 1) - 0.05f, n22, n24);
                tessellator.addDistortedVertexWithUV((float)n2 - 0.125f, (float)(n3 + 1) + 0.125f, (float)(renderType + 1) - 0.05f, n22, n23);
            }
        }
        return true;
    }

    public void titleScreenBlocks(Block block, float f, int metadata) {
        int i = block.getRenderType();
        Tessellator tessellator = Tessellator.instance;
        if (i == 0) {
            block.func_237_e();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float f1 = 0.5f;
            float f2 = 1.0f;
            float f3 = 0.8f;
            float f4 = 0.6f;
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_F(f2, f2, f2, f);
            this.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(0, metadata));
            tessellator.setColorRGBA_F(f1, f1, f1, f);
            this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(1, metadata));
            tessellator.setColorRGBA_F(f3, f3, f3, f);
            this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(2, metadata));
            this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(3, metadata));
            tessellator.setColorRGBA_F(f4, f4, f4, f);
            this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(4, metadata));
            this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(5, metadata));
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    public static boolean renderItemIn3dCross(int var0) {
        if (var0 == 1) {
            return true;
        }
        return var0 == 0;
    }

    public boolean renderBlockBush(Block block, int n, int n2, int n3) {
        int y = n;
        int x = n2;
        int z = n3;
        n3 = x;
        n2 = y;
        Tessellator tessellator = Tessellator.instance;
        int textureid = block.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 2) {
            textureid = this.overrideBlockTexture;
        }
        float brightness = block.getBlockBrightness(this.blockAccess, n2, n3, z);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        n = (textureid & 0xF) << 4;
        int n31 = textureid & 0xFF0;
        if ((n2 + n3 + z & 1) == 1) {
            n = (textureid & 0xF) << 4;
        }
        float xuvStart = (float)n / 256.0f;
        float xuvEnd = ((float)n + 15.99f) / 256.0f;
        float yuvStart = (float)n31 / 512.0f;
        float yuvEnd = ((float)n31 + 15.99f) / 512.0f;
        float axuvStart = xuvStart;
        float axuvEnd = xuvEnd;
        if (this.overrideBlockTexture < 0 && block.blockID == 142) {
            axuvStart = 0.5f;
            axuvEnd = 0.5625f;
        } else if (this.overrideBlockTexture < 0) {
            axuvStart = 0.0f;
            axuvEnd = 0.0625f;
        }
        if (distortion == 0) {
            tessellator.addVertexWithUV(n2 + 1, n3 + 1, z + 1, xuvStart, yuvStart);
            tessellator.addVertexWithUV(n2 + 1, n3, z + 1, xuvStart, yuvEnd);
            tessellator.addVertexWithUV(n2 + 1, n3, z, xuvEnd, yuvEnd);
            tessellator.addVertexWithUV(n2 + 1, n3 + 1, z, xuvEnd, yuvStart);
            tessellator.addVertexWithUV(n2 + 0, n3, z + 1, xuvEnd, yuvEnd);
            tessellator.addVertexWithUV(n2 + 0, n3 + 1, z + 1, xuvEnd, yuvStart);
            tessellator.addVertexWithUV(n2 + 0, n3 + 1, z, xuvStart, yuvStart);
            tessellator.addVertexWithUV(n2 + 0, n3, z, xuvStart, yuvEnd);
            tessellator.addVertexWithUV(n2 + 0, n3, z, xuvEnd, yuvEnd);
            tessellator.addVertexWithUV(n2 + 0, n3 + 1, z, xuvEnd, yuvStart);
            tessellator.addVertexWithUV(n2 + 1, n3 + 1, z, xuvStart, yuvStart);
            tessellator.addVertexWithUV(n2 + 1, n3, z, xuvStart, yuvEnd);
            tessellator.addVertexWithUV(n2 + 0, n3 + 1, z + 1, xuvStart, yuvStart);
            tessellator.addVertexWithUV(n2 + 0, n3, z + 1, xuvStart, yuvEnd);
            tessellator.addVertexWithUV(n2 + 1, n3, z + 1, xuvEnd, yuvEnd);
            tessellator.addVertexWithUV(n2 + 1, n3 + 1, z + 1, xuvEnd, yuvStart);
            tessellator.addVertexWithUV(n2, n3 + 1, z + 1, xuvStart, yuvStart);
            tessellator.addVertexWithUV(n2, n3, z + 1, xuvStart, yuvEnd);
            tessellator.addVertexWithUV(n2, n3, z, xuvEnd, yuvEnd);
            tessellator.addVertexWithUV(n2, n3 + 1, z, xuvEnd, yuvStart);
            tessellator.addVertexWithUV(n2 + 1, n3, z + 1, xuvEnd, yuvEnd);
            tessellator.addVertexWithUV(n2 + 1, n3 + 1, z + 1, xuvEnd, yuvStart);
            tessellator.addVertexWithUV(n2 + 1, n3 + 1, z, xuvStart, yuvStart);
            tessellator.addVertexWithUV(n2 + 1, n3, z, xuvStart, yuvEnd);
            tessellator.addVertexWithUV(n2 + 1, n3, z, xuvEnd, yuvEnd);
            tessellator.addVertexWithUV(n2 + 1, n3 + 1, z, xuvEnd, yuvStart);
            tessellator.addVertexWithUV(n2, n3 + 1, z, xuvStart, yuvStart);
            tessellator.addVertexWithUV(n2, n3, z, xuvStart, yuvEnd);
            tessellator.addVertexWithUV(n2 + 1, n3 + 1, z + 1, xuvStart, yuvStart);
            tessellator.addVertexWithUV(n2 + 1, n3, z + 1, xuvStart, yuvEnd);
            tessellator.addVertexWithUV(n2, n3, z + 1, xuvEnd, yuvEnd);
            tessellator.addVertexWithUV(n2, n3 + 1, z + 1, xuvEnd, yuvStart);
            tessellator.addVertexWithUV(n2, n3 + 1, z + 1, axuvStart, yuvStart);
            tessellator.addVertexWithUV(n2 + 1, n3 + 1, z + 1, axuvStart, yuvEnd);
            tessellator.addVertexWithUV(n2 + 1, n3 + 1, z, axuvEnd, yuvEnd);
            tessellator.addVertexWithUV(n2, n3 + 1, z, axuvEnd, yuvStart);
            tessellator.addVertexWithUV(n2 + 1, n3 + 1, z + 1, axuvStart, yuvStart);
            tessellator.addVertexWithUV(n2, n3 + 1, z + 1, axuvStart, yuvEnd);
            tessellator.addVertexWithUV(n2, n3 + 1, z, axuvEnd, yuvEnd);
            tessellator.addVertexWithUV(n2 + 1, n3 + 1, z, axuvEnd, yuvStart);
        } else if (distortion > 0) {
            tessellator.addDistortedVertexWithUV(n2 + 1, n3 + 1, z + 1, xuvStart, yuvStart);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3, z + 1, xuvStart, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3, z, xuvEnd, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3 + 1, z, xuvEnd, yuvStart);
            tessellator.addDistortedVertexWithUV(n2 + 0, n3, z + 1, xuvEnd, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2 + 0, n3 + 1, z + 1, xuvEnd, yuvStart);
            tessellator.addDistortedVertexWithUV(n2 + 0, n3 + 1, z, xuvStart, yuvStart);
            tessellator.addDistortedVertexWithUV(n2 + 0, n3, z, xuvStart, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2 + 0, n3, z, xuvEnd, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2 + 0, n3 + 1, z, xuvEnd, yuvStart);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3 + 1, z, xuvStart, yuvStart);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3, z, xuvStart, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2 + 0, n3 + 1, z + 1, xuvStart, yuvStart);
            tessellator.addDistortedVertexWithUV(n2 + 0, n3, z + 1, xuvStart, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3, z + 1, xuvEnd, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3 + 1, z + 1, xuvEnd, yuvStart);
            tessellator.addDistortedVertexWithUV(n2, n3 + 1, z + 1, xuvStart, yuvStart);
            tessellator.addDistortedVertexWithUV(n2, n3, z + 1, xuvStart, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2, n3, z, xuvEnd, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2, n3 + 1, z, xuvEnd, yuvStart);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3, z + 1, xuvEnd, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3 + 1, z + 1, xuvEnd, yuvStart);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3 + 1, z, xuvStart, yuvStart);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3, z, xuvStart, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3, z, xuvEnd, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3 + 1, z, xuvEnd, yuvStart);
            tessellator.addDistortedVertexWithUV(n2, n3 + 1, z, xuvStart, yuvStart);
            tessellator.addDistortedVertexWithUV(n2, n3, z, xuvStart, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3 + 1, z + 1, xuvStart, yuvStart);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3, z + 1, xuvStart, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2, n3, z + 1, xuvEnd, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2, n3 + 1, z + 1, xuvEnd, yuvStart);
            tessellator.addDistortedVertexWithUV(n2, n3 + 1, z + 1, axuvStart, yuvStart);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3 + 1, z + 1, axuvStart, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3 + 1, z, axuvEnd, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2, n3 + 1, z, axuvEnd, yuvStart);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3 + 1, z + 1, axuvStart, yuvStart);
            tessellator.addDistortedVertexWithUV(n2, n3 + 1, z + 1, axuvStart, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2, n3 + 1, z, axuvEnd, yuvEnd);
            tessellator.addDistortedVertexWithUV(n2 + 1, n3 + 1, z, axuvEnd, yuvStart);
        }
        int var21 = n2;
        int var23 = n2 + 1;
        int var5 = n3;
        int var25 = z;
        int var27 = z + 1;
        double var13 = xuvStart;
        double var15 = xuvEnd;
        double var17 = yuvStart;
        double var19 = yuvEnd;
        if (this.overrideBlockTexture < 0) {
            var13 = 0.375;
            var15 = 0.4375;
        }
        if (distortion == 0) {
            tessellator.addVertexWithUV(var21, (double)var5 + 1.0, var25, var13, var17);
            tessellator.addVertexWithUV(var21, (double)var5 + 0.0, var25, var13, var19);
            tessellator.addVertexWithUV(var23, (double)var5 + 0.0, var27, var15, var19);
            tessellator.addVertexWithUV(var23, (double)var5 + 1.0, var27, var15, var17);
            tessellator.addVertexWithUV(var23, (double)var5 + 1.0, var27, var13, var17);
            tessellator.addVertexWithUV(var23, (double)var5 + 0.0, var27, var13, var19);
            tessellator.addVertexWithUV(var21, (double)var5 + 0.0, var25, var15, var19);
            tessellator.addVertexWithUV(var21, (double)var5 + 1.0, var25, var15, var17);
            tessellator.addVertexWithUV(var21, (double)var5 + 1.0, var27, var13, var17);
            tessellator.addVertexWithUV(var21, (double)var5 + 0.0, var27, var13, var19);
            tessellator.addVertexWithUV(var23, (double)var5 + 0.0, var25, var15, var19);
            tessellator.addVertexWithUV(var23, (double)var5 + 1.0, var25, var15, var17);
            tessellator.addVertexWithUV(var23, (double)var5 + 1.0, var25, var13, var17);
            tessellator.addVertexWithUV(var23, (double)var5 + 0.0, var25, var13, var19);
            tessellator.addVertexWithUV(var21, (double)var5 + 0.0, var27, var15, var19);
            tessellator.addVertexWithUV(var21, (double)var5 + 1.0, var27, var15, var17);
        } else if (distortion > 0) {
            tessellator.addDistortedVertexWithUV(var21, (double)var5 + 1.0, var25, var13, var17);
            tessellator.addDistortedVertexWithUV(var21, (double)var5 + 0.0, var25, var13, var19);
            tessellator.addDistortedVertexWithUV(var23, (double)var5 + 0.0, var27, var15, var19);
            tessellator.addDistortedVertexWithUV(var23, (double)var5 + 1.0, var27, var15, var17);
            tessellator.addDistortedVertexWithUV(var23, (double)var5 + 1.0, var27, var13, var17);
            tessellator.addDistortedVertexWithUV(var23, (double)var5 + 0.0, var27, var13, var19);
            tessellator.addDistortedVertexWithUV(var21, (double)var5 + 0.0, var25, var15, var19);
            tessellator.addDistortedVertexWithUV(var21, (double)var5 + 1.0, var25, var15, var17);
            tessellator.addDistortedVertexWithUV(var21, (double)var5 + 1.0, var27, var13, var17);
            tessellator.addDistortedVertexWithUV(var21, (double)var5 + 0.0, var27, var13, var19);
            tessellator.addDistortedVertexWithUV(var23, (double)var5 + 0.0, var25, var15, var19);
            tessellator.addDistortedVertexWithUV(var23, (double)var5 + 1.0, var25, var15, var17);
            tessellator.addDistortedVertexWithUV(var23, (double)var5 + 1.0, var25, var13, var17);
            tessellator.addDistortedVertexWithUV(var23, (double)var5 + 0.0, var25, var13, var19);
            tessellator.addDistortedVertexWithUV(var21, (double)var5 + 0.0, var27, var15, var19);
            tessellator.addDistortedVertexWithUV(var21, (double)var5 + 1.0, var27, var15, var17);
        }
        return true;
    }

    public void renderPlantTextureOnly(Block var1, int var2, double var3, double var5, double var7) {
        Tessellator tessellator = Tessellator.instance;
        int var10 = var2;
        if (this.overrideBlockTexture >= 0) {
            var10 = this.overrideBlockTexture;
        }
        int var11 = (var10 & 0xF) << 4;
        int var12 = var10 & 0xFF0;
        double var13 = (float)var11 / 256.0f;
        double var15 = ((float)var11 + 15.99f) / 256.0f;
        double var17 = (float)var12 / 512.0f;
        double var19 = ((float)var12 + 15.99f) / 512.0f;
        double var21 = var3 + 0.5 - (double)0.45f;
        double var23 = var3 + 0.5 + (double)0.45f;
        double var25 = var7 + 0.5 - (double)0.45f;
        double var27 = var7 + 0.5 + (double)0.45f;
        if (distortion == 0) {
            tessellator.addVertexWithUV(var21, var5 + 1.0, var25, var13, var17);
            tessellator.addVertexWithUV(var21, var5 + 0.0, var25, var13, var19);
            tessellator.addVertexWithUV(var23, var5 + 0.0, var27, var15, var19);
            tessellator.addVertexWithUV(var23, var5 + 1.0, var27, var15, var17);
            tessellator.addVertexWithUV(var23, var5 + 1.0, var27, var13, var17);
            tessellator.addVertexWithUV(var23, var5 + 0.0, var27, var13, var19);
            tessellator.addVertexWithUV(var21, var5 + 0.0, var25, var15, var19);
            tessellator.addVertexWithUV(var21, var5 + 1.0, var25, var15, var17);
            tessellator.addVertexWithUV(var21, var5 + 1.0, var27, var13, var17);
            tessellator.addVertexWithUV(var21, var5 + 0.0, var27, var13, var19);
            tessellator.addVertexWithUV(var23, var5 + 0.0, var25, var15, var19);
            tessellator.addVertexWithUV(var23, var5 + 1.0, var25, var15, var17);
            tessellator.addVertexWithUV(var23, var5 + 1.0, var25, var13, var17);
            tessellator.addVertexWithUV(var23, var5 + 0.0, var25, var13, var19);
            tessellator.addVertexWithUV(var21, var5 + 0.0, var27, var15, var19);
            tessellator.addVertexWithUV(var21, var5 + 1.0, var27, var15, var17);
        } else if (distortion > 0) {
            tessellator.addDistortedVertexWithUV(var21, var5 + 1.0, var25, var13, var17);
            tessellator.addDistortedVertexWithUV(var21, var5 + 0.0, var25, var13, var19);
            tessellator.addDistortedVertexWithUV(var23, var5 + 0.0, var27, var15, var19);
            tessellator.addDistortedVertexWithUV(var23, var5 + 1.0, var27, var15, var17);
            tessellator.addDistortedVertexWithUV(var23, var5 + 1.0, var27, var13, var17);
            tessellator.addDistortedVertexWithUV(var23, var5 + 0.0, var27, var13, var19);
            tessellator.addDistortedVertexWithUV(var21, var5 + 0.0, var25, var15, var19);
            tessellator.addDistortedVertexWithUV(var21, var5 + 1.0, var25, var15, var17);
            tessellator.addDistortedVertexWithUV(var21, var5 + 1.0, var27, var13, var17);
            tessellator.addDistortedVertexWithUV(var21, var5 + 0.0, var27, var13, var19);
            tessellator.addDistortedVertexWithUV(var23, var5 + 0.0, var25, var15, var19);
            tessellator.addDistortedVertexWithUV(var23, var5 + 1.0, var25, var15, var17);
            tessellator.addDistortedVertexWithUV(var23, var5 + 1.0, var25, var13, var17);
            tessellator.addDistortedVertexWithUV(var23, var5 + 0.0, var25, var13, var19);
            tessellator.addDistortedVertexWithUV(var21, var5 + 0.0, var27, var15, var19);
            tessellator.addDistortedVertexWithUV(var21, var5 + 1.0, var27, var15, var17);
        }
    }

    private boolean renderGearPowered(Block block, int n, int n2, int n3) {
        int n29 = n;
        int n30 = n2;
        int renderType = n3;
        n3 = n30;
        n2 = n29;
        Tessellator tessellator = Tessellator.instance;
        int var60 = this.blockAccess.getBlockMetadata(n, n2, n3);
        int n18 = block.getBlockTextureFromSideAndMetadata(0, var60);
        if (this.overrideBlockTexture >= 0) {
            n18 = this.overrideBlockTexture;
        }
        float n15 = block.getBlockBrightness(this.blockAccess, n2, n3, renderType);
        tessellator.setColorOpaque_F(n15, n15, n15);
        n = ((n18 & 0xF) << 4) + 16;
        int n19 = (n18 & 0xF) << 4;
        int n31 = n18 & 0xF0;
        if ((n2 + n3 + renderType & 1) == 1) {
            n = (n18 & 0xF) << 4;
            n19 = ((n18 & 0xF) << 4) + 16;
        }
        float minY = (float)n / 256.0f;
        float maxY = ((float)n + 15.99f) / 256.0f;
        float n8 = (float)n31 / 512.0f;
        float n32 = ((float)n31 + 15.99f) / 512.0f;
        float n21 = (float)n19 / 256.0f;
        float n22 = ((float)n19 + 15.99f) / 256.0f;
        float n23 = (float)n31 / 512.0f;
        float n24 = ((float)n31 + 15.99f) / 512.0f;
        if (this.blockAccess.isBlockNormalCube(n2 - 1, n3, renderType)) {
            tessellator.addVertexWithUV((float)n2 + 0.05f, (float)(n3 + 1) + 0.125f, (float)(renderType + 1) + 0.125f, minY, n8);
            tessellator.addVertexWithUV((float)n2 + 0.05f, (float)n3 - 0.125f, (float)(renderType + 1) + 0.125f, minY, n32);
            tessellator.addVertexWithUV((float)n2 + 0.05f, (float)n3 - 0.125f, (float)renderType - 0.125f, maxY, n32);
            tessellator.addVertexWithUV((float)n2 + 0.05f, (float)(n3 + 1) + 0.125f, (float)renderType - 0.125f, maxY, n8);
        }
        if (this.blockAccess.isBlockNormalCube(n2 + 1, n3, renderType)) {
            tessellator.addVertexWithUV((float)(n2 + 1) - 0.05f, (float)n3 - 0.125f, (float)(renderType + 1) + 0.125f, maxY, n32);
            tessellator.addVertexWithUV((float)(n2 + 1) - 0.05f, (float)(n3 + 1) + 0.125f, (float)(renderType + 1) + 0.125f, maxY, n8);
            tessellator.addVertexWithUV((float)(n2 + 1) - 0.05f, (float)(n3 + 1) + 0.125f, (float)renderType - 0.125f, minY, n8);
            tessellator.addVertexWithUV((float)(n2 + 1) - 0.05f, (float)n3 - 0.125f, (float)renderType - 0.125f, minY, n32);
        }
        if (this.blockAccess.isBlockNormalCube(n2, n3, renderType - 1)) {
            tessellator.addVertexWithUV((float)(n2 + 1) + 0.125f, (float)n3 - 0.125f, (float)renderType + 0.05f, n22, n24);
            tessellator.addVertexWithUV((float)(n2 + 1) + 0.125f, (float)(n3 + 1) + 0.125f, (float)renderType + 0.05f, n22, n23);
            tessellator.addVertexWithUV((float)n2 - 0.125f, (float)(n3 + 1) + 0.125f, (float)renderType + 0.05f, n21, n23);
            tessellator.addVertexWithUV((float)n2 - 0.125f, (float)n3 - 0.125f, (float)renderType + 0.05f, n21, n24);
        }
        if (this.blockAccess.isBlockNormalCube(n2, n3, renderType + 1)) {
            tessellator.addVertexWithUV((float)(n2 + 1) + 0.125f, (float)(n3 + 1) + 0.125f, (float)(renderType + 1) - 0.05f, n21, n23);
            tessellator.addVertexWithUV((float)(n2 + 1) + 0.125f, (float)n3 - 0.125f, (float)(renderType + 1) - 0.05f, n21, n24);
            tessellator.addVertexWithUV((float)n2 - 0.125f, (float)n3 - 0.125f, (float)(renderType + 1) - 0.05f, n22, n24);
            tessellator.addVertexWithUV((float)n2 - 0.125f, (float)(n3 + 1) + 0.125f, (float)(renderType + 1) - 0.05f, n22, n23);
        }
        return true;
    }

    public boolean renderBlockLilyPad(Block block, int xCoord, int yCoord, int zCoord) {
        Tessellator tessellator = Tessellator.instance;
        int texture = block.blockIndexInTexture;
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xScale = (texture & 0xF) << 4;
        int totalIndex = texture & 0xFF0;
        float yAligned = -0.0625f;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        long l1 = (long)(xCoord * 3129871) ^ (long)zCoord * 116129781L ^ (long)yCoord;
        l1 = l1 * l1 * 42317861L + l1 * 11L;
        int rotation = (int)(l1 >> 16 & 3L);
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        float xAligned = (float)xCoord + 0.5f;
        float zAligned = (float)zCoord + 0.5f;
        float xRot = (float)(rotation & 1) * 0.5f * (float)(1 - rotation / 2 % 2 * 2);
        float zRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - (rotation + 1) / 2 % 2 * 2);
        if (distortion == 0) {
            tessellator.addVertexWithUV(xAligned + xRot - zRot, (float)yCoord + yAligned, zAligned + xRot + zRot, minX, minY);
            tessellator.addVertexWithUV(xAligned + xRot + zRot, (float)yCoord + yAligned, zAligned - xRot + zRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned - xRot + zRot, (float)yCoord + yAligned, zAligned - xRot - zRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned - xRot - zRot, (float)yCoord + yAligned, zAligned + xRot - zRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - xRot - zRot, (float)yCoord + yAligned, zAligned + xRot - zRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - xRot + zRot, (float)yCoord + yAligned, zAligned - xRot - zRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + xRot + zRot, (float)yCoord + yAligned, zAligned - xRot + zRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned + xRot - zRot, (float)yCoord + yAligned, zAligned + xRot + zRot, minX, minY);
        } else if (distortion > 0) {
            tessellator.addDistortedVertexWithUV(xAligned + xRot - zRot, (float)yCoord + yAligned, zAligned + xRot + zRot, minX, minY);
            tessellator.addDistortedVertexWithUV(xAligned + xRot + zRot, (float)yCoord + yAligned, zAligned - xRot + zRot, maxX, minY);
            tessellator.addDistortedVertexWithUV(xAligned - xRot + zRot, (float)yCoord + yAligned, zAligned - xRot - zRot, maxX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned - xRot - zRot, (float)yCoord + yAligned, zAligned + xRot - zRot, minX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned - xRot - zRot, (float)yCoord + yAligned, zAligned + xRot - zRot, minX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned - xRot + zRot, (float)yCoord + yAligned, zAligned - xRot - zRot, maxX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned + xRot + zRot, (float)yCoord + yAligned, zAligned - xRot + zRot, maxX, minY);
            tessellator.addDistortedVertexWithUV(xAligned + xRot - zRot, (float)yCoord + yAligned, zAligned + xRot + zRot, minX, minY);
        }
        double var19 = xCoord;
        double var20 = yCoord;
        double var15 = zCoord;
        this.renderPlantTextureOnly(block, 299, var19, var20 - 1.0625, var15);
        return true;
    }

    public boolean renderBlockFourLeafClover(Block block, int xCoord, int yCoord, int zCoord) {
        Tessellator tessellator = Tessellator.instance;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        this.renderBlockFourLeafClover1(block, xCoord, yCoord, zCoord);
        this.renderBlockFourLeafClover2(block, xCoord, yCoord, zCoord);
        this.renderBlockFourLeafClover3(block, xCoord, yCoord, zCoord);
        this.renderBlockFourLeafClover4(block, xCoord, yCoord, zCoord);
        this.renderPlantTextureOnly(block, 270, xCoord, yCoord, zCoord);
        return true;
    }

    public boolean renderBlockFourLeafClover1(Block block, int xCoord, int yCoord, int zCoord) {
        Tessellator tessellator = Tessellator.instance;
        int texture = 286;
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xScale = (texture & 0xF) << 4;
        int totalIndex = texture & 0xFF0;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        float xAligned = xCoord;
        float yAligned = yCoord;
        float zAligned = zCoord;
        if (distortion == 0) {
            tessellator.addVertexWithUV(xAligned, (double)yAligned + 0.2, zAligned + 1.0f, minX, minY);
            tessellator.addVertexWithUV(xAligned, yAligned, zAligned, maxX, minY);
            tessellator.addVertexWithUV(xAligned + 1.0f, yAligned, zAligned, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2, zAligned + 1.0f, minX, maxY);
            tessellator.addVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2, zAligned + 1.0f, minX, maxY);
            tessellator.addVertexWithUV(xAligned + 1.0f, yAligned, zAligned, maxX, maxY);
            tessellator.addVertexWithUV(xAligned, yAligned, zAligned, maxX, minY);
            tessellator.addVertexWithUV(xAligned, (double)yAligned + 0.2, zAligned + 1.0f, minX, minY);
        } else if (distortion > 0) {
            tessellator.addDistortedVertexWithUV(xAligned, (double)yAligned + 0.2, zAligned + 1.0f, minX, minY);
            tessellator.addDistortedVertexWithUV(xAligned, yAligned, zAligned, maxX, minY);
            tessellator.addDistortedVertexWithUV(xAligned + 1.0f, yAligned, zAligned, maxX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2, zAligned + 1.0f, minX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2, zAligned + 1.0f, minX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned + 1.0f, yAligned, zAligned, maxX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned, yAligned, zAligned, maxX, minY);
            tessellator.addDistortedVertexWithUV(xAligned, (double)yAligned + 0.2, zAligned + 1.0f, minX, minY);
        }
        return true;
    }

    public boolean renderBlockFourLeafClover2(Block block, int xCoord, int yCoord, int zCoord) {
        Tessellator tessellator = Tessellator.instance;
        int texture = 301;
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xScale = (texture & 0xF) << 4;
        int totalIndex = texture & 0xFF0;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        float xAligned = xCoord;
        float yAligned = yCoord;
        float zAligned = zCoord;
        if (distortion == 0) {
            tessellator.addVertexWithUV(xAligned, (double)yAligned + 0.2, zAligned, minX, minY);
            tessellator.addVertexWithUV(xAligned, yAligned, zAligned + 1.0f, maxX, minY);
            tessellator.addVertexWithUV(xAligned + 1.0f, yAligned, zAligned + 1.0f, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2, zAligned, minX, maxY);
            tessellator.addVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2, zAligned, minX, maxY);
            tessellator.addVertexWithUV(xAligned + 1.0f, yAligned, zAligned + 1.0f, maxX, maxY);
            tessellator.addVertexWithUV(xAligned, yAligned, zAligned + 1.0f, maxX, minY);
            tessellator.addVertexWithUV(xAligned, (double)yAligned + 0.2, zAligned, minX, minY);
        } else if (distortion > 0) {
            tessellator.addDistortedVertexWithUV(xAligned, (double)yAligned + 0.2, zAligned, minX, minY);
            tessellator.addDistortedVertexWithUV(xAligned, yAligned, zAligned + 1.0f, maxX, minY);
            tessellator.addDistortedVertexWithUV(xAligned + 1.0f, yAligned, zAligned + 1.0f, maxX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2, zAligned, minX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2, zAligned, minX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned + 1.0f, yAligned, zAligned + 1.0f, maxX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned, yAligned, zAligned + 1.0f, maxX, minY);
            tessellator.addDistortedVertexWithUV(xAligned, (double)yAligned + 0.2, zAligned, minX, minY);
        }
        return true;
    }

    public boolean renderBlockFourLeafClover3(Block block, int xCoord, int yCoord, int zCoord) {
        Tessellator tessellator = Tessellator.instance;
        int texture = 285;
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xScale = (texture & 0xF) << 4;
        int totalIndex = texture & 0xFF0;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        float xAligned = xCoord;
        float yAligned = yCoord;
        float zAligned = zCoord;
        if (distortion == 0) {
            tessellator.addVertexWithUV(xAligned, (double)yAligned + 0.2, zAligned, minX, minY);
            tessellator.addVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2 - 0.2, zAligned, maxX, minY);
            tessellator.addVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2 - 0.2, zAligned + 1.0f, maxX, maxY);
            tessellator.addVertexWithUV(xAligned, (double)yAligned + 0.2, zAligned + 1.0f, minX, maxY);
            tessellator.addVertexWithUV(xAligned, (double)yAligned + 0.2, zAligned + 1.0f, minX, maxY);
            tessellator.addVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2 - 0.2, zAligned + 1.0f, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2 - 0.2, zAligned, maxX, minY);
            tessellator.addVertexWithUV(xAligned, (double)yAligned + 0.2, zAligned, minX, minY);
        } else if (distortion > 0) {
            tessellator.addDistortedVertexWithUV(xAligned, (double)yAligned + 0.2, zAligned, minX, minY);
            tessellator.addDistortedVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2 - 0.2, zAligned, maxX, minY);
            tessellator.addDistortedVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2 - 0.2, zAligned + 1.0f, maxX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned, (double)yAligned + 0.2, zAligned + 1.0f, minX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned, (double)yAligned + 0.2, zAligned + 1.0f, minX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2 - 0.2, zAligned + 1.0f, maxX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2 - 0.2, zAligned, maxX, minY);
            tessellator.addDistortedVertexWithUV(xAligned, (double)yAligned + 0.2, zAligned, minX, minY);
        }
        return true;
    }

    public boolean renderBlockFourLeafClover4(Block block, int xCoord, int yCoord, int zCoord) {
        Tessellator tessellator = Tessellator.instance;
        int texture = 302;
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xScale = (texture & 0xF) << 4;
        int totalIndex = texture & 0xFF0;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        float xAligned = xCoord;
        float yAligned = yCoord;
        float zAligned = zCoord;
        if (distortion == 0) {
            tessellator.addVertexWithUV(xAligned, yAligned, zAligned, minX, minY);
            tessellator.addVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2, zAligned, maxX, minY);
            tessellator.addVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2, zAligned + 1.0f, maxX, maxY);
            tessellator.addVertexWithUV(xAligned, yAligned, zAligned + 1.0f, minX, maxY);
            tessellator.addVertexWithUV(xAligned, yAligned, zAligned + 1.0f, minX, maxY);
            tessellator.addVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2, zAligned + 1.0f, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2, zAligned, maxX, minY);
            tessellator.addVertexWithUV(xAligned, yAligned, zAligned, minX, minY);
        } else if (distortion > 0) {
            tessellator.addDistortedVertexWithUV(xAligned, yAligned, zAligned, minX, minY);
            tessellator.addDistortedVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2, zAligned, maxX, minY);
            tessellator.addDistortedVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2, zAligned + 1.0f, maxX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned, yAligned, zAligned + 1.0f, minX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned, yAligned, zAligned + 1.0f, minX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2, zAligned + 1.0f, maxX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned + 1.0f, (double)yAligned + 0.2, zAligned, maxX, minY);
            tessellator.addDistortedVertexWithUV(xAligned, yAligned, zAligned, minX, minY);
        }
        return true;
    }

    public boolean renderBlockLilyPadWithFlower(Block block, int xCoord, int yCoord, int zCoord) {
        Tessellator tessellator = Tessellator.instance;
        int textureid = block.getBlockTextureFromSide(1);
        if (this.overrideBlockTexture >= 2) {
            textureid = this.overrideBlockTexture;
        }
        int xScale = (textureid & 0xF) << 4;
        int totalIndex = textureid & 0xFF0;
        float yAligned = -0.0625f;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        long l1 = (long)(xCoord * 3129871) ^ (long)zCoord * 116129781L ^ (long)yCoord;
        l1 = l1 * l1 * 42317861L + l1 * 11L;
        int rotation = (int)(l1 >> 16 & 3L);
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        float xAligned = (float)xCoord + 0.5f;
        float zAligned = (float)zCoord + 0.5f;
        float xRot = (float)(rotation & 1) * 0.5f * (float)(1 - rotation / 2 % 2 * 2);
        float zRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - (rotation + 1) / 2 % 2 * 2);
        if (distortion == 0) {
            tessellator.addVertexWithUV(xAligned + xRot - zRot, (float)yCoord + yAligned, zAligned + xRot + zRot, minX, minY);
            tessellator.addVertexWithUV(xAligned + xRot + zRot, (float)yCoord + yAligned, zAligned - xRot + zRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned - xRot + zRot, (float)yCoord + yAligned, zAligned - xRot - zRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned - xRot - zRot, (float)yCoord + yAligned, zAligned + xRot - zRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - xRot - zRot, (float)yCoord + yAligned, zAligned + xRot - zRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - xRot + zRot, (float)yCoord + yAligned, zAligned - xRot - zRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + xRot + zRot, (float)yCoord + yAligned, zAligned - xRot + zRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned + xRot - zRot, (float)yCoord + yAligned, zAligned + xRot + zRot, minX, minY);
        } else if (distortion > 0) {
            tessellator.addDistortedVertexWithUV(xAligned + xRot - zRot, (float)yCoord + yAligned, zAligned + xRot + zRot, minX, minY);
            tessellator.addDistortedVertexWithUV(xAligned + xRot + zRot, (float)yCoord + yAligned, zAligned - xRot + zRot, maxX, minY);
            tessellator.addDistortedVertexWithUV(xAligned - xRot + zRot, (float)yCoord + yAligned, zAligned - xRot - zRot, maxX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned - xRot - zRot, (float)yCoord + yAligned, zAligned + xRot - zRot, minX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned - xRot - zRot, (float)yCoord + yAligned, zAligned + xRot - zRot, minX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned - xRot + zRot, (float)yCoord + yAligned, zAligned - xRot - zRot, maxX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned + xRot + zRot, (float)yCoord + yAligned, zAligned - xRot + zRot, maxX, minY);
            tessellator.addDistortedVertexWithUV(xAligned + xRot - zRot, (float)yCoord + yAligned, zAligned + xRot + zRot, minX, minY);
        }
        double xDouble = xCoord;
        double yDouble = yCoord;
        double zDouble = zCoord;
        this.renderPlantTextureOnly(block, 283, xDouble, yDouble - 0.0625, zDouble);
        this.renderPlantTextureOnly(block, 299, xDouble, yDouble - 1.0625, zDouble);
        this.renderBlockLilyPadWithFlower2(block, xCoord, yCoord, zCoord, xDouble, yDouble + 0.0375, zDouble, 317);
        return true;
    }

    public boolean renderBlockLilyPadWithFlower2(Block block, int xCoord, int j, int zCoord, double x, double y, double z, int textureInIndex) {
        Tessellator tessellator = Tessellator.instance;
        int texture = textureInIndex;
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xScale = (texture & 0xF) << 4;
        int totalIndex = texture & 0xFF0;
        float yAligned = 0.015625f;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        long l1 = (long)(xCoord * 3129871) ^ (long)zCoord * 116129781L ^ (long)j;
        l1 = l1 * l1 * 42317861L + l1 * 11L;
        int rotation = (int)(l1 >> 16 & 3L);
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, j, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        float xAligned = (float)xCoord + 0.5f;
        float zAligned = (float)zCoord + 0.5f;
        float xRot = (float)(rotation & 1) * 0.5f * (float)(1 - rotation / 2 % 2 * 2);
        float zRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - (rotation + 1) / 2 % 2 * 2);
        if (distortion == 0) {
            tessellator.addVertexWithUV(xAligned + xRot - zRot, (float)j + yAligned, zAligned + xRot + zRot, minX, minY);
            tessellator.addVertexWithUV(xAligned + xRot + zRot, (float)j + yAligned, zAligned - xRot + zRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned - xRot + zRot, (float)j + yAligned, zAligned - xRot - zRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned - xRot - zRot, (float)j + yAligned, zAligned + xRot - zRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - xRot - zRot, (float)j + yAligned, zAligned + xRot - zRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - xRot + zRot, (float)j + yAligned, zAligned - xRot - zRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + xRot + zRot, (float)j + yAligned, zAligned - xRot + zRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned + xRot - zRot, (float)j + yAligned, zAligned + xRot + zRot, minX, minY);
        } else if (distortion > 0) {
            tessellator.addDistortedVertexWithUV(xAligned + xRot - zRot, (float)j + yAligned, zAligned + xRot + zRot, minX, minY);
            tessellator.addDistortedVertexWithUV(xAligned + xRot + zRot, (float)j + yAligned, zAligned - xRot + zRot, maxX, minY);
            tessellator.addDistortedVertexWithUV(xAligned - xRot + zRot, (float)j + yAligned, zAligned - xRot - zRot, maxX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned - xRot - zRot, (float)j + yAligned, zAligned + xRot - zRot, minX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned - xRot - zRot, (float)j + yAligned, zAligned + xRot - zRot, minX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned - xRot + zRot, (float)j + yAligned, zAligned - xRot - zRot, maxX, maxY);
            tessellator.addDistortedVertexWithUV(xAligned + xRot + zRot, (float)j + yAligned, zAligned - xRot + zRot, maxX, minY);
            tessellator.addDistortedVertexWithUV(xAligned + xRot - zRot, (float)j + yAligned, zAligned + xRot + zRot, minX, minY);
        }
        return true;
    }

    public boolean renderBlockLeafPile(Block block, int xCoord, int yCoord, int zCoord) {
        Tessellator tessellator = Tessellator.instance;
        int texture = block.blockIndexInTexture;
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xScale = (texture & 0xF) << 4;
        int totalIndex = texture & 0xFF0;
        float yAligned = 0.0025f;
        float yAlignedBelow = -0.0025f;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        int rotation = 0;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        float xAligned = (float)xCoord + 0.5f;
        float zAligned = (float)zCoord + 0.5f;
        float xRot = (float)(rotation & true) * 0.5f * (float)(1 - rotation / 2 % 2 * 2);
        float zRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - (rotation + 1) / 2 % 2 * 2);
        tessellator.addVertexWithUV(xAligned + xRot - zRot, (float)yCoord + yAligned, zAligned + xRot + zRot, minX, minY);
        tessellator.addVertexWithUV(xAligned + xRot + zRot, (float)yCoord + yAligned, zAligned - xRot + zRot, maxX, minY);
        tessellator.addVertexWithUV(xAligned - xRot + zRot, (float)yCoord + yAligned, zAligned - xRot - zRot, maxX, maxY);
        tessellator.addVertexWithUV(xAligned - xRot - zRot, (float)yCoord + yAligned, zAligned + xRot - zRot, minX, maxY);
        tessellator.addVertexWithUV(xAligned - xRot - zRot, (float)yCoord + yAligned, zAligned + xRot - zRot, minX, maxY);
        tessellator.addVertexWithUV(xAligned - xRot + zRot, (float)yCoord + yAligned, zAligned - xRot - zRot, maxX, maxY);
        tessellator.addVertexWithUV(xAligned + xRot + zRot, (float)yCoord + yAligned, zAligned - xRot + zRot, maxX, minY);
        tessellator.addVertexWithUV(xAligned + xRot - zRot, (float)yCoord + yAligned, zAligned + xRot + zRot, minX, minY);
        if (this.blockAccess.isBlockNormalCube(xCoord, yCoord + 1, zCoord)) {
            tessellator.addVertexWithUV(xAligned + xRot - zRot, (float)yCoord + yAlignedBelow + 1.0f, zAligned + xRot + zRot, minX, minY);
            tessellator.addVertexWithUV(xAligned + xRot + zRot, (float)yCoord + yAlignedBelow + 1.0f, zAligned - xRot + zRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned - xRot + zRot, (float)yCoord + yAlignedBelow + 1.0f, zAligned - xRot - zRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned - xRot - zRot, (float)yCoord + yAlignedBelow + 1.0f, zAligned + xRot - zRot, minX, maxY);
        }
        if (this.blockAccess.isBlockNormalCube(xCoord, yCoord + 1, zCoord)) {
            tessellator.addVertexWithUV(xAligned - xRot - zRot, (float)yCoord + yAlignedBelow + 1.0f, zAligned + xRot - zRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - xRot + zRot, (float)yCoord + yAlignedBelow + 1.0f, zAligned - xRot - zRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + xRot + zRot, (float)yCoord + yAlignedBelow + 1.0f, zAligned - xRot + zRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned + xRot - zRot, (float)yCoord + yAlignedBelow + 1.0f, zAligned + xRot + zRot, minX, minY);
        }
        if (this.blockAccess.isBlockNormalCube(xCoord - 1, yCoord, zCoord)) {
            tessellator.addVertexWithUV((float)xCoord + 0.05f, yCoord + 1, zCoord + 1, minX, minY);
            tessellator.addVertexWithUV((float)xCoord + 0.05f, yCoord, zCoord + 1, minX, maxY);
            tessellator.addVertexWithUV((float)xCoord + 0.05f, yCoord, zCoord, maxX, maxY);
            tessellator.addVertexWithUV((float)xCoord + 0.05f, yCoord + 1, zCoord, maxX, minY);
        }
        if (this.blockAccess.isBlockNormalCube(xCoord + 1, yCoord, zCoord)) {
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.05f, yCoord, zCoord + 1, maxX, maxY);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.05f, yCoord + 1, zCoord + 1, maxX, minY);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.05f, yCoord + 1, zCoord, minX, minY);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.05f, yCoord, zCoord, minX, maxY);
        }
        if (this.blockAccess.isBlockNormalCube(xCoord, yCoord, zCoord - 1)) {
            tessellator.addVertexWithUV(xCoord + 1, yCoord, (float)zCoord + 0.05f, maxX, maxY);
            tessellator.addVertexWithUV(xCoord + 1, yCoord + 1, (float)zCoord + 0.05f, maxX, minY);
            tessellator.addVertexWithUV(xCoord, yCoord + 1, (float)zCoord + 0.05f, minX, minY);
            tessellator.addVertexWithUV(xCoord, yCoord, (float)zCoord + 0.05f, minX, maxY);
        }
        if (this.blockAccess.isBlockNormalCube(xCoord, yCoord, zCoord + 1)) {
            tessellator.addVertexWithUV(xCoord + 1, yCoord + 1, (float)(zCoord + 1) - 0.05f, minX, minY);
            tessellator.addVertexWithUV(xCoord + 1, yCoord, (float)(zCoord + 1) - 0.05f, minX, maxY);
            tessellator.addVertexWithUV(xCoord, yCoord, (float)(zCoord + 1) - 0.05f, maxX, maxY);
            tessellator.addVertexWithUV(xCoord, yCoord + 1, (float)(zCoord + 1) - 0.05f, maxX, minY);
        }
        return true;
    }

    public boolean renderBlockShelfMushroom(Block block, int xCoord, int yCoord, int zCoord) {
        int metadata = this.blockAccess.getBlockMetadata(xCoord, yCoord, zCoord);
        Tessellator tessellator = Tessellator.instance;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        if (Block.lightValue[block.blockID] > 0) {
            lightFloat = 1.0f;
        }
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        if (metadata == 1) {
            this.renderShelfAtAngleCapTop(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapBottom(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapTopTiny(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapTopSmall(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapBottomTiny(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapBottomSmall(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleStemSmall(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleStem(block, xCoord, yCoord, zCoord, metadata);
        } else if (metadata == 2) {
            this.renderShelfAtAngleCapTop(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapBottom(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapTopTiny(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapTopSmall(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapBottomTiny(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapBottomSmall(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleStemSmall(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleStem(block, xCoord, yCoord, zCoord, metadata);
        } else if (metadata == 3) {
            this.renderShelfAtAngleCapTop(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapBottom(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapTopTiny(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapTopSmall(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapBottomTiny(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapBottomSmall(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleStemSmall(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleStem(block, xCoord, yCoord, zCoord, metadata);
        } else if (metadata == 4) {
            this.renderShelfAtAngleCapTop(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapBottom(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapTopTiny(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapTopSmall(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapBottomTiny(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapBottomSmall(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleStemSmall(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleStem(block, xCoord, yCoord, zCoord, metadata);
        } else {
            this.renderShelfAtAngleCapTop(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapBottom(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapTopTiny(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapTopSmall(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapBottomTiny(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleCapBottomSmall(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleStemSmall(block, xCoord, yCoord, zCoord, metadata);
            this.renderShelfAtAngleStem(block, xCoord, yCoord, zCoord, metadata);
        }
        return true;
    }

    public boolean renderShelfAtAngleCapTop(Block block, int xCoord, int yCoord, int zCoord, int metadata) {
        Tessellator tessellator = Tessellator.instance;
        int texture = 302;
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xScale = (texture & 0xF) << 4;
        int totalIndex = texture & 0xFF0;
        float yAligned = 0.75f;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        int rotation = metadata - 1;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        float xAligned = (float)xCoord + 0.5f;
        float zAligned = (float)zCoord + 0.5f;
        float redXRot = (float)(rotation & 1) * 0.5f * (float)(1 - (rotation / 2 & 1) * 2);
        float redZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - ((rotation + 1) / 2 & 1) * 2);
        float yellowXRot = (float)(rotation & 1) * 0.5f * (float)(1 - (rotation / 2 & 1) * 2);
        float yellowZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - ((rotation + 1) / 2 & 1) * 2);
        float blueXRot = (float)(rotation & 1) * 0.5f * (float)(1 - rotation / 2 % 2 * 2);
        float blueZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - (rotation + 1) / 2 % 2 * 2);
        float greenXRot = (float)(rotation & 1) * 0.5f * (float)(1 - rotation / 2 % 2 * 2);
        float greenZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - (rotation + 1) / 2 % 2 * 2);
        if (metadata == 4) {
            tessellator.addVertexWithUV(xAligned + redXRot - redZRot, (float)yCoord + yAligned, zAligned + redXRot + redZRot, minX, minY);
            tessellator.addVertexWithUV(xAligned + redXRot + redZRot, (float)yCoord + yAligned, zAligned - redXRot + redZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned - redXRot + redZRot, (float)yCoord + yAligned, zAligned - redXRot - redZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned - redXRot - redZRot, (float)yCoord + yAligned, zAligned + redXRot - redZRot, minX, maxY);
        } else if (metadata == 1) {
            tessellator.addVertexWithUV(xAligned + blueXRot - blueZRot, (float)yCoord + yAligned, zAligned + blueXRot + blueZRot, minX, minY);
            tessellator.addVertexWithUV(xAligned + blueXRot + blueZRot, (float)yCoord + yAligned, zAligned - blueXRot + blueZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned - blueXRot + blueZRot, (float)yCoord + yAligned, zAligned - blueXRot - blueZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned - blueXRot - blueZRot, (float)yCoord + yAligned, zAligned + blueXRot - blueZRot, minX, maxY);
        } else if (metadata == 3) {
            tessellator.addVertexWithUV(xAligned + greenXRot - greenZRot, (float)yCoord + yAligned, zAligned + greenXRot + greenZRot, minX, minY);
            tessellator.addVertexWithUV(xAligned + greenXRot + greenZRot, (float)yCoord + yAligned, zAligned - greenXRot + greenZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned - greenXRot + greenZRot, (float)yCoord + yAligned, zAligned - greenXRot - greenZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned - greenXRot - greenZRot, (float)yCoord + yAligned, zAligned + greenXRot - greenZRot, minX, maxY);
        } else if (metadata == 2) {
            tessellator.addVertexWithUV(xAligned + yellowXRot - yellowZRot, (float)yCoord + yAligned, zAligned + yellowXRot + yellowZRot, minX, minY);
            tessellator.addVertexWithUV(xAligned + yellowXRot + yellowZRot, (float)yCoord + yAligned, zAligned - yellowXRot + yellowZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned - yellowXRot + yellowZRot, (float)yCoord + yAligned, zAligned - yellowXRot - yellowZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned - yellowXRot - yellowZRot, (float)yCoord + yAligned, zAligned + yellowXRot - yellowZRot, minX, maxY);
        }
        return true;
    }

    public boolean renderShelfAtAngleCapTopSmall(Block block, int xCoord, int yCoord, int zCoord, int metadata) {
        Tessellator tessellator = Tessellator.instance;
        int texture = 334;
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xScale = (texture & 0xF) << 4;
        int totalIndex = texture & 0xFF0;
        float yAligned = 0.375f;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        int rotation = metadata - 1;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        float xAligned = (float)xCoord + 0.5f;
        float zAligned = (float)zCoord + 0.5f;
        float redXRot = (float)(rotation & 1) * 0.5f * (float)(1 - (rotation / 2 & 1) * 2);
        float redZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - ((rotation + 1) / 2 & 1) * 2);
        float yellowXRot = (float)(rotation & 1) * 0.5f * (float)(1 - (rotation / 2 & 1) * 2);
        float yellowZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - ((rotation + 1) / 2 & 1) * 2);
        float blueXRot = (float)(rotation & 1) * 0.5f * (float)(1 - rotation / 2 % 2 * 2);
        float blueZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - (rotation + 1) / 2 % 2 * 2);
        float greenXRot = (float)(rotation & 1) * 0.5f * (float)(1 - rotation / 2 % 2 * 2);
        float greenZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - (rotation + 1) / 2 % 2 * 2);
        if (metadata == 4) {
            tessellator.addVertexWithUV(xAligned + redXRot - redZRot, (float)yCoord + yAligned, zAligned + redXRot + redZRot, minX, minY);
            tessellator.addVertexWithUV(xAligned + redXRot + redZRot, (float)yCoord + yAligned, zAligned - redXRot + redZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned - redXRot + redZRot, (float)yCoord + yAligned, zAligned - redXRot - redZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned - redXRot - redZRot, (float)yCoord + yAligned, zAligned + redXRot - redZRot, minX, maxY);
        } else if (metadata == 1) {
            tessellator.addVertexWithUV(xAligned + blueXRot - blueZRot, (float)yCoord + yAligned, zAligned + blueXRot + blueZRot, minX, minY);
            tessellator.addVertexWithUV(xAligned + blueXRot + blueZRot, (float)yCoord + yAligned, zAligned - blueXRot + blueZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned - blueXRot + blueZRot, (float)yCoord + yAligned, zAligned - blueXRot - blueZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned - blueXRot - blueZRot, (float)yCoord + yAligned, zAligned + blueXRot - blueZRot, minX, maxY);
        } else if (metadata == 3) {
            tessellator.addVertexWithUV(xAligned + greenXRot - greenZRot, (float)yCoord + yAligned, zAligned + greenXRot + greenZRot, minX, minY);
            tessellator.addVertexWithUV(xAligned + greenXRot + greenZRot, (float)yCoord + yAligned, zAligned - greenXRot + greenZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned - greenXRot + greenZRot, (float)yCoord + yAligned, zAligned - greenXRot - greenZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned - greenXRot - greenZRot, (float)yCoord + yAligned, zAligned + greenXRot - greenZRot, minX, maxY);
        } else if (metadata == 2) {
            tessellator.addVertexWithUV(xAligned + yellowXRot - yellowZRot, (float)yCoord + yAligned, zAligned + yellowXRot + yellowZRot, minX, minY);
            tessellator.addVertexWithUV(xAligned + yellowXRot + yellowZRot, (float)yCoord + yAligned, zAligned - yellowXRot + yellowZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned - yellowXRot + yellowZRot, (float)yCoord + yAligned, zAligned - yellowXRot - yellowZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned - yellowXRot - yellowZRot, (float)yCoord + yAligned, zAligned + yellowXRot - yellowZRot, minX, maxY);
        }
        return true;
    }

    public boolean renderShelfAtAngleCapBottom(Block block, int xCoord, int yCoord, int zCoord, int metadata) {
        Tessellator tessellator = Tessellator.instance;
        int texture = 301;
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xScale = (texture & 0xF) << 4;
        int totalIndex = texture & 0xFF0;
        float yAligned = 0.75f;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        int rotation = metadata - 1;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        float xAligned = (float)xCoord + 0.5f;
        float zAligned = (float)zCoord + 0.5f;
        float redXRot = (float)(rotation & 1) * 0.5f * (float)(1 - (rotation / 2 & 1) * 2);
        float redZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - ((rotation + 1) / 2 & 1) * 2);
        float yellowXRot = (float)(rotation & 1) * 0.5f * (float)(1 - (rotation / 2 & 1) * 2);
        float yellowZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - ((rotation + 1) / 2 & 1) * 2);
        float blueXRot = (float)(rotation & 1) * 0.5f * (float)(1 - rotation / 2 % 2 * 2);
        float blueZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - (rotation + 1) / 2 % 2 * 2);
        float greenXRot = (float)(rotation & 1) * 0.5f * (float)(1 - rotation / 2 % 2 * 2);
        float greenZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - (rotation + 1) / 2 % 2 * 2);
        if (metadata == 4) {
            tessellator.addVertexWithUV(xAligned - redXRot - redZRot, (float)yCoord + yAligned, zAligned + redXRot - redZRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - redXRot + redZRot, (float)yCoord + yAligned, zAligned - redXRot - redZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + redXRot + redZRot, (float)yCoord + yAligned, zAligned - redXRot + redZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned + redXRot - redZRot, (float)yCoord + yAligned, zAligned + redXRot + redZRot, minX, minY);
        } else if (metadata == 1) {
            tessellator.addVertexWithUV(xAligned - blueXRot - blueZRot, (float)yCoord + yAligned, zAligned + blueXRot - blueZRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - blueXRot + blueZRot, (float)yCoord + yAligned, zAligned - blueXRot - blueZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + blueXRot + blueZRot, (float)yCoord + yAligned, zAligned - blueXRot + blueZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned + blueXRot - blueZRot, (float)yCoord + yAligned, zAligned + blueXRot + blueZRot, minX, minY);
        } else if (metadata == 3) {
            tessellator.addVertexWithUV(xAligned - greenXRot - greenZRot, (float)yCoord + yAligned, zAligned + greenXRot - greenZRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - greenXRot + greenZRot, (float)yCoord + yAligned, zAligned - greenXRot - greenZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + greenXRot + greenZRot, (float)yCoord + yAligned, zAligned - greenXRot + greenZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned + greenXRot - greenZRot, (float)yCoord + yAligned, zAligned + greenXRot + greenZRot, minX, minY);
        } else if (metadata == 2) {
            tessellator.addVertexWithUV(xAligned - yellowXRot - yellowZRot, (float)yCoord + yAligned, zAligned + yellowXRot - yellowZRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - yellowXRot + yellowZRot, (float)yCoord + yAligned, zAligned - yellowXRot - yellowZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + yellowXRot + yellowZRot, (float)yCoord + yAligned, zAligned - yellowXRot + yellowZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned + yellowXRot - yellowZRot, (float)yCoord + yAligned, zAligned + yellowXRot + yellowZRot, minX, minY);
        }
        return true;
    }

    public boolean renderShelfAtAngleCapBottomSmall(Block block, int xCoord, int yCoord, int zCoord, int metadata) {
        Tessellator tessellator = Tessellator.instance;
        int texture = 333;
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xScale = (texture & 0xF) << 4;
        int totalIndex = texture & 0xFF0;
        float yAligned = 0.375f;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        int rotation = metadata - 1;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        float xAligned = (float)xCoord + 0.5f;
        float zAligned = (float)zCoord + 0.5f;
        float redXRot = (float)(rotation & 1) * 0.5f * (float)(1 - (rotation / 2 & 1) * 2);
        float redZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - ((rotation + 1) / 2 & 1) * 2);
        float yellowXRot = (float)(rotation & 1) * 0.5f * (float)(1 - (rotation / 2 & 1) * 2);
        float yellowZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - ((rotation + 1) / 2 & 1) * 2);
        float blueXRot = (float)(rotation & 1) * 0.5f * (float)(1 - rotation / 2 % 2 * 2);
        float blueZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - (rotation + 1) / 2 % 2 * 2);
        float greenXRot = (float)(rotation & 1) * 0.5f * (float)(1 - rotation / 2 % 2 * 2);
        float greenZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - (rotation + 1) / 2 % 2 * 2);
        if (metadata == 4) {
            tessellator.addVertexWithUV(xAligned - redXRot - redZRot, (float)yCoord + yAligned, zAligned + redXRot - redZRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - redXRot + redZRot, (float)yCoord + yAligned, zAligned - redXRot - redZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + redXRot + redZRot, (float)yCoord + yAligned, zAligned - redXRot + redZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned + redXRot - redZRot, (float)yCoord + yAligned, zAligned + redXRot + redZRot, minX, minY);
        } else if (metadata == 1) {
            tessellator.addVertexWithUV(xAligned - blueXRot - blueZRot, (float)yCoord + yAligned, zAligned + blueXRot - blueZRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - blueXRot + blueZRot, (float)yCoord + yAligned, zAligned - blueXRot - blueZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + blueXRot + blueZRot, (float)yCoord + yAligned, zAligned - blueXRot + blueZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned + blueXRot - blueZRot, (float)yCoord + yAligned, zAligned + blueXRot + blueZRot, minX, minY);
        } else if (metadata == 3) {
            tessellator.addVertexWithUV(xAligned - greenXRot - greenZRot, (float)yCoord + yAligned, zAligned + greenXRot - greenZRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - greenXRot + greenZRot, (float)yCoord + yAligned, zAligned - greenXRot - greenZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + greenXRot + greenZRot, (float)yCoord + yAligned, zAligned - greenXRot + greenZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned + greenXRot - greenZRot, (float)yCoord + yAligned, zAligned + greenXRot + greenZRot, minX, minY);
        } else if (metadata == 2) {
            tessellator.addVertexWithUV(xAligned - yellowXRot - yellowZRot, (float)yCoord + yAligned, zAligned + yellowXRot - yellowZRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - yellowXRot + yellowZRot, (float)yCoord + yAligned, zAligned - yellowXRot - yellowZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + yellowXRot + yellowZRot, (float)yCoord + yAligned, zAligned - yellowXRot + yellowZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned + yellowXRot - yellowZRot, (float)yCoord + yAligned, zAligned + yellowXRot + yellowZRot, minX, minY);
        }
        return true;
    }

    public boolean renderShelfAtAngleCapTopTiny(Block block, int xCoord, int yCoord, int zCoord, int metadata) {
        Tessellator tessellator = Tessellator.instance;
        int texture = 350;
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xScale = (texture & 0xF) << 4;
        int totalIndex = texture & 0xFF0;
        float yAligned = 0.5f;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        int rotation = metadata - 1;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        float xAligned = (float)xCoord + 0.5f;
        float zAligned = (float)zCoord + 0.5f;
        float redXRot = (float)(rotation & 1) * 0.5f * (float)(1 - (rotation / 2 & 1) * 2);
        float redZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - ((rotation + 1) / 2 & 1) * 2);
        float yellowXRot = (float)(rotation & 1) * 0.5f * (float)(1 - (rotation / 2 & 1) * 2);
        float yellowZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - ((rotation + 1) / 2 & 1) * 2);
        float blueXRot = (float)(rotation & 1) * 0.5f * (float)(1 - rotation / 2 % 2 * 2);
        float blueZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - (rotation + 1) / 2 % 2 * 2);
        float greenXRot = (float)(rotation & 1) * 0.5f * (float)(1 - rotation / 2 % 2 * 2);
        float greenZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - (rotation + 1) / 2 % 2 * 2);
        if (metadata == 4) {
            tessellator.addVertexWithUV(xAligned + redXRot - redZRot, (float)yCoord + yAligned, zAligned + redXRot + redZRot, minX, minY);
            tessellator.addVertexWithUV(xAligned + redXRot + redZRot, (float)yCoord + yAligned, zAligned - redXRot + redZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned - redXRot + redZRot, (float)yCoord + yAligned, zAligned - redXRot - redZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned - redXRot - redZRot, (float)yCoord + yAligned, zAligned + redXRot - redZRot, minX, maxY);
        } else if (metadata == 1) {
            tessellator.addVertexWithUV(xAligned + blueXRot - blueZRot, (float)yCoord + yAligned, zAligned + blueXRot + blueZRot, minX, minY);
            tessellator.addVertexWithUV(xAligned + blueXRot + blueZRot, (float)yCoord + yAligned, zAligned - blueXRot + blueZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned - blueXRot + blueZRot, (float)yCoord + yAligned, zAligned - blueXRot - blueZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned - blueXRot - blueZRot, (float)yCoord + yAligned, zAligned + blueXRot - blueZRot, minX, maxY);
        } else if (metadata == 3) {
            tessellator.addVertexWithUV(xAligned + greenXRot - greenZRot, (float)yCoord + yAligned, zAligned + greenXRot + greenZRot, minX, minY);
            tessellator.addVertexWithUV(xAligned + greenXRot + greenZRot, (float)yCoord + yAligned, zAligned - greenXRot + greenZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned - greenXRot + greenZRot, (float)yCoord + yAligned, zAligned - greenXRot - greenZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned - greenXRot - greenZRot, (float)yCoord + yAligned, zAligned + greenXRot - greenZRot, minX, maxY);
        } else if (metadata == 2) {
            tessellator.addVertexWithUV(xAligned + yellowXRot - yellowZRot, (float)yCoord + yAligned, zAligned + yellowXRot + yellowZRot, minX, minY);
            tessellator.addVertexWithUV(xAligned + yellowXRot + yellowZRot, (float)yCoord + yAligned, zAligned - yellowXRot + yellowZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned - yellowXRot + yellowZRot, (float)yCoord + yAligned, zAligned - yellowXRot - yellowZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned - yellowXRot - yellowZRot, (float)yCoord + yAligned, zAligned + yellowXRot - yellowZRot, minX, maxY);
        }
        return true;
    }

    public boolean renderShelfAtAngleCapBottomTiny(Block block, int xCoord, int yCoord, int zCoord, int metadata) {
        Tessellator tessellator = Tessellator.instance;
        int texture = 349;
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xScale = (texture & 0xF) << 4;
        int totalIndex = texture & 0xFF0;
        float yAligned = 0.5f;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        int rotation = metadata - 1;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        float xAligned = (float)xCoord + 0.5f;
        float zAligned = (float)zCoord + 0.5f;
        float redXRot = (float)(rotation & 1) * 0.5f * (float)(1 - (rotation / 2 & 1) * 2);
        float redZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - ((rotation + 1) / 2 & 1) * 2);
        float yellowXRot = (float)(rotation & 1) * 0.5f * (float)(1 - (rotation / 2 & 1) * 2);
        float yellowZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - ((rotation + 1) / 2 & 1) * 2);
        float blueXRot = (float)(rotation & 1) * 0.5f * (float)(1 - rotation / 2 % 2 * 2);
        float blueZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - (rotation + 1) / 2 % 2 * 2);
        float greenXRot = (float)(rotation & 1) * 0.5f * (float)(1 - rotation / 2 % 2 * 2);
        float greenZRot = (float)(rotation + 1 & 1) * 0.5f * (float)(1 - (rotation + 1) / 2 % 2 * 2);
        if (metadata == 4) {
            tessellator.addVertexWithUV(xAligned - redXRot - redZRot, (float)yCoord + yAligned, zAligned + redXRot - redZRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - redXRot + redZRot, (float)yCoord + yAligned, zAligned - redXRot - redZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + redXRot + redZRot, (float)yCoord + yAligned, zAligned - redXRot + redZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned + redXRot - redZRot, (float)yCoord + yAligned, zAligned + redXRot + redZRot, minX, minY);
        } else if (metadata == 1) {
            tessellator.addVertexWithUV(xAligned - blueXRot - blueZRot, (float)yCoord + yAligned, zAligned + blueXRot - blueZRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - blueXRot + blueZRot, (float)yCoord + yAligned, zAligned - blueXRot - blueZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + blueXRot + blueZRot, (float)yCoord + yAligned, zAligned - blueXRot + blueZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned + blueXRot - blueZRot, (float)yCoord + yAligned, zAligned + blueXRot + blueZRot, minX, minY);
        } else if (metadata == 3) {
            tessellator.addVertexWithUV(xAligned - greenXRot - greenZRot, (float)yCoord + yAligned, zAligned + greenXRot - greenZRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - greenXRot + greenZRot, (float)yCoord + yAligned, zAligned - greenXRot - greenZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + greenXRot + greenZRot, (float)yCoord + yAligned, zAligned - greenXRot + greenZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned + greenXRot - greenZRot, (float)yCoord + yAligned, zAligned + greenXRot + greenZRot, minX, minY);
        } else if (metadata == 2) {
            tessellator.addVertexWithUV(xAligned - yellowXRot - yellowZRot, (float)yCoord + yAligned, zAligned + yellowXRot - yellowZRot, minX, maxY);
            tessellator.addVertexWithUV(xAligned - yellowXRot + yellowZRot, (float)yCoord + yAligned, zAligned - yellowXRot - yellowZRot, maxX, maxY);
            tessellator.addVertexWithUV(xAligned + yellowXRot + yellowZRot, (float)yCoord + yAligned, zAligned - yellowXRot + yellowZRot, maxX, minY);
            tessellator.addVertexWithUV(xAligned + yellowXRot - yellowZRot, (float)yCoord + yAligned, zAligned + yellowXRot + yellowZRot, minX, minY);
        }
        return true;
    }

    public boolean renderShelfAtAngleStem(Block block, int xCoord, int yCoord, int zCoord, int metadata) {
        Tessellator tessellator = Tessellator.instance;
        int texture1 = 303;
        if (this.overrideBlockTexture >= 0) {
            texture1 = this.overrideBlockTexture;
        }
        int xScale1 = (texture1 & 0xF) << 4;
        int totalIndex1 = texture1 & 0xFF0;
        double minXt1 = (float)xScale1 / 256.0f;
        double maxXt1 = ((float)xScale1 + 15.99f) / 256.0f;
        double minYt1 = (float)totalIndex1 / 512.0f;
        double maxYt1 = ((float)totalIndex1 + 15.99f) / 512.0f;
        int texture2 = 319;
        if (this.overrideBlockTexture >= 0) {
            texture2 = this.overrideBlockTexture;
        }
        int xScale2 = (texture2 & 0xF) << 4;
        int totalIndex2 = texture2 & 0xFF0;
        double minXt2 = (float)xScale2 / 256.0f;
        double d100 = ((float)xScale2 + 15.99f) / 256.0f;
        double minYt2 = (float)totalIndex2 / 512.0f;
        double maxYt2 = ((float)totalIndex2 + 15.99f) / 512.0f;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        if (metadata == 4) {
            tessellator.addVertexWithUV(xCoord + 1, (double)yCoord - 0.25, (float)zCoord + 0.5f, d100, maxYt2);
            tessellator.addVertexWithUV(xCoord + 1, (double)yCoord + 0.75, (float)zCoord + 0.5f, d100, minYt2);
            tessellator.addVertexWithUV(xCoord, (double)yCoord + 0.75, (float)zCoord + 0.5f, minXt2, minYt2);
            tessellator.addVertexWithUV(xCoord, (double)yCoord - 0.25, (float)zCoord + 0.5f, minXt2, maxYt2);
            tessellator.addVertexWithUV(xCoord + 1, (double)yCoord + 0.75, (float)zCoord + 0.5f, minXt1, minYt1);
            tessellator.addVertexWithUV(xCoord + 1, (double)yCoord - 0.25, (float)zCoord + 0.5f, minXt1, maxYt1);
            tessellator.addVertexWithUV(xCoord, (double)yCoord - 0.25, (float)zCoord + 0.5f, maxXt1, maxYt1);
            tessellator.addVertexWithUV(xCoord, (double)yCoord + 0.75, (float)zCoord + 0.5f, maxXt1, minYt1);
        } else if (metadata == 1) {
            tessellator.addVertexWithUV((float)xCoord + 0.5f, (double)yCoord + 0.75, zCoord + 1, minXt2, minYt2);
            tessellator.addVertexWithUV((float)xCoord + 0.5f, (double)yCoord - 0.25, zCoord + 1, minXt2, maxYt2);
            tessellator.addVertexWithUV((float)xCoord + 0.5f, (double)yCoord - 0.25, zCoord, d100, maxYt2);
            tessellator.addVertexWithUV((float)xCoord + 0.5f, (double)yCoord + 0.75, zCoord, d100, minYt2);
            tessellator.addVertexWithUV((float)xCoord + 0.5f, (double)yCoord - 0.25, zCoord + 1, maxXt1, maxYt1);
            tessellator.addVertexWithUV((float)xCoord + 0.5f, (double)yCoord + 0.75, zCoord + 1, maxXt1, minYt1);
            tessellator.addVertexWithUV((float)xCoord + 0.5f, (double)yCoord + 0.75, zCoord, minXt1, minYt1);
            tessellator.addVertexWithUV((float)xCoord + 0.5f, (double)yCoord - 0.25, zCoord, minXt1, maxYt1);
        } else if (metadata == 3) {
            tessellator.addVertexWithUV((float)xCoord + 0.5f, (double)yCoord + 0.75, zCoord + 1, minXt1, minYt1);
            tessellator.addVertexWithUV((float)xCoord + 0.5f, (double)yCoord - 0.25, zCoord + 1, minXt1, maxYt1);
            tessellator.addVertexWithUV((float)xCoord + 0.5f, (double)yCoord - 0.25, zCoord, maxXt1, maxYt1);
            tessellator.addVertexWithUV((float)xCoord + 0.5f, (double)yCoord + 0.75, zCoord, maxXt1, minYt1);
            tessellator.addVertexWithUV((float)xCoord + 0.5f, (double)yCoord - 0.25, zCoord + 1, d100, maxYt2);
            tessellator.addVertexWithUV((float)xCoord + 0.5f, (double)yCoord + 0.75, zCoord + 1, d100, minYt2);
            tessellator.addVertexWithUV((float)xCoord + 0.5f, (double)yCoord + 0.75, zCoord, minXt2, minYt2);
            tessellator.addVertexWithUV((float)xCoord + 0.5f, (double)yCoord - 0.25, zCoord, minXt2, maxYt2);
        } else if (metadata == 2) {
            tessellator.addVertexWithUV(xCoord + 1, (double)yCoord - 0.25, (float)zCoord + 0.5f, maxXt1, maxYt1);
            tessellator.addVertexWithUV(xCoord + 1, (double)yCoord + 0.75, (float)zCoord + 0.5f, maxXt1, minYt1);
            tessellator.addVertexWithUV(xCoord, (double)yCoord + 0.75, (float)zCoord + 0.5f, minXt1, minYt1);
            tessellator.addVertexWithUV(xCoord, (double)yCoord - 0.25, (float)zCoord + 0.5f, minXt1, maxYt1);
            tessellator.addVertexWithUV(xCoord + 1, (double)yCoord + 0.75, (float)zCoord + 0.5f, minXt2, minYt2);
            tessellator.addVertexWithUV(xCoord + 1, (double)yCoord - 0.25, (float)zCoord + 0.5f, minXt2, maxYt2);
            tessellator.addVertexWithUV(xCoord, (double)yCoord - 0.25, (float)zCoord + 0.5f, d100, maxYt2);
            tessellator.addVertexWithUV(xCoord, (double)yCoord + 0.75, (float)zCoord + 0.5f, d100, minYt2);
        }
        return true;
    }

    public boolean renderShelfAtAngleStemSmall(Block block, int xCoord, int yCoord, int zCoord, int metadata) {
        Tessellator tessellator = Tessellator.instance;
        int texture1 = 335;
        if (this.overrideBlockTexture >= 0) {
            texture1 = this.overrideBlockTexture;
        }
        int xScale1 = (texture1 & 0xF) << 4;
        int totalIndex1 = texture1 & 0xFF0;
        double minXt1 = (float)((double)xScale1 + 8.01) / 256.0f;
        double maxXt1 = ((float)xScale1 + 15.99f) / 256.0f;
        double minYt1 = (float)totalIndex1 / 512.0f;
        double maxYt1 = ((float)totalIndex1 + 15.99f) / 512.0f;
        int texture2 = 335;
        if (this.overrideBlockTexture >= 0) {
            texture2 = this.overrideBlockTexture;
        }
        int xScale2 = (texture2 & 0xF) << 4;
        int totalIndex2 = texture2 & 0xFF0;
        double minXt2 = (float)xScale2 / 256.0f;
        double maxXt2 = ((float)xScale2 + 7.99f) / 256.0f;
        double minYt2 = (float)totalIndex2 / 512.0f;
        double maxYt2 = ((float)totalIndex2 + 15.99f) / 512.0f;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        if (metadata == 4) {
            tessellator.addVertexWithUV((double)xCoord + 0.5, (double)yCoord - 0.625, (float)(zCoord + 1) - 0.2875f, maxXt2, maxYt2);
            tessellator.addVertexWithUV((double)xCoord + 0.5, (double)yCoord + 0.375, (float)(zCoord + 1) - 0.2875f, maxXt2, minYt2);
            tessellator.addVertexWithUV(xCoord, (double)yCoord + 0.375, (float)(zCoord + 1) - 0.2875f, minXt2, minYt2);
            tessellator.addVertexWithUV(xCoord, (double)yCoord - 0.625, (float)(zCoord + 1) - 0.2875f, minXt2, maxYt2);
            tessellator.addVertexWithUV((double)xCoord + 0.5, (double)yCoord + 0.375, (float)(zCoord + 1) - 0.2875f, minXt1, minYt1);
            tessellator.addVertexWithUV((double)xCoord + 0.5, (double)yCoord - 0.625, (float)(zCoord + 1) - 0.2875f, minXt1, maxYt1);
            tessellator.addVertexWithUV(xCoord, (double)yCoord - 0.625, (float)(zCoord + 1) - 0.2875f, maxXt1, maxYt1);
            tessellator.addVertexWithUV(xCoord, (double)yCoord + 0.375, (float)(zCoord + 1) - 0.2875f, maxXt1, minYt1);
            tessellator.addVertexWithUV((double)xCoord + 0.5, (double)yCoord - 0.5, (float)(zCoord + 1) - 0.7875f, maxXt2, maxYt2);
            tessellator.addVertexWithUV((double)xCoord + 0.5, (double)yCoord + 0.5, (float)(zCoord + 1) - 0.7875f, maxXt2, minYt2);
            tessellator.addVertexWithUV(xCoord, (double)yCoord + 0.5, (float)(zCoord + 1) - 0.7875f, minXt2, minYt2);
            tessellator.addVertexWithUV(xCoord, (double)yCoord - 0.5, (float)(zCoord + 1) - 0.7875f, minXt2, maxYt2);
            tessellator.addVertexWithUV((double)xCoord + 0.5, (double)yCoord + 0.5, (float)(zCoord + 1) - 0.7875f, minXt1, minYt1);
            tessellator.addVertexWithUV((double)xCoord + 0.5, (double)yCoord - 0.5, (float)(zCoord + 1) - 0.7875f, minXt1, maxYt1);
            tessellator.addVertexWithUV(xCoord, (double)yCoord - 0.5, (float)(zCoord + 1) - 0.7875f, maxXt1, maxYt1);
            tessellator.addVertexWithUV(xCoord, (double)yCoord + 0.5, (float)(zCoord + 1) - 0.7875f, maxXt1, minYt1);
        } else if (metadata == 1) {
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.7875f, (double)yCoord + 0.5, (double)zCoord + 0.5, minXt1, minYt1);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.7875f, (double)yCoord - 0.5, (double)zCoord + 0.5, minXt1, maxYt1);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.7875f, (double)yCoord - 0.5, zCoord + 1, maxXt1, maxYt1);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.7875f, (double)yCoord + 0.5, zCoord + 1, maxXt1, minYt1);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.7875f, (double)yCoord - 0.5, (double)zCoord + 0.5, maxXt2, maxYt2);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.7875f, (double)yCoord + 0.5, (double)zCoord + 0.5, maxXt2, minYt2);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.7875f, (double)yCoord + 0.5, zCoord + 1, minXt2, minYt2);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.7875f, (double)yCoord - 0.5, zCoord + 1, minXt2, maxYt2);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.2875f, (double)yCoord + 0.375, (double)zCoord + 0.5, minXt1, minYt1);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.2875f, (double)yCoord - 0.625, (double)zCoord + 0.5, minXt1, maxYt1);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.2875f, (double)yCoord - 0.625, zCoord + 1, maxXt1, maxYt1);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.2875f, (double)yCoord + 0.375, zCoord + 1, maxXt1, minYt1);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.2875f, (double)yCoord - 0.625, (double)zCoord + 0.5, maxXt2, maxYt2);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.2875f, (double)yCoord + 0.375, (double)zCoord + 0.5, maxXt2, minYt2);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.2875f, (double)yCoord + 0.375, zCoord + 1, minXt2, minYt2);
            tessellator.addVertexWithUV((float)(xCoord + 1) - 0.2875f, (double)yCoord - 0.625, zCoord + 1, minXt2, maxYt2);
        } else if (metadata == 3) {
            tessellator.addVertexWithUV((float)xCoord + 0.7875f, (double)yCoord + 0.5, (double)zCoord + 0.5, minXt1, minYt1);
            tessellator.addVertexWithUV((float)xCoord + 0.7875f, (double)yCoord - 0.5, (double)zCoord + 0.5, minXt1, maxYt1);
            tessellator.addVertexWithUV((float)xCoord + 0.7875f, (double)yCoord - 0.5, zCoord, maxXt1, maxYt1);
            tessellator.addVertexWithUV((float)xCoord + 0.7875f, (double)yCoord + 0.5, zCoord, maxXt1, minYt1);
            tessellator.addVertexWithUV((float)xCoord + 0.7875f, (double)yCoord - 0.5, (double)zCoord + 0.5, maxXt2, maxYt2);
            tessellator.addVertexWithUV((float)xCoord + 0.7875f, (double)yCoord + 0.5, (double)zCoord + 0.5, maxXt2, minYt2);
            tessellator.addVertexWithUV((float)xCoord + 0.7875f, (double)yCoord + 0.5, zCoord, minXt2, minYt2);
            tessellator.addVertexWithUV((float)xCoord + 0.7875f, (double)yCoord - 0.5, zCoord, minXt2, maxYt2);
            tessellator.addVertexWithUV((float)xCoord + 0.2875f, (double)yCoord + 0.375, (double)zCoord + 0.5, minXt1, minYt1);
            tessellator.addVertexWithUV((float)xCoord + 0.2875f, (double)yCoord - 0.625, (double)zCoord + 0.5, minXt1, maxYt1);
            tessellator.addVertexWithUV((float)xCoord + 0.2875f, (double)yCoord - 0.625, zCoord, maxXt1, maxYt1);
            tessellator.addVertexWithUV((float)xCoord + 0.2875f, (double)yCoord + 0.375, zCoord, maxXt1, minYt1);
            tessellator.addVertexWithUV((float)xCoord + 0.2875f, (double)yCoord - 0.625, (double)zCoord + 0.5, maxXt2, maxYt2);
            tessellator.addVertexWithUV((float)xCoord + 0.2875f, (double)yCoord + 0.375, (double)zCoord + 0.5, maxXt2, minYt2);
            tessellator.addVertexWithUV((float)xCoord + 0.2875f, (double)yCoord + 0.375, zCoord, minXt2, minYt2);
            tessellator.addVertexWithUV((float)xCoord + 0.2875f, (double)yCoord - 0.625, zCoord, minXt2, maxYt2);
        } else if (metadata == 2) {
            tessellator.addVertexWithUV(xCoord + 1, (double)yCoord - 0.625, (float)zCoord + 0.2875f, maxXt1, maxYt1);
            tessellator.addVertexWithUV(xCoord + 1, (double)yCoord + 0.375, (float)zCoord + 0.2875f, maxXt1, minYt1);
            tessellator.addVertexWithUV((double)xCoord + 0.5, (double)yCoord + 0.375, (float)zCoord + 0.2875f, minXt1, minYt1);
            tessellator.addVertexWithUV((double)xCoord + 0.5, (double)yCoord - 0.625, (float)zCoord + 0.2875f, minXt1, maxYt1);
            tessellator.addVertexWithUV(xCoord + 1, (double)yCoord + 0.375, (float)zCoord + 0.2875f, minXt2, minYt2);
            tessellator.addVertexWithUV(xCoord + 1, (double)yCoord - 0.625, (float)zCoord + 0.2875f, minXt2, maxYt2);
            tessellator.addVertexWithUV((double)xCoord + 0.5, (double)yCoord - 0.625, (float)zCoord + 0.2875f, maxXt2, maxYt2);
            tessellator.addVertexWithUV((double)xCoord + 0.5, (double)yCoord + 0.375, (float)zCoord + 0.2875f, maxXt2, minYt2);
            tessellator.addVertexWithUV(xCoord + 1, (double)yCoord - 0.5, (float)zCoord + 0.7875f, maxXt1, maxYt1);
            tessellator.addVertexWithUV(xCoord + 1, (double)yCoord + 0.5, (float)zCoord + 0.7875f, maxXt1, minYt1);
            tessellator.addVertexWithUV((double)xCoord + 0.5, (double)yCoord + 0.5, (float)zCoord + 0.7875f, minXt1, minYt1);
            tessellator.addVertexWithUV((double)xCoord + 0.5, (double)yCoord - 0.5, (float)zCoord + 0.7875f, minXt1, maxYt1);
            tessellator.addVertexWithUV(xCoord + 1, (double)yCoord + 0.5, (float)zCoord + 0.7875f, minXt2, minYt2);
            tessellator.addVertexWithUV(xCoord + 1, (double)yCoord - 0.5, (float)zCoord + 0.7875f, minXt2, maxYt2);
            tessellator.addVertexWithUV((double)xCoord + 0.5, (double)yCoord - 0.5, (float)zCoord + 0.7875f, maxXt2, maxYt2);
            tessellator.addVertexWithUV((double)xCoord + 0.5, (double)yCoord + 0.5, (float)zCoord + 0.7875f, maxXt2, minYt2);
        }
        return true;
    }

    public boolean renderBlockLavender(Block block, int xCoord, int yCoord, int zCoord) {
        Tessellator tessellator = Tessellator.instance;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        if (Block.lightValue[block.blockID] > 0) {
            lightFloat = 1.0f;
        }
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        double xDouble = xCoord;
        double yDouble = yCoord;
        double zDouble = zCoord;
        this.renderPlantTextureOnly(block, block.blockIndexInTexture, xDouble, yDouble, zDouble);
        this.renderCropsTextureOnly(block, block.blockIndexInTexture, xDouble, yDouble, zDouble);
        return true;
    }

    public void renderCropsTextureOnly(Block block, int textureInIndex, double xCoord, double yCoord, double zCoord) {
        Tessellator tessellator = Tessellator.instance;
        int texture = textureInIndex;
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xScale = (texture & 0xF) << 4;
        int totalIndex = texture & 0xFF0;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        double xAligned1 = xCoord + 0.5 - 0.25;
        double xAligned2 = xCoord + 0.5 + 0.25;
        double zAligned1 = zCoord + 0.5 - 0.5;
        double zAligned2 = zCoord + 0.5 + 0.5;
        tessellator.addVertexWithUV(xAligned1, yCoord + 1.0, zAligned1, minX, minY);
        tessellator.addVertexWithUV(xAligned1, yCoord + 0.0, zAligned1, minX, maxY);
        tessellator.addVertexWithUV(xAligned1, yCoord + 0.0, zAligned2, maxX, maxY);
        tessellator.addVertexWithUV(xAligned1, yCoord + 1.0, zAligned2, maxX, minY);
        tessellator.addVertexWithUV(xAligned1, yCoord + 1.0, zAligned2, minX, minY);
        tessellator.addVertexWithUV(xAligned1, yCoord + 0.0, zAligned2, minX, maxY);
        tessellator.addVertexWithUV(xAligned1, yCoord + 0.0, zAligned1, maxX, maxY);
        tessellator.addVertexWithUV(xAligned1, yCoord + 1.0, zAligned1, maxX, minY);
        tessellator.addVertexWithUV(xAligned2, yCoord + 1.0, zAligned2, minX, minY);
        tessellator.addVertexWithUV(xAligned2, yCoord + 0.0, zAligned2, minX, maxY);
        tessellator.addVertexWithUV(xAligned2, yCoord + 0.0, zAligned1, maxX, maxY);
        tessellator.addVertexWithUV(xAligned2, yCoord + 1.0, zAligned1, maxX, minY);
        tessellator.addVertexWithUV(xAligned2, yCoord + 1.0, zAligned1, minX, minY);
        tessellator.addVertexWithUV(xAligned2, yCoord + 0.0, zAligned1, minX, maxY);
        tessellator.addVertexWithUV(xAligned2, yCoord + 0.0, zAligned2, maxX, maxY);
        tessellator.addVertexWithUV(xAligned2, yCoord + 1.0, zAligned2, maxX, minY);
        xAligned1 = xCoord + 0.5 - 0.5;
        xAligned2 = xCoord + 0.5 + 0.5;
        zAligned1 = zCoord + 0.5 - 0.25;
        zAligned2 = zCoord + 0.5 + 0.25;
        tessellator.addVertexWithUV(xAligned1, yCoord + 1.0, zAligned1, minX, minY);
        tessellator.addVertexWithUV(xAligned1, yCoord + 0.0, zAligned1, minX, maxY);
        tessellator.addVertexWithUV(xAligned2, yCoord + 0.0, zAligned1, maxX, maxY);
        tessellator.addVertexWithUV(xAligned2, yCoord + 1.0, zAligned1, maxX, minY);
        tessellator.addVertexWithUV(xAligned2, yCoord + 1.0, zAligned1, minX, minY);
        tessellator.addVertexWithUV(xAligned2, yCoord + 0.0, zAligned1, minX, maxY);
        tessellator.addVertexWithUV(xAligned1, yCoord + 0.0, zAligned1, maxX, maxY);
        tessellator.addVertexWithUV(xAligned1, yCoord + 1.0, zAligned1, maxX, minY);
        tessellator.addVertexWithUV(xAligned2, yCoord + 1.0, zAligned2, minX, minY);
        tessellator.addVertexWithUV(xAligned2, yCoord + 0.0, zAligned2, minX, maxY);
        tessellator.addVertexWithUV(xAligned1, yCoord + 0.0, zAligned2, maxX, maxY);
        tessellator.addVertexWithUV(xAligned1, yCoord + 1.0, zAligned2, maxX, minY);
        tessellator.addVertexWithUV(xAligned1, yCoord + 1.0, zAligned2, minX, minY);
        tessellator.addVertexWithUV(xAligned1, yCoord + 0.0, zAligned2, minX, maxY);
        tessellator.addVertexWithUV(xAligned2, yCoord + 0.0, zAligned2, maxX, maxY);
        tessellator.addVertexWithUV(xAligned2, yCoord + 1.0, zAligned2, maxX, minY);
    }

    public void renderCrossedSquaresTextureOnlyAngled(Block block, int textureInIndex, double xCoord, double yCoord, double zCoord) {
        Tessellator tessellator = Tessellator.instance;
        int texture = textureInIndex;
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xScale = (texture & 0xF) << 4;
        int totalIndex = texture & 0xFF0;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        tessellator.addVertexWithUV(xCoord + 0.5, yCoord + 1.0, zCoord + 1.0, minX, minY);
        tessellator.addVertexWithUV(xCoord + 0.5, yCoord, zCoord + 1.0, minX, maxY);
        tessellator.addVertexWithUV(xCoord + 0.5, yCoord, zCoord, maxX, maxY);
        tessellator.addVertexWithUV(xCoord + 0.5, yCoord + 1.0, zCoord, maxX, minY);
        tessellator.addVertexWithUV(xCoord + 0.5, yCoord, zCoord + 1.0, maxX, maxY);
        tessellator.addVertexWithUV(xCoord + 0.5, yCoord + 1.0, zCoord + 1.0, maxX, minY);
        tessellator.addVertexWithUV(xCoord + 0.5, yCoord + 1.0, zCoord, minX, minY);
        tessellator.addVertexWithUV(xCoord + 0.5, yCoord, zCoord, minX, maxY);
        tessellator.addVertexWithUV(xCoord + 1.0, yCoord, zCoord + 0.5, maxX, maxY);
        tessellator.addVertexWithUV(xCoord + 1.0, yCoord + 1.0, zCoord + 0.5, maxX, minY);
        tessellator.addVertexWithUV(xCoord, yCoord + 1.0, zCoord + 0.5, minX, minY);
        tessellator.addVertexWithUV(xCoord, yCoord, zCoord + 0.5, minX, maxY);
        tessellator.addVertexWithUV(xCoord + 1.0, yCoord + 1.0, zCoord + 0.5, minX, minY);
        tessellator.addVertexWithUV(xCoord + 1.0, yCoord, zCoord + 0.5, minX, maxY);
        tessellator.addVertexWithUV(xCoord, yCoord, zCoord + 0.5, maxX, maxY);
        tessellator.addVertexWithUV(xCoord, yCoord + 1.0, zCoord + 0.5, maxX, minY);
    }

    public boolean renderBlockBouquet(Block block, int xCoord, int yCoord, int zCoord) {
        Tessellator tessellator = Tessellator.instance;
        float lightFloat = block.getBlockBrightness(this.blockAccess, xCoord, yCoord, zCoord);
        if (Block.lightValue[block.blockID] > 0) {
            lightFloat = 1.0f;
        }
        tessellator.setColorOpaque_F(lightFloat, lightFloat, lightFloat);
        double xDouble = xCoord;
        double yDouble = yCoord;
        double zDouble = zCoord;
        this.renderPlantTextureOnly(block, block.blockIndexInTexture, xDouble, yDouble, zDouble);
        return true;
    }

    public boolean renderBlockAlwaysLit(Block block, int xCoord, int yCoord, int zCoord) {
        Tessellator tessellator = Tessellator.instance;
        float lightFloat = 1.0f;
        tessellator.setColorOpaque_F(lightFloat, lightFloat - 0.1f, lightFloat - 0.2f);
        this.renderStandardBlockLit(block, xCoord, yCoord, zCoord);
        return true;
    }

    public boolean renderStandardBlockLit(Block var1, int var2, int var3, int var4) {
        int var5 = var1.colorMultiplier(this.blockAccess, var2, var3, var4);
        float var6 = (float)(var5 >> 16 & 0xFF) / 255.0f;
        float var7 = (float)(var5 >> 8 & 0xFF) / 255.0f;
        float var8 = (float)(var5 & 0xFF) / 255.0f;
        if (EntityRenderer.field_28135_a) {
            float var9 = (var6 * 30.0f + var7 * 59.0f + var8 * 11.0f) / 100.0f;
            float var10 = (var6 * 30.0f + var7 * 70.0f) / 100.0f;
            float var11 = (var6 * 30.0f + var8 * 70.0f) / 100.0f;
            var6 = var9;
            var7 = var10;
            var8 = var11;
        }
        return this.renderStandardBlockWithColorMultiplier(var1, var2, var3, var4, 255.0f, 205.0f, 165.0f);
    }

    public void renderCropsTextureOnlyDISTORTED(Block block, int textureInIndex, double xCoord, double yCoord, double zCoord) {
        Tessellator tessellator = Tessellator.instance;
        int texture = textureInIndex;
        if (this.overrideBlockTexture >= 0) {
            texture = this.overrideBlockTexture;
        }
        int xScale = (texture & 0xF) << 4;
        int totalIndex = texture & 0xFF0;
        double minX = (float)xScale / 256.0f;
        double maxX = ((float)xScale + 15.99f) / 256.0f;
        double minY = (float)totalIndex / 512.0f;
        double maxY = ((float)totalIndex + 15.99f) / 512.0f;
        double xAligned1 = xCoord + 0.5 - 0.25;
        double xAligned2 = xCoord + 0.5 + 0.25;
        double zAligned1 = zCoord + 0.5 - 0.5;
        double zAligned2 = zCoord + 0.5 + 0.5;
        tessellator.addDistortedVertexWithUV(xAligned1, yCoord + 1.0, zAligned1, minX, minY);
        tessellator.addDistortedVertexWithUV(xAligned1, yCoord + 0.0, zAligned1, minX, maxY);
        tessellator.addDistortedVertexWithUV(xAligned1, yCoord + 0.0, zAligned2, maxX, maxY);
        tessellator.addDistortedVertexWithUV(xAligned1, yCoord + 1.0, zAligned2, maxX, minY);
        tessellator.addDistortedVertexWithUV(xAligned1, yCoord + 1.0, zAligned2, minX, minY);
        tessellator.addDistortedVertexWithUV(xAligned1, yCoord + 0.0, zAligned2, minX, maxY);
        tessellator.addDistortedVertexWithUV(xAligned1, yCoord + 0.0, zAligned1, maxX, maxY);
        tessellator.addDistortedVertexWithUV(xAligned1, yCoord + 1.0, zAligned1, maxX, minY);
        tessellator.addDistortedVertexWithUV(xAligned2, yCoord + 1.0, zAligned2, minX, minY);
        tessellator.addDistortedVertexWithUV(xAligned2, yCoord + 0.0, zAligned2, minX, maxY);
        tessellator.addDistortedVertexWithUV(xAligned2, yCoord + 0.0, zAligned1, maxX, maxY);
        tessellator.addDistortedVertexWithUV(xAligned2, yCoord + 1.0, zAligned1, maxX, minY);
        tessellator.addDistortedVertexWithUV(xAligned2, yCoord + 1.0, zAligned1, minX, minY);
        tessellator.addDistortedVertexWithUV(xAligned2, yCoord + 0.0, zAligned1, minX, maxY);
        tessellator.addDistortedVertexWithUV(xAligned2, yCoord + 0.0, zAligned2, maxX, maxY);
        tessellator.addDistortedVertexWithUV(xAligned2, yCoord + 1.0, zAligned2, maxX, minY);
        xAligned1 = xCoord + 0.5 - 0.5;
        xAligned2 = xCoord + 0.5 + 0.5;
        zAligned1 = zCoord + 0.5 - 0.25;
        zAligned2 = zCoord + 0.5 + 0.25;
        tessellator.addDistortedVertexWithUV(xAligned1, yCoord + 1.0, zAligned1, minX, minY);
        tessellator.addDistortedVertexWithUV(xAligned1, yCoord + 0.0, zAligned1, minX, maxY);
        tessellator.addDistortedVertexWithUV(xAligned2, yCoord + 0.0, zAligned1, maxX, maxY);
        tessellator.addDistortedVertexWithUV(xAligned2, yCoord + 1.0, zAligned1, maxX, minY);
        tessellator.addDistortedVertexWithUV(xAligned2, yCoord + 1.0, zAligned1, minX, minY);
        tessellator.addDistortedVertexWithUV(xAligned2, yCoord + 0.0, zAligned1, minX, maxY);
        tessellator.addDistortedVertexWithUV(xAligned1, yCoord + 0.0, zAligned1, maxX, maxY);
        tessellator.addDistortedVertexWithUV(xAligned1, yCoord + 1.0, zAligned1, maxX, minY);
        tessellator.addDistortedVertexWithUV(xAligned2, yCoord + 1.0, zAligned2, minX, minY);
        tessellator.addDistortedVertexWithUV(xAligned2, yCoord + 0.0, zAligned2, minX, maxY);
        tessellator.addDistortedVertexWithUV(xAligned1, yCoord + 0.0, zAligned2, maxX, maxY);
        tessellator.addDistortedVertexWithUV(xAligned1, yCoord + 1.0, zAligned2, maxX, minY);
        tessellator.addDistortedVertexWithUV(xAligned1, yCoord + 1.0, zAligned2, minX, minY);
        tessellator.addDistortedVertexWithUV(xAligned1, yCoord + 0.0, zAligned2, minX, maxY);
        tessellator.addDistortedVertexWithUV(xAligned2, yCoord + 0.0, zAligned2, maxX, maxY);
        tessellator.addDistortedVertexWithUV(xAligned2, yCoord + 1.0, zAligned2, maxX, minY);
    }

    public boolean renderCauldron(Block var1, int var2, int var3, int var4) {
        Tessellator instance = Tessellator.instance;
        float light = var1.getBlockBrightness(this.blockAccess, var2, var3, var4);
        float lNE = 0.8f;
        float lEW = 0.6f;
        float lBelow = 0.5f;
        float lAbove = 1.0f;
        float var110 = light;
        float var120 = var1.getBlockBrightness(this.blockAccess, var2 + 1, var3, var4);
        if (var120 < var110) {
            var120 = var110;
        }
        instance.setColorOpaque_F(lEW * var120, lEW * var120, lEW * var120);
        this.renderWestFace(var1, var2, var3, (double)var4 - 0.876, 413);
        this.renderWestFace(var1, var2, var3, var4, 413);
        var120 = var1.getBlockBrightness(this.blockAccess, var2 - 1, var3, var4);
        if (var120 < var110) {
            var120 = var110;
        }
        instance.setColorOpaque_F(lEW * var120, lEW * var120, lEW * var120);
        this.renderEastFace(var1, var2, var3, var4, 413);
        this.renderEastFace(var1, var2, var3, (double)var4 + 0.876, 413);
        var120 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 - 1);
        if (var120 < var110) {
            var120 = var110;
        }
        instance.setColorOpaque_F(lNE * var120, lNE * var120, lNE * var120);
        this.renderNorthFace(var1, var2, var3, var4, 413);
        this.renderNorthFace(var1, (double)var2 + 0.876, var3, var4, 413);
        var120 = var1.getBlockBrightness(this.blockAccess, var2, var3, var4 + 1);
        if (var120 < var110) {
            var120 = var110;
        }
        instance.setColorOpaque_F(lNE * var120, lNE * var120, lNE * var120);
        this.renderSouthFace(var1, var2, var3, var4, 413);
        this.renderSouthFace(var1, (double)var2 - 0.876, var3, var4, 413);
        var120 = var1.getBlockBrightness(this.blockAccess, var2, var3 - 1, var4);
        if (var120 < var110) {
            var120 = var110;
        }
        instance.setColorOpaque_F(lBelow * var120, lBelow * var120, lBelow * var120);
        this.renderBottomFace(var1, var2, var3, var4, 397);
        this.renderBottomFace(var1, var2, (double)var3 + 0.125, var4, 396);
        var120 = var1.getBlockBrightness(this.blockAccess, var2, var3 + 1, var4);
        if (var120 < var110) {
            var120 = var110;
        }
        instance.setColorOpaque_F(lAbove * var120, lAbove * var120, lAbove * var120);
        this.renderTopFace(var1, var2, (double)var3 - 0.75, var4, 396);
        this.renderTopFace(var1, var2, var3, var4, 412);
        TileEntityCauldron cauldron = (TileEntityCauldron)this.blockAccess.getBlockTileEntity(var2, var3, var4);
        if (cauldron.holdingpotion) {
            if (cauldron.recipestage == 0) {
                this.renderTopFace(var1, var2, (double)var3 - 0.175, var4, 205);
            } else {
                instance.setColorOpaque_F((float)Effect.getRedFromColor(Effect.getColorFromDamage(cauldron.curpotion)) / 255.0f, (float)Effect.getGreenFromColor(Effect.getColorFromDamage(cauldron.curpotion)) / 255.0f, (float)Effect.getBlueFromColor(Effect.getColorFromDamage(cauldron.curpotion)) / 255.0f);
                this.renderTopFace(var1, var2, (double)var3 - 0.175, var4, 429);
            }
        }
        return true;
    }

    private boolean renderBlockAnvil(BlockAnvil par1BlockAnvil, int par2, int par3, int par4) {
        return this.renderBlockAnvilMetadata(par1BlockAnvil, par2, par3, par4, this.blockAccess.getBlockMetadata(par2, par3, par4));
    }

    public boolean renderBlockAnvilMetadata(BlockAnvil par1BlockAnvil, int par2, int par3, int par4, int par5) {
        Tessellator var6 = Tessellator.instance;
        float var7 = 1.0f;
        int var8 = par1BlockAnvil.colorMultiplier(this.blockAccess, par2, par3, par4);
        float var9 = (float)(var8 >> 16 & 0xFF) / 255.0f;
        float var10 = (float)(var8 >> 8 & 0xFF) / 255.0f;
        float var11 = (float)(var8 & 0xFF) / 255.0f;
        if (EntityRenderer.field_28135_a) {
            float var12 = (var9 * 30.0f + var10 * 59.0f + var11 * 11.0f) / 100.0f;
            float var13 = (var9 * 30.0f + var10 * 70.0f) / 100.0f;
            float var14 = (var9 * 30.0f + var11 * 70.0f) / 100.0f;
            var9 = var12;
            var10 = var13;
            var11 = var14;
        }
        var6.setColorOpaque_F(var7 * var9, var7 * var10, var7 * var11);
        return this.renderBlockAnvilOrient(par1BlockAnvil, par2, par3, par4, par5, false);
    }

    private boolean renderBlockAnvilOrient(BlockAnvil par1BlockAnvil, int par2, int par3, int par4, int par5, boolean par6) {
        int var7 = par6 ? 0 : par5 & 3;
        boolean var8 = false;
        float var9 = 0.0f;
        switch (var7) {
            case 0: {
                this.uvRotateSouthFace = 2;
                this.uvRotateNorth = 1;
                this.uvRotateTop = 3;
                this.uvRotateBottom = 3;
                break;
            }
            case 1: {
                this.uvRotateEast = 1;
                this.uvRotateWest = 2;
                this.uvRotateTop = 2;
                this.uvRotateBottom = 1;
                var8 = true;
                break;
            }
            case 2: {
                this.uvRotateSouthFace = 1;
                this.uvRotateNorth = 2;
                break;
            }
            case 3: {
                this.uvRotateEast = 2;
                this.uvRotateWest = 1;
                this.uvRotateTop = 1;
                this.uvRotateBottom = 2;
                var8 = true;
            }
        }
        var9 = this.renderBlockAnvilRotate(par1BlockAnvil, par2, par3, par4, 0, var9, 0.75f, 0.25f, 0.75f, var8, par6, par5);
        var9 = this.renderBlockAnvilRotate(par1BlockAnvil, par2, par3, par4, 2, var9, 0.25f, 0.3125f, 0.5f, var8, par6, par5);
        this.renderBlockAnvilRotate(par1BlockAnvil, par2, par3, par4, 3, var9, 0.625f, 0.375f, 1.0f, var8, par6, par5);
        par1BlockAnvil.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.uvRotateEast = 0;
        this.uvRotateWest = 0;
        this.uvRotateSouthFace = 0;
        this.uvRotateNorth = 0;
        this.uvRotateTop = 0;
        this.uvRotateBottom = 0;
        return true;
    }

    private float renderBlockAnvilRotate(BlockAnvil par1BlockAnvil, int par2, int par3, int par4, int par5, float miny, float x, float maxy, float z, boolean par10, boolean par11, int par12) {
        if (par10) {
            float var13 = x;
            x = z;
            z = var13;
        }
        par1BlockAnvil.setBlockBounds(0.5f - (x /= 2.0f), miny, 0.5f - (z /= 2.0f), 0.5f + x, miny + maxy, 0.5f + z);
        if (par11) {
            Tessellator var14 = Tessellator.instance;
            var14.startDrawingQuads();
            var14.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(par1BlockAnvil, 0.0, 0.0, 0.0, par1BlockAnvil.getBlockTextureFromSideAndMetadata(0, par12));
            var14.draw();
            var14.startDrawingQuads();
            var14.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(par1BlockAnvil, 0.0, 0.0, 0.0, par1BlockAnvil.getBlockTextureFromSideAndMetadata(1, par12));
            var14.draw();
            var14.startDrawingQuads();
            var14.setNormal(0.0f, 0.0f, -1.0f);
            this.renderEastFace(par1BlockAnvil, 0.0, 0.0, 0.0, par1BlockAnvil.getBlockTextureFromSideAndMetadata(2, par12));
            var14.draw();
            var14.startDrawingQuads();
            var14.setNormal(0.0f, 0.0f, 1.0f);
            this.renderWestFace(par1BlockAnvil, 0.0, 0.0, 0.0, par1BlockAnvil.getBlockTextureFromSideAndMetadata(3, par12));
            var14.draw();
            var14.startDrawingQuads();
            var14.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderNorthFace(par1BlockAnvil, 0.0, 0.0, 0.0, par1BlockAnvil.getBlockTextureFromSideAndMetadata(4, par12));
            var14.draw();
            var14.startDrawingQuads();
            var14.setNormal(1.0f, 0.0f, 0.0f);
            this.renderSouthFace(par1BlockAnvil, 0.0, 0.0, 0.0, par1BlockAnvil.getBlockTextureFromSideAndMetadata(5, par12));
            var14.draw();
        } else {
            this.renderStandardBlock(par1BlockAnvil, par2, par3, par4);
        }
        return miny + maxy;
    }
}

