/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.renderer.entity;

import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class OpenGlHelper {
    public static int defaultTexUnit;
    public static int lightmapTexUnit;
    private static boolean useMultitextureARB;

    static {
        useMultitextureARB = false;
    }

    public static void initializeTextures() {
        boolean bl = useMultitextureARB = GLContext.getCapabilities().GL_ARB_multitexture && !GLContext.getCapabilities().OpenGL11;
        if (useMultitextureARB) {
            defaultTexUnit = 33984;
            lightmapTexUnit = 33985;
        } else {
            defaultTexUnit = 33984;
            lightmapTexUnit = 33985;
        }
    }

    public static void setActiveTexture(int i) {
        if (useMultitextureARB) {
            ARBMultitexture.glActiveTextureARB((int)i);
        } else {
            GL11.glIsTexture((int)i);
        }
    }

    public static void setClientActiveTexture(int i) {
        if (useMultitextureARB) {
            ARBMultitexture.glClientActiveTextureARB((int)i);
        } else {
            GL11.glIsTexture((int)i);
        }
    }

    public static void setLightmapTextureCoords(int i, float f, float f1) {
        if (useMultitextureARB) {
            ARBMultitexture.glMultiTexCoord2fARB((int)i, (float)f, (float)f1);
        } else {
            GL11.glIsTexture((int)i);
        }
    }

    public static void glBlendFunc(int sFactorRGB, int dFactorRGB, int sfactorAlpha, int dfactorAlpha) {
        GL11.glBlendFunc((int)sFactorRGB, (int)dFactorRGB);
    }
}

