/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.renderer.entity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.src.client.GameSettings;
import net.minecraft.src.client.gui.FontRenderer;
import net.minecraft.src.client.model.ModelBiped;
import net.minecraft.src.client.model.ModelChicken;
import net.minecraft.src.client.model.ModelCow;
import net.minecraft.src.client.model.ModelFox;
import net.minecraft.src.client.model.ModelPig;
import net.minecraft.src.client.model.ModelSheep1;
import net.minecraft.src.client.model.ModelSheep2;
import net.minecraft.src.client.model.ModelSkeleton;
import net.minecraft.src.client.model.ModelSlime;
import net.minecraft.src.client.model.ModelSquid;
import net.minecraft.src.client.model.ModelStroldianBase;
import net.minecraft.src.client.model.ModelWolf;
import net.minecraft.src.client.model.ModelZombie;
import net.minecraft.src.client.renderer.ItemRenderer;
import net.minecraft.src.client.renderer.RenderEngine;
import net.minecraft.src.client.renderer.entity.Render;
import net.minecraft.src.client.renderer.entity.RenderArmouredSkeleton;
import net.minecraft.src.client.renderer.entity.RenderArmouredZombie;
import net.minecraft.src.client.renderer.entity.RenderArrow;
import net.minecraft.src.client.renderer.entity.RenderArrowGolden;
import net.minecraft.src.client.renderer.entity.RenderArrowPurple;
import net.minecraft.src.client.renderer.entity.RenderBiped;
import net.minecraft.src.client.renderer.entity.RenderBlaze;
import net.minecraft.src.client.renderer.entity.RenderBoat;
import net.minecraft.src.client.renderer.entity.RenderBrick;
import net.minecraft.src.client.renderer.entity.RenderChair;
import net.minecraft.src.client.renderer.entity.RenderChicken;
import net.minecraft.src.client.renderer.entity.RenderCow;
import net.minecraft.src.client.renderer.entity.RenderCreeper;
import net.minecraft.src.client.renderer.entity.RenderDynamiteStick;
import net.minecraft.src.client.renderer.entity.RenderEntity;
import net.minecraft.src.client.renderer.entity.RenderExplosiveFireball;
import net.minecraft.src.client.renderer.entity.RenderFallingSand;
import net.minecraft.src.client.renderer.entity.RenderFireball;
import net.minecraft.src.client.renderer.entity.RenderFireball2;
import net.minecraft.src.client.renderer.entity.RenderFish;
import net.minecraft.src.client.renderer.entity.RenderFox;
import net.minecraft.src.client.renderer.entity.RenderGhast;
import net.minecraft.src.client.renderer.entity.RenderGiantZombie;
import net.minecraft.src.client.renderer.entity.RenderItem;
import net.minecraft.src.client.renderer.entity.RenderLightningBolt;
import net.minecraft.src.client.renderer.entity.RenderLiving;
import net.minecraft.src.client.renderer.entity.RenderMinecart;
import net.minecraft.src.client.renderer.entity.RenderMoobloom;
import net.minecraft.src.client.renderer.entity.RenderMooshroom;
import net.minecraft.src.client.renderer.entity.RenderPainting;
import net.minecraft.src.client.renderer.entity.RenderPig;
import net.minecraft.src.client.renderer.entity.RenderPlayer;
import net.minecraft.src.client.renderer.entity.RenderSheep;
import net.minecraft.src.client.renderer.entity.RenderSign;
import net.minecraft.src.client.renderer.entity.RenderSkeleton;
import net.minecraft.src.client.renderer.entity.RenderSlime;
import net.minecraft.src.client.renderer.entity.RenderSnowball;
import net.minecraft.src.client.renderer.entity.RenderSpeechBubble;
import net.minecraft.src.client.renderer.entity.RenderSpider;
import net.minecraft.src.client.renderer.entity.RenderSquid;
import net.minecraft.src.client.renderer.entity.RenderStroldianBase;
import net.minecraft.src.client.renderer.entity.RenderTNTPrimed;
import net.minecraft.src.client.renderer.entity.RenderTorch;
import net.minecraft.src.client.renderer.entity.RenderWolf;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.animals.EntityChicken;
import net.minecraft.src.game.entity.animals.EntityCow;
import net.minecraft.src.game.entity.animals.EntityFox;
import net.minecraft.src.game.entity.animals.EntityMoobloom;
import net.minecraft.src.game.entity.animals.EntityMooshroom;
import net.minecraft.src.game.entity.animals.EntityPig;
import net.minecraft.src.game.entity.animals.EntitySheep;
import net.minecraft.src.game.entity.animals.EntitySquid;
import net.minecraft.src.game.entity.animals.EntityStroldian;
import net.minecraft.src.game.entity.animals.EntityWolf;
import net.minecraft.src.game.entity.monster.EntityBiped;
import net.minecraft.src.game.entity.monster.EntityBlaze;
import net.minecraft.src.game.entity.monster.EntityCreeper;
import net.minecraft.src.game.entity.monster.EntityGhast;
import net.minecraft.src.game.entity.monster.EntityGiantZombie;
import net.minecraft.src.game.entity.monster.EntitySkeleton;
import net.minecraft.src.game.entity.monster.EntitySkeletonArmored;
import net.minecraft.src.game.entity.monster.EntitySlime;
import net.minecraft.src.game.entity.monster.EntitySpider;
import net.minecraft.src.game.entity.monster.EntityZombie;
import net.minecraft.src.game.entity.monster.EntityZombieArmored;
import net.minecraft.src.game.entity.other.EntityArrow;
import net.minecraft.src.game.entity.other.EntityArrowGolden;
import net.minecraft.src.game.entity.other.EntityArrowPurple;
import net.minecraft.src.game.entity.other.EntityBoat;
import net.minecraft.src.game.entity.other.EntityBrick;
import net.minecraft.src.game.entity.other.EntityChair;
import net.minecraft.src.game.entity.other.EntityDynamite;
import net.minecraft.src.game.entity.other.EntityEgg;
import net.minecraft.src.game.entity.other.EntityFallingSand;
import net.minecraft.src.game.entity.other.EntityFireball;
import net.minecraft.src.game.entity.other.EntityFish;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.entity.other.EntityLightningBolt;
import net.minecraft.src.game.entity.other.EntityMinecart;
import net.minecraft.src.game.entity.other.EntityPainting;
import net.minecraft.src.game.entity.other.EntitySmallExplosiveFireball;
import net.minecraft.src.game.entity.other.EntitySmallFireball;
import net.minecraft.src.game.entity.other.EntitySnowball;
import net.minecraft.src.game.entity.other.EntitySpeechBubble;
import net.minecraft.src.game.entity.other.EntityTNTPrimed;
import net.minecraft.src.game.entity.other.EntityTorch;
import net.minecraft.src.game.entity.other.SignEntity;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.level.World;
import org.lwjgl.opengl.GL11;

public class RenderManager {
    private Map entityRenderMap = new HashMap();
    public static RenderManager instance = new RenderManager();
    FontRenderer fontRenderer;
    public static double renderPosX;
    public static double renderPosY;
    public static double renderPosZ;
    public RenderEngine renderEngine;
    public ItemRenderer itemRenderer;
    public World worldObj;
    public EntityLiving livingPlayer;
    public float playerViewY;
    public float playerViewX;
    public GameSettings options;
    public double field_1222_l;
    public double field_1221_m;
    public double field_1220_n;

    private RenderManager() {
        this.entityRenderMap.put(EntitySpider.class, new RenderSpider());
        this.entityRenderMap.put(EntityPig.class, new RenderPig(new ModelPig(), new ModelPig(0.5f), 0.7f));
        this.entityRenderMap.put(EntitySheep.class, new RenderSheep(new ModelSheep2(), new ModelSheep1(), 0.7f));
        this.entityRenderMap.put(EntityCow.class, new RenderCow(new ModelCow(), 0.7f));
        this.entityRenderMap.put(EntityWolf.class, new RenderWolf(new ModelWolf(), 0.5f));
        this.entityRenderMap.put(EntityChicken.class, new RenderChicken(new ModelChicken(), 0.3f));
        this.entityRenderMap.put(EntityCreeper.class, new RenderCreeper());
        this.entityRenderMap.put(EntitySkeleton.class, new RenderSkeleton(new ModelSkeleton(), 0.5f));
        this.entityRenderMap.put(EntityZombie.class, new RenderBiped(new ModelZombie(), 0.5f));
        this.entityRenderMap.put(EntitySlime.class, new RenderSlime(new ModelSlime(16), new ModelSlime(0), 0.25f));
        this.entityRenderMap.put(EntityPlayer.class, new RenderPlayer());
        this.entityRenderMap.put(EntityGiantZombie.class, new RenderGiantZombie(new ModelZombie(), 0.5f, 6.0f));
        this.entityRenderMap.put(EntityGhast.class, new RenderGhast());
        this.entityRenderMap.put(EntitySquid.class, new RenderSquid(new ModelSquid(), 0.7f));
        this.entityRenderMap.put(EntityLiving.class, new RenderLiving(new ModelBiped(), 0.5f));
        this.entityRenderMap.put(Entity.class, new RenderEntity());
        this.entityRenderMap.put(EntityPainting.class, new RenderPainting());
        this.entityRenderMap.put(EntityArrow.class, new RenderArrow());
        this.entityRenderMap.put(EntitySnowball.class, new RenderSnowball(Item.snowball.getIconFromDamage(0)));
        this.entityRenderMap.put(EntityEgg.class, new RenderSnowball(Item.egg.getIconFromDamage(0)));
        this.entityRenderMap.put(EntityFireball.class, new RenderFireball());
        this.entityRenderMap.put(EntityItem.class, new RenderItem());
        this.entityRenderMap.put(EntityTNTPrimed.class, new RenderTNTPrimed());
        this.entityRenderMap.put(EntityFallingSand.class, new RenderFallingSand());
        this.entityRenderMap.put(EntityMinecart.class, new RenderMinecart());
        this.entityRenderMap.put(EntityBoat.class, new RenderBoat());
        this.entityRenderMap.put(EntityFish.class, new RenderFish());
        this.entityRenderMap.put(EntityLightningBolt.class, new RenderLightningBolt());
        this.entityRenderMap.put(EntityBiped.class, new RenderBiped(new ModelBiped(), 0.5f));
        this.entityRenderMap.put(EntityFox.class, new RenderFox(new ModelFox(), 0.5f));
        this.entityRenderMap.put(EntityArrowGolden.class, new RenderArrowGolden());
        this.entityRenderMap.put(EntityBiped.class, new RenderBiped(new ModelBiped(), 0.5f));
        this.entityRenderMap.put(EntityBlaze.class, new RenderBlaze());
        this.entityRenderMap.put(EntitySmallFireball.class, new RenderFireball2(0.5f));
        this.entityRenderMap.put(EntitySmallExplosiveFireball.class, new RenderExplosiveFireball(0.5f));
        this.entityRenderMap.put(EntityMooshroom.class, new RenderMooshroom(new ModelCow(), 0.7f, Block.mushroomRed));
        this.entityRenderMap.put(EntityMoobloom.class, new RenderMoobloom(new ModelCow(), 0.7f, Block.dandelion));
        this.entityRenderMap.put(EntityStroldian.class, new RenderStroldianBase(new ModelStroldianBase(), 0.5f));
        this.entityRenderMap.put(EntityChair.class, new RenderChair());
        this.entityRenderMap.put(EntityZombieArmored.class, new RenderArmouredZombie(new ModelZombie(), 0.5f));
        this.entityRenderMap.put(EntitySkeletonArmored.class, new RenderArmouredSkeleton(new ModelSkeleton(), 0.5f));
        this.entityRenderMap.put(EntityDynamite.class, new RenderDynamiteStick());
        this.entityRenderMap.put(EntityArrowPurple.class, new RenderArrowPurple());
        this.entityRenderMap.put(SignEntity.class, new RenderSign());
        this.entityRenderMap.put(EntityTorch.class, new RenderTorch());
        this.entityRenderMap.put(EntityBrick.class, new RenderBrick());
        this.entityRenderMap.put(EntitySpeechBubble.class, new RenderSpeechBubble());
        for (Render var2 : this.entityRenderMap.values()) {
            var2.setRenderManager(this);
        }
    }

    public Render getEntityClassRenderObject(Class var1) {
        Render var2 = (Render)this.entityRenderMap.get(var1);
        if (var2 == null && var1 != Entity.class) {
            var2 = this.getEntityClassRenderObject(var1.getSuperclass());
            this.entityRenderMap.put(var1, var2);
        }
        return var2;
    }

    public Render getEntityRenderObject(Entity var1) {
        return this.getEntityClassRenderObject(var1.getClass());
    }

    public void cacheActiveRenderInfo(World var1, RenderEngine var2, FontRenderer var3, EntityLiving var4, GameSettings var5, float var6) {
        this.worldObj = var1;
        this.renderEngine = var2;
        this.options = var5;
        this.livingPlayer = var4;
        this.fontRenderer = var3;
        if (var4.isPlayerSleeping()) {
            int var7 = var1.getBlockId(MathHelper.floor_double(var4.posX), MathHelper.floor_double(var4.posY), MathHelper.floor_double(var4.posZ));
            if (var7 == Block.blockBed.blockID) {
                int var8 = var1.getBlockMetadata(MathHelper.floor_double(var4.posX), MathHelper.floor_double(var4.posY), MathHelper.floor_double(var4.posZ));
                int var9 = var8 & 3;
                this.playerViewY = var9 * 90 + 180;
                this.playerViewX = 0.0f;
            }
        } else {
            this.playerViewY = var4.prevRotationYaw + (var4.rotationYaw - var4.prevRotationYaw) * var6;
            this.playerViewX = var4.prevRotationPitch + (var4.rotationPitch - var4.prevRotationPitch) * var6;
        }
        this.field_1222_l = var4.lastTickPosX + (var4.posX - var4.lastTickPosX) * (double)var6;
        this.field_1221_m = var4.lastTickPosY + (var4.posY - var4.lastTickPosY) * (double)var6;
        this.field_1220_n = var4.lastTickPosZ + (var4.posZ - var4.lastTickPosZ) * (double)var6;
        if (var5.thirdPersonView == 2) {
            this.playerViewY = 180.0f;
        }
    }

    public void renderEntity(Entity var1, float var2) {
        double var3 = var1.lastTickPosX + (var1.posX - var1.lastTickPosX) * (double)var2;
        double var5 = var1.lastTickPosY + (var1.posY - var1.lastTickPosY) * (double)var2;
        double var7 = var1.lastTickPosZ + (var1.posZ - var1.lastTickPosZ) * (double)var2;
        float var9 = var1.prevRotationYaw + (var1.rotationYaw - var1.prevRotationYaw) * var2;
        float var10 = var1.getEntityBrightness(var2);
        GL11.glColor3f((float)var10, (float)var10, (float)var10);
        this.renderEntityWithPosYaw(var1, var3 - renderPosX, var5 - renderPosY, var7 - renderPosZ, var9, var2);
    }

    public void renderEntityWithPosYaw(Entity var1, double var2, double var4, double var6, float var8, float var9) {
        Render var10 = this.getEntityRenderObject(var1);
        if (var10 != null) {
            var10.doRender(var1, var2, var4, var6, var8, var9);
            var10.doRenderShadowAndFire(var1, var2, var4, var6, var8, var9);
        }
    }

    public void func_852_a(World var1) {
        this.worldObj = var1;
    }

    public double func_851_a(double var1, double var3, double var5) {
        double var7 = var1 - this.field_1222_l;
        double var9 = var3 - this.field_1221_m;
        double var11 = var5 - this.field_1220_n;
        return var7 * var7 + var9 * var9 + var11 * var11;
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }
}

