/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.renderer.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.src.client.GameSettings;
import net.minecraft.src.client.gui.FontRenderer;
import net.minecraft.src.client.model.ModelBiped2;
import net.minecraft.src.client.player.EntityPlayerSP;
import net.minecraft.src.client.renderer.RenderBlocks;
import net.minecraft.src.client.renderer.Tessellator;
import net.minecraft.src.client.renderer.entity.RenderLiving2;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.entity.player.EnumPlayerAction;
import net.minecraft.src.game.item.EnumAction;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemArmor;
import net.minecraft.src.game.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class RenderPlayer
extends RenderLiving2 {
    private ModelBiped2 modelBipedMain;
    private ModelBiped2 modelArmorChestplate;
    private ModelBiped2 modelArmor;
    private static final String[] armorFilenamePrefix = new String[]{"cloth", "chain", "iron", "diamond", "gold"};

    public RenderPlayer() {
        super(new ModelBiped2(0.0f), 0.5f);
        this.modelBipedMain = (ModelBiped2)this.mainModel;
        this.modelArmorChestplate = new ModelBiped2(1.0f);
        this.modelArmor = new ModelBiped2(0.5f);
    }

    protected int setArmorModel(EntityPlayer var1, int var2, float var3) {
        Item var5;
        ItemStack var4 = var1.inventory.armorItemInSlot(3 - var2);
        if (var4 != null && (var5 = var4.getItem()) instanceof ItemArmor) {
            ItemArmor var6 = (ItemArmor)var5;
            this.loadTexture("/armor/" + armorFilenamePrefix[var6.renderIndex] + "_" + (var2 == 2 ? 2 : 1) + ".png");
            ModelBiped2 var7 = var2 == 2 ? this.modelArmor : this.modelArmorChestplate;
            var7.bipedHead.showModel = var2 == 0;
            var7.bipedHeadwear.showModel = var2 == 0;
            var7.bipedBody.showModel = var2 == 1 || var2 == 2;
            var7.bipedRightArm.showModel = var2 == 1;
            var7.bipedLeftArm.showModel = var2 == 1;
            var7.bipedRightLeg.showModel = var2 == 2 || var2 == 3;
            var7.bipedLeftLeg.showModel = var2 == 2 || var2 == 3;
            this.setRenderPassModel(var7);
            return 1;
        }
        return -1;
    }

    public void renderPlayer(EntityPlayer var1, double var2, double var4, double var6, float var8, float var9) {
        ItemStack var10 = var1.inventory.getCurrentItem();
        this.modelBipedMain.heldItemRight = var10 != null ? 1 : 0;
        this.modelArmor.heldItemRight = this.modelBipedMain.heldItemRight;
        this.modelArmorChestplate.heldItemRight = this.modelBipedMain.heldItemRight;
        this.modelArmor.isSneak = this.modelBipedMain.isSneak = var1.isSneaking();
        this.modelArmorChestplate.isSneak = this.modelBipedMain.isSneak;
        double var11 = var4 - (double)var1.yOffset;
        if (var1.isSneaking() && !(var1 instanceof EntityPlayerSP)) {
            var11 -= 0.125;
        }
        if (var10 != null && var1.getItemInUseCount() > 0) {
            EnumAction var1100 = var10.getItemUseAction();
            if (var1100 == EnumAction.block) {
                this.modelBipedMain.heldItemRight = 3;
                this.modelArmor.heldItemRight = 3;
                this.modelArmorChestplate.heldItemRight = 3;
            } else if (var1100 == EnumAction.bow) {
                this.modelBipedMain.aimedBow = true;
                this.modelArmor.aimedBow = true;
                this.modelArmorChestplate.aimedBow = true;
            }
        }
        if (var10 != null && var10.itemID == Item.bow.itemID) {
            this.modelBipedMain.aimedBow = true;
            this.modelArmor.aimedBow = true;
            this.modelArmorChestplate.aimedBow = true;
        }
        if (var10 != null && var1.getBowCounter() > 0) {
            EnumPlayerAction var110 = var1.getAction();
            if (var110 == EnumPlayerAction.BLOCKING) {
                this.modelBipedMain.heldItemRight = 3;
                this.modelArmor.heldItemRight = 3;
                this.modelArmorChestplate.heldItemRight = 3;
            } else if (var110 == EnumPlayerAction.BOW) {
                this.modelBipedMain.aimedBow = true;
                this.modelArmor.aimedBow = true;
                this.modelArmorChestplate.aimedBow = true;
            } else {
                this.modelBipedMain.aimedBow = false;
                this.modelArmor.aimedBow = false;
                this.modelArmorChestplate.aimedBow = false;
            }
        }
        if (this.modelBipedMain.isRiding) {
            this.modelArmor.isRiding = true;
            this.modelArmorChestplate.isRiding = true;
        } else if (!this.modelBipedMain.isRiding) {
            this.modelArmor.isRiding = false;
            this.modelArmorChestplate.isRiding = false;
        }
        super.doRenderLiving(var1, var2, var11, var6, var8, var9);
        this.modelBipedMain.aimedBow = false;
        this.modelArmor.aimedBow = false;
        this.modelArmorChestplate.aimedBow = false;
        this.modelBipedMain.isSneak = false;
        this.modelArmor.isSneak = false;
        this.modelArmorChestplate.isSneak = false;
        this.modelBipedMain.heldItemRight = 0;
        this.modelArmor.heldItemRight = 0;
        this.modelArmorChestplate.heldItemRight = 0;
    }

    protected void renderName(EntityPlayer var1, double var2, double var4, double var6) {
        if (Minecraft.isGuiEnabled() && var1 != this.renderManager.livingPlayer) {
            float var11;
            float var8 = 1.6f;
            float var9 = 0.016666668f * var8;
            float var10 = var1.getDistanceToEntity(this.renderManager.livingPlayer);
            float f = var11 = var1.isSneaking() ? 32.0f : 64.0f;
            if (var10 < var11) {
                String var12 = var1.username;
                if (!var1.isSneaking()) {
                    if (var1.isPlayerSleeping()) {
                        this.renderLivingLabel(var1, var12, var2, var4 - 1.5, var6, 64);
                    } else {
                        this.renderLivingLabel(var1, var12, var2, var4, var6, 64);
                    }
                } else {
                    FontRenderer var13 = this.getFontRendererFromRenderManager();
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)((float)var2 + 0.0f), (float)((float)var4 + 2.3f), (float)((float)var6));
                    GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glScalef((float)(-var9), (float)(-var9), (float)var9);
                    GL11.glDisable((int)2896);
                    GL11.glTranslatef((float)0.0f, (float)(0.25f / var9), (float)0.0f);
                    GL11.glDepthMask((boolean)false);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    Tessellator var14 = Tessellator.instance;
                    GL11.glDisable((int)3553);
                    var14.startDrawingQuads();
                    int var15 = var13.getStringWidth(var12) / 2;
                    var14.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
                    var14.addVertex(-var15 - 1, -1.0, 0.0);
                    var14.addVertex(-var15 - 1, 8.0, 0.0);
                    var14.addVertex(var15 + 1, 8.0, 0.0);
                    var14.addVertex(var15 + 1, -1.0, 0.0);
                    var14.draw();
                    GL11.glEnable((int)3553);
                    GL11.glDepthMask((boolean)true);
                    var13.drawString(var12, -var13.getStringWidth(var12) / 2, 0, 0x20FFFFFF);
                    GL11.glEnable((int)2896);
                    GL11.glDisable((int)3042);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopMatrix();
                }
            }
        }
    }

    protected void renderSpecials(EntityPlayer player, float var2) {
        ItemStack heldItem;
        float renderYaw;
        ItemStack itemstack = player.inventory.armorItemInSlot(3);
        if (itemstack != null && itemstack.getItem().itemID < 256) {
            GL11.glPushMatrix();
            float light = player.worldObj.getLightBrightness(MathHelper.floor_double(player.posX), MathHelper.floor_double(player.posY), MathHelper.floor_double(player.posZ));
            if (itemstack != null) {
                int var7 = Item.itemsList[itemstack.itemID].getColorFromDamage(itemstack.getItemDamage());
                float var8 = (float)(var7 >> 16 & 0xFF) / 255.0f;
                float var9 = (float)(var7 >> 8 & 0xFF) / 255.0f;
                float var10 = (float)(var7 & 0xFF) / 255.0f;
                GL11.glColor4f((float)(light * var8), (float)(light * var9), (float)(light * var10), (float)1.0f);
            }
            this.modelBipedMain.bipedHead.postRender(0.0625f);
            if (RenderBlocks.renderItemIn3d(Block.blocksList[itemstack.itemID].getRenderType())) {
                float scale = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)scale, (float)(-scale), (float)scale);
            }
            GL11.glColor4f((float)light, (float)light, (float)light, (float)1.0f);
            this.renderManager.itemRenderer.renderItem(player, itemstack, 0);
            if (itemstack != null && itemstack.itemID == Item.potion.itemID) {
                this.renderManager.itemRenderer.renderItemPotion(player, itemstack, 0);
            }
            GL11.glPopMatrix();
        }
        if (player.username.equals("deadmau5") && this.loadDownloadableImageTexture(player.skinUrl, null)) {
            int var19 = 0;
            while (var19 < 2) {
                renderYaw = player.prevRotationYaw + (player.rotationYaw - player.prevRotationYaw) * var2 - (player.prevRenderYawOffset + (player.renderYawOffset - player.prevRenderYawOffset) * var2);
                float renderPitch = player.prevRotationPitch + (player.rotationPitch - player.prevRotationPitch) * var2;
                GL11.glPushMatrix();
                GL11.glRotatef((float)renderYaw, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)renderPitch, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(0.375f * (float)(var19 * 2 - 1)), (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.375f, (float)0.0f);
                GL11.glRotatef((float)(-renderPitch), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(-renderYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                float scale = 1.3333334f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                this.modelBipedMain.renderEars(0.0625f);
                GL11.glPopMatrix();
                ++var19;
            }
        }
        if (this.loadDownloadableImageTexture(player.playerCloakUrl, null)) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
            double var20 = player.field_20066_r + (player.field_20063_u - player.field_20066_r) * (double)var2 - (player.prevPosX + (player.posX - player.prevPosX) * (double)var2);
            double var22 = player.field_20065_s + (player.field_20062_v - player.field_20065_s) * (double)var2 - (player.prevPosY + (player.posY - player.prevPosY) * (double)var2);
            double var8 = player.field_20064_t + (player.field_20061_w - player.field_20064_t) * (double)var2 - (player.prevPosZ + (player.posZ - player.prevPosZ) * (double)var2);
            float var10 = player.prevRenderYawOffset + (player.renderYawOffset - player.prevRenderYawOffset) * var2;
            double var11 = MathHelper.sin(var10 * (float)Math.PI / 180.0f);
            double var13 = -MathHelper.cos(var10 * (float)Math.PI / 180.0f);
            float var15 = (float)var22 * 10.0f;
            if (var15 < -6.0f) {
                var15 = -6.0f;
            }
            if (var15 > 32.0f) {
                var15 = 32.0f;
            }
            float var16 = (float)(var20 * var11 + var8 * var13) * 100.0f;
            float var17 = (float)(var20 * var13 - var8 * var11) * 100.0f;
            if (var16 < 0.0f) {
                var16 = 0.0f;
            }
            float var18 = player.field_775_e + (player.field_774_f - player.field_775_e) * var2;
            var15 += MathHelper.sin((player.prevDistanceWalkedModified + (player.distanceWalkedModified - player.prevDistanceWalkedModified) * var2) * 6.0f) * 32.0f * var18;
            if (player.isSneaking()) {
                var15 += 25.0f;
            }
            GL11.glRotatef((float)(6.0f + var16 / 2.0f + var15), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(var17 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-var17 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.modelBipedMain.renderCloak(0.0625f);
            GL11.glPopMatrix();
        }
        if ((heldItem = player.inventory.getCurrentItem()) != null) {
            GL11.glPushMatrix();
            float light = player.worldObj.getLightBrightness(MathHelper.floor_double(player.posX), MathHelper.floor_double(player.posY), MathHelper.floor_double(player.posZ));
            int var7 = Item.itemsList[heldItem.itemID].getColorFromDamage(heldItem.getItemDamage());
            float red = (float)(var7 >> 16 & 0xFF) / 255.0f;
            float green = (float)(var7 >> 8 & 0xFF) / 255.0f;
            float blue = (float)(var7 & 0xFF) / 255.0f;
            GL11.glColor4f((float)(light * red), (float)(light * green), (float)(light * blue), (float)1.0f);
            this.modelBipedMain.bipedRightArm.postRender(0.0625f);
            GL11.glTranslatef((float)-0.0625f, (float)0.4375f, (float)0.0625f);
            if (player.fishEntity != null) {
                heldItem = new ItemStack(Item.stick);
            }
            EnumAction itemAction = null;
            if (player.getItemInUseCount() > 0) {
                itemAction = heldItem.getItemUseAction();
            }
            if (heldItem.itemID < 256 && RenderBlocks.renderItemIn3d(Block.blocksList[heldItem.itemID].getRenderType()) && GameSettings.itemRenderOld) {
                renderYaw = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(renderYaw *= 0.75f), (float)(-renderYaw), (float)renderYaw);
            } else if (heldItem.itemID < 256 && RenderBlocks.renderItemIn3d(Block.blocksList[heldItem.itemID].getRenderType())) {
                renderYaw = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(renderYaw *= 0.75f), (float)(-renderYaw), (float)renderYaw);
            } else if (heldItem.itemID == Item.bow.itemID) {
                light = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)0.125f, (float)0.3125f);
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)light, (float)(-light), (float)light);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (Item.itemsList[heldItem.itemID].isArrow3D()) {
                renderYaw = 0.375f;
                if (Item.itemsList[heldItem.itemID].shouldRotateAroundWhenRendering()) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
                }
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.125f);
                GL11.glScalef((float)renderYaw, (float)(-renderYaw), (float)renderYaw);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (Item.itemsList[heldItem.itemID].isFull3D()) {
                light = 0.625f;
                if (Item.itemsList[heldItem.itemID].shouldRotateAroundWhenRendering()) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
                }
                if (player.getItemInUseCount() > 0 && itemAction == EnumAction.block) {
                    GL11.glTranslatef((float)0.05f, (float)0.0f, (float)-0.1f);
                    GL11.glRotatef((float)-50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)-60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
                GL11.glScalef((float)light, (float)(-light), (float)light);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                renderYaw = 0.375f;
                GL11.glTranslatef((float)0.25f, (float)0.1875f, (float)-0.1875f);
                GL11.glScalef((float)renderYaw, (float)renderYaw, (float)renderYaw);
                GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.renderManager.itemRenderer.renderItem(player, heldItem, 0);
            if (heldItem.itemID == Item.potion.itemID) {
                GL11.glColor4f((float)light, (float)light, (float)light, (float)1.0f);
                this.renderManager.itemRenderer.renderItemPotion(player, heldItem, 0);
            }
            GL11.glPopMatrix();
        }
    }

    protected void func_186_b(EntityPlayer var1, float var2) {
        float var3 = 0.9375f;
        GL11.glScalef((float)var3, (float)var3, (float)var3);
    }

    public void drawFirstPersonHand(EntityPlayer var1) {
        this.modelBipedMain.onGround = 0.0f;
        this.modelBipedMain.setRotationAngles(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        this.modelBipedMain.bipedRightArm.render(0.0625f);
        this.modelBipedMain.isSneak = false;
        this.modelBipedMain.isRiding = false;
    }

    protected void func_22016_b(EntityPlayer player, double var2, double var4, double var6) {
        if (player.isEntityAlive() && player.isPlayerSleeping()) {
            super.renderLivingAt(player, var2 + (double)player.field_22063_x, var4 + (double)player.field_22062_y, var6 + (double)player.field_22061_z);
        } else {
            super.renderLivingAt(player, var2, var4, var6);
        }
    }

    protected void func_22017_a(EntityPlayer player, float var2, float var3, float var4) {
        if (player.isEntityAlive() && player.isPlayerSleeping()) {
            GL11.glRotatef((float)player.getBedOrientationInDegrees(), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.getDeathMaxRotation(player), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            super.rotateCorpse(player, var2, var3, var4);
        }
    }

    @Override
    protected void passSpecialRender(EntityLiving var1, double var2, double var4, double var6) {
        this.renderName((EntityPlayer)var1, var2, var4, var6);
    }

    @Override
    protected void preRenderCallback(EntityLiving var1, float var2) {
        this.func_186_b((EntityPlayer)var1, var2);
    }

    @Override
    protected int shouldRenderPass(EntityLiving var1, int var2, float var3) {
        return this.setArmorModel((EntityPlayer)var1, var2, var3);
    }

    @Override
    protected void renderEquippedItems(EntityLiving var1, float var2) {
        this.renderSpecials((EntityPlayer)var1, var2);
    }

    @Override
    protected void rotateCorpse(EntityLiving var1, float var2, float var3, float var4) {
        this.func_22017_a((EntityPlayer)var1, var2, var3, var4);
    }

    protected void func_22012_b(EntityLiving var1, double var2, double var4, double var6) {
        this.func_22016_b((EntityPlayer)var1, var2, var4, var6);
    }

    @Override
    public void doRenderLiving(EntityLiving var1, double var2, double var4, double var6, float var8, float var9) {
        this.renderPlayer((EntityPlayer)var1, var2, var4, var6, var8, var9);
    }

    @Override
    public void doRender(Entity var1, double var2, double var4, double var6, float var8, float var9) {
        this.renderPlayer((EntityPlayer)var1, var2, var4, var6, var8, var9);
    }
}

