/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockContainer;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.block.tileentity.TileEntityAnvil;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockAnvil
extends BlockContainer {
    private Random rand = new Random();
    private static boolean keepAnvilInventory = false;

    protected BlockAnvil(int var1) {
        super(var1, Material.iron);
        this.blockIndexInTexture = 509;
    }

    @Override
    public int getRenderType() {
        return 35;
    }

    @Override
    public int idDropped(int var1, Random var2) {
        return this.blockID;
    }

    @Override
    public int idPicked(World world, int par2, int par3, int par4) {
        return this.blockID;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int var5 = par1IBlockAccess.getBlockMetadata(par2, par3, par4) & 3;
        if (var5 != 3 && var5 != 1) {
            this.setBlockBounds(0.125f, 0.0f, 0.0f, 0.875f, 1.0f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.125f, 1.0f, 1.0f, 0.875f);
        }
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    @Override
    public void onBlockAdded(World var1, int var2, int var3, int var4) {
        super.onBlockAdded(var1, var2, var3, var4);
        this.setDefaultDirection(var1, var2, var3, var4);
    }

    private void setDefaultDirection(World var1, int var2, int var3, int var4) {
        if (!var1.multiplayerWorld) {
            int var5 = var1.getBlockId(var2, var3, var4 - 1);
            int var6 = var1.getBlockId(var2, var3, var4 + 1);
            int var7 = var1.getBlockId(var2 - 1, var3, var4);
            int var8 = var1.getBlockId(var2 + 1, var3, var4);
            int var9 = 3;
            if (Block.opaqueCubeLookup[var5] && !Block.opaqueCubeLookup[var6]) {
                var9 = 3;
            }
            if (Block.opaqueCubeLookup[var6] && !Block.opaqueCubeLookup[var5]) {
                var9 = 2;
            }
            if (Block.opaqueCubeLookup[var7] && !Block.opaqueCubeLookup[var8]) {
                var9 = 5;
            }
            if (Block.opaqueCubeLookup[var8] && !Block.opaqueCubeLookup[var7]) {
                var9 = 4;
            }
            var1.setBlockMetadataWithNotify(var2, var3, var4, var9);
        }
    }

    @Override
    public int getBlockTexture(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        return this.blockIndexInTexture;
    }

    @Override
    public int getBlockTextureFromSide(int var1) {
        return this.blockIndexInTexture;
    }

    @Override
    public boolean blockActivated(World var1, int var2, int var3, int var4, EntityPlayer var5) {
        System.out.println("a" + var2 + " " + var3 + " " + var4);
        if (var1.multiplayerWorld) {
            return true;
        }
        if (var5.isSneaking()) {
            return false;
        }
        TileEntityAnvil var6 = (TileEntityAnvil)var1.getBlockTileEntity(var2, var3, var4);
        System.out.println(String.valueOf(var2) + " " + var3 + " " + var4);
        var5.displayGUIAnvil(var6, var2, var3, var4);
        return true;
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityAnvil();
    }

    @Override
    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLiving par5EntityLiving) {
        int var6 = MathHelper.floor_double((double)(par5EntityLiving.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        int var7 = par1World.getBlockMetadata(par2, par3, par4) >> 2;
        ++var6;
        if ((var6 %= 4) == 0) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 2 | var7 << 2);
        }
        if (var6 == 1) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 3 | var7 << 2);
        }
        if (var6 == 2) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, var7 << 2);
        }
        if (var6 == 3) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 1 | var7 << 2);
        }
    }

    @Override
    public void onBlockRemoval(World world, int xCoord, int yCoord, int zCoord) {
        if (!keepAnvilInventory) {
            TileEntityAnvil var5 = (TileEntityAnvil)world.getBlockTileEntity(xCoord, yCoord, zCoord);
            int var6 = 0;
            while (var6 < var5.getSizeInventory()) {
                ItemStack var7 = var5.getStackInSlot(var6);
                if (var7 != null) {
                    float var8 = this.rand.nextFloat() * 0.8f + 0.1f;
                    float var9 = this.rand.nextFloat() * 0.8f + 0.1f;
                    float var10 = this.rand.nextFloat() * 0.8f + 0.1f;
                    while (var7.stackSize > 0) {
                        int var11 = this.rand.nextInt(21) + 10;
                        if (var11 > var7.stackSize) {
                            var11 = var7.stackSize;
                        }
                        var7.stackSize -= var11;
                        EntityItem var12 = new EntityItem(world, (float)xCoord + var8, (float)yCoord + var9, (float)zCoord + var10, new ItemStack(var7.itemID, var11, var7.getItemDamage()));
                        float var13 = 0.05f;
                        var12.motionX = (float)this.rand.nextGaussian() * var13;
                        var12.motionY = (float)this.rand.nextGaussian() * var13 + 0.2f;
                        var12.motionZ = (float)this.rand.nextGaussian() * var13;
                        world.entityJoinedWorld(var12);
                    }
                }
                ++var6;
            }
        }
        super.onBlockRemoval(world, xCoord, yCoord, zCoord);
    }
}

