/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockFalling;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.stats.StatList;

public class BlockAsh
extends BlockFalling {
    protected BlockAsh(int var1, int var2) {
        super(var1, var2, Material.ash);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.setTickOnLoad(true);
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.375f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World var1, int var2, int var3, int var4) {
        int metadata = var1.getBlockMetadata(var2, var3, var4) & 7;
        float addedHeight = (float)(2 * (1 + metadata)) / 16.0f;
        return AxisAlignedBB.getBoundingBoxFromPool(var2, var3, var4, (double)var2 + 1.0, (double)var3 + (double)addedHeight, (double)var4 + 1.0);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess var1, int var2, int var3, int var4) {
        int var5 = var1.getBlockMetadata(var2, var3, var4) & 7;
        float var6 = (float)(2 * (1 + var5)) / 16.0f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, var6, 1.0f);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int xCoord, int yCoord, int zCoord) {
        int blockBelow = world.getBlockId(xCoord, yCoord - 1, zCoord);
        int metadataBelow = world.getBlockMetadata(xCoord, yCoord - 1, zCoord) & 7;
        return blockBelow != 0 && Block.blocksList[blockBelow].isOpaqueCube() || world.getBlockMaterial(xCoord, yCoord - 1, zCoord).getIsSolid() || blockBelow == Block.leaves.blockID || blockBelow == Block.leavesFir.blockID || blockBelow == this.blockID && metadataBelow >= 7;
    }

    @Override
    public void harvestBlock(World var1, EntityPlayer var2, int var3, int var4, int var5, int var6) {
        if (!var1.multiplayerWorld && var2.getCurrentEquippedItem() != null && var2.getCurrentEquippedItem().itemID == Item.hoeGold.itemID) {
            var2.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(var1, var3, var4, var5, new ItemStack(Block.ashPile.blockID, 1, 0));
        } else {
            int var7 = Item.ash.itemID;
            float var8 = 0.7f;
            double var9 = (double)(var1.rand.nextFloat() * var8) + (double)(1.0f - var8) * 0.5;
            double var11 = (double)(var1.rand.nextFloat() * var8) + (double)(1.0f - var8) * 0.5;
            double var13 = (double)(var1.rand.nextFloat() * var8) + (double)(1.0f - var8) * 0.5;
            EntityItem var15 = new EntityItem(var1, (double)var3 + var9, (double)var4 + var11, (double)var5 + var13, new ItemStack(var7, 1, 0));
            var15.delayBeforeCanPickup = 10;
            var1.entityJoinedWorld(var15);
            var1.setBlockWithNotify(var3, var4, var5, 0);
            var2.addStat(StatList.mineBlockStatArray[this.blockID], 1);
        }
    }

    @Override
    public boolean blockActivated(World var1, int var2, int var3, int var4, EntityPlayer var5) {
        int metadata = var1.getBlockMetadata(var2, var3, var4) & 7;
        if (!var1.multiplayerWorld && metadata < 7) {
            if (var5.getCurrentEquippedItem() != null && var5.getCurrentEquippedItem().itemID == this.blockID) {
                if (!var5.capabilities.depleteItems) {
                    --var5.getCurrentEquippedItem().stackSize;
                }
                var1.playSoundEffect((float)var2 + 0.5f, (float)var3 + 0.5f, (float)var4 + 0.5f, this.stepSound.func_1145_d(), (this.stepSound.getVolume() + 1.0f) / 2.0f, this.stepSound.getPitch() * 0.8f);
                this.addLayer(var1, var2, var3, var4, var5, metadata);
                return true;
            }
            return false;
        }
        if (var5.isSneaking()) {
            return false;
        }
        return false;
    }

    private void addLayer(World var1, int var2, int var3, int var4, EntityPlayer var5, int addedMetadata) {
        var1.setBlockAndMetadataWithNotify(var2, var3, var4, this.blockID, 0);
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        super.randomDisplayTick(world, i, j, k, random);
        int var5 = world.getBlockMetadata(i, j, k) & 7;
        float var6 = (float)(2 * (1 + var5)) / 16.0f;
        if (random.nextInt(2) == 0) {
            world.spawnParticle("townaura", (float)i + random.nextFloat(), (float)j + var6, (float)k + random.nextFloat(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onEntityWalking(World world, int var2, int var3, int var4, Entity entity) {
        int var5 = world.getBlockMetadata(var2, var3, var4) & 7;
        float var6 = (float)(2 * (1 + var5)) / 16.0f;
        world.spawnParticle("electric", entity.posX, (double)var3 + 0.1 + (double)var6, entity.posZ, 0.0, 0.025, 0.0);
        world.spawnParticle("electric", entity.posX, (double)var3 + 0.1 + (double)var6, entity.posZ, 0.0, 0.025, 0.0);
        world.spawnParticle("electric", entity.posX, (double)var3 + 0.1 + (double)var6, entity.posZ, 0.0, 0.025, 0.0);
        world.spawnParticle("electric", entity.posX, (double)var3 + 0.1 + (double)var6, entity.posZ, 0.0, 0.025, 0.0);
    }

    @Override
    public int idDropped(int var1, Random var2) {
        return Item.ash.itemID;
    }

    @Override
    public int quantityDropped(Random var1) {
        return 0;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        return var5 == 1 ? true : super.shouldSideBeRendered(var1, var2, var3, var4, var5);
    }
}

