/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.client.model.ModelBed;
import net.minecraft.src.game.achievements.AchievementList;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.level.EnumStatus;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.chunk.ChunkCoordinates;

public class BlockBed
extends Block {
    public static final int[][] headBlockToFootBlockMap;

    static {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[0] = 1;
        nArrayArray[3] = nArray4;
        headBlockToFootBlockMap = nArrayArray;
    }

    public BlockBed(int id) {
        super(id, 134, Material.cloth);
        this.setBounds();
    }

    @Override
    public boolean blockActivated(World world, int xCoord, int yCoord, int zCoord, EntityPlayer player) {
        EnumStatus sleepStatus;
        if (world.multiplayerWorld) {
            return true;
        }
        if (player.isSneaking()) {
            return false;
        }
        int metadata = world.getBlockMetadata(xCoord, yCoord, zCoord);
        if (!BlockBed.isBlockFootOfBed(metadata)) {
            int var7 = BlockBed.getDirectionFromMetadata(metadata);
            if (world.getBlockId(xCoord += headBlockToFootBlockMap[var7][0], yCoord, zCoord += headBlockToFootBlockMap[var7][1]) != this.blockID) {
                return true;
            }
            metadata = world.getBlockMetadata(xCoord, yCoord, zCoord);
        }
        if (!world.worldProvider.canRespawnHere()) {
            double xPos = (double)xCoord + 0.5;
            double yPos = (double)yCoord + 0.5;
            double zPos = (double)zCoord + 0.5;
            world.setBlockWithNotify(xCoord, yCoord, zCoord, 0);
            int directionMetadata = BlockBed.getDirectionFromMetadata(metadata);
            if (world.getBlockId(xCoord += headBlockToFootBlockMap[directionMetadata][0], yCoord, zCoord += headBlockToFootBlockMap[directionMetadata][1]) == this.blockID) {
                world.setBlockWithNotify(xCoord, yCoord, zCoord, 0);
                xPos = (xPos + (double)xCoord + 0.5) / 2.0;
                yPos = (yPos + (double)yCoord + 0.5) / 2.0;
                zPos = (zPos + (double)zCoord + 0.5) / 2.0;
            }
            world.newExplosion(null, (float)xCoord + 0.5f, (float)yCoord + 0.5f, (float)zCoord + 0.5f, 5.0f, true);
            player.triggerAchievement(AchievementList.bedExplode);
            return true;
        }
        if (BlockBed.isBedOccupied(metadata)) {
            EntityPlayer playerSecondary = null;
            for (EntityPlayer playerOther : world.playerEntities) {
                if (!playerOther.isPlayerSleeping()) continue;
                ChunkCoordinates var10 = playerOther.bedChunkCoordinates;
                if (var10.x != xCoord || var10.y != yCoord || var10.z != zCoord) continue;
                playerSecondary = playerOther;
            }
            if (playerSecondary != null) {
                player.addChatMessage("tile.bed.occupied");
                return true;
            }
            BlockBed.setBedOccupied(world, xCoord, yCoord, zCoord, false);
        }
        if ((sleepStatus = player.sleepInBedAt(xCoord, yCoord, zCoord)) == EnumStatus.OK) {
            BlockBed.setBedOccupied(world, xCoord, yCoord, zCoord, true);
            return true;
        }
        if (sleepStatus == EnumStatus.NOT_POSSIBLE_NOW) {
            player.addChatMessage("tile.bed.noSleep");
        }
        return true;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int blockFace, int metadata) {
        if (blockFace == 0) {
            return Block.planks.blockIndexInTexture;
        }
        int directionMetadata = BlockBed.getDirectionFromMetadata(metadata);
        int bedBlockModel = ModelBed.bedDirection[directionMetadata][blockFace];
        if (BlockBed.isBlockFootOfBed(metadata)) {
            if (bedBlockModel == 2) {
                return this.blockIndexInTexture + 2 + 16;
            }
            return bedBlockModel != 5 && bedBlockModel != 4 ? this.blockIndexInTexture + 1 : this.blockIndexInTexture + 1 + 16;
        }
        if (bedBlockModel == 3) {
            return this.blockIndexInTexture - 1 + 16;
        }
        return bedBlockModel != 5 && bedBlockModel != 4 ? this.blockIndexInTexture : this.blockIndexInTexture + 16;
    }

    @Override
    public int getRenderType() {
        return 14;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess blockAccess, int var2, int var3, int var4) {
        this.setBounds();
    }

    @Override
    public void onNeighborBlockChange(World world, int xCoord, int yCoord, int zCoord, int var5) {
        int metadata = world.getBlockMetadata(xCoord, yCoord, zCoord);
        int directionMetadata = BlockBed.getDirectionFromMetadata(metadata);
        if (BlockBed.isBlockFootOfBed(metadata)) {
            if (world.getBlockId(xCoord - headBlockToFootBlockMap[directionMetadata][0], yCoord, zCoord - headBlockToFootBlockMap[directionMetadata][1]) != this.blockID) {
                world.setBlockWithNotify(xCoord, yCoord, zCoord, 0);
            }
        } else if (world.getBlockId(xCoord + headBlockToFootBlockMap[directionMetadata][0], yCoord, zCoord + headBlockToFootBlockMap[directionMetadata][1]) != this.blockID) {
            world.setBlockWithNotify(xCoord, yCoord, zCoord, 0);
            if (!world.multiplayerWorld) {
                this.dropBlockAsItem(world, xCoord, yCoord, zCoord, metadata);
            }
        }
    }

    @Override
    public int idDropped(int metadata, Random rand) {
        return BlockBed.isBlockFootOfBed(metadata) ? 0 : Item.bed.itemID;
    }

    @Override
    public int idPicked(World par1World, int par2, int par3, int par4) {
        return Item.bed.itemID;
    }

    private void setBounds() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5625f, 1.0f);
    }

    public static int getDirectionFromMetadata(int metadata) {
        return metadata & 3;
    }

    public static boolean isBlockFootOfBed(int metadata) {
        return (metadata & 8) != 0;
    }

    public static boolean isBedOccupied(int metadata) {
        return (metadata & 4) != 0;
    }

    public static void setBedOccupied(World world, int xCoord, int yCoord, int zCoord, boolean occupied) {
        int metadata = world.getBlockMetadata(xCoord, yCoord, zCoord);
        metadata = occupied ? (metadata |= 4) : (metadata &= 0xFFFFFFFB);
        world.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, metadata);
    }

    public static ChunkCoordinates getNearestEmptyChunkCoordinates(World world, int xCoord, int yCoord, int zCoord, int canSpawn) {
        int metadata = world.getBlockMetadata(xCoord, yCoord, zCoord);
        int directionMetadata = BlockBed.getDirectionFromMetadata(metadata);
        int var7 = 0;
        while (var7 <= 1) {
            int xBedCoord = xCoord - headBlockToFootBlockMap[directionMetadata][0] * var7 - 1;
            int zBedCoord = zCoord - headBlockToFootBlockMap[directionMetadata][1] * var7 - 1;
            int xBedCoordSecondary = xBedCoord + 2;
            int zBedCoordSecondary = zBedCoord + 2;
            int xSpawn = xBedCoord;
            while (xSpawn <= xBedCoordSecondary) {
                int zSpawn = zBedCoord;
                while (zSpawn <= zBedCoordSecondary) {
                    if (world.isBlockNormalCube(xSpawn, yCoord - 1, zSpawn) && world.isAirBlock(xSpawn, yCoord, zSpawn) && world.isAirBlock(xSpawn, yCoord + 1, zSpawn)) {
                        if (canSpawn <= 0) {
                            return new ChunkCoordinates(xSpawn, yCoord, zSpawn);
                        }
                        --canSpawn;
                    }
                    ++zSpawn;
                }
                ++xSpawn;
            }
            ++var7;
        }
        return null;
    }

    @Override
    public void dropBlockAsItemWithChance(World world, int var2, int var3, int var4, int var5, float var6) {
        if (!BlockBed.isBlockFootOfBed(var5)) {
            super.dropBlockAsItemWithChance(world, var2, var3, var4, var5, var6);
        }
    }

    @Override
    public int getMobilityFlag() {
        return 1;
    }
}

