/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.stats.StatList;

public class BlockBookshelf
extends Block {
    int blockFaceInt;

    public BlockBookshelf(int id, int texture, int topTexture) {
        super(id, texture, Material.wood);
        this.blockFaceInt = topTexture;
    }

    @Override
    public int getBlockTextureFromSide(int blockFace) {
        return blockFace <= 1 ? this.blockFaceInt : this.blockIndexInTexture;
    }

    @Override
    public int idDropped(int i, Random rand) {
        if (this.blockID == 155) {
            return Item.brick.itemID;
        }
        return Item.book.itemID;
    }

    @Override
    public int quantityDropped(Random rand) {
        return 3;
    }

    @Override
    public void harvestBlock(World world, EntityPlayer player, int xCoord, int yCoord, int zCoord, int metadata) {
        if (!world.multiplayerWorld && player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().itemID == Item.axeGold.itemID) {
            player.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(world, xCoord, yCoord, zCoord, new ItemStack(this.blockID, 1, metadata & 3));
            player.addToPlayerScore(player, 1);
        } else {
            super.harvestBlock(world, player, xCoord, yCoord, zCoord, metadata);
        }
    }
}

