/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.client.GameSettings;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockBush
extends Block {
    IBlockAccess blockAccess;
    public boolean isFruiting;

    protected BlockBush(int id, int texture, boolean producingFruit) {
        super(id, Material.plants);
        this.blockIndexInTexture = texture;
        this.isFruiting = producingFruit;
        this.setTickOnLoad(true);
    }

    @Override
    public int idDropped(int damageMetadata, Random rand) {
        return Block.blueberryBush.blockID;
    }

    @Override
    public int idPicked(World par1World, int par2, int par3, int par4) {
        return Block.blueberryBush.blockID + 1;
    }

    @Override
    public int quantityDropped(Random rand) {
        return 1;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int xCoord, int yCoord, int zCoord) {
        return super.canPlaceBlockAt(world, xCoord, yCoord, zCoord) && this.canThisPlantGrowOnThisBlockID(world.getBlockId(xCoord, yCoord - 1, zCoord));
    }

    protected boolean canThisPlantGrowOnThisBlockID(int blockid) {
        return blockid == Block.grass.blockID || blockid == Block.dirt.blockID || blockid == Block.tilledField.blockID || blockid == Block.sand.blockID || blockid == Block.gravel.blockID;
    }

    @Override
    public void updateTick(World world, int xCoord, int yCoord, int zCoord, Random rand) {
        float growth;
        super.updateTick(world, xCoord, yCoord, zCoord, rand);
        if (world.getBlockLightValue(xCoord, yCoord + 1, zCoord) >= 9 && !this.isFruiting && rand.nextInt((int)(200.0f / (growth = this.getGrowthRate(world, xCoord, yCoord, zCoord)))) == 0) {
            world.setBlockWithNotify(xCoord, yCoord, zCoord, Block.blueberryBushFruiting.blockID);
        }
    }

    public void fertilize(World world, int xCoord, int yCoord, int zCoord) {
        if (!this.isFruiting) {
            world.setBlockWithNotify(xCoord, yCoord, zCoord, Block.blueberryBushFruiting.blockID);
        }
    }

    private float getGrowthRate(World world, int xCoord, int yCoord, int zCoord) {
        float baseRate = 1.0f;
        int var6 = world.getBlockId(xCoord, yCoord, zCoord - 1);
        int var7 = world.getBlockId(xCoord, yCoord, zCoord + 1);
        int var8 = world.getBlockId(xCoord - 1, yCoord, zCoord);
        int var9 = world.getBlockId(xCoord + 1, yCoord, zCoord);
        int var10 = world.getBlockId(xCoord - 1, yCoord, zCoord - 1);
        int var11 = world.getBlockId(xCoord + 1, yCoord, zCoord - 1);
        int var12 = world.getBlockId(xCoord + 1, yCoord, zCoord + 1);
        int var13 = world.getBlockId(xCoord - 1, yCoord, zCoord + 1);
        boolean var14 = var8 == this.blockID || var9 == this.blockID;
        boolean var15 = var6 == this.blockID || var7 == this.blockID;
        boolean var16 = var10 == this.blockID || var11 == this.blockID || var12 == this.blockID || var13 == this.blockID;
        int var17 = xCoord - 1;
        while (var17 <= xCoord + 1) {
            int var18 = zCoord - 1;
            while (var18 <= zCoord + 1) {
                int var19 = world.getBlockId(var17, yCoord - 1, var18);
                float var20 = 0.0f;
                if (this.canThisPlantGrowOnThisBlockID(var19)) {
                    var20 = 1.0f;
                    if (!this.isFruiting) {
                        var20 = 3.0f;
                    }
                }
                if (var17 != xCoord || var18 != zCoord) {
                    var20 /= 4.0f;
                }
                baseRate += var20;
                ++var18;
            }
            ++var17;
        }
        if (var16 || var14 && var15) {
            baseRate /= 2.0f;
        }
        return baseRate;
    }

    @Override
    public void onNeighborBlockChange(World world, int xCoord, int yCoord, int zCoord, int var5) {
        super.onNeighborBlockChange(world, xCoord, yCoord, zCoord, var5);
        this.func_268_h(world, xCoord, yCoord, zCoord);
    }

    protected final void func_268_h(World world, int xCoord, int yCoord, int zCoord) {
        if (!this.canBlockStay(world, xCoord, yCoord, zCoord)) {
            this.dropBlockAsItem(world, xCoord, yCoord, zCoord, world.getBlockMetadata(xCoord, yCoord, zCoord));
            world.setBlockWithNotify(xCoord, yCoord, zCoord, 0);
        }
    }

    @Override
    public boolean canBlockStay(World world, int xCoord, int yCoord, int zCoord) {
        return (world.getFullBlockLightValue(xCoord, yCoord, zCoord) >= 8 || world.canBlockSeeTheSky(xCoord, yCoord, zCoord)) && this.canThisPlantGrowOnThisBlockID(world.getBlockId(xCoord, yCoord - 1, zCoord));
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 20;
    }

    @Override
    public int getBlockTextureFromSide(int blockFace) {
        if (blockFace == 1 && this.isFruiting) {
            return this.blockIndexInTexture - 3;
        }
        if (blockFace == 2 && this.isFruiting) {
            return this.blockIndexInTexture - 9;
        }
        if (blockFace == 1) {
            return this.blockIndexInTexture - 1;
        }
        if (blockFace == 2) {
            return this.blockIndexInTexture + 1;
        }
        return this.blockIndexInTexture;
    }

    @Override
    public int getRenderAs3DItem() {
        if (GameSettings.flowerItems3D) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean blockActivated(World world, int xCoord, int yCoord, int zCoord, EntityPlayer player) {
        if (world.multiplayerWorld) {
            return true;
        }
        if (player.isSneaking()) {
            return false;
        }
        if (this.isFruiting) {
            world.playSoundAtEntity(player, "item.sweet_berries.pick_from_bush", 1.0f, 1.0f);
            world.setBlockWithNotify(xCoord, yCoord, zCoord, Block.blueberryBush.blockID);
            float baseMotion = 0.7f;
            float xItemMotion = world.rand.nextFloat() * baseMotion + (1.0f - baseMotion) * 0.5f;
            float yItemMotion = world.rand.nextFloat() * baseMotion + (1.0f - baseMotion) * 0.5f;
            float zItemMotion = world.rand.nextFloat() * baseMotion + (1.0f - baseMotion) * 0.5f;
            EntityItem var12 = new EntityItem(world, (float)xCoord + xItemMotion, (double)((float)yCoord + yItemMotion) + 0.5, (float)zCoord + zItemMotion, new ItemStack(Item.blueberry));
            var12.delayBeforeCanPickup = 10;
            world.entityJoinedWorld(var12);
            return true;
        }
        return false;
    }
}

