/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.level.World;

public class BlockCactus
extends Block {
    protected BlockCactus(int id, int texture) {
        super(id, texture, Material.cactus);
        this.setTickOnLoad(true);
    }

    @Override
    public void updateTick(World world, int var2, int var3, int zCoord, Random rand) {
        if (world.isAirBlock(var2, var3 + 1, zCoord)) {
            int var6 = 1;
            while (world.getBlockId(var2, var3 - var6, zCoord) == this.blockID) {
                ++var6;
            }
            if (var6 < 3) {
                int var7 = world.getBlockMetadata(var2, var3, zCoord);
                if (var7 == 15) {
                    world.setBlockWithNotify(var2, var3 + 1, zCoord, this.blockID);
                    world.setBlockMetadataWithNotify(var2, var3, zCoord, 0);
                } else {
                    world.setBlockMetadataWithNotify(var2, var3, zCoord, var7 + 1);
                }
            }
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int var2, int var3, int var4) {
        float var5 = 0.0625f;
        return AxisAlignedBB.getBoundingBoxFromPool((float)var2 + var5, var3, (float)var4 + var5, (float)(var2 + 1) - var5, (float)(var3 + 1) - var5, (float)(var4 + 1) - var5);
    }

    @Override
    public int getBlockTextureFromSide(int blockFace) {
        if (blockFace == 1) {
            return this.blockIndexInTexture - 1;
        }
        return blockFace == 0 ? this.blockIndexInTexture - 1 : this.blockIndexInTexture;
    }

    @Override
    public boolean canPlaceBlockAt(World var1, int var2, int var3, int var4) {
        return !super.canPlaceBlockAt(var1, var2, var3, var4) ? false : this.canBlockStay(var1, var2, var3, var4);
    }

    @Override
    public void onNeighborBlockChange(World world, int var2, int var3, int var4, int var5) {
        if (!this.canBlockStay(world, var2, var3, var4)) {
            this.dropBlockAsItem(world, var2, var3, var4, world.getBlockMetadata(var2, var3, var4));
            world.setBlockWithNotify(var2, var3, var4, 0);
        }
    }

    @Override
    public boolean canBlockStay(World world, int xCoord, int yCoord, int zCoord) {
        if (world.getBlockMaterial(xCoord - 1, yCoord, zCoord).isSolid() && world.getBlockId(xCoord - 1, yCoord, zCoord) != Block.cactus.blockID) {
            return false;
        }
        if (world.getBlockMaterial(xCoord + 1, yCoord, zCoord).isSolid() && world.getBlockId(xCoord + 1, yCoord, zCoord) != Block.cactus.blockID) {
            return false;
        }
        if (world.getBlockMaterial(xCoord, yCoord, zCoord - 1).isSolid() && world.getBlockId(xCoord, yCoord, zCoord - 1) != Block.cactus.blockID) {
            return false;
        }
        if (world.getBlockMaterial(xCoord, yCoord, zCoord + 1).isSolid() && world.getBlockId(xCoord, yCoord, zCoord + 1) != Block.cactus.blockID) {
            return false;
        }
        int blockBelow = world.getBlockId(xCoord, yCoord - 1, zCoord);
        if (world.getBlockId(xCoord, yCoord, zCoord + 1) != Block.cactus.blockID && world.getBlockId(xCoord, yCoord, zCoord - 1) != Block.cactus.blockID && world.getBlockId(xCoord + 1, yCoord, zCoord) != Block.cactus.blockID && world.getBlockId(xCoord - 1, yCoord, zCoord) != Block.cactus.blockID) {
            return blockBelow == Block.cactus.blockID || blockBelow == Block.sand.blockID;
        }
        return true;
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int xCoord, int yCoord, int zCoord, Entity entity) {
        entity.attackEntityFrom(null, 1);
    }
}

