/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockFlower;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.stats.StatList;

public final class BlockCaveSpike
extends BlockFlower {
    protected BlockCaveSpike(int n, int n2) {
        super(n, n2);
        this.setBlockBounds(0.275f, 0.0f, 0.275f, 0.725f, 1.0f, 0.725f);
    }

    @Override
    protected final boolean canThisPlantGrowOnThisBlockID(int n) {
        return Block.opaqueCubeLookup[n];
    }

    @Override
    public final boolean canBlockStay(World world, int blockId, int n, int n2) {
        return true;
    }

    @Override
    public final boolean canPlaceBlockAt(World world, int n, int n2, int n3) {
        return true;
    }

    @Override
    public boolean isCollidable() {
        return true;
    }

    @Override
    public final AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int n, int n2, int n3) {
        return new AxisAlignedBB((double)n + this.minX, (double)n2 + this.minY, (double)n3 + this.minZ, (double)n + this.maxX, (double)n2 + this.maxY, (double)n3 + this.maxZ);
    }

    @Override
    public int idDropped(int var1, Random var2) {
        if (this.blockID == 126) {
            return Item.stick.itemID;
        }
        return Block.cobblestone.blockID;
    }

    @Override
    public void harvestBlock(World var1, EntityPlayer var2, int var3, int var4, int var5, int var6) {
        if (!var1.multiplayerWorld && var2.getCurrentEquippedItem() != null && var2.getCurrentEquippedItem().itemID == Item.pickaxeGold.itemID) {
            var2.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(var1, var3, var4, var5, new ItemStack(this.blockID, 1, var6 & 3));
            var2.addToPlayerScore(var2, 1);
        } else {
            super.harvestBlock(var1, var2, var3, var4, var5, var6);
        }
    }
}

