/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.stats.StatList;

public class BlockCrimsonLog
extends Block {
    protected BlockCrimsonLog(int var1) {
        super(var1, Material.wood);
        this.blockIndexInTexture = 153;
    }

    @Override
    public int quantityDropped(Random var1) {
        return 1;
    }

    @Override
    public int idDropped(int var1, Random var2) {
        return Block.logCrimson.blockID;
    }

    @Override
    public void harvestBlock(World world, EntityPlayer thePlayer, int xCoord, int yCoord, int zCoord, int damageMetadata) {
        if (thePlayer.getCurrentEquippedItem() != null && thePlayer.inventory.getCurrentItem().getItem().itemID == Item.axeStone.itemID) {
            if (damageMetadata <= 2) {
                Random rand = new Random();
                int num = rand.nextBoolean() ? 2 : 1;
                this.dropBlockAsItem_do(world, xCoord, yCoord, zCoord, new ItemStack(this.blockID, num, damageMetadata + 3));
                thePlayer.addToPlayerScore(thePlayer, 1);
            } else {
                super.harvestBlock(world, thePlayer, xCoord, yCoord, zCoord, damageMetadata);
            }
        } else if (!world.multiplayerWorld && thePlayer.getCurrentEquippedItem() != null && thePlayer.getCurrentEquippedItem().itemID == Item.axeFire.itemID) {
            thePlayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(world, xCoord, yCoord, zCoord, new ItemStack(Item.coal.itemID, 1, damageMetadata & 3));
            thePlayer.addToPlayerScore(thePlayer, 1);
        } else {
            super.harvestBlock(world, thePlayer, xCoord, yCoord, zCoord, damageMetadata);
        }
    }

    @Override
    public void onBlockRemoval(World var1, int var2, int var3, int var4) {
        int var5 = 4;
        int var6 = var5 + 1;
        if (var1.checkChunksExist(var2 - var6, var3 - var6, var4 - var6, var2 + var6, var3 + var6, var4 + var6)) {
            int var7 = -var5;
            while (var7 <= var5) {
                int var8 = -var5;
                while (var8 <= var5) {
                    int var9 = -var5;
                    while (var9 <= var5) {
                        int var11;
                        int var10 = var1.getBlockId(var2 + var7, var3 + var8, var4 + var9);
                        if (var10 == Block.netherWart.blockID && ((var11 = var1.getBlockMetadata(var2 + var7, var3 + var8, var4 + var9)) & 8) == 0) {
                            var1.setBlockMetadata(var2 + var7, var3 + var8, var4 + var9, var11 | 8);
                        }
                        ++var9;
                    }
                    ++var8;
                }
                ++var7;
            }
        }
    }

    @Override
    public int getBlockTextureFromSide(int var1) {
        if (var1 == 1) {
            return 154;
        }
        if (var1 == 0) {
            return 154;
        }
        return 153;
    }

    @Override
    protected int damageDropped(int var1) {
        return var1;
    }
}

