/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockFlower;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemFireSword;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.item.ItemSword;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.stats.StatList;

public class BlockDeadBush
extends BlockFlower {
    protected BlockDeadBush(int var1, int var2) {
        super(var1, var2);
        float var3 = 0.4f;
        this.setBlockBounds(0.5f - var3, 0.0f, 0.5f - var3, 0.5f + var3, 1.0f, 0.5f + var3);
    }

    @Override
    protected boolean canThisPlantGrowOnThisBlockID(int var1) {
        return var1 == Block.sand.blockID;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int var1, int var2) {
        return this.blockIndexInTexture;
    }

    @Override
    public int idDropped(int var1, Random var2) {
        return Item.stick.itemID;
    }

    @Override
    public void harvestBlock(World var1, EntityPlayer var2, int var3, int var4, int var5, int var6) {
        if (!var1.multiplayerWorld && var2.getCurrentEquippedItem() != null && var2.getCurrentEquippedItem().getItem() instanceof ItemSword) {
            var2.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(var1, var3, var4, var5, new ItemStack(this.blockID, 1, var6 & 3));
            var2.addToPlayerScore(var2, 1);
        } else if (!var1.multiplayerWorld && var2.getCurrentEquippedItem() != null && var2.getCurrentEquippedItem().getItem() instanceof ItemFireSword) {
            var2.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(var1, var3, var4, var5, new ItemStack(Item.ash.itemID, 1, var6 & 3));
            var2.addToPlayerScore(var2, 1);
        } else {
            super.harvestBlock(var1, var2, var3, var4, var5, var6);
        }
    }
}

