/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockLeavesBase;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemFireSword;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.item.ItemSword;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.stats.StatList;

public class BlockFirLeaves
extends BlockLeavesBase {
    private int baseIndexInPNG;
    int[] adjacentTreeBlocks;

    protected BlockFirLeaves(int var1, int var2) {
        super(var1, var2, Material.leaves, false);
        this.baseIndexInPNG = var2;
        this.setTickOnLoad(true);
    }

    @Override
    public void onBlockRemoval(World var1, int var2, int var3, int var4) {
        int var5 = 1;
        int var6 = var5 + 1;
        if (var1.checkChunksExist(var2 - var6, var3 - var6, var4 - var6, var2 + var6, var3 + var6, var4 + var6)) {
            int var7 = -var5;
            while (var7 <= var5) {
                int var8 = -var5;
                while (var8 <= var5) {
                    int var9 = -var5;
                    while (var9 <= var5) {
                        int var10 = var1.getBlockId(var2 + var7, var3 + var8, var4 + var9);
                        if (var10 == Block.leavesFir.blockID) {
                            int var11 = var1.getBlockMetadata(var2 + var7, var3 + var8, var4 + var9);
                            var1.setBlockMetadata(var2 + var7, var3 + var8, var4 + var9, var11 | 8);
                        }
                        ++var9;
                    }
                    ++var8;
                }
                ++var7;
            }
        }
    }

    @Override
    public void updateTick(World var1, int var2, int var3, int var4, Random var5) {
        int var6;
        if (!var1.multiplayerWorld && ((var6 = var1.getBlockMetadata(var2, var3, var4)) & 8) != 0) {
            int var12;
            int var7 = 4;
            int var8 = var7 + 1;
            int var9 = 32;
            int var10 = var9 * var9;
            int var11 = var9 / 2;
            if (this.adjacentTreeBlocks == null) {
                this.adjacentTreeBlocks = new int[var9 * var9 * var9];
            }
            if (var1.checkChunksExist(var2 - var8, var3 - var8, var4 - var8, var2 + var8, var3 + var8, var4 + var8)) {
                var12 = -var7;
                while (true) {
                    int var15;
                    int var14;
                    int var13;
                    if (var12 > var7) {
                        for (var12 = 1; var12 <= 4; ++var12) {
                            var13 = -var7;
                            while (var13 <= var7) {
                                var14 = -var7;
                                while (var14 <= var7) {
                                    var15 = -var7;
                                    while (var15 <= var7) {
                                        if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + var15 + var11] == var12 - 1) {
                                            if (this.adjacentTreeBlocks[(var13 + var11 - 1) * var10 + (var14 + var11) * var9 + var15 + var11] == -2) {
                                                this.adjacentTreeBlocks[(var13 + var11 - 1) * var10 + (var14 + var11) * var9 + var15 + var11] = var12;
                                            }
                                            if (this.adjacentTreeBlocks[(var13 + var11 + 1) * var10 + (var14 + var11) * var9 + var15 + var11] == -2) {
                                                this.adjacentTreeBlocks[(var13 + var11 + 1) * var10 + (var14 + var11) * var9 + var15 + var11] = var12;
                                            }
                                            if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 - 1) * var9 + var15 + var11] == -2) {
                                                this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 - 1) * var9 + var15 + var11] = var12;
                                            }
                                            if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 + 1) * var9 + var15 + var11] == -2) {
                                                this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 + 1) * var9 + var15 + var11] = var12;
                                            }
                                            if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + (var15 + var11 - 1)] == -2) {
                                                this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + (var15 + var11 - 1)] = var12;
                                            }
                                            if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + var15 + var11 + 1] == -2) {
                                                this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + var15 + var11 + 1] = var12;
                                            }
                                        }
                                        ++var15;
                                    }
                                    ++var14;
                                }
                                ++var13;
                            }
                        }
                        break;
                    }
                    var13 = -var7;
                    while (var13 <= var7) {
                        var14 = -var7;
                        while (var14 <= var7) {
                            var15 = var1.getBlockId(var2 + var12, var3 + var13, var4 + var14);
                            this.adjacentTreeBlocks[(var12 + var11) * var10 + (var13 + var11) * var9 + var14 + var11] = var15 == Block.logFir.blockID ? 0 : (var15 == Block.leavesFir.blockID ? -2 : -1);
                            ++var14;
                        }
                        ++var13;
                    }
                    ++var12;
                }
            }
            if ((var12 = this.adjacentTreeBlocks[var11 * var10 + var11 * var9 + var11]) >= 0) {
                var1.setBlockMetadata(var2, var3, var4, var6 & 0xFFFFFFF7);
            } else {
                this.removeLeaves(var1, var2, var3, var4);
            }
        }
    }

    private void removeLeaves(World var1, int var2, int var3, int var4) {
        this.dropBlockAsItem(var1, var2, var3, var4, var1.getBlockMetadata(var2, var3, var4));
        var1.setBlockWithNotify(var2, var3, var4, 0);
    }

    @Override
    public void dropBlockAsItem(World world, int n, int n2, int n3, int n4) {
        this.dropBlockAsItemWithChance(world, n, n2, n3, n4, 0.075f);
    }

    @Override
    public final int idDropped(int n, Random random) {
        return Block.saplingFir.blockID;
    }

    @Override
    public void harvestBlock(World var1, EntityPlayer var2, int var3, int var4, int var5, int var6) {
        if (!var1.multiplayerWorld && var2.getCurrentEquippedItem() != null && var2.getCurrentEquippedItem().getItem() instanceof ItemSword) {
            var2.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(var1, var3, var4, var5, new ItemStack(this.blockID, 1, var6 & 3));
            var2.addToPlayerScore(var2, 1);
        } else if (!var1.multiplayerWorld && var2.getCurrentEquippedItem() != null && var2.getCurrentEquippedItem().getItem() instanceof ItemFireSword) {
            var2.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(var1, var3, var4, var5, new ItemStack(Item.ash.itemID, 1, var6 & 3));
            var2.addToPlayerScore(var2, 1);
        } else {
            super.harvestBlock(var1, var2, var3, var4, var5, var6);
        }
    }

    @Override
    protected int damageDropped(int var1) {
        return var1 & 3;
    }

    @Override
    public boolean isOpaqueCube() {
        return !this.graphicsLevel;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int var1, int var2) {
        return (var2 & 3) == 1 ? this.blockIndexInTexture + 80 : this.blockIndexInTexture;
    }

    @Override
    public void setGraphicsLevel(boolean var1) {
        this.graphicsLevel = var1;
        this.blockIndexInTexture = this.baseIndexInPNG + (var1 ? 0 : 1);
    }

    @Override
    public void onEntityWalking(World var1, int var2, int var3, int var4, Entity var5) {
        super.onEntityWalking(var1, var2, var3, var4, var5);
    }
}

