/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.client.model.ModelBed;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.chunk.ChunkPosition;

public class BlockGearCircuitCopper
extends Block {
    private boolean wiresProvidePower = true;
    private Set field_21031_b = new HashSet();

    public BlockGearCircuitCopper(int var1, int var2) {
        super(var1, var2, Material.circuits);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int blockFace, int damageMetadata) {
        if (blockFace == 2) {
            return 274 + (damageMetadata <= 0 ? 0 : 16);
        }
        return this.blockIndexInTexture + (damageMetadata <= 0 ? 0 : 16);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World var1, int var2, int var3, int var4) {
        return null;
    }

    @Override
    public boolean canBlockStay(World world, int n, int n2, int n3) {
        return world.isBlockOpaqueCube(n, n2, n3 + 1) || world.isBlockOpaqueCube(n, n2, n3 - 1) || world.isBlockOpaqueCube(n - 1, n2, n3) || world.isBlockOpaqueCube(n + 1, n2, n3);
    }

    @Override
    public final boolean isCollidable() {
        return true;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 18;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int n, int n2, int n3) {
        return this.canBlockStay(world, n, n2, n3);
    }

    private void updateAndPropagateCurrentStrength(World var1, int var2, int var3, int var4) {
        this.func_21030_a(var1, var2, var3, var4, var2, var3, var4);
        ArrayList var5 = new ArrayList(this.field_21031_b);
        this.field_21031_b.clear();
        int var6 = 0;
        while (var6 < var5.size()) {
            ChunkPosition var7 = (ChunkPosition)var5.get(var6);
            var1.notifyBlocksOfNeighborChange(var7.x, var7.y, var7.z, this.blockID);
            ++var6;
        }
    }

    private void func_21030_a(World world, int xCoord, int yCoord, int zCoord, int var5, int var6, int var7) {
        int zSignal;
        int ySignal;
        int xSignal;
        int var11;
        int metadata = world.getBlockMetadata(xCoord, yCoord, zCoord);
        int signalStrength = 0;
        this.wiresProvidePower = false;
        boolean var10 = world.isBlockIndirectlyGettingPowered(xCoord, yCoord, zCoord);
        this.wiresProvidePower = true;
        if (var10) {
            signalStrength = 15;
        } else {
            var11 = 0;
            while (var11 < 6) {
                xSignal = xCoord;
                ySignal = yCoord;
                zSignal = zCoord;
                if (var11 == 0) {
                    xSignal = xCoord - 1;
                }
                if (var11 == 1) {
                    ++xSignal;
                }
                if (var11 == 2) {
                    zSignal = zCoord - 1;
                }
                if (var11 == 3) {
                    ++zSignal;
                }
                if (var11 == 4) {
                    ySignal = yCoord - 1;
                }
                if (var11 == 5) {
                    ++ySignal;
                }
                if (xSignal != var5 || ySignal != var6 || zSignal != var7) {
                    signalStrength = this.getMaxCurrentStrength(world, xSignal, ySignal, zSignal, signalStrength);
                }
                if (world.isBlockNormalCube(xSignal, ySignal, zSignal)) {
                    if (xSignal != var5 || ySignal != var6 || zSignal != var7) {
                        signalStrength = this.getMaxCurrentStrength(world, xSignal, ySignal, zSignal, signalStrength);
                    }
                } else if (!(world.isBlockNormalCube(xSignal, ySignal, zSignal) || xSignal == var5 && ySignal == var6 && zSignal == var7)) {
                    signalStrength = this.getMaxCurrentStrength(world, xSignal, ySignal, zSignal, signalStrength);
                }
                ++var11;
            }
            signalStrength = signalStrength > 0 ? --signalStrength : 0;
        }
        if (metadata != signalStrength) {
            world.editingBlocks = true;
            world.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, signalStrength);
            world.markBlocksDirty(xCoord, yCoord, zCoord, xCoord, yCoord, zCoord);
            world.editingBlocks = false;
            var11 = 0;
            while (var11 < 6) {
                xSignal = xCoord;
                ySignal = yCoord;
                zSignal = zCoord;
                int var14 = yCoord - 1;
                if (var11 == 0) {
                    xSignal = xCoord - 1;
                }
                if (var11 == 1) {
                    ++xSignal;
                }
                if (var11 == 2) {
                    zSignal = zCoord - 1;
                }
                if (var11 == 3) {
                    ++zSignal;
                }
                if (var11 == 4) {
                    ySignal = yCoord - 1;
                }
                if (var11 == 5) {
                    ++ySignal;
                }
                boolean var15 = false;
                int var16 = this.getMaxCurrentStrength(world, xSignal, ySignal, zSignal, -1);
                signalStrength = world.getBlockMetadata(xCoord, yCoord, zCoord);
                if (signalStrength > 0) {
                    --signalStrength;
                }
                if (var16 >= 0 && var16 != signalStrength) {
                    this.func_21030_a(world, xSignal, ySignal, zSignal, xCoord, yCoord, zCoord);
                }
                ++var11;
            }
            if (metadata == 0 || signalStrength == 0) {
                this.field_21031_b.add(new ChunkPosition(xCoord, yCoord, zCoord));
                this.field_21031_b.add(new ChunkPosition(xCoord - 1, yCoord, zCoord));
                this.field_21031_b.add(new ChunkPosition(xCoord + 1, yCoord, zCoord));
                this.field_21031_b.add(new ChunkPosition(xCoord, yCoord - 1, zCoord));
                this.field_21031_b.add(new ChunkPosition(xCoord, yCoord + 1, zCoord));
                this.field_21031_b.add(new ChunkPosition(xCoord, yCoord, zCoord - 1));
                this.field_21031_b.add(new ChunkPosition(xCoord, yCoord, zCoord + 1));
            }
        }
    }

    private void notifyWireNeighborsOfNeighborChange(World var1, int var2, int var3, int var4) {
        if (var1.getBlockId(var2, var3, var4) == this.blockID) {
            var1.notifyBlocksOfNeighborChange(var2, var3, var4, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2 - 1, var3, var4, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2 + 1, var3, var4, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2, var3, var4 - 1, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2, var3, var4 + 1, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2, var3 - 1, var4, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2, var3 + 1, var4, this.blockID);
        }
    }

    @Override
    public void onBlockAdded(World var1, int var2, int var3, int var4) {
        super.onBlockAdded(var1, var2, var3, var4);
        if (!var1.multiplayerWorld) {
            this.updateAndPropagateCurrentStrength(var1, var2, var3, var4);
            var1.notifyBlocksOfNeighborChange(var2, var3 + 1, var4, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2, var3 - 1, var4, this.blockID);
            this.notifyWireNeighborsOfNeighborChange(var1, var2 - 1, var3, var4);
            this.notifyWireNeighborsOfNeighborChange(var1, var2 + 1, var3, var4);
            this.notifyWireNeighborsOfNeighborChange(var1, var2, var3, var4 - 1);
            this.notifyWireNeighborsOfNeighborChange(var1, var2, var3, var4 + 1);
            if (var1.isBlockNormalCube(var2 - 1, var3, var4)) {
                this.notifyWireNeighborsOfNeighborChange(var1, var2 - 1, var3 + 1, var4);
            } else {
                this.notifyWireNeighborsOfNeighborChange(var1, var2 - 1, var3 - 1, var4);
            }
            if (var1.isBlockNormalCube(var2 + 1, var3, var4)) {
                this.notifyWireNeighborsOfNeighborChange(var1, var2 + 1, var3 + 1, var4);
            } else {
                this.notifyWireNeighborsOfNeighborChange(var1, var2 + 1, var3 - 1, var4);
            }
            if (var1.isBlockNormalCube(var2, var3, var4 - 1)) {
                this.notifyWireNeighborsOfNeighborChange(var1, var2, var3 + 1, var4 - 1);
            } else {
                this.notifyWireNeighborsOfNeighborChange(var1, var2, var3 - 1, var4 - 1);
            }
            if (var1.isBlockNormalCube(var2, var3, var4 + 1)) {
                this.notifyWireNeighborsOfNeighborChange(var1, var2, var3 + 1, var4 + 1);
            } else {
                this.notifyWireNeighborsOfNeighborChange(var1, var2, var3 - 1, var4 + 1);
            }
        }
    }

    @Override
    public void onBlockRemoval(World var1, int var2, int var3, int var4) {
        super.onBlockRemoval(var1, var2, var3, var4);
        if (!var1.multiplayerWorld) {
            var1.notifyBlocksOfNeighborChange(var2, var3 + 1, var4, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2, var3 - 1, var4, this.blockID);
            this.updateAndPropagateCurrentStrength(var1, var2, var3, var4);
            this.notifyWireNeighborsOfNeighborChange(var1, var2 - 1, var3, var4);
            this.notifyWireNeighborsOfNeighborChange(var1, var2 + 1, var3, var4);
            this.notifyWireNeighborsOfNeighborChange(var1, var2, var3, var4 - 1);
            this.notifyWireNeighborsOfNeighborChange(var1, var2, var3, var4 + 1);
            if (var1.isBlockNormalCube(var2 - 1, var3, var4)) {
                this.notifyWireNeighborsOfNeighborChange(var1, var2 - 1, var3 + 1, var4);
            } else {
                this.notifyWireNeighborsOfNeighborChange(var1, var2 - 1, var3 - 1, var4);
            }
            if (var1.isBlockNormalCube(var2 + 1, var3, var4)) {
                this.notifyWireNeighborsOfNeighborChange(var1, var2 + 1, var3 + 1, var4);
            } else {
                this.notifyWireNeighborsOfNeighborChange(var1, var2 + 1, var3 - 1, var4);
            }
            if (var1.isBlockNormalCube(var2, var3, var4 - 1)) {
                this.notifyWireNeighborsOfNeighborChange(var1, var2, var3 + 1, var4 - 1);
            } else {
                this.notifyWireNeighborsOfNeighborChange(var1, var2, var3 - 1, var4 - 1);
            }
            if (var1.isBlockNormalCube(var2, var3, var4 + 1)) {
                this.notifyWireNeighborsOfNeighborChange(var1, var2, var3 + 1, var4 + 1);
            } else {
                this.notifyWireNeighborsOfNeighborChange(var1, var2, var3 - 1, var4 + 1);
            }
        }
    }

    private int getMaxCurrentStrength(World var1, int var2, int var3, int var4, int var5) {
        if (var1.getBlockId(var2, var3, var4) != this.blockID) {
            return var5;
        }
        int var6 = var1.getBlockMetadata(var2, var3, var4);
        return var6 > var5 ? var6 : var5;
    }

    @Override
    public void onNeighborBlockChange(World var1, int var2, int var3, int var4, int var5) {
        if (!var1.multiplayerWorld) {
            int var6 = var1.getBlockMetadata(var2, var3, var4);
            boolean var7 = this.canPlaceBlockAt(var1, var2, var3, var4);
            if (!var7) {
                this.dropBlockAsItem(var1, var2, var3, var4, var6);
                var1.setBlockWithNotify(var2, var3, var4, 0);
            } else {
                this.updateAndPropagateCurrentStrength(var1, var2, var3, var4);
            }
            super.onNeighborBlockChange(var1, var2, var3, var4, var5);
        }
    }

    @Override
    public int idDropped(int var1, Random var2) {
        return this.blockID;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World var1, int var2, int var3, int var4, int var5) {
        return !this.wiresProvidePower ? false : this.isPoweringTo(var1, var2, var3, var4, var5);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess var1, int var2, int var3, int var4, int blockFace) {
        boolean var9;
        if (!this.wiresProvidePower) {
            return false;
        }
        if (var1.getBlockMetadata(var2, var3, var4) == 0) {
            return false;
        }
        if (blockFace == 1) {
            return true;
        }
        if (blockFace == 0) {
            return true;
        }
        boolean var6 = BlockGearCircuitCopper.isPowerProviderOrWire(var1, var2 - 1, var3, var4, 1) || !var1.isBlockNormalCube(var2 - 1, var3, var4) && BlockGearCircuitCopper.isPowerProviderOrWire(var1, var2 - 1, var3 - 1, var4, -1) && BlockGearCircuitCopper.isPowerProviderOrWire(var1, var2 - 1, var3 + 1, var4, -1);
        boolean var7 = BlockGearCircuitCopper.isPowerProviderOrWire(var1, var2 + 1, var3, var4, 3) || !var1.isBlockNormalCube(var2 + 1, var3, var4) && BlockGearCircuitCopper.isPowerProviderOrWire(var1, var2 + 1, var3 - 1, var4, -1) && BlockGearCircuitCopper.isPowerProviderOrWire(var1, var2 + 1, var3 + 1, var4, -1);
        boolean var8 = BlockGearCircuitCopper.isPowerProviderOrWire(var1, var2, var3, var4 - 1, 2) || !var1.isBlockNormalCube(var2, var3, var4 - 1) && BlockGearCircuitCopper.isPowerProviderOrWire(var1, var2, var3 - 1, var4 - 1, -1) && BlockGearCircuitCopper.isPowerProviderOrWire(var1, var2, var3 + 1, var4 - 1, -1);
        boolean bl = var9 = BlockGearCircuitCopper.isPowerProviderOrWire(var1, var2, var3, var4 + 1, 0) || !var1.isBlockNormalCube(var2, var3, var4 + 1) && BlockGearCircuitCopper.isPowerProviderOrWire(var1, var2, var3 - 1, var4 + 1, -1) && BlockGearCircuitCopper.isPowerProviderOrWire(var1, var2, var3 + 1, var4 + 1, -1);
        if (!(var8 || var7 || var6 || var9 || blockFace < 2 || blockFace > 5)) {
            return true;
        }
        if (blockFace == 2 && var8 && !var6 && !var7) {
            return true;
        }
        if (blockFace == 3 && var9 && !var6 && !var7) {
            return true;
        }
        if (blockFace == 4 && var6 && !var8 && !var9) {
            return true;
        }
        return blockFace == 5 && var7 && !var8 && !var9;
    }

    @Override
    public boolean canProvidePower() {
        return this.wiresProvidePower;
    }

    @Override
    public void randomDisplayTick(World var1, int var2, int var3, int var4, Random var5) {
        int var6 = var1.getBlockMetadata(var2, var3, var4);
        if (var6 > 0) {
            double var7 = (double)var2 + 0.5 + ((double)var5.nextFloat() - 0.5) * 0.2;
            double var9 = (float)var3 + 0.0625f;
            double var11 = (double)var4 + 0.5 + ((double)var5.nextFloat() - 0.5) * 0.2;
            float var13 = (float)var6 / 15.0f;
            float var14 = var13 * 0.6f + 0.4f;
            if (var6 == 0) {
                var14 = 0.0f;
            }
            float var15 = var13 * var13 * 0.7f - 0.5f;
            float var16 = var13 * var13 * 0.6f - 0.7f;
            if (var15 < 0.0f) {
                var15 = 0.0f;
            }
            if (var16 < 0.0f) {
                var16 = 0.0f;
            }
            double var100 = (double)var2 + (double)var1.rand.nextFloat() * 0.5 + 0.5;
            double var300 = (double)var3 + (double)var1.rand.nextFloat() * 0.5 + 0.5;
            double var500 = (double)var4 + (double)var1.rand.nextFloat() * 0.5 + 0.5;
            var1.spawnParticle("smoke", var100, var300, var500, 0.0, 0.0, 0.0);
        }
    }

    public static boolean isPowerProviderOrWire(IBlockAccess blockAccess, int var1, int var2, int var3, int var4) {
        int connectedBlock = blockAccess.getBlockId(var1, var2, var3);
        if (connectedBlock == Block.gear.blockID) {
            return true;
        }
        if (connectedBlock == 0) {
            return false;
        }
        if (Block.blocksList[connectedBlock].canProvidePower()) {
            return true;
        }
        if (connectedBlock != Block.gearRelayIdle.blockID && connectedBlock != Block.gearRelayActive.blockID && connectedBlock != Block.gearWaitIdle.blockID && connectedBlock != Block.gearWaitActive.blockID && connectedBlock != Block.gearNotGateIdle.blockID && connectedBlock != Block.gearNotGateActive.blockID) {
            return false;
        }
        int metadata = blockAccess.getBlockMetadata(var1, var2, var3);
        return var4 == ModelBed.field_22279_b[metadata & 3];
    }
}

