/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.level.World;

public final class BlockGears
extends Block {
    protected BlockGears(int n, int n2) {
        super(n, n2, Material.circuits);
    }

    @Override
    public final AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int n, int n2, int n3) {
        return null;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int n, int n2, int n3) {
        return this.canBlockStay(world, n, n2, n3);
    }

    @Override
    public void updateTick(World world, int n, int n2, int n3, Random random) {
    }

    private void gearUpdate(World world, int n, int n2, int n3) {
        if (!this.canBlockStay(world, n, n2, n3)) {
            this.dropBlockAsItem(world, n, n2, n3, world.getBlockMetadata(n, n2, n3));
            world.setBlockWithNotify(n, n2, n3, 0);
        }
    }

    @Override
    public int tickRate() {
        return 1;
    }

    @Override
    public final void onNeighborBlockChange(World world, int n, int n2, int n3, int n4) {
        super.onNeighborBlockChange(world, n, n2, n3, n4);
        this.gearUpdate(world, n, n2, n3);
    }

    @Override
    public boolean canBlockStay(World world, int n, int n2, int n3) {
        return world.isBlockOpaqueCube(n, n2, n3 + 1) || world.isBlockOpaqueCube(n, n2, n3 - 1) || world.isBlockOpaqueCube(n - 1, n2, n3) || world.isBlockOpaqueCube(n + 1, n2, n3);
    }

    @Override
    public final boolean isOpaqueCube() {
        return false;
    }

    @Override
    public final boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public final int getRenderType() {
        return 18;
    }

    @Override
    public final int quantityDropped(Random random) {
        return 1;
    }

    @Override
    public final boolean isCollidable() {
        return true;
    }
}

