/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.BlockFalling;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;

public class BlockGravel
extends BlockFalling {
    public BlockGravel(int id, int texture) {
        super(id, texture, Material.sand);
    }

    @Override
    public void harvestBlock(World world, EntityPlayer thePlayer, int xCoord, int yCoord, int zCoord, int damageMetadata) {
        if (thePlayer.getCurrentEquippedItem() != null && thePlayer.inventory.getCurrentItem().getItem().itemID == Item.shovelStone.itemID) {
            Random rand = new Random();
            if (rand.nextBoolean()) {
                this.dropBlockAsItem_do(world, xCoord, yCoord, zCoord, new ItemStack(Item.flint.itemID, 1, damageMetadata));
                thePlayer.addToPlayerScore(thePlayer, 1);
            } else {
                super.harvestBlock(world, thePlayer, xCoord, yCoord, zCoord, damageMetadata);
            }
        } else {
            super.harvestBlock(world, thePlayer, xCoord, yCoord, zCoord, damageMetadata);
        }
    }

    @Override
    public int idDropped(int damageMetadata, Random rand) {
        return rand.nextInt(10) == 0 ? Item.flint.itemID : this.blockID;
    }
}

