/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.stats.StatList;

public class BlockLog
extends Block {
    protected BlockLog(int id) {
        super(id, Material.wood);
        this.blockIndexInTexture = 20;
    }

    @Override
    public int quantityDropped(Random rand) {
        return 1;
    }

    @Override
    protected int damageDropped(int damageMetadata) {
        return damageMetadata;
    }

    @Override
    public int idDropped(int damageMetadata, Random rand) {
        return Block.log.blockID;
    }

    @Override
    public void harvestBlock(World world, EntityPlayer thePlayer, int xCoord, int yCoord, int zCoord, int damageMetadata) {
        if (thePlayer.getCurrentEquippedItem() != null && thePlayer.inventory.getCurrentItem().getItem().itemID == Item.axeStone.itemID) {
            if (damageMetadata <= 2) {
                Random rand = new Random();
                int num = rand.nextBoolean() ? 2 : 1;
                this.dropBlockAsItem_do(world, xCoord, yCoord, zCoord, new ItemStack(this.blockID, num, damageMetadata + 3));
                thePlayer.addToPlayerScore(thePlayer, 1);
            } else {
                super.harvestBlock(world, thePlayer, xCoord, yCoord, zCoord, damageMetadata);
            }
        } else if (!world.multiplayerWorld && thePlayer.getCurrentEquippedItem() != null && thePlayer.getCurrentEquippedItem().itemID == Item.axeFire.itemID) {
            thePlayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(world, xCoord, yCoord, zCoord, new ItemStack(Item.coal.itemID, 1, damageMetadata & 3));
            thePlayer.addToPlayerScore(thePlayer, 1);
        } else {
            super.harvestBlock(world, thePlayer, xCoord, yCoord, zCoord, damageMetadata);
        }
    }

    @Override
    public void onBlockRemoval(World world, int xCoord, int yCoord, int zCoord) {
        int blocksBelow = 4;
        int blocksToSides = blocksBelow + 1;
        if (world.checkChunksExist(xCoord - blocksToSides, yCoord - blocksToSides, zCoord - blocksToSides, xCoord + blocksToSides, yCoord + blocksToSides, zCoord + blocksToSides)) {
            int xCheck = -blocksBelow;
            while (xCheck <= blocksBelow) {
                int yCheck = -blocksBelow;
                while (yCheck <= blocksBelow) {
                    int zCheck = -blocksBelow;
                    while (zCheck <= blocksBelow) {
                        int setMetadata;
                        int totalBlockCheck = world.getBlockId(xCoord + xCheck, yCoord + yCheck, zCoord + zCheck);
                        if (totalBlockCheck == Block.leaves.blockID && ((setMetadata = world.getBlockMetadata(xCoord + xCheck, yCoord + yCheck, zCoord + zCheck)) & 8) == 0) {
                            world.setBlockMetadata(xCoord + xCheck, yCoord + yCheck, zCoord + zCheck, setMetadata | 8);
                        }
                        ++zCheck;
                    }
                    ++yCheck;
                }
                ++xCheck;
            }
        }
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int blockFace, int damageMetadata) {
        if (blockFace == 1 || blockFace == 0) {
            return 21;
        }
        if (damageMetadata == 0 || damageMetadata == 3) {
            return 20;
        }
        if (damageMetadata == 1 || damageMetadata == 4) {
            return 116;
        }
        if (damageMetadata == 2 || damageMetadata == 5) {
            return 117;
        }
        return 20;
    }
}

