/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.stats.StatList;

public class BlockMycelium
extends Block {
    protected BlockMycelium(int i) {
        super(i, Material.ground);
        this.blockIndexInTexture = 183;
        this.setTickOnLoad(true);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (i == 1) {
            return 184;
        }
        return i != 0 ? 183 : 2;
    }

    @Override
    public int getBlockTexture(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (l == 1) {
            return 184;
        }
        if (l == 0) {
            return 2;
        }
        return 183;
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.multiplayerWorld) {
            return;
        }
        if (world.getBlockLightValue(i, j + 1, k) < 4 && Block.lightOpacity[world.getBlockId(i, j + 1, k)] > 2 && world.getBlockId(i, j + 1, k) != Block.snowBlock.blockID) {
            world.setBlockWithNotify(i, j, k, Block.dirt.blockID);
        } else if (world.getBlockLightValue(i, j + 1, k) >= 9) {
            int l = 0;
            while (l < 4) {
                int i1 = i + random.nextInt(3) - 1;
                int j1 = j + random.nextInt(5) - 3;
                int k1 = k + random.nextInt(3) - 1;
                int l1 = world.getBlockId(i1, j1 + 1, k1);
                if (world.getBlockId(i1, j1, k1) == Block.dirt.blockID && l1 != Block.waterMoving.blockID && l1 != Block.waterStill.blockID && world.getBlockLightValue(i1, j1 + 1, k1) >= 4 && Block.lightOpacity[l1] <= 2) {
                    world.setBlockWithNotify(i1, j1, k1, this.blockID);
                }
                ++l;
            }
        }
        if (world.getBlockId(i, j + 1, k) == Block.path.blockID) {
            world.setBlockWithNotify(i, j, k, Block.dirt.blockID);
        }
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        super.randomDisplayTick(world, i, j, k, random);
        if (random.nextInt(10) == 0) {
            world.spawnParticle("townaura", (float)i + random.nextFloat(), (float)j + 1.1f, (float)k + random.nextFloat(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int idDropped(int i, Random random) {
        return Block.dirt.idDropped(0, random);
    }

    @Override
    public void harvestBlock(World var1, EntityPlayer var2, int var3, int var4, int var5, int var6) {
        if (!var1.multiplayerWorld && var2.getCurrentEquippedItem() != null && var2.getCurrentEquippedItem().itemID == Item.shovelGold.itemID) {
            var2.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(var1, var3, var4, var5, new ItemStack(Block.mycelium.blockID, 1, var6 & 3));
            var2.addToPlayerScore(var2, 1);
        } else {
            super.harvestBlock(var1, var2, var3, var4, var5, var6);
        }
    }
}

