/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block.tileentity;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.tileentity.TileEntityAnvil;
import net.minecraft.src.game.block.tileentity.TileEntityBlastFurnace;
import net.minecraft.src.game.block.tileentity.TileEntityCauldron;
import net.minecraft.src.game.block.tileentity.TileEntityChair;
import net.minecraft.src.game.block.tileentity.TileEntityChairCrimson;
import net.minecraft.src.game.block.tileentity.TileEntityChairFirwood;
import net.minecraft.src.game.block.tileentity.TileEntityChairStone;
import net.minecraft.src.game.block.tileentity.TileEntityChest;
import net.minecraft.src.game.block.tileentity.TileEntityDispenser;
import net.minecraft.src.game.block.tileentity.TileEntityFurnace;
import net.minecraft.src.game.block.tileentity.TileEntityMobSpawner;
import net.minecraft.src.game.block.tileentity.TileEntityNote;
import net.minecraft.src.game.block.tileentity.TileEntityPiston;
import net.minecraft.src.game.block.tileentity.TileEntityReactor;
import net.minecraft.src.game.block.tileentity.TileEntityRecordPlayer;
import net.minecraft.src.game.block.tileentity.TileEntitySign;
import net.minecraft.src.game.block.tileentity.TileEntityTable;
import net.minecraft.src.game.block.tileentity.TileEntityTableCrimson;
import net.minecraft.src.game.block.tileentity.TileEntityTableFirwood;
import net.minecraft.src.game.block.tileentity.TileEntityTableGlass;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class TileEntity {
    public Entity riddenByEntity;
    public Entity ridingEntity;
    private static Map nameToClassMap = new HashMap();
    private static Map classToNameMap = new HashMap();
    public World worldObj;
    public int xCoord;
    public int yCoord;
    public int zCoord;
    protected boolean field_31007_h;
    private static Random rand = new Random();
    public static int keyInt = rand.nextInt(4);

    static {
        TileEntity.addMapping(TileEntityFurnace.class, "Furnace");
        TileEntity.addMapping(TileEntityChest.class, "Chest");
        TileEntity.addMapping(TileEntityRecordPlayer.class, "RecordPlayer");
        TileEntity.addMapping(TileEntityDispenser.class, "Trap");
        TileEntity.addMapping(TileEntitySign.class, "Sign");
        TileEntity.addMapping(TileEntityMobSpawner.class, "MobSpawner");
        TileEntity.addMapping(TileEntityNote.class, "Music");
        TileEntity.addMapping(TileEntityPiston.class, "Piston");
        TileEntity.addMapping(TileEntityBlastFurnace.class, "BlastFurnace");
        TileEntity.addMapping(TileEntityChair.class, "Chair");
        TileEntity.addMapping(TileEntityChairCrimson.class, "ChairRed");
        TileEntity.addMapping(TileEntityChairFirwood.class, "ChairGray");
        TileEntity.addMapping(TileEntityTable.class, "Table");
        TileEntity.addMapping(TileEntityTableCrimson.class, "TableRed");
        TileEntity.addMapping(TileEntityTableFirwood.class, "TableGray");
        TileEntity.addMapping(TileEntityChairStone.class, "ChairStone");
        TileEntity.addMapping(TileEntityReactor.class, "Reactor");
        TileEntity.addMapping(TileEntityTableGlass.class, "TableGlass");
        TileEntity.addMapping(TileEntityCauldron.class, "Cauldron");
        TileEntity.addMapping(TileEntityAnvil.class, "Anvil");
    }

    private static void addMapping(Class var0, String var1) {
        if (classToNameMap.containsKey(var1)) {
            throw new IllegalArgumentException("Duplicate id: " + var1);
        }
        nameToClassMap.put(var1, var0);
        classToNameMap.put(var0, var1);
    }

    public void readFromNBT(NBTTagCompound var1) {
        this.xCoord = var1.getInteger("x");
        this.yCoord = var1.getInteger("y");
        this.zCoord = var1.getInteger("z");
    }

    public void writeToNBT(NBTTagCompound var1) {
        String var2 = (String)classToNameMap.get(this.getClass());
        if (var2 == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        var1.setString("id", var2);
        var1.setInteger("x", this.xCoord);
        var1.setInteger("y", this.yCoord);
        var1.setInteger("z", this.zCoord);
    }

    public void updateEntity() {
    }

    public static TileEntity createAndLoadEntity(NBTTagCompound var0) {
        TileEntity var1 = null;
        try {
            Class var2 = (Class)nameToClassMap.get(var0.getString("id"));
            if (var2 != null) {
                var1 = (TileEntity)var2.newInstance();
            }
        }
        catch (Exception var3) {
            var3.printStackTrace();
        }
        if (var1 != null) {
            var1.readFromNBT(var0);
        } else {
            System.out.println("Skipping TileEntity with id " + var0.getString("id"));
        }
        return var1;
    }

    public int getBlockMetadata() {
        return this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
    }

    public void y_() {
        if (this.worldObj != null) {
            this.worldObj.func_698_b(this.xCoord, this.yCoord, this.zCoord, this);
        }
    }

    public double getDistanceFrom(double var1, double var3, double var5) {
        double var7 = (double)this.xCoord + 0.5 - var1;
        double var9 = (double)this.yCoord + 0.5 - var3;
        double var11 = (double)this.zCoord + 0.5 - var5;
        return var7 * var7 + var9 * var9 + var11 * var11;
    }

    public Block getBlockType() {
        return Block.blocksList[this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord)];
    }

    public boolean func_31006_g() {
        return this.field_31007_h;
    }

    public void func_31005_i() {
        this.field_31007_h = true;
    }

    public void func_31004_j() {
        this.field_31007_h = false;
    }
}

