/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block.tileentity;

import net.minecraft.src.client.inventory.IInventory;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockFurnace;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.nbt.NBTTagCompound;
import net.minecraft.src.game.nbt.NBTTagList;
import net.minecraft.src.game.recipe.FurnaceRecipes;

public class TileEntityFurnace
extends TileEntity
implements IInventory {
    public ItemStack[] furnaceItemStacks = new ItemStack[3];
    public int furnaceBurnTime = 0;
    public int currentItemBurnTime = 0;
    public int furnaceCookTime = 0;

    @Override
    public int getSizeInventory() {
        return this.furnaceItemStacks.length;
    }

    @Override
    public ItemStack getStackInSlot(int var1) {
        return this.furnaceItemStacks[var1];
    }

    @Override
    public ItemStack decrStackSize(int var1, int var2) {
        if (this.furnaceItemStacks[var1] != null) {
            if (this.furnaceItemStacks[var1].stackSize <= var2) {
                ItemStack var3 = this.furnaceItemStacks[var1];
                this.furnaceItemStacks[var1] = null;
                return var3;
            }
            ItemStack var3 = this.furnaceItemStacks[var1].splitStack(var2);
            if (this.furnaceItemStacks[var1].stackSize == 0) {
                this.furnaceItemStacks[var1] = null;
            }
            return var3;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int var1, ItemStack var2) {
        this.furnaceItemStacks[var1] = var2;
        if (var2 != null && var2.stackSize > this.getInventoryStackLimit()) {
            var2.stackSize = this.getInventoryStackLimit();
        }
    }

    @Override
    public String getInvName() {
        return "Furnace";
    }

    @Override
    public void readFromNBT(NBTTagCompound var1) {
        super.readFromNBT(var1);
        NBTTagList var2 = var1.getTagList("Items");
        this.furnaceItemStacks = new ItemStack[this.getSizeInventory()];
        int var3 = 0;
        while (var3 < var2.tagCount()) {
            NBTTagCompound var4 = (NBTTagCompound)var2.tagAt(var3);
            byte var5 = var4.getByte("Slot");
            if (var5 >= 0 && var5 < this.furnaceItemStacks.length) {
                this.furnaceItemStacks[var5] = new ItemStack(var4);
            }
            ++var3;
        }
        this.furnaceBurnTime = var1.getShort("BurnTime");
        this.furnaceCookTime = var1.getShort("CookTime");
        this.currentItemBurnTime = this.getItemBurnTime(this.furnaceItemStacks[1]);
    }

    @Override
    public void writeToNBT(NBTTagCompound var1) {
        super.writeToNBT(var1);
        var1.setShort("BurnTime", (short)this.furnaceBurnTime);
        var1.setShort("CookTime", (short)this.furnaceCookTime);
        NBTTagList var2 = new NBTTagList();
        int var3 = 0;
        while (var3 < this.furnaceItemStacks.length) {
            if (this.furnaceItemStacks[var3] != null) {
                NBTTagCompound var4 = new NBTTagCompound();
                var4.setByte("Slot", (byte)var3);
                this.furnaceItemStacks[var3].writeToNBT(var4);
                var2.setTag(var4);
            }
            ++var3;
        }
        var1.setTag("Items", var2);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    public int getCookProgressScaled(int var1) {
        return this.furnaceCookTime * var1 / 200;
    }

    public int getBurnTimeRemainingScaled(int var1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * var1 / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @Override
    public void updateEntity() {
        boolean var1 = this.furnaceBurnTime > 0;
        boolean var2 = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.worldObj.multiplayerWorld) {
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = this.getItemBurnTime(this.furnaceItemStacks[1]);
                if (this.furnaceBurnTime > 0) {
                    var2 = true;
                    if (this.furnaceItemStacks[1] != null) {
                        --this.furnaceItemStacks[1].stackSize;
                        if (this.furnaceItemStacks[1].stackSize == 0) {
                            this.furnaceItemStacks[1] = null;
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == 200) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    var2 = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (var1 != this.furnaceBurnTime > 0) {
                var2 = true;
                BlockFurnace.updateFurnaceBlockState(this.furnaceBurnTime > 0, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            }
        }
        if (var2) {
            this.onInventoryChanged();
        }
    }

    private boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        ItemStack var1 = FurnaceRecipes.smelting().getSmeltingResult(this.furnaceItemStacks[0].getItem().itemID);
        if (var1 == null) {
            return false;
        }
        if (this.furnaceItemStacks[2] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[2].isItemEqual(var1)) {
            return false;
        }
        if (this.furnaceItemStacks[2].stackSize < this.getInventoryStackLimit() && this.furnaceItemStacks[2].stackSize < this.furnaceItemStacks[2].getMaxStackSize()) {
            return true;
        }
        return this.furnaceItemStacks[2].stackSize < var1.getMaxStackSize();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack var1 = FurnaceRecipes.smelting().getSmeltingResult(this.furnaceItemStacks[0].getItem().itemID);
            if (this.furnaceItemStacks[2] == null) {
                this.furnaceItemStacks[2] = var1.copy();
            } else if (this.furnaceItemStacks[2].itemID == var1.itemID) {
                ++this.furnaceItemStacks[2].stackSize;
            }
            if (this.furnaceItemStacks[0].getItem() != Item.bucketMilk) {
                --this.furnaceItemStacks[0].stackSize;
            } else {
                this.furnaceItemStacks[0] = new ItemStack(Item.bucketEmpty, 1);
            }
            if (this.furnaceItemStacks[0].stackSize <= 0) {
                this.furnaceItemStacks[0] = null;
            }
        }
    }

    private int getItemBurnTime(ItemStack var1) {
        if (var1 == null) {
            return 0;
        }
        int var2 = var1.getItem().itemID;
        if (var2 < 256 && Block.blocksList[var2].blockMaterial == Material.wood) {
            return 300;
        }
        if (var2 == Item.stick.itemID) {
            return 100;
        }
        if (var2 == Block.saplingFir.blockID) {
            return 100;
        }
        if (var2 == Block.tallGrass.blockID) {
            return 100;
        }
        if (var2 == Block.fern.blockID) {
            return 100;
        }
        if (var2 == Block.shrub.blockID) {
            return 100;
        }
        if (var2 == Block.leaves.blockID) {
            return 100;
        }
        if (var2 == Block.leavesFir.blockID) {
            return 100;
        }
        if (var2 == Block.leavesBlossoming.blockID) {
            return 100;
        }
        if (var2 == Block.deadBush.blockID) {
            return 100;
        }
        if (var2 == Block.dandelion.blockID) {
            return 100;
        }
        if (var2 == Block.roseRed.blockID) {
            return 100;
        }
        if (var2 == Block.roseCyan.blockID) {
            return 100;
        }
        if (var2 == Block.paeonia.blockID) {
            return 100;
        }
        if (var2 == Block.marigold.blockID) {
            return 100;
        }
        if (var2 == Block.blockCoal.blockID) {
            return 16000;
        }
        if (var2 == Block.glowstone.blockID) {
            return 8000;
        }
        if (var2 == Block.magma.blockID) {
            return 2400;
        }
        if (var2 == Block.cloth.blockID) {
            return 300;
        }
        if (var2 == Block.sponge.blockID) {
            return 300;
        }
        if (var2 == Block.slabSingleSponge.blockID) {
            return 300;
        }
        if (var2 == Block.spongeStairs.blockID) {
            return 300;
        }
        if (var2 == Block.cactus.blockID) {
            return 300;
        }
        if (var2 == Block.blueberryBush.blockID) {
            return 300;
        }
        if (var2 == Block.caveRoots.blockID) {
            return 100;
        }
        if (var2 == Block.cobweb.blockID) {
            return 300;
        }
        if (var2 == Item.sugarCane.itemID) {
            return 100;
        }
        if (var2 == Item.silk.itemID) {
            return 100;
        }
        if (var2 == Item.coal.itemID) {
            return 1600;
        }
        if (var2 == Item.doorWood.itemID) {
            return 1200;
        }
        if (var2 == Item.doorFirwoodItem.itemID) {
            return 1200;
        }
        if (var2 == Item.chairOak.itemID) {
            return 1200;
        }
        if (var2 == Item.chairFir.itemID) {
            return 1200;
        }
        if (var2 == Item.tableOak.itemID) {
            return 1200;
        }
        if (var2 == Item.tableFir.itemID) {
            return 1200;
        }
        if (var2 == Item.boat.itemID) {
            return 1200;
        }
        if (var2 == Item.lightStoneDust.itemID) {
            return 1600;
        }
        if (var2 == Item.bucketLava.itemID) {
            this.furnaceItemStacks[1] = new ItemStack(Item.bucketEmpty, 1);
            return 20000;
        }
        return var2 == Block.sapling.blockID ? 100 : 0;
    }

    @Override
    public boolean canInteractWith(EntityPlayer var1) {
        if (this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return var1.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void func_183_c() {
    }

    @Override
    public void onInventoryChanged() {
    }
}

