/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block.tileentity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.src.client.gui.FontRenderer;
import net.minecraft.src.client.renderer.RenderEngine;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.block.tileentity.TileEntityChair;
import net.minecraft.src.game.block.tileentity.TileEntityChairCrimson;
import net.minecraft.src.game.block.tileentity.TileEntityChairCrimsonRenderer;
import net.minecraft.src.game.block.tileentity.TileEntityChairFirwood;
import net.minecraft.src.game.block.tileentity.TileEntityChairFirwoodRenderer;
import net.minecraft.src.game.block.tileentity.TileEntityChairRenderer;
import net.minecraft.src.game.block.tileentity.TileEntityChairStone;
import net.minecraft.src.game.block.tileentity.TileEntityChairStoneRenderer;
import net.minecraft.src.game.block.tileentity.TileEntityMobSpawner;
import net.minecraft.src.game.block.tileentity.TileEntityMobSpawnerRenderer;
import net.minecraft.src.game.block.tileentity.TileEntityPiston;
import net.minecraft.src.game.block.tileentity.TileEntityRendererPiston;
import net.minecraft.src.game.block.tileentity.TileEntitySign;
import net.minecraft.src.game.block.tileentity.TileEntitySignRenderer;
import net.minecraft.src.game.block.tileentity.TileEntitySpecialRenderer;
import net.minecraft.src.game.block.tileentity.TileEntityTable;
import net.minecraft.src.game.block.tileentity.TileEntityTableCrimson;
import net.minecraft.src.game.block.tileentity.TileEntityTableCrimsonRenderer;
import net.minecraft.src.game.block.tileentity.TileEntityTableFirwood;
import net.minecraft.src.game.block.tileentity.TileEntityTableFirwoodRenderer;
import net.minecraft.src.game.block.tileentity.TileEntityTableGlass;
import net.minecraft.src.game.block.tileentity.TileEntityTableGlassRenderer;
import net.minecraft.src.game.block.tileentity.TileEntityTableRenderer;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.level.World;
import org.lwjgl.opengl.GL11;

public class TileEntityRenderer {
    private Map specialRendererMap = new HashMap();
    public static TileEntityRenderer instance = new TileEntityRenderer();
    private FontRenderer fontRenderer;
    public static double staticPlayerX;
    public static double staticPlayerY;
    public static double staticPlayerZ;
    public RenderEngine renderEngine;
    public World worldObj;
    public EntityLiving entityLivingPlayer;
    public float playerYaw;
    public float playerPitch;
    public double playerX;
    public double playerY;
    public double playerZ;

    private TileEntityRenderer() {
        this.specialRendererMap.put(TileEntitySign.class, new TileEntitySignRenderer());
        this.specialRendererMap.put(TileEntityChair.class, new TileEntityChairRenderer());
        this.specialRendererMap.put(TileEntityChairCrimson.class, new TileEntityChairCrimsonRenderer());
        this.specialRendererMap.put(TileEntityChairFirwood.class, new TileEntityChairFirwoodRenderer());
        this.specialRendererMap.put(TileEntityChairStone.class, new TileEntityChairStoneRenderer());
        this.specialRendererMap.put(TileEntityTable.class, new TileEntityTableRenderer());
        this.specialRendererMap.put(TileEntityTableCrimson.class, new TileEntityTableCrimsonRenderer());
        this.specialRendererMap.put(TileEntityTableFirwood.class, new TileEntityTableFirwoodRenderer());
        this.specialRendererMap.put(TileEntityTableGlass.class, new TileEntityTableGlassRenderer());
        this.specialRendererMap.put(TileEntityMobSpawner.class, new TileEntityMobSpawnerRenderer());
        this.specialRendererMap.put(TileEntityPiston.class, new TileEntityRendererPiston());
        for (TileEntitySpecialRenderer var2 : this.specialRendererMap.values()) {
            var2.setTileEntityRenderer(this);
        }
    }

    public TileEntitySpecialRenderer getSpecialRendererForClass(Class var1) {
        TileEntitySpecialRenderer var2 = (TileEntitySpecialRenderer)this.specialRendererMap.get(var1);
        if (var2 == null && var1 != TileEntity.class) {
            var2 = this.getSpecialRendererForClass(var1.getSuperclass());
            this.specialRendererMap.put(var1, var2);
        }
        return var2;
    }

    public boolean hasSpecialRenderer(TileEntity var1) {
        return this.getSpecialRendererForEntity(var1) != null;
    }

    public TileEntitySpecialRenderer getSpecialRendererForEntity(TileEntity var1) {
        return var1 == null ? null : this.getSpecialRendererForClass(var1.getClass());
    }

    public void cacheActiveRenderInfo(World var1, RenderEngine var2, FontRenderer var3, EntityLiving var4, float var5) {
        if (this.worldObj != var1) {
            this.func_31072_a(var1);
        }
        this.renderEngine = var2;
        this.entityLivingPlayer = var4;
        this.fontRenderer = var3;
        this.playerYaw = var4.prevRotationYaw + (var4.rotationYaw - var4.prevRotationYaw) * var5;
        this.playerPitch = var4.prevRotationPitch + (var4.rotationPitch - var4.prevRotationPitch) * var5;
        this.playerX = var4.lastTickPosX + (var4.posX - var4.lastTickPosX) * (double)var5;
        this.playerY = var4.lastTickPosY + (var4.posY - var4.lastTickPosY) * (double)var5;
        this.playerZ = var4.lastTickPosZ + (var4.posZ - var4.lastTickPosZ) * (double)var5;
    }

    public void renderTileEntity(TileEntity var1, float var2) {
        if (var1.getDistanceFrom(this.playerX, this.playerY, this.playerZ) < 4096.0) {
            float var3 = this.worldObj.getLightBrightness(var1.xCoord, var1.yCoord, var1.zCoord);
            GL11.glColor3f((float)var3, (float)var3, (float)var3);
            this.renderTileEntityAt(var1, (double)var1.xCoord - staticPlayerX, (double)var1.yCoord - staticPlayerY, (double)var1.zCoord - staticPlayerZ, var2);
        }
    }

    public void renderTileEntityAt(TileEntity var1, double var2, double var4, double var6, float var8) {
        TileEntitySpecialRenderer var9 = this.getSpecialRendererForEntity(var1);
        if (var9 != null) {
            var9.renderTileEntityAt(var1, var2, var4, var6, var8);
        }
    }

    public void func_31072_a(World var1) {
        this.worldObj = var1;
        for (TileEntitySpecialRenderer var3 : this.specialRendererMap.values()) {
            if (var3 == null) continue;
            var3.func_31069_a(var1);
        }
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }
}

