/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity.animals;

import java.util.Random;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.animals.EntityAnimal;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class EntitySheep
extends EntityAnimal {
    public static final float[][] fleeceColorTable = new float[][]{{1.0f, 1.0f, 1.0f}, {0.95f, 0.7f, 0.2f}, {0.9f, 0.5f, 0.85f}, {0.6f, 0.7f, 0.95f}, {0.9f, 0.9f, 0.2f}, {0.5f, 0.8f, 0.1f}, {0.95f, 0.7f, 0.8f}, {0.3f, 0.3f, 0.3f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.6f, 0.7f}, {0.7f, 0.4f, 0.9f}, {0.2f, 0.4f, 0.8f}, {0.5f, 0.4f, 0.3f}, {0.4f, 0.5f, 0.2f}, {0.8f, 0.3f, 0.3f}, {0.1f, 0.1f, 0.1f}};
    public boolean grazing = false;
    private int grazingTime = 0;
    int i = 0;
    int j = 0;
    public float graze;
    public float grazeO;

    public EntitySheep(World var1) {
        super(var1);
        this.texture = "/mob/animals/sheep/sheep.png";
        this.setSize(0.9f, 1.3f);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, new Byte(0));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.grazeO = this.graze;
        float f = this.graze = this.grazing ? (this.graze = this.graze + 0.2f) : (this.graze = this.graze - 0.2f);
        if (this.graze < 0.0f) {
            this.graze = 0.0f;
        }
        if (this.graze > 1.0f) {
            this.graze = 1.0f;
        }
        float var1 = MathHelper.sin(this.rotationYaw * (float)Math.PI / 180.0f);
        float var2 = MathHelper.cos(this.rotationYaw * (float)Math.PI / 180.0f);
        var1 *= -0.7f;
        var2 *= 0.7f;
        int xCoord = (int)(this.posX - 0.5);
        int yCoord = (int)(this.posY - 1.0);
        int zCoord = (int)(this.posZ - 0.5);
        if (!this.grazing && this.rand.nextInt(200) == 0 && this.worldObj.getBlockId(xCoord, yCoord, zCoord) == Block.grass.blockID && this.getSheared() && !this.worldObj.multiplayerWorld) {
            this.grazingTime = 0;
            this.grazing = true;
        }
        if (this.grazingTime++ < 60 && this.grazing && !this.worldObj.multiplayerWorld) {
            this.isJumping = false;
            this.rotationPitch = 40 + this.grazingTime / 2 % 2 * 10;
        }
        if (this.grazingTime >= 60 && this.grazing && !this.worldObj.multiplayerWorld) {
            if (this.worldObj.getBlockId(xCoord, yCoord, zCoord) == Block.grass.blockID) {
                this.worldObj.setBlockWithNotify(xCoord, yCoord, zCoord, Block.dirt.blockID);
                this.setSheared(false);
            }
            this.grazingTime = 0;
            this.grazing = false;
        }
    }

    @Override
    public boolean attackEntityFrom(Entity var1, int var2) {
        if (!this.worldObj.multiplayerWorld && !this.getSheared() && var1 instanceof EntityLiving) {
            this.setSheared(true);
            int var3 = 1 + this.rand.nextInt(3);
            int var4 = 0;
            while (var4 < var3) {
                EntityItem var5 = this.entityDropItem(new ItemStack(Block.cloth.blockID, 1, this.getFleeceColor()), 1.0f);
                var5.motionY += (double)(this.rand.nextFloat() * 0.05f);
                var5.motionX += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                var5.motionZ += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                ++var4;
            }
            return false;
        }
        return super.attackEntityFrom(var1, var2);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        super.writeEntityToNBT(var1);
        var1.setBoolean("Sheared", this.getSheared());
        var1.setByte("Color", (byte)this.getFleeceColor());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        super.readEntityFromNBT(var1);
        this.setSheared(var1.getBoolean("Sheared"));
        this.setFleeceColor(var1.getByte("Color"));
    }

    @Override
    protected String getLivingSound() {
        return "mob.sheep";
    }

    @Override
    protected String getHurtSound() {
        return "mob.sheep";
    }

    @Override
    protected String getDeathSound() {
        return "mob.sheep";
    }

    public int getFleeceColor() {
        return this.dataWatcher.getWatchableObjectByte(16) & 0xF;
    }

    public void setFleeceColor(int var1) {
        byte var2 = this.dataWatcher.getWatchableObjectByte(16);
        this.dataWatcher.updateObject(16, (byte)(var2 & 0xF0 | var1 & 0xF));
    }

    public boolean getSheared() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 0x10) != 0;
    }

    public void setSheared(boolean var1) {
        byte var2 = this.dataWatcher.getWatchableObjectByte(16);
        if (var1) {
            this.dataWatcher.updateObject(16, (byte)(var2 | 0x10));
        } else {
            this.dataWatcher.updateObject(16, (byte)(var2 & 0xFFFFFFEF));
        }
    }

    public static int getRandomFleeceColor(Random var0) {
        int var1 = var0.nextInt(100);
        if (var1 < 5) {
            return 0;
        }
        if (var1 < 10) {
            return 0;
        }
        if (var1 < 15) {
            return 0;
        }
        if (var1 < 18) {
            return 0;
        }
        return var0.nextInt(500) == 0 ? 6 : 0;
    }
}

