/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity.other;

import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.BlockFalling;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class EntityFallingSand
extends Entity {
    public int blockID;
    public int blockMetadata;
    public int fallTime = 0;

    public EntityFallingSand(World world) {
        super(world);
    }

    public EntityFallingSand(World world, double xCoord, double yCoord, double zCoord, int block, int metadata) {
        super(world);
        this.blockID = block;
        this.blockMetadata = metadata;
        this.preventEntitySpawning = true;
        this.setSize(0.98f, 0.98f);
        this.yOffset = this.height / 2.0f;
        this.setPosition(xCoord, yCoord, zCoord);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = xCoord;
        this.prevPosY = yCoord;
        this.prevPosZ = zCoord;
        int x = MathHelper.floor_double(this.posX);
        int y = MathHelper.floor_double(this.posY);
        int z = MathHelper.floor_double(this.posZ);
        world.setBlockWithNotify(x, y, z, 0);
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected void entityInit() {
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public void onUpdate() {
        this.fire = 0;
        if (this.blockID == 0) {
            this.setEntityDead();
        } else {
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            ++this.fallTime;
            this.motionY -= (double)0.04f;
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.98f;
            this.motionY *= (double)0.98f;
            this.motionZ *= (double)0.98f;
            int x = MathHelper.floor_double(this.posX);
            int y = MathHelper.floor_double(this.posY);
            int z = MathHelper.floor_double(this.posZ);
            if (this.worldObj.getBlockId(x, y, z) == this.blockID && this.blockID != 189) {
                this.worldObj.setBlockWithNotify(x, y, z, 0);
            }
            if (this.onGround) {
                this.motionX *= (double)0.7f;
                this.motionZ *= (double)0.7f;
                this.motionY *= -0.5;
                this.setEntityDead();
                if (!(this.worldObj.canBlockBePlacedAt(this.blockID, x, y, z, true, 1) && !BlockFalling.canFallBelow(this.worldObj, x, y - 1, z) && this.worldObj.setBlockAndMetadataWithNotify(x, y, z, this.blockID, this.blockMetadata) || this.worldObj.multiplayerWorld)) {
                    if (this.blockID == 189 && !this.worldObj.multiplayerWorld) {
                        this.dropItem(Item.ash.itemID, 1);
                    } else {
                        this.dropItem(this.blockID, 1);
                    }
                }
            } else if (this.fallTime > 100 && !this.worldObj.multiplayerWorld) {
                if (this.blockID == 189) {
                    this.dropItem(Item.ash.itemID, 1);
                    this.setEntityDead();
                } else {
                    this.dropItem(this.blockID, 1);
                }
                this.setEntityDead();
            }
        }
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound nbt) {
        nbt.setByte("Tile", (byte)this.blockID);
        nbt.setInteger("Metadata", this.blockMetadata);
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound nbt) {
        this.blockID = nbt.getByte("Tile") & 0xFF;
        this.blockMetadata = nbt.getInteger("Metadata");
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }

    public World getWorld() {
        return this.worldObj;
    }
}

