/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity.other;

import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.achievements.AchievementList;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class EntityItem
extends Entity {
    public ItemStack item;
    public int age = 0;
    public int delayBeforeCanPickup;
    private int health = 5;
    public float field_804_d = (float)(Math.random() * Math.PI * 2.0);

    public EntityItem(World var1, double var2, double var4, double var6, ItemStack var8) {
        super(var1);
        this.setSize(0.25f, 0.25f);
        this.yOffset = this.height / 2.0f;
        this.setPosition(var2, var4, var6);
        this.item = var8;
        this.rotationYaw = (float)(Math.random() * 360.0);
        this.motionX = (float)(Math.random() * (double)0.2f - (double)0.1f);
        this.motionY = 0.2f;
        this.motionZ = (float)(Math.random() * (double)0.2f - (double)0.1f);
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    public EntityItem(World var1) {
        super(var1);
        this.setSize(0.25f, 0.25f);
        this.yOffset = this.height / 2.0f;
    }

    @Override
    protected void entityInit() {
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.delayBeforeCanPickup > 0) {
            --this.delayBeforeCanPickup;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= (double)0.04f;
        if (this.worldObj.getBlockMaterial(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ)) == Material.lava) {
            this.motionY = 0.2f;
            this.motionX = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f;
            this.motionZ = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f;
            this.worldObj.playSoundAtEntity(this, "random.fizz", 0.4f, 2.0f + this.rand.nextFloat() * 0.4f);
        }
        if (this.worldObj.getBlockMaterial(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ)) == Material.water) {
            this.motionY = 0.08750000011920929;
        }
        this.pushOutOfBlocks(this.posX, (this.boundingBox.minY + this.boundingBox.maxY) / 2.0, this.posZ);
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        float var1 = 0.98f;
        if (this.onGround) {
            var1 = 0.58800006f;
            int var2 = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.boundingBox.minY) - 1, MathHelper.floor_double(this.posZ));
            if (var2 > 0) {
                var1 = Block.blocksList[var2].slipperiness * 0.98f;
            }
        }
        this.motionX *= (double)var1;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)var1;
        if (this.onGround) {
            this.motionY *= -0.5;
        }
        ++this.age;
        if (this.age >= 5400) {
            this.worldObj.spawnParticle("smalldust", this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0);
        }
        if (this.age >= 6000) {
            this.worldObj.spawnParticle("explode", this.posX, this.posY, this.posZ, 0.0, 0.1, 0.0);
            this.worldObj.spawnParticle("explode", this.posX, this.posY, this.posZ, 0.0, 0.1, 0.0);
            this.worldObj.spawnParticle("explode", this.posX, this.posY, this.posZ, 0.0, 0.1, 0.0);
            this.setEntityDead();
        }
    }

    @Override
    public boolean handleWaterMovement() {
        return this.worldObj.handleMaterialAcceleration(this.boundingBox, Material.water, this);
    }

    @Override
    protected void dealFireDamage(int var1) {
        this.attackEntityFrom(null, var1);
    }

    @Override
    public boolean attackEntityFrom(Entity var1, int var2) {
        this.setBeenAttacked();
        this.health -= var2;
        if (this.health <= 0) {
            this.setEntityDead();
        }
        return false;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        var1.setShort("Health", (byte)this.health);
        var1.setShort("Age", (short)this.age);
        var1.setCompoundTag("Item", this.item.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        this.health = var1.getShort("Health") & 0xFF;
        this.age = var1.getShort("Age");
        NBTTagCompound var2 = var1.getCompoundTag("Item");
        this.item = new ItemStack(var2);
    }

    @Override
    public void onCollideWithPlayer(EntityPlayer var1) {
        if (!this.worldObj.multiplayerWorld) {
            int var2 = this.item.stackSize;
            if (this.delayBeforeCanPickup == 0 && var1.inventory.addItemStackToInventory(this.item)) {
                if (this.item.itemID == Block.log.blockID) {
                    var1.triggerAchievement(AchievementList.mineWood);
                }
                if (this.item.itemID == Block.logFir.blockID) {
                    var1.triggerAchievement(AchievementList.mineWood);
                }
                if (this.item.itemID == Block.logCrimson.blockID) {
                    var1.triggerAchievement(AchievementList.mineWood);
                }
                if (this.item.itemID == Item.leather.itemID) {
                    var1.triggerAchievement(AchievementList.killCow);
                }
                if (this.item.itemID == Block.roseCyan.blockID) {
                    var1.triggerAchievement(AchievementList.flowers);
                }
                if (this.item.itemID == Item.diamond.itemID) {
                    var1.triggerAchievement(AchievementList.diamonds);
                }
                this.worldObj.playSoundAtEntity(this, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                var1.onItemPickup(this, var2);
                if (this.item.stackSize <= 0) {
                    this.setEntityDead();
                }
            }
        }
    }
}

