/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.item;

import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.entity.other.EntityChair;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;

public class ItemChair
extends Item {
    public int blockid;

    public ItemChair(int id, int chairType) {
        super(id);
        chairType = this.blockid;
        this.maxStackSize = 64;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int xCoord, int yCoord, int zCoord, int blockFace) {
        if (blockFace == 0) {
            return false;
        }
        if (!world.getBlockMaterial(xCoord, yCoord, zCoord).isSolid()) {
            return false;
        }
        if (blockFace == 1) {
            ++yCoord;
        }
        if (blockFace == 2) {
            --zCoord;
        }
        if (blockFace == 3) {
            ++zCoord;
        }
        if (blockFace == 4) {
            --xCoord;
        }
        if (blockFace == 5) {
            ++xCoord;
        }
        if (!Block.table.canPlaceBlockAt(world, xCoord, yCoord, zCoord)) {
            return false;
        }
        if (this.blockid == 0) {
            world.setBlockAndMetadataWithNotify(xCoord, yCoord, zCoord, Block.chair.blockID, MathHelper.floor_double((double)((entityplayer.rotationYaw + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF);
        }
        --itemstack.stackSize;
        Block thisBlock = Block.planks;
        world.playSoundEffect((float)xCoord + 0.5f, (float)yCoord + 0.5f, (float)zCoord + 0.5f, thisBlock.stepSound.func_1145_d(), (thisBlock.stepSound.getVolume() + 1.0f) / 2.0f, thisBlock.stepSound.getPitch() * 0.8f);
        if (!world.multiplayerWorld) {
            EntityChair testplacedmob = new EntityChair(world);
            testplacedmob.setLocationAndAngles((double)xCoord + 0.5, (double)yCoord + 0.05, (double)zCoord + 0.5, 0.0f, 0.0f);
            world.entityJoinedWorld(testplacedmob);
        }
        return true;
    }
}

