/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.item;

import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;

public class ItemDoor
extends Item {
    private Material doorMaterial;
    public int doorType;

    public ItemDoor(int id, Material material, int door) {
        super(id);
        this.doorMaterial = material;
        this.maxStackSize = 64;
        this.doorType = door;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int xCoord, int yCoord, int zCoord, int blockFace) {
        if (blockFace != 1) {
            return false;
        }
        Block doorType = this.doorType == 1 ? Block.doorCrimson : (this.doorType == 2 ? Block.doorFir : (this.doorMaterial == Material.wood ? Block.doorWood : Block.doorSteel));
        if (!doorType.canPlaceBlockAt(world, xCoord, ++yCoord, zCoord)) {
            return false;
        }
        int doorRotation = MathHelper.floor_double((double)((entityplayer.rotationYaw + 180.0f) * 4.0f / 360.0f) - 0.5) & 3;
        ItemDoor.placeDoorBlock(world, xCoord, yCoord, zCoord, doorRotation, doorType);
        Block thisBlock = Block.planks;
        world.playSoundEffect((float)xCoord + 0.5f, (float)yCoord + 0.5f, (float)zCoord + 0.5f, thisBlock.stepSound.func_1145_d(), (thisBlock.stepSound.getVolume() + 1.0f) / 2.0f, thisBlock.stepSound.getPitch() * 0.8f);
        --itemstack.stackSize;
        return true;
    }

    public static void placeDoorBlock(World world, int xCoord, int yCoord, int zCoord, int metadata, Block door) {
        int xDoorRot = 0;
        int zDoorRot = 0;
        if (metadata == 0) {
            zDoorRot = 1;
        }
        if (metadata == 1) {
            xDoorRot = -1;
        }
        if (metadata == 2) {
            zDoorRot = -1;
        }
        if (metadata == 3) {
            xDoorRot = 1;
        }
        int negFloorCheck = (world.isBlockNormalCube(xCoord - xDoorRot, yCoord, zCoord - zDoorRot) ? 1 : 0) + (world.isBlockNormalCube(xCoord - xDoorRot, yCoord + 1, zCoord - zDoorRot) ? 1 : 0);
        int posFloorCheck = (world.isBlockNormalCube(xCoord + xDoorRot, yCoord, zCoord + zDoorRot) ? 1 : 0) + (world.isBlockNormalCube(xCoord + xDoorRot, yCoord + 1, zCoord + zDoorRot) ? 1 : 0);
        boolean negDoesDoorHaveTop = world.getBlockId(xCoord - xDoorRot, yCoord, zCoord - zDoorRot) == door.blockID || world.getBlockId(xCoord - xDoorRot, yCoord + 1, zCoord - zDoorRot) == door.blockID;
        boolean posDoesDoorHaveTop = world.getBlockId(xCoord + xDoorRot, yCoord, zCoord + zDoorRot) == door.blockID || world.getBlockId(xCoord + xDoorRot, yCoord + 1, zCoord + zDoorRot) == door.blockID;
        boolean canBePlaced = false;
        if (negDoesDoorHaveTop && !posDoesDoorHaveTop) {
            canBePlaced = true;
        } else if (posFloorCheck > negFloorCheck) {
            canBePlaced = true;
        }
        if (canBePlaced) {
            metadata = metadata - 1 & 3;
            metadata += 4;
        }
        world.editingBlocks = true;
        world.setBlockAndMetadataWithNotify(xCoord, yCoord, zCoord, door.blockID, metadata);
        world.setBlockAndMetadataWithNotify(xCoord, yCoord + 1, zCoord, door.blockID, metadata + 8);
        world.editingBlocks = false;
        world.notifyBlocksOfNeighborChange(xCoord, yCoord, zCoord, door.blockID);
        world.notifyBlocksOfNeighborChange(xCoord, yCoord + 1, zCoord, door.blockID);
    }
}

