/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.item;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.item.EnumToolMaterial;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.item.ItemTool;

public class ItemPickaxe
extends ItemTool {
    private static Block[] blocksEffectiveAgainst = new Block[]{Block.cobblestone, Block.slabDoubleRock, Block.slabSingleRock, Block.stone, Block.sandstone, Block.mossyCobblestone, Block.oreIron, Block.blockIron, Block.oreCoal, Block.blockCoal, Block.oreGold, Block.blockGold, Block.oreDiamond, Block.blockDiamond, Block.ice, Block.netherrack, Block.oreLapis, Block.blockLapis, Block.furnaceActive, Block.furnaceIdle, Block.basalt, Block.blackstone, Block.oreCoalNether, Block.oreDiamondNether, Block.oreGoldNether, Block.oreIronNether, Block.magma, Block.soulSandstone, Block.stairsCobblestone, Block.coralBlue, Block.coralRed, Block.coralYellow, Block.coralDead, Block.stalactite, Block.stalagmite, Block.glass, Block.temperedGlass, Block.stoneBrick, Block.chairStone, Block.brickMossy, Block.brickGilded, Block.brickFired, Block.brickFiredMossy, Block.brickFiredGilded, Block.glassTable, Block.brickBasalt, Block.stucco, Block.fenceRock, Block.brick, Block.forgeActive, Block.forgeIdle, Block.gearRelayActive, Block.gearRelayIdle, Block.gearWaitActive, Block.gearWaitIdle, Block.gearNotGateActive, Block.gearNotGateIdle, Block.pistonBase, Block.pistonStickyBase, Block.pistonExtension, Block.pistonMoving};
    private Random rand;

    protected ItemPickaxe(int id, EnumToolMaterial material) {
        super(id, 2, material, blocksEffectiveAgainst);
    }

    @Override
    public boolean canHarvestBlock(Block blockid) {
        if (blockid == Block.obsidian) {
            return this.toolMaterial.getHarvestLevel() == 3;
        }
        if (blockid != Block.blockDiamond && blockid != Block.oreDiamond && blockid != Block.oreDiamondNether) {
            if (blockid != Block.blockGold && blockid != Block.oreGold && blockid != Block.oreGoldNether) {
                if (blockid != Block.blockIron && blockid != Block.oreIron && blockid != Block.oreIronNether) {
                    if (blockid != Block.blockLapis && blockid != Block.oreLapis) {
                        if (blockid != Block.oreRedstone && blockid != Block.oreRedstoneGlowing) {
                            if (blockid.blockMaterial == Material.rock) {
                                return true;
                            }
                            return blockid.blockMaterial == Material.iron;
                        }
                        return this.toolMaterial.getHarvestLevel() >= 2;
                    }
                    return this.toolMaterial.getHarvestLevel() >= 1;
                }
                return this.toolMaterial.getHarvestLevel() >= 1;
            }
            return this.toolMaterial.getHarvestLevel() >= 2;
        }
        return this.toolMaterial.getHarvestLevel() >= 2;
    }

    @Override
    public float getStrVsBlock(ItemStack item, Block blockid) {
        float multiplier = 1.0f;
        if (this.toolMaterial.equals((Object)EnumToolMaterial.EMERALD)) {
            multiplier = (float)this.getMaxDamage() / (float)(this.getMaxDamage() - item.getItemDamage());
        }
        int var3 = 0;
        while (var3 < blocksEffectiveAgainst.length) {
            if (blocksEffectiveAgainst[var3] == blockid) {
                return this.toolMaterial.getEfficiencyOnProperMaterial() * multiplier;
            }
            ++var3;
        }
        return 1.0f;
    }
}

