/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.item;

import net.minecraft.src.game.Facing;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.entity.monster.EntitySlime;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;

public class ItemSlimeBucket
extends Item {
    public World worldObj;
    public EntityPlayer player;

    public ItemSlimeBucket(int id) {
        super(id);
        this.setHasSubtypes(true);
        this.setMaxDamage(2);
        this.maxStackSize = 1;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int xCoord, int yCoord, int zCoord, int par7) {
        if (world.isRemote) {
            return true;
        }
        int i = world.getBlockId(xCoord, yCoord, zCoord);
        xCoord += Facing.offsetsXForSide[par7];
        yCoord += Facing.offsetsYForSide[par7];
        zCoord += Facing.offsetsZForSide[par7];
        double d = 0.0;
        if (par7 == 1 && i == Block.fence.blockID || i == Block.fenceRock.blockID) {
            d = 0.5;
        }
        if (ItemSlimeBucket.func_48440_a(world, itemstack.getItemDamage(), (double)xCoord + 0.5, (double)yCoord + d, (double)zCoord + 0.5) && entityplayer.capabilities.depleteItems) {
            System.out.println("CURRENT ITEM DAMAGE: " + itemstack.getItemDamage());
            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, new ItemStack(Item.bucketEmpty));
        }
        return true;
    }

    public static boolean func_48440_a(World world, int par1, double xCoord, double yCoord, double zCoord) {
        if (!world.multiplayerWorld) {
            EntitySlime spawnedMob = new EntitySlime(world);
            spawnedMob.setSlimeSize(1);
            spawnedMob.setLocationAndAngles(xCoord, yCoord + 0.05, zCoord, 0.0f, 0.0f);
            world.entityJoinedWorld(spawnedMob);
        }
        return true;
    }
}

