/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.item;

import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.ItemBlock;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;

public class ItemSnow
extends ItemBlock {
    public ItemSnow(int id) {
        super(id);
    }

    @Override
    public int getIconFromDamage(int var1) {
        return Block.snowPile.getBlockTextureFromSideAndMetadata(0, 0);
    }

    public boolean onItemUse(ItemStack itemstack, EntityPlayer thePlayer, World world, int xCoord, int yCoord, int zCoord, int par7, float par8, float par9, float par10) {
        int currentBlock = world.getBlockId(xCoord, yCoord, zCoord);
        if (currentBlock == Block.snowPile.blockID) {
            Block block = Block.blocksList[this.blockID];
            int metadata = world.getBlockMetadata(xCoord, yCoord, zCoord);
            int metadataAddition = metadata & 7;
            if (metadataAddition <= 6) {
                world.setBlockMetadata(xCoord, yCoord, zCoord, metadata + 1);
                world.markBlockNeedsUpdate(xCoord, yCoord, zCoord);
                world.playSoundEffect((float)xCoord + 0.5f, (float)yCoord + 0.5f, (float)zCoord + 0.5f, block.stepSound.func_1145_d(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                --itemstack.stackSize;
                return true;
            }
        }
        return super.onItemUse(itemstack, thePlayer, world, xCoord, yCoord, zCoord, par7);
    }
}

