/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.chunk;

import java.util.Random;
import net.minecraft.src.client.IProgressUpdate;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockSand;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.WorldGenerator;
import net.minecraft.src.game.level.biomes.BiomeGenBase;
import net.minecraft.src.game.level.chunk.Chunk;
import net.minecraft.src.game.level.chunk.IChunkProvider;
import net.minecraft.src.game.level.features.WorldGenCactus;
import net.minecraft.src.game.level.features.WorldGenClay;
import net.minecraft.src.game.level.features.WorldGenDungeons;
import net.minecraft.src.game.level.features.WorldGenFlowers;
import net.minecraft.src.game.level.features.WorldGenLakes;
import net.minecraft.src.game.level.features.WorldGenLiquids;
import net.minecraft.src.game.level.features.WorldGenMinable;
import net.minecraft.src.game.level.features.WorldGenPumpkin;
import net.minecraft.src.game.level.features.WorldGenReed;
import net.minecraft.src.game.level.map.MapGenBase;
import net.minecraft.src.game.level.map.MapGenCaves;
import net.minecraft.src.game.level.noisegen.NoiseGeneratorOctaves;

public class ChunkProviderSky
implements IChunkProvider {
    private Random field_28087_j;
    private NoiseGeneratorOctaves field_28086_k;
    private NoiseGeneratorOctaves field_28085_l;
    private NoiseGeneratorOctaves field_28084_m;
    private NoiseGeneratorOctaves field_28083_n;
    private NoiseGeneratorOctaves field_28082_o;
    public NoiseGeneratorOctaves field_28096_a;
    public NoiseGeneratorOctaves field_28095_b;
    public NoiseGeneratorOctaves field_28094_c;
    private World field_28081_p;
    private double[] field_28080_q;
    private double[] field_28079_r = new double[256];
    private double[] field_28078_s = new double[256];
    private double[] field_28077_t = new double[256];
    private MapGenBase field_28076_u = new MapGenCaves();
    private BiomeGenBase[] field_28075_v;
    double[] field_28093_d;
    double[] field_28092_e;
    double[] field_28091_f;
    double[] field_28090_g;
    double[] field_28089_h;
    int[][] field_28088_i = new int[32][32];
    private double[] field_28074_w;

    public ChunkProviderSky(World var1, long var2) {
        this.field_28081_p = var1;
        this.field_28087_j = new Random(var2);
        this.field_28086_k = new NoiseGeneratorOctaves(this.field_28087_j, 16);
        this.field_28085_l = new NoiseGeneratorOctaves(this.field_28087_j, 16);
        this.field_28084_m = new NoiseGeneratorOctaves(this.field_28087_j, 8);
        this.field_28083_n = new NoiseGeneratorOctaves(this.field_28087_j, 4);
        this.field_28082_o = new NoiseGeneratorOctaves(this.field_28087_j, 4);
        this.field_28096_a = new NoiseGeneratorOctaves(this.field_28087_j, 10);
        this.field_28095_b = new NoiseGeneratorOctaves(this.field_28087_j, 16);
        this.field_28094_c = new NoiseGeneratorOctaves(this.field_28087_j, 8);
    }

    public void func_28071_a(int var1, int var2, byte[] var3, BiomeGenBase[] var4, double[] var5) {
        int var6 = 2;
        int var7 = var6 + 1;
        int var8 = 33;
        int var9 = var6 + 1;
        this.field_28080_q = this.func_28073_a(this.field_28080_q, var1 * var6, 0, var2 * var6, var7, var8, var9);
        int var10 = 0;
        while (var10 < var6) {
            int var11 = 0;
            while (var11 < var6) {
                int var12 = 0;
                while (var12 < 32) {
                    double var13 = 0.25;
                    double var15 = this.field_28080_q[((var10 + 0) * var9 + var11 + 0) * var8 + var12 + 0];
                    double var17 = this.field_28080_q[((var10 + 0) * var9 + var11 + 1) * var8 + var12 + 0];
                    double var19 = this.field_28080_q[((var10 + 1) * var9 + var11 + 0) * var8 + var12 + 0];
                    double var21 = this.field_28080_q[((var10 + 1) * var9 + var11 + 1) * var8 + var12 + 0];
                    double var23 = (this.field_28080_q[((var10 + 0) * var9 + var11 + 0) * var8 + var12 + 1] - var15) * var13;
                    double var25 = (this.field_28080_q[((var10 + 0) * var9 + var11 + 1) * var8 + var12 + 1] - var17) * var13;
                    double var27 = (this.field_28080_q[((var10 + 1) * var9 + var11 + 0) * var8 + var12 + 1] - var19) * var13;
                    double var29 = (this.field_28080_q[((var10 + 1) * var9 + var11 + 1) * var8 + var12 + 1] - var21) * var13;
                    int var31 = 0;
                    while (var31 < 4) {
                        double var32 = 0.125;
                        double var34 = var15;
                        double var36 = var17;
                        double var38 = (var19 - var15) * var32;
                        double var40 = (var21 - var17) * var32;
                        int var42 = 0;
                        while (var42 < 8) {
                            int var43 = var42 + var10 * 8 << 11 | 0 + var11 * 8 << 7 | var12 * 4 + var31;
                            int var44 = 128;
                            double var45 = 0.125;
                            double var47 = var34;
                            double var49 = (var36 - var34) * var45;
                            int var51 = 0;
                            while (var51 < 8) {
                                int var52 = 0;
                                if (var47 > 0.0) {
                                    var52 = Block.stone.blockID;
                                }
                                var3[var43] = (byte)var52;
                                var43 += var44;
                                var47 += var49;
                                ++var51;
                            }
                            var34 += var38;
                            var36 += var40;
                            ++var42;
                        }
                        var15 += var23;
                        var17 += var25;
                        var19 += var27;
                        var21 += var29;
                        ++var31;
                    }
                    ++var12;
                }
                ++var11;
            }
            ++var10;
        }
    }

    public void func_28072_a(int var1, int var2, byte[] var3, BiomeGenBase[] var4) {
        double var5 = 0.03125;
        this.field_28079_r = this.field_28083_n.generateNoiseOctaves(this.field_28079_r, var1 * 16, var2 * 16, 0.0, 16, 16, 1, var5, var5, 1.0);
        this.field_28078_s = this.field_28083_n.generateNoiseOctaves(this.field_28078_s, var1 * 16, 109.0134, var2 * 16, 16, 1, 16, var5, 1.0, var5);
        this.field_28077_t = this.field_28082_o.generateNoiseOctaves(this.field_28077_t, var1 * 16, var2 * 16, 0.0, 16, 16, 1, var5 * 2.0, var5 * 2.0, var5 * 2.0);
        int var7 = 0;
        while (var7 < 16) {
            int var8 = 0;
            while (var8 < 16) {
                BiomeGenBase var9 = var4[var7 + var8 * 16];
                int var10 = (int)(this.field_28077_t[var7 + var8 * 16] / 3.0 + 3.0 + this.field_28087_j.nextDouble() * 0.25);
                int var11 = -1;
                byte var12 = var9.topBlock;
                byte var13 = var9.fillerBlock;
                int var14 = 127;
                while (var14 >= 0) {
                    int var15 = (var8 * 16 + var7) * 128 + var14;
                    byte var16 = var3[var15];
                    if (var16 == 0) {
                        var11 = -1;
                    } else if (var16 == Block.stone.blockID) {
                        if (var11 == -1) {
                            if (var10 <= 0) {
                                var12 = 0;
                                var13 = (byte)Block.stone.blockID;
                            }
                            var11 = var10;
                            var3[var15] = var14 >= 0 ? var12 : var13;
                        } else if (var11 > 0) {
                            var3[var15] = var13;
                            if (--var11 == 0 && var13 == Block.sand.blockID) {
                                var11 = this.field_28087_j.nextInt(4);
                                var13 = (byte)Block.sandstone.blockID;
                            }
                        }
                    }
                    --var14;
                }
                ++var8;
            }
            ++var7;
        }
    }

    @Override
    public Chunk prepareChunk(int var1, int var2) {
        return this.provideChunk(var1, var2);
    }

    @Override
    public Chunk provideChunk(int var1, int var2) {
        this.field_28087_j.setSeed((long)var1 * 341873128712L + (long)var2 * 132897987541L);
        byte[] var3 = new byte[32768];
        Chunk var4 = new Chunk(this.field_28081_p, var3, var1, var2);
        this.field_28075_v = this.field_28081_p.getWorldChunkManager().loadBlockGeneratorData(this.field_28075_v, var1 * 16, var2 * 16, 16, 16);
        double[] var5 = this.field_28081_p.getWorldChunkManager().temperature;
        this.func_28071_a(var1, var2, var3, this.field_28075_v, var5);
        this.func_28072_a(var1, var2, var3, this.field_28075_v);
        this.field_28076_u.generate(this, this.field_28081_p, var1, var2, var3);
        var4.func_1024_c();
        return var4;
    }

    private double[] func_28073_a(double[] var1, int var2, int var3, int var4, int var5, int var6, int var7) {
        if (var1 == null) {
            var1 = new double[var5 * var6 * var7];
        }
        double var8 = 684.412;
        double var10 = 684.412;
        double[] var12 = this.field_28081_p.getWorldChunkManager().temperature;
        double[] var13 = this.field_28081_p.getWorldChunkManager().humidity;
        this.field_28090_g = this.field_28096_a.func_4109_a(this.field_28090_g, var2, var4, var5, var7, 1.121, 1.121, 0.5);
        this.field_28089_h = this.field_28095_b.func_4109_a(this.field_28089_h, var2, var4, var5, var7, 200.0, 200.0, 0.5);
        this.field_28093_d = this.field_28084_m.generateNoiseOctaves(this.field_28093_d, var2, var3, var4, var5, var6, var7, (var8 *= 2.0) / 80.0, var10 / 160.0, var8 / 80.0);
        this.field_28092_e = this.field_28086_k.generateNoiseOctaves(this.field_28092_e, var2, var3, var4, var5, var6, var7, var8, var10, var8);
        this.field_28091_f = this.field_28085_l.generateNoiseOctaves(this.field_28091_f, var2, var3, var4, var5, var6, var7, var8, var10, var8);
        int var14 = 0;
        int var15 = 0;
        int var16 = 16 / var5;
        int var17 = 0;
        while (var17 < var5) {
            int var18 = var17 * var16 + var16 / 2;
            int var19 = 0;
            while (var19 < var7) {
                double var29;
                int var20 = var19 * var16 + var16 / 2;
                double var21 = var12[var18 * 16 + var20];
                double var23 = var13[var18 * 16 + var20] * var21;
                double var25 = 1.0 - var23;
                var25 *= var25;
                var25 *= var25;
                var25 = 1.0 - var25;
                double var27 = (this.field_28090_g[var15] + 256.0) / 512.0;
                if ((var27 *= var25) > 1.0) {
                    var27 = 1.0;
                }
                if ((var29 = this.field_28089_h[var15] / 8000.0) < 0.0) {
                    var29 = -var29 * 0.3;
                }
                if ((var29 = var29 * 3.0 - 2.0) > 1.0) {
                    var29 = 1.0;
                }
                var29 /= 8.0;
                var29 = 0.0;
                if (var27 < 0.0) {
                    var27 = 0.0;
                }
                var27 += 0.5;
                var29 = var29 * (double)var6 / 16.0;
                ++var15;
                double var31 = (double)var6 / 2.0;
                int var33 = 0;
                while (var33 < var6) {
                    double var45;
                    double var34 = 0.0;
                    double var36 = ((double)var33 - var31) * 8.0 / var27;
                    if (var36 < 0.0) {
                        var36 *= -1.0;
                    }
                    double var38 = this.field_28092_e[var14] / 512.0;
                    double var40 = this.field_28091_f[var14] / 512.0;
                    double var42 = (this.field_28093_d[var14] / 10.0 + 1.0) / 2.0;
                    var34 = var42 < 0.0 ? var38 : (var42 > 1.0 ? var40 : var38 + (var40 - var38) * var42);
                    var34 -= 8.0;
                    int var44 = 32;
                    if (var33 > var6 - var44) {
                        var45 = (float)(var33 - (var6 - var44)) / ((float)var44 - 1.0f);
                        var34 = var34 * (1.0 - var45) + -30.0 * var45;
                    }
                    if (var33 < (var44 = 8)) {
                        var45 = (float)(var44 - var33) / ((float)var44 - 1.0f);
                        var34 = var34 * (1.0 - var45) + -30.0 * var45;
                    }
                    var1[var14] = var34;
                    ++var14;
                    ++var33;
                }
                ++var19;
            }
            ++var17;
        }
        return var1;
    }

    @Override
    public boolean chunkExists(int var1, int var2) {
        return true;
    }

    @Override
    public void populate(IChunkProvider var1, int var2, int var3) {
        int var19;
        int var23;
        int var17;
        int var16;
        int var15;
        int var14;
        int var13;
        BlockSand.fallInstantly = true;
        int var4 = var2 * 16;
        int var5 = var3 * 16;
        BiomeGenBase var6 = this.field_28081_p.getWorldChunkManager().getBiomeGenAt(var4 + 16, var5 + 16);
        this.field_28087_j.setSeed(this.field_28081_p.getRandomSeed());
        long var7 = this.field_28087_j.nextLong() / 2L * 2L + 1L;
        long var9 = this.field_28087_j.nextLong() / 2L * 2L + 1L;
        this.field_28087_j.setSeed((long)var2 * var7 + (long)var3 * var9 ^ this.field_28081_p.getRandomSeed());
        double var11 = 0.25;
        if (this.field_28087_j.nextInt(4) == 0) {
            var13 = var4 + this.field_28087_j.nextInt(16) + 8;
            var14 = this.field_28087_j.nextInt(128);
            var15 = var5 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenLakes(Block.waterStill.blockID).generate(this.field_28081_p, this.field_28087_j, var13, var14, var15);
        }
        if (this.field_28087_j.nextInt(8) == 0) {
            var13 = var4 + this.field_28087_j.nextInt(16) + 8;
            var14 = this.field_28087_j.nextInt(this.field_28087_j.nextInt(120) + 8);
            var15 = var5 + this.field_28087_j.nextInt(16) + 8;
            if (var14 < 64 || this.field_28087_j.nextInt(10) == 0) {
                new WorldGenLakes(Block.lavaStill.blockID).generate(this.field_28081_p, this.field_28087_j, var13, var14, var15);
            }
        }
        var13 = 0;
        while (var13 < 8) {
            var14 = var4 + this.field_28087_j.nextInt(16) + 8;
            var15 = this.field_28087_j.nextInt(128);
            var16 = var5 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenDungeons().generate(this.field_28081_p, this.field_28087_j, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 10) {
            var14 = var4 + this.field_28087_j.nextInt(16);
            var15 = this.field_28087_j.nextInt(128);
            var16 = var5 + this.field_28087_j.nextInt(16);
            new WorldGenClay(32).generate(this.field_28081_p, this.field_28087_j, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 20) {
            var14 = var4 + this.field_28087_j.nextInt(16);
            var15 = this.field_28087_j.nextInt(128);
            var16 = var5 + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.dirt.blockID, 32).generate(this.field_28081_p, this.field_28087_j, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 10) {
            var14 = var4 + this.field_28087_j.nextInt(16);
            var15 = this.field_28087_j.nextInt(128);
            var16 = var5 + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.gravel.blockID, 32).generate(this.field_28081_p, this.field_28087_j, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 20) {
            var14 = var4 + this.field_28087_j.nextInt(16);
            var15 = this.field_28087_j.nextInt(128);
            var16 = var5 + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.oreCoal.blockID, 16).generate(this.field_28081_p, this.field_28087_j, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 20) {
            var14 = var4 + this.field_28087_j.nextInt(16);
            var15 = this.field_28087_j.nextInt(64);
            var16 = var5 + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.oreIron.blockID, 8).generate(this.field_28081_p, this.field_28087_j, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 2) {
            var14 = var4 + this.field_28087_j.nextInt(16);
            var15 = this.field_28087_j.nextInt(32);
            var16 = var5 + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.oreGold.blockID, 8).generate(this.field_28081_p, this.field_28087_j, var14, var15, var16);
            ++var13;
        }
        var13 = 0;
        while (var13 < 1) {
            var14 = var4 + this.field_28087_j.nextInt(16);
            var15 = this.field_28087_j.nextInt(16);
            var16 = var5 + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.oreDiamond.blockID, 7).generate(this.field_28081_p, this.field_28087_j, var14, var15, var16);
            ++var13;
        }
        var11 = 0.5;
        var13 = (int)((this.field_28094_c.func_806_a((double)var4 * var11, (double)var5 * var11) / 8.0 + this.field_28087_j.nextDouble() * 4.0 + 4.0) / 3.0);
        var14 = 0;
        if (this.field_28087_j.nextInt(10) == 0) {
            ++var14;
        }
        WorldGenerator obj = var6.getRandomWorldGenForSkyTrees(this.field_28087_j);
        var15 = 0;
        while (var15 < var14) {
            int j13 = var4 + this.field_28087_j.nextInt(16) + 8;
            int l15 = var5 + this.field_28087_j.nextInt(16) + 8;
            obj.func_517_a(1.0, 1.0, 1.0);
            obj.generate(this.field_28081_p, this.field_28087_j, j13, this.field_28081_p.getHeightValue(j13, l15), l15);
            ++var15;
        }
        var15 = 0;
        while (var15 < var14) {
            var16 = var4 + this.field_28087_j.nextInt(16) + 8;
            var17 = var5 + this.field_28087_j.nextInt(16) + 8;
            WorldGenerator var18 = var6.getRandomWorldGenForSkyTrees(this.field_28087_j);
            var18.func_517_a(1.0, 1.0, 1.0);
            var18.generate(this.field_28081_p, this.field_28087_j, var16, this.field_28081_p.getHeightValue(var16, var17), var17);
            ++var15;
        }
        var15 = 0;
        while (var15 < 2) {
            var16 = var4 + this.field_28087_j.nextInt(16) + 8;
            var17 = this.field_28087_j.nextInt(128);
            var23 = var5 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenFlowers(Block.dandelion.blockID).generate(this.field_28081_p, this.field_28087_j, var16, var17, var23);
            ++var15;
        }
        if (this.field_28087_j.nextInt(2) == 0) {
            var15 = var4 + this.field_28087_j.nextInt(16) + 8;
            var16 = this.field_28087_j.nextInt(128);
            var17 = var5 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenFlowers(Block.roseRed.blockID).generate(this.field_28081_p, this.field_28087_j, var15, var16, var17);
        }
        if (this.field_28087_j.nextInt(4) == 0) {
            var15 = var4 + this.field_28087_j.nextInt(16) + 8;
            var16 = this.field_28087_j.nextInt(128);
            var17 = var5 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.field_28081_p, this.field_28087_j, var15, var16, var17);
        }
        if (this.field_28087_j.nextInt(8) == 0) {
            var15 = var4 + this.field_28087_j.nextInt(16) + 8;
            var16 = this.field_28087_j.nextInt(128);
            var17 = var5 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.field_28081_p, this.field_28087_j, var15, var16, var17);
        }
        var15 = 0;
        while (var15 < 10) {
            var16 = var4 + this.field_28087_j.nextInt(16) + 8;
            var17 = this.field_28087_j.nextInt(128);
            var23 = var5 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenReed().generate(this.field_28081_p, this.field_28087_j, var16, var17, var23);
            ++var15;
        }
        if (this.field_28087_j.nextInt(32) == 0) {
            var15 = var4 + this.field_28087_j.nextInt(16) + 8;
            var16 = this.field_28087_j.nextInt(128);
            var17 = var5 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenPumpkin().generate(this.field_28081_p, this.field_28087_j, var15, var16, var17);
        }
        var15 = 0;
        if (var6 == BiomeGenBase.desert) {
            var15 += 10;
        }
        var16 = 0;
        while (var16 < var15) {
            var17 = var4 + this.field_28087_j.nextInt(16) + 8;
            var23 = this.field_28087_j.nextInt(128);
            var19 = var5 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenCactus().generate(this.field_28081_p, this.field_28087_j, var17, var23, var19);
            ++var16;
        }
        var16 = 0;
        while (var16 < 50) {
            var17 = var4 + this.field_28087_j.nextInt(16) + 8;
            var23 = this.field_28087_j.nextInt(this.field_28087_j.nextInt(120) + 8);
            var19 = var5 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenLiquids(Block.waterMoving.blockID).generate(this.field_28081_p, this.field_28087_j, var17, var23, var19);
            ++var16;
        }
        var16 = 0;
        while (var16 < 20) {
            var17 = var4 + this.field_28087_j.nextInt(16) + 8;
            var23 = this.field_28087_j.nextInt(this.field_28087_j.nextInt(this.field_28087_j.nextInt(112) + 8) + 8);
            var19 = var5 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenLiquids(Block.lavaMoving.blockID).generate(this.field_28081_p, this.field_28087_j, var17, var23, var19);
            ++var16;
        }
        this.field_28074_w = this.field_28081_p.getWorldChunkManager().getTemperatures(this.field_28074_w, var4 + 8, var5 + 8, 16, 16);
        var16 = var4 + 8;
        while (var16 < var4 + 8 + 16) {
            var17 = var5 + 8;
            while (var17 < var5 + 8 + 16) {
                var23 = var16 - (var4 + 8);
                var19 = var17 - (var5 + 8);
                int var20 = this.field_28081_p.findTopSolidBlock(var16, var17);
                double var21 = this.field_28074_w[var23 * 16 + var19] - (double)(var20 - 64) / 64.0 * 0.3;
                if (var21 < 0.5 && var20 > 0 && var20 < 128 && this.field_28081_p.isAirBlock(var16, var20, var17) && this.field_28081_p.getBlockMaterial(var16, var20 - 1, var17).getIsSolid() && this.field_28081_p.getBlockMaterial(var16, var20 - 1, var17) != Material.ice) {
                    this.field_28081_p.setBlockWithNotify(var16, var20, var17, Block.snowPile.blockID);
                }
                ++var17;
            }
            ++var16;
        }
        BlockSand.fallInstantly = false;
    }

    @Override
    public boolean saveChunks(boolean var1, IProgressUpdate var2) {
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        return false;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "RandomLevelSource";
    }
}

