/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.features;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.WorldGenerator;

public class WorldGenBigMushroom
extends WorldGenerator {
    private int field_35266_a = -1;

    public WorldGenBigMushroom(int i) {
        this.field_35266_a = i;
    }

    public WorldGenBigMushroom() {
    }

    @Override
    public boolean generate(World world, Random random, int xCoord, int yCoord, int zCoord) {
        int mushroomType = random.nextInt(2);
        if (this.field_35266_a >= 0) {
            mushroomType = this.field_35266_a;
        }
        int mTypeChoiceY = random.nextInt(3) + 4;
        boolean flag = true;
        if (yCoord < 1 || yCoord + mTypeChoiceY + 1 > world.field_35472_c) {
            return false;
        }
        int j1 = yCoord;
        while (j1 <= yCoord + 1 + mTypeChoiceY) {
            int byte0 = 3;
            if (j1 == yCoord) {
                byte0 = 0;
            }
            int i2 = xCoord - byte0;
            while (i2 <= xCoord + byte0 && flag) {
                int l2 = zCoord - byte0;
                while (l2 <= zCoord + byte0 && flag) {
                    if (j1 >= 0 && j1 < world.field_35472_c) {
                        int k3 = world.getBlockId(i2, j1, l2);
                        if (k3 != 0 && k3 != Block.leaves.blockID) {
                            flag = false;
                        }
                    } else {
                        flag = false;
                    }
                    ++l2;
                }
                ++i2;
            }
            ++j1;
        }
        if (!flag) {
            return false;
        }
        int k1 = world.getBlockId(xCoord, yCoord - 1, zCoord);
        if (k1 != Block.dirt.blockID && k1 != Block.grass.blockID && k1 != Block.mycelium.blockID) {
            return false;
        }
        if (!Block.mushroomBrown.canPlaceBlockAt(world, xCoord, yCoord, zCoord)) {
            return false;
        }
        world.setBlock(xCoord, yCoord - 1, zCoord, Block.dirt.blockID);
        int l1 = yCoord + mTypeChoiceY;
        if (mushroomType == 1) {
            l1 = yCoord + mTypeChoiceY - 3;
        }
        int yPositionOutput = l1;
        while (yPositionOutput <= yCoord + mTypeChoiceY) {
            int mTypeChoiceX = 1;
            if (yPositionOutput < yCoord + mTypeChoiceY) {
                ++mTypeChoiceX;
            }
            if (mushroomType == 0) {
                mTypeChoiceX = 3;
            }
            int xPositionOutput = xCoord - mTypeChoiceX;
            while (xPositionOutput <= xCoord + mTypeChoiceX) {
                int zPositionOutput = zCoord - mTypeChoiceX;
                while (zPositionOutput <= zCoord + mTypeChoiceX) {
                    block39: {
                        int metadata;
                        block38: {
                            metadata = 5;
                            if (xPositionOutput == xCoord - mTypeChoiceX) {
                                --metadata;
                            }
                            if (xPositionOutput == xCoord + mTypeChoiceX) {
                                ++metadata;
                            }
                            if (zPositionOutput == zCoord - mTypeChoiceX) {
                                metadata -= 3;
                            }
                            if (zPositionOutput == zCoord + mTypeChoiceX) {
                                metadata += 3;
                            }
                            if (mushroomType != 0 && yPositionOutput >= yCoord + mTypeChoiceY) break block38;
                            if ((xPositionOutput == xCoord - mTypeChoiceX || xPositionOutput == xCoord + mTypeChoiceX) && (zPositionOutput == zCoord - mTypeChoiceX || zPositionOutput == zCoord + mTypeChoiceX)) break block39;
                            if (xPositionOutput == xCoord - (mTypeChoiceX - 1) && zPositionOutput == zCoord - mTypeChoiceX) {
                                metadata = 1;
                            }
                            if (xPositionOutput == xCoord - mTypeChoiceX && zPositionOutput == zCoord - (mTypeChoiceX - 1)) {
                                metadata = 1;
                            }
                            if (xPositionOutput == xCoord + (mTypeChoiceX - 1) && zPositionOutput == zCoord - mTypeChoiceX) {
                                metadata = 3;
                            }
                            if (xPositionOutput == xCoord + mTypeChoiceX && zPositionOutput == zCoord - (mTypeChoiceX - 1)) {
                                metadata = 3;
                            }
                            if (xPositionOutput == xCoord - (mTypeChoiceX - 1) && zPositionOutput == zCoord + mTypeChoiceX) {
                                metadata = 7;
                            }
                            if (xPositionOutput == xCoord - mTypeChoiceX && zPositionOutput == zCoord + (mTypeChoiceX - 1)) {
                                metadata = 7;
                            }
                            if (xPositionOutput == xCoord + (mTypeChoiceX - 1) && zPositionOutput == zCoord + mTypeChoiceX) {
                                metadata = 9;
                            }
                            if (xPositionOutput == xCoord + mTypeChoiceX && zPositionOutput == zCoord + (mTypeChoiceX - 1)) {
                                metadata = 9;
                            }
                        }
                        if (metadata == 5 && yPositionOutput < yCoord + mTypeChoiceY) {
                            metadata = 0;
                        }
                        if (!(metadata == 0 && yCoord < yCoord + mTypeChoiceY - 1 || Block.opaqueCubeLookup[world.getBlockId(xPositionOutput, yPositionOutput, zPositionOutput)])) {
                            world.setBlockAndMetadata(xPositionOutput, yPositionOutput, zPositionOutput, Block.mushroomCapBrown.blockID + mushroomType, metadata);
                        }
                    }
                    ++zPositionOutput;
                }
                ++xPositionOutput;
            }
            ++yPositionOutput;
        }
        int k2 = 0;
        while (k2 < mTypeChoiceY) {
            int j3 = world.getBlockId(xCoord, yCoord + k2, zCoord);
            if (!Block.opaqueCubeLookup[j3]) {
                world.setBlockWithNotify(xCoord, yCoord + k2, zCoord, Block.mushroomStem.blockID);
            }
            ++k2;
        }
        return true;
    }
}

