/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.structure;

import java.util.List;
import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.tileentity.TileEntityChest;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemDoor;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.chunk.ChunkPosition;
import net.minecraft.src.game.level.structure.StructureBoundingBox;
import net.minecraft.src.game.level.structure.StructurePieceBlockSelector;
import net.minecraft.src.game.level.structure.StructurePieceTreasure;
import net.minecraft.src.game.level.structure.WeightedRandom;
import net.minecraft.src.game.level.structure.WeightedRandomChestContent;

public abstract class StructureComponent {
    protected StructureBoundingBox boundingBox;
    protected int coordBaseMode;
    protected int field_35026_i;

    protected StructureComponent(int i) {
        this.field_35026_i = i;
        this.coordBaseMode = -1;
    }

    public void buildComponent(StructureComponent structurecomponent, List list, Random random) {
    }

    public abstract boolean addComponentParts(World var1, Random var2, StructureBoundingBox var3);

    public StructureBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public int func_35012_c() {
        return this.field_35026_i;
    }

    public static StructureComponent getIntersectingStructureComponent(List list, StructureBoundingBox structureboundingbox) {
        for (StructureComponent structurecomponent : list) {
            if (structurecomponent.getBoundingBox() == null || !structurecomponent.getBoundingBox().intersectsWith(structureboundingbox)) continue;
            return structurecomponent;
        }
        return null;
    }

    public ChunkPosition func_40008_a_() {
        return new ChunkPosition(this.boundingBox.func_40597_e(), this.boundingBox.func_40596_f(), this.boundingBox.func_40598_g());
    }

    protected boolean isLiquidInStructureBoundingBox(World world, StructureBoundingBox structureboundingbox) {
        int i = Math.max(this.boundingBox.minX - 1, structureboundingbox.minX);
        int j = Math.max(this.boundingBox.minY - 1, structureboundingbox.minY);
        int k = Math.max(this.boundingBox.minZ - 1, structureboundingbox.minZ);
        int l = Math.min(this.boundingBox.maxX + 1, structureboundingbox.maxX);
        int i1 = Math.min(this.boundingBox.maxY + 1, structureboundingbox.maxY);
        int j1 = Math.min(this.boundingBox.maxZ + 1, structureboundingbox.maxZ);
        int k1 = i;
        while (k1 <= l) {
            int j2 = k;
            while (j2 <= j1) {
                int i3 = world.getBlockId(k1, j, j2);
                if (i3 > 0 && Block.blocksList[i3].blockMaterial.getIsLiquid()) {
                    return true;
                }
                i3 = world.getBlockId(k1, i1, j2);
                if (i3 > 0 && Block.blocksList[i3].blockMaterial.getIsLiquid()) {
                    return true;
                }
                ++j2;
            }
            ++k1;
        }
        int l1 = i;
        while (l1 <= l) {
            int k2 = j;
            while (k2 <= i1) {
                int j3 = world.getBlockId(l1, k2, k);
                if (j3 > 0 && Block.blocksList[j3].blockMaterial.getIsLiquid()) {
                    return true;
                }
                j3 = world.getBlockId(l1, k2, j1);
                if (j3 > 0 && Block.blocksList[j3].blockMaterial.getIsLiquid()) {
                    return true;
                }
                ++k2;
            }
            ++l1;
        }
        int i2 = k;
        while (i2 <= j1) {
            int l2 = j;
            while (l2 <= i1) {
                int k3 = world.getBlockId(i, l2, i2);
                if (k3 > 0 && Block.blocksList[k3].blockMaterial.getIsLiquid()) {
                    return true;
                }
                k3 = world.getBlockId(l, l2, i2);
                if (k3 > 0 && Block.blocksList[k3].blockMaterial.getIsLiquid()) {
                    return true;
                }
                ++l2;
            }
            ++i2;
        }
        return false;
    }

    protected int getXWithOffset(int i, int j) {
        switch (this.coordBaseMode) {
            case 0: 
            case 2: {
                return this.boundingBox.minX + i;
            }
            case 1: {
                return this.boundingBox.maxX - j;
            }
            case 3: {
                return this.boundingBox.minX + j;
            }
        }
        return i;
    }

    protected int getYWithOffset(int i) {
        if (this.coordBaseMode == -1) {
            return i;
        }
        return i + this.boundingBox.minY;
    }

    protected int getZWithOffset(int i, int j) {
        switch (this.coordBaseMode) {
            case 2: {
                return this.boundingBox.maxZ - j;
            }
            case 0: {
                return this.boundingBox.minZ + j;
            }
            case 1: 
            case 3: {
                return this.boundingBox.minZ + i;
            }
        }
        return j;
    }

    protected int func_35009_c(int i, int j) {
        if (i == Block.rail.blockID) {
            if (this.coordBaseMode == 1 || this.coordBaseMode == 3) {
                return j != 1 ? 1 : 0;
            }
        } else if (i == Block.doorWood.blockID || i == Block.doorSteel.blockID) {
            if (this.coordBaseMode == 0) {
                if (j == 0) {
                    return 2;
                }
                if (j == 2) {
                    return 0;
                }
            } else {
                if (this.coordBaseMode == 1) {
                    return j + 1 & 3;
                }
                if (this.coordBaseMode == 3) {
                    return j + 3 & 3;
                }
            }
        } else if (i == Block.stairsCobblestone.blockID || i == Block.stairsPlanks.blockID || i == Block.stairsCobblestone.blockID || i == Block.stairsCobblestone.blockID) {
            if (this.coordBaseMode == 0) {
                if (j == 2) {
                    return 3;
                }
                if (j == 3) {
                    return 2;
                }
            } else if (this.coordBaseMode == 1) {
                if (j == 0) {
                    return 2;
                }
                if (j == 1) {
                    return 3;
                }
                if (j == 2) {
                    return 0;
                }
                if (j == 3) {
                    return 1;
                }
            } else if (this.coordBaseMode == 3) {
                if (j == 0) {
                    return 2;
                }
                if (j == 1) {
                    return 3;
                }
                if (j == 2) {
                    return 1;
                }
                if (j == 3) {
                    return 0;
                }
            }
        } else if (i == Block.ladder.blockID) {
            if (this.coordBaseMode == 0) {
                if (j == 2) {
                    return 3;
                }
                if (j == 3) {
                    return 2;
                }
            } else if (this.coordBaseMode == 1) {
                if (j == 2) {
                    return 4;
                }
                if (j == 3) {
                    return 5;
                }
                if (j == 4) {
                    return 2;
                }
                if (j == 5) {
                    return 3;
                }
            } else if (this.coordBaseMode == 3) {
                if (j == 2) {
                    return 5;
                }
                if (j == 3) {
                    return 4;
                }
                if (j == 4) {
                    return 2;
                }
                if (j == 5) {
                    return 3;
                }
            }
        } else if (i == Block.button.blockID) {
            if (this.coordBaseMode == 0) {
                if (j == 3) {
                    return 4;
                }
                if (j == 4) {
                    return 3;
                }
            } else if (this.coordBaseMode == 1) {
                if (j == 3) {
                    return 1;
                }
                if (j == 4) {
                    return 2;
                }
                if (j == 2) {
                    return 3;
                }
                if (j == 1) {
                    return 4;
                }
            } else if (this.coordBaseMode == 3) {
                if (j == 3) {
                    return 2;
                }
                if (j == 4) {
                    return 1;
                }
                if (j == 2) {
                    return 3;
                }
                if (j == 1) {
                    return 4;
                }
            }
        }
        return j;
    }

    protected void placeBlockAtCurrentPosition(World world, int i, int j, int k, int l, int i1, StructureBoundingBox structureboundingbox) {
        int l1;
        int k1;
        int j1 = this.getXWithOffset(k, i1);
        if (!structureboundingbox.isVecInside(j1, k1 = this.getYWithOffset(l), l1 = this.getZWithOffset(k, i1))) {
            return;
        }
        world.setBlockAndMetadata(j1, k1, l1, i, j);
    }

    protected int getBlockIdAtCurrentPosition(World world, int i, int j, int k, StructureBoundingBox structureboundingbox) {
        int j1;
        int i1;
        int l = this.getXWithOffset(i, k);
        if (!structureboundingbox.isVecInside(l, i1 = this.getYWithOffset(j), j1 = this.getZWithOffset(i, k))) {
            return 0;
        }
        return world.getBlockId(l, i1, j1);
    }

    protected void fillWithBlocks(World world, StructureBoundingBox structureboundingbox, int i, int j, int k, int l, int i1, int j1, int k1, int l1, boolean flag) {
        int i2 = j;
        while (i2 <= i1) {
            int j2 = i;
            while (j2 <= l) {
                int k2 = k;
                while (k2 <= j1) {
                    if (!flag || this.getBlockIdAtCurrentPosition(world, j2, i2, k2, structureboundingbox) != 0) {
                        if (i2 == j || i2 == i1 || j2 == i || j2 == l || k2 == k || k2 == j1) {
                            this.placeBlockAtCurrentPosition(world, k1, 0, j2, i2, k2, structureboundingbox);
                        } else {
                            this.placeBlockAtCurrentPosition(world, l1, 0, j2, i2, k2, structureboundingbox);
                        }
                    }
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
    }

    protected void fillWithRandomizedBlocks(World world, StructureBoundingBox structureboundingbox, int i, int j, int k, int l, int i1, int j1, boolean flag, Random random, StructurePieceBlockSelector structurepieceblockselector) {
        int k1 = j;
        while (k1 <= i1) {
            int l1 = i;
            while (l1 <= l) {
                int i2 = k;
                while (i2 <= j1) {
                    if (!flag || this.getBlockIdAtCurrentPosition(world, l1, k1, i2, structureboundingbox) != 0) {
                        structurepieceblockselector.selectBlocks(random, l1, k1, i2, k1 == j || k1 == i1 || l1 == i || l1 == l || i2 == k || i2 == j1);
                        this.placeBlockAtCurrentPosition(world, structurepieceblockselector.getSelectedBlockId(), structurepieceblockselector.getSelectedBlockMetaData(), l1, k1, i2, structureboundingbox);
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
    }

    protected void randomlyFillWithBlocks(World world, StructureBoundingBox structureboundingbox, Random random, float f, int i, int j, int k, int l, int i1, int j1, int k1, int l1, boolean flag) {
        int i2 = j;
        while (i2 <= i1) {
            int j2 = i;
            while (j2 <= l) {
                int k2 = k;
                while (k2 <= j1) {
                    if (!(random.nextFloat() > f || flag && this.getBlockIdAtCurrentPosition(world, j2, i2, k2, structureboundingbox) == 0)) {
                        if (i2 == j || i2 == i1 || j2 == i || j2 == l || k2 == k || k2 == j1) {
                            this.placeBlockAtCurrentPosition(world, k1, 0, j2, i2, k2, structureboundingbox);
                        } else {
                            this.placeBlockAtCurrentPosition(world, l1, 0, j2, i2, k2, structureboundingbox);
                        }
                    }
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
    }

    protected void randomlyPlaceBlock(World world, StructureBoundingBox structureboundingbox, Random random, float f, int i, int j, int k, int l, int i1) {
        if (random.nextFloat() < f) {
            this.placeBlockAtCurrentPosition(world, l, i1, i, j, k, structureboundingbox);
        }
    }

    protected void randomlyRareFillWithBlocks(World world, StructureBoundingBox structureboundingbox, int i, int j, int k, int l, int i1, int j1, int k1, boolean flag) {
        float f = l - i + 1;
        float f1 = i1 - j + 1;
        float f2 = j1 - k + 1;
        float f3 = (float)i + f / 2.0f;
        float f4 = (float)k + f2 / 2.0f;
        int l1 = j;
        while (l1 <= i1) {
            float f5 = (float)(l1 - j) / f1;
            int i2 = i;
            while (i2 <= l) {
                float f6 = ((float)i2 - f3) / (f * 0.5f);
                int j2 = k;
                while (j2 <= j1) {
                    float f8;
                    float f7 = ((float)j2 - f4) / (f2 * 0.5f);
                    if ((!flag || this.getBlockIdAtCurrentPosition(world, i2, l1, j2, structureboundingbox) != 0) && (f8 = f6 * f6 + f5 * f5 + f7 * f7) <= 1.05f) {
                        this.placeBlockAtCurrentPosition(world, k1, 0, i2, l1, j2, structureboundingbox);
                    }
                    ++j2;
                }
                ++i2;
            }
            ++l1;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void clearCurrentPositionBlocksUpwards(World world, int i, int j, int k, StructureBoundingBox structureboundingbox) {
        l = this.getXWithOffset(i, k);
        if (structureboundingbox.isVecInside(l, i1 = this.getYWithOffset(j), j1 = this.getZWithOffset(i, k))) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            world.setBlockAndMetadata(l, i1, j1, 0, 0);
            ++i1;
lbl7:
            // 2 sources

            ** while (!world.isAirBlock((int)l, (int)i1, (int)j1) && i1 < world.field_35469_d)
        }
lbl8:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    protected void fillCurrentPositionBlocksDownwards(World world, int i, int j, int k, int l, int i1, StructureBoundingBox structureboundingbox) {
        j1 = this.getXWithOffset(k, i1);
        if (structureboundingbox.isVecInside(j1, k1 = this.getYWithOffset(l), l1 = this.getZWithOffset(k, i1))) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            world.setBlockAndMetadata(j1, k1, l1, i, j);
            --k1;
lbl7:
            // 2 sources

            ** while ((world.isAirBlock((int)j1, (int)k1, (int)l1) || world.getBlockMaterial((int)j1, (int)k1, (int)l1).getIsLiquid()) && k1 > 1)
        }
lbl8:
        // 1 sources

    }

    protected void createTreasureChestAtCurrentPosition(World world, StructureBoundingBox structureboundingbox, Random random, int i, int j, int k, StructurePieceTreasure[] astructurepiecetreasure, int l) {
        int k1;
        int j1;
        int i1 = this.getXWithOffset(i, k);
        if (structureboundingbox.isVecInside(i1, j1 = this.getYWithOffset(j), k1 = this.getZWithOffset(i, k)) && world.getBlockId(i1, j1, k1) != Block.chest.blockID) {
            world.setBlockWithNotify(i1, j1, k1, Block.chest.blockID);
            TileEntityChest tileentitychest = (TileEntityChest)world.getBlockTileEntity(i1, j1, k1);
            if (tileentitychest != null) {
                StructureComponent.fillTreasureChestWithLoot(random, astructurepiecetreasure, tileentitychest, l);
            }
        }
    }

    private static void fillTreasureChestWithLoot(Random random, StructurePieceTreasure[] astructurepiecetreasure, TileEntityChest tileentitychest, int i) {
        int j = 0;
        while (j < i) {
            StructurePieceTreasure structurepiecetreasure = (StructurePieceTreasure)WeightedRandom.func_35735_a(random, astructurepiecetreasure);
            int k = structurepiecetreasure.field_35595_c + random.nextInt(structurepiecetreasure.field_35593_e - structurepiecetreasure.field_35595_c + 1);
            if (Item.itemsList[structurepiecetreasure.field_35596_a].getItemStackLimit() >= k) {
                tileentitychest.setInventorySlotContents(random.nextInt(tileentitychest.getSizeInventory()), new ItemStack(structurepiecetreasure.field_35596_a, k, structurepiecetreasure.field_35594_b));
            } else {
                int l = 0;
                while (l < k) {
                    tileentitychest.setInventorySlotContents(random.nextInt(tileentitychest.getSizeInventory()), new ItemStack(structurepiecetreasure.field_35596_a, 1, structurepiecetreasure.field_35594_b));
                    ++l;
                }
            }
            ++j;
        }
    }

    protected void placeDoorAtCurrentPosition(World world, StructureBoundingBox structureboundingbox, Random random, int i, int j, int k, int l) {
        int k1;
        int j1;
        int i1 = this.getXWithOffset(i, k);
        if (structureboundingbox.isVecInside(i1, j1 = this.getYWithOffset(j), k1 = this.getZWithOffset(i, k))) {
            ItemDoor.placeDoorBlock(world, i1, j1, k1, l, Block.doorWood);
        }
    }

    protected boolean generateStructureChestContents(World par1World, StructureBoundingBox par2StructureBoundingBox, Random par3Random, int par4, int par5, int par6, WeightedRandomChestContent[] par7ArrayOfWeightedRandomChestContent, int par8) {
        int var11;
        int var10;
        int var9 = this.getXWithOffset(par4, par6);
        if (par2StructureBoundingBox.isVecInside(var9, var10 = this.getYWithOffset(par5), var11 = this.getZWithOffset(par4, par6)) && par1World.getBlockId(var9, var10, var11) != Block.chest.blockID) {
            par1World.setBlock(var9, var10, var11, Block.chest.blockID);
            TileEntityChest var12 = (TileEntityChest)par1World.getBlockTileEntity(var9, var10, var11);
            if (var12 != null) {
                WeightedRandomChestContent.generateChestContents(par3Random, par7ArrayOfWeightedRandomChestContent, var12, par8);
            }
            return true;
        }
        return false;
    }
}

