/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.structure;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.structure.StructureBoundingBox;
import net.minecraft.src.game.level.structure.StructureComponent;

public abstract class StructureStart {
    protected LinkedList components = new LinkedList();
    protected StructureBoundingBox boundingBox;

    protected StructureStart() {
    }

    public StructureBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public LinkedList func_40560_b() {
        return this.components;
    }

    public void generateStructure(World world, Random random, StructureBoundingBox structureboundingbox) {
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            StructureComponent structurecomponent = (StructureComponent)iterator.next();
            if (!structurecomponent.getBoundingBox().intersectsWith(structureboundingbox) || structurecomponent.addComponentParts(world, random, structureboundingbox)) continue;
            iterator.remove();
        }
    }

    protected void updateBoundingBox() {
        this.boundingBox = StructureBoundingBox.getNewBoundingBox();
        for (StructureComponent structurecomponent : this.components) {
            this.boundingBox.resizeBoundingBoxTo(structurecomponent.getBoundingBox());
        }
    }

    protected void markAvailableHeight(World world, Random random, int i) {
        int j = world.field_35470_e - i;
        int k = this.boundingBox.getYSize() + 1;
        if (k < j) {
            k += random.nextInt(j - k);
        }
        int l = k - this.boundingBox.maxY;
        this.boundingBox.offset(0, l, 0);
        for (StructureComponent structurecomponent : this.components) {
            structurecomponent.getBoundingBox().offset(0, l, 0);
        }
    }

    protected void func_40559_a(World world, Random random, int i, int j) {
        int k = j - i + 1 - this.boundingBox.getYSize();
        int l = 1;
        l = k > 1 ? i + random.nextInt(k) : i;
        int i1 = l - this.boundingBox.minY;
        this.boundingBox.offset(0, i1, 0);
        for (StructureComponent structurecomponent : this.components) {
            structurecomponent.getBoundingBox().offset(0, i1, 0);
        }
    }

    public boolean isSizeableStructure() {
        return true;
    }
}

