/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.File;
import net.minecraft.client.MinecraftApplet;
import net.minecraft.mitask.PlayerCommandHandler;
import net.minecraft.src.client.EnumOS2;
import net.minecraft.src.client.EnumOptions;
import net.minecraft.src.client.GameSettings;
import net.minecraft.src.client.GameWindowListener;
import net.minecraft.src.client.MinecraftError;
import net.minecraft.src.client.MinecraftException;
import net.minecraft.src.client.MinecraftImpl;
import net.minecraft.src.client.MouseHelper;
import net.minecraft.src.client.OpenGlCapsChecker;
import net.minecraft.src.client.Session;
import net.minecraft.src.client.Timer;
import net.minecraft.src.client.UnexpectedThrowable;
import net.minecraft.src.client.gui.FontRenderer;
import net.minecraft.src.client.gui.GuiAchievement;
import net.minecraft.src.client.gui.GuiChat;
import net.minecraft.src.client.gui.GuiConflictWarning;
import net.minecraft.src.client.gui.GuiConnecting;
import net.minecraft.src.client.gui.GuiContainerCreative;
import net.minecraft.src.client.gui.GuiErrorScreen;
import net.minecraft.src.client.gui.GuiGameOver;
import net.minecraft.src.client.gui.GuiIngame;
import net.minecraft.src.client.gui.GuiIngameMenu;
import net.minecraft.src.client.gui.GuiInventory;
import net.minecraft.src.client.gui.GuiMainMenu;
import net.minecraft.src.client.gui.GuiScreen;
import net.minecraft.src.client.gui.GuiSleepMP;
import net.minecraft.src.client.gui.GuiUnused;
import net.minecraft.src.client.gui.LoadingScreenRenderer;
import net.minecraft.src.client.gui.ScaledResolution;
import net.minecraft.src.client.gui.ScreenShotHelper;
import net.minecraft.src.client.model.ModelBiped;
import net.minecraft.src.client.packets.NetClientHandler;
import net.minecraft.src.client.packets.ThreadCheckHasPaid;
import net.minecraft.src.client.packets.ThreadSleepForever;
import net.minecraft.src.client.particle.EffectRenderer;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.client.physics.MovingObjectPosition;
import net.minecraft.src.client.player.EntityClientPlayerMP;
import net.minecraft.src.client.player.EntityPlayerSP;
import net.minecraft.src.client.player.MovementInputFromOptions;
import net.minecraft.src.client.player.PlayerController;
import net.minecraft.src.client.player.PlayerControllerTest;
import net.minecraft.src.client.renderer.EntityRenderer;
import net.minecraft.src.client.renderer.GLAllocation;
import net.minecraft.src.client.renderer.ItemRenderer;
import net.minecraft.src.client.renderer.RenderBlocks;
import net.minecraft.src.client.renderer.RenderEngine;
import net.minecraft.src.client.renderer.RenderGlobal;
import net.minecraft.src.client.renderer.Tessellator;
import net.minecraft.src.client.renderer.Vec3D;
import net.minecraft.src.client.renderer.WorldRenderer;
import net.minecraft.src.client.renderer.block.ColorizerFoliage;
import net.minecraft.src.client.renderer.block.ColorizerGrass;
import net.minecraft.src.client.renderer.block.ColorizerWater;
import net.minecraft.src.client.renderer.block.TextureCampfireBaseFX;
import net.minecraft.src.client.renderer.block.TextureCampfireFX;
import net.minecraft.src.client.renderer.block.TextureCombustorFX;
import net.minecraft.src.client.renderer.block.TextureCompassFX;
import net.minecraft.src.client.renderer.block.TextureFlamesFX;
import net.minecraft.src.client.renderer.block.TextureGearsFX;
import net.minecraft.src.client.renderer.block.TextureLavaFX;
import net.minecraft.src.client.renderer.block.TextureLavaFlowFX;
import net.minecraft.src.client.renderer.block.TextureMotorFX;
import net.minecraft.src.client.renderer.block.TexturePackList;
import net.minecraft.src.client.renderer.block.TexturePortalFX;
import net.minecraft.src.client.renderer.block.TextureSlimeBucketFX;
import net.minecraft.src.client.renderer.block.TextureTreadmillBackFX;
import net.minecraft.src.client.renderer.block.TextureTreadmillFrontFX;
import net.minecraft.src.client.renderer.block.TextureTreadmillSideFX;
import net.minecraft.src.client.renderer.block.TextureTreadmillTopFX;
import net.minecraft.src.client.renderer.block.TextureWatchFX;
import net.minecraft.src.client.renderer.block.TextureWaterFX;
import net.minecraft.src.client.renderer.block.TextureWaterFlowFX;
import net.minecraft.src.client.renderer.entity.RenderManager;
import net.minecraft.src.client.sound.SoundManager;
import net.minecraft.src.client.sound.ThreadDownloadResources;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.Profiler;
import net.minecraft.src.game.achievements.AchievementList;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.effect.Effect;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.other.EntityBoat;
import net.minecraft.src.game.entity.other.EntityMinecart;
import net.minecraft.src.game.entity.other.EntityPainting;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.entity.player.EnumPlayerAction;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.EnumMovingObjectType;
import net.minecraft.src.game.level.Teleporter;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.WorldProvider;
import net.minecraft.src.game.level.WorldSettings;
import net.minecraft.src.game.level.chunk.ChunkCoordinates;
import net.minecraft.src.game.level.chunk.ChunkProviderLoadOrGenerate;
import net.minecraft.src.game.level.chunk.IChunkProvider;
import net.minecraft.src.game.level.chunk.ISaveFormat;
import net.minecraft.src.game.level.chunk.ISaveHandler;
import net.minecraft.src.game.level.chunk.SaveConverterMcRegion;
import net.minecraft.src.game.stats.StatFileWriter;
import net.minecraft.src.game.stats.StatList;
import net.minecraft.src.game.stats.StatStringFormatKeyInv;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.util.glu.GLU;

public abstract class Minecraft
implements Runnable {
    public static byte[] field_28006_b = new byte[0xA00000];
    public static Minecraft theMinecraft;
    public PlayerController playerController;
    private boolean fullscreen = false;
    private boolean hasCrashed = false;
    public int displayWidth;
    public int displayHeight;
    private OpenGlCapsChecker glCapabilities;
    private Timer timer = new Timer(20.0f);
    public World theWorld;
    public RenderGlobal renderGlobal;
    public EntityPlayerSP thePlayer;
    public EntityLiving renderViewEntity;
    public EffectRenderer effectRenderer;
    public Session session = null;
    public String minecraftUri;
    public Canvas mcCanvas;
    public boolean hideQuitButton = true;
    public volatile boolean isGamePaused = false;
    public RenderEngine renderEngine;
    public FontRenderer fontRenderer;
    public GuiScreen currentScreen = null;
    public LoadingScreenRenderer loadingScreen = new LoadingScreenRenderer(this);
    public EntityRenderer entityRenderer;
    private ThreadDownloadResources downloadResourcesThread;
    private int ticksRan = 0;
    private int leftClickCounter = 0;
    private int tempDisplayWidth;
    private int tempDisplayHeight;
    public GuiAchievement guiAchievement = new GuiAchievement(this);
    public GuiIngame ingameGUI;
    public boolean skipRenderWorld = false;
    public ModelBiped field_9242_w = new ModelBiped(0.0f);
    public MovingObjectPosition objectMouseOver = null;
    public GameSettings gameSettings;
    protected MinecraftApplet mcApplet;
    public SoundManager sndManager = new SoundManager();
    public MouseHelper mouseHelper;
    public TexturePackList texturePackList;
    public File mcDataDir;
    private ISaveFormat saveLoader;
    public static long[] frameTimes;
    public static long[] tickTimes;
    public static int numRecordedFrameTimes;
    public static long hasPaidCheckTime;
    public StatFileWriter statFileWriter;
    private String serverName;
    private int serverPort;
    private TextureWaterFX textureWaterFX = new TextureWaterFX();
    private TextureLavaFX textureLavaFX = new TextureLavaFX();
    private static File minecraftDir;
    public volatile boolean running = true;
    public String debug = "";
    boolean isTakingScreenshot = false;
    long prevFrameTime = -1L;
    public boolean inGameHasFocus = false;
    private int mouseTicksRan = 0;
    public boolean isRaining = false;
    long systemTime = System.currentTimeMillis();
    private int joinPlayerCounter = 0;
    public final Profiler mcProfiler = new Profiler();
    boolean rmb = false;
    private TextureMotorFX textureMotorFX = new TextureMotorFX();
    private TextureCombustorFX textureCombustorFX = new TextureCombustorFX();
    private TextureTreadmillTopFX textureTreadmillTopFX = new TextureTreadmillTopFX();
    private TextureTreadmillFrontFX textureTreadmillFrontFX = new TextureTreadmillFrontFX();
    private TextureTreadmillBackFX textureTreadmillBackFX = new TextureTreadmillBackFX();
    private TextureTreadmillSideFX textureTreadmillSideFX = new TextureTreadmillSideFX();
    private TextureCampfireFX textureCampfireFX = new TextureCampfireFX();
    private TextureCampfireBaseFX textureCampfireBaseFX = new TextureCampfireBaseFX();
    public static PlayerCommandHandler pch;

    static {
        frameTimes = new long[512];
        tickTimes = new long[512];
        numRecordedFrameTimes = 0;
        hasPaidCheckTime = 0L;
        minecraftDir = null;
    }

    public Minecraft(Component var1, Canvas var2, MinecraftApplet var3, int var4, int var5, boolean var6) {
        theMinecraft = this;
        StatList.func_27360_a();
        this.tempDisplayHeight = var5;
        this.fullscreen = var6;
        this.mcApplet = var3;
        new ThreadSleepForever(this, "Timer hack thread");
        this.mcCanvas = var2;
        this.displayWidth = var4;
        this.displayHeight = var5;
        this.fullscreen = var6;
        if (var3 == null || "true".equals(var3.getParameter("stand-alone"))) {
            this.hideQuitButton = false;
        }
        theMinecraft = this;
        pch = new PlayerCommandHandler(theMinecraft);
    }

    public static Minecraft getInstance() {
        return theMinecraft;
    }

    public void onMinecraftCrash(UnexpectedThrowable var1) {
        this.hasCrashed = true;
        this.displayUnexpectedThrowable(var1);
    }

    public abstract void displayUnexpectedThrowable(UnexpectedThrowable var1);

    public void setServer(String var1, int var2) {
        this.serverName = var1;
        this.serverPort = var2;
    }

    public void startGame() throws LWJGLException {
        if (this.mcCanvas != null) {
            Graphics var1 = this.mcCanvas.getGraphics();
            if (var1 != null) {
                var1.setColor(Color.blue);
                var1.fillRect(0, 0, this.displayWidth, this.displayHeight);
                var1.dispose();
            }
            Display.setParent((Canvas)this.mcCanvas);
        } else if (this.fullscreen) {
            Display.setFullscreen((boolean)true);
            this.displayWidth = Display.getDisplayMode().getWidth();
            this.displayHeight = Display.getDisplayMode().getHeight();
            if (this.displayWidth <= 0) {
                this.displayWidth = 1;
            }
            if (this.displayHeight <= 0) {
                this.displayHeight = 1;
            }
        } else {
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.displayWidth, this.displayHeight));
        }
        Display.setTitle((String)"Minecraft Minecraft ReIndev");
        try {
            PixelFormat pixelformat = new PixelFormat();
            pixelformat = pixelformat.withDepthBits(24);
            Display.create((PixelFormat)pixelformat);
        }
        catch (LWJGLException var6) {
            var6.printStackTrace();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Display.create();
        }
        this.mcDataDir = Minecraft.getMinecraftDir();
        this.saveLoader = new SaveConverterMcRegion(new File(this.mcDataDir, "saves"));
        this.gameSettings = new GameSettings(this, this.mcDataDir);
        this.texturePackList = new TexturePackList(this, this.mcDataDir);
        this.renderEngine = new RenderEngine(this.texturePackList, this.gameSettings);
        this.fontRenderer = new FontRenderer(this.gameSettings, "/font/default.png", this.renderEngine, false);
        ColorizerWater.func_28182_a(this.renderEngine.func_28149_a("/misc/watercolor.png"));
        ColorizerGrass.func_28181_a(this.renderEngine.func_28149_a("/misc/grasscolor.png"));
        ColorizerFoliage.func_28152_a(this.renderEngine.func_28149_a("/misc/foliagecolor.png"));
        this.entityRenderer = new EntityRenderer(this);
        RenderManager.instance.itemRenderer = new ItemRenderer(this);
        this.statFileWriter = new StatFileWriter(this.session, this.mcDataDir);
        AchievementList.openInventory.setStatStringFormatter(new StatStringFormatKeyInv(this));
        this.loadScreen();
        Keyboard.create();
        Mouse.create();
        Effect.initEffects();
        this.mouseHelper = new MouseHelper(this.mcCanvas);
        try {
            Controllers.create();
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        this.checkGLError("Pre startup");
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glCullFace((int)1029);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        this.checkGLError("Startup");
        this.glCapabilities = new OpenGlCapsChecker();
        this.sndManager.loadSoundSettings(this.gameSettings);
        this.renderEngine.registerTextureFX(this.textureLavaFX);
        this.renderEngine.registerTextureFX(this.textureWaterFX);
        this.renderEngine.registerTextureFX(new TexturePortalFX());
        this.renderEngine.registerTextureFX(new TextureSlimeBucketFX(this));
        this.renderEngine.registerTextureFX(new TextureCompassFX(this));
        this.renderEngine.registerTextureFX(new TextureWatchFX(this));
        this.renderEngine.registerTextureFX(new TextureWaterFlowFX());
        this.renderEngine.registerTextureFX(new TextureLavaFlowFX());
        this.renderEngine.registerTextureFX(new TextureFlamesFX(0));
        this.renderEngine.registerTextureFX(new TextureFlamesFX(1));
        this.renderEngine.registerTextureFX(new TextureGearsFX(0));
        this.renderEngine.registerTextureFX(new TextureGearsFX(1));
        this.renderEngine.registerTextureFX(this.textureMotorFX);
        this.renderEngine.registerTextureFX(this.textureCombustorFX);
        this.renderEngine.registerTextureFX(this.textureTreadmillTopFX);
        this.renderEngine.registerTextureFX(this.textureTreadmillFrontFX);
        this.renderEngine.registerTextureFX(this.textureTreadmillBackFX);
        this.renderEngine.registerTextureFX(this.textureTreadmillSideFX);
        this.renderEngine.registerTextureFX(this.textureCampfireFX);
        this.renderEngine.registerTextureFX(this.textureCampfireBaseFX);
        this.renderGlobal = new RenderGlobal(this, this.renderEngine);
        GL11.glViewport((int)0, (int)0, (int)this.displayWidth, (int)this.displayHeight);
        this.effectRenderer = new EffectRenderer(this.theWorld, this.renderEngine);
        try {
            this.downloadResourcesThread = new ThreadDownloadResources(this.mcDataDir, this);
            this.downloadResourcesThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkGLError("Post startup");
        this.ingameGUI = new GuiIngame(this);
        if (this.serverName != null) {
            this.displayGuiScreen(new GuiConnecting(this, this.serverName, this.serverPort));
        } else {
            this.displayGuiScreen(new GuiMainMenu());
        }
    }

    private void loadScreen() throws LWJGLException {
        ScaledResolution var1 = new ScaledResolution(this.gameSettings, this.displayWidth, this.displayHeight);
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)var1.field_25121_a, (double)var1.field_25120_b, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glViewport((int)0, (int)0, (int)this.displayWidth, (int)this.displayHeight);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Tessellator var2 = Tessellator.instance;
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2912);
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/title/mojang.png"));
        var2.startDrawingQuads();
        var2.setColorOpaque_I(0xFFFFFF);
        var2.addVertexWithUV(0.0, this.displayHeight, 0.0, 0.0, 0.0);
        var2.addVertexWithUV(this.displayWidth, this.displayHeight, 0.0, 0.0, 0.0);
        var2.addVertexWithUV(this.displayWidth, 0.0, 0.0, 0.0, 0.0);
        var2.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        var2.draw();
        int var3 = 256;
        int var4 = 256;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        var2.setColorOpaque_I(0xFFFFFF);
        this.func_6274_a((var1.getScaledWidth() - var3) / 2, (var1.getScaledHeight() - var4) / 2, 0, 0, var3, var4);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        Display.swapBuffers();
    }

    public void func_6274_a(int var1, int var2, int var3, int var4, int var5, int var6) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.instance;
        var9.startDrawingQuads();
        var9.addVertexWithUV(var1 + 0, var2 + var6, 0.0, (float)(var3 + 0) * var7, (float)(var4 + var6) * var8);
        var9.addVertexWithUV(var1 + var5, var2 + var6, 0.0, (float)(var3 + var5) * var7, (float)(var4 + var6) * var8);
        var9.addVertexWithUV(var1 + var5, var2 + 0, 0.0, (float)(var3 + var5) * var7, (float)(var4 + 0) * var8);
        var9.addVertexWithUV(var1 + 0, var2 + 0, 0.0, (float)(var3 + 0) * var7, (float)(var4 + 0) * var8);
        var9.draw();
    }

    public static File getMinecraftDir() {
        if (minecraftDir == null) {
            minecraftDir = Minecraft.getAppDir("reindev");
        }
        return minecraftDir;
    }

    public static File getAppDir(String var0) {
        File var2;
        String var1 = System.getProperty("user.home", ".");
        switch (Minecraft.getOs()) {
            case linux: 
            case solaris: {
                var2 = new File(var1, String.valueOf('.') + var0 + '/');
                break;
            }
            case windows: {
                String var3 = System.getenv("APPDATA");
                if (var3 != null) {
                    var2 = new File(var3, "." + var0 + '/');
                    break;
                }
                var2 = new File(var1, String.valueOf('.') + var0 + '/');
                break;
            }
            case macos: {
                var2 = new File(var1, "Library/Application Support/" + var0);
                break;
            }
            default: {
                var2 = new File(var1, String.valueOf(var0) + '/');
            }
        }
        if (!var2.exists() && !var2.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + var2);
        }
        return var2;
    }

    private static EnumOS2 getOs() {
        String var0 = System.getProperty("os.name").toLowerCase();
        if (var0.contains("win")) {
            return EnumOS2.windows;
        }
        if (var0.contains("mac")) {
            return EnumOS2.macos;
        }
        if (var0.contains("solaris")) {
            return EnumOS2.solaris;
        }
        if (var0.contains("sunos")) {
            return EnumOS2.solaris;
        }
        if (var0.contains("linux")) {
            return EnumOS2.linux;
        }
        return var0.contains("unix") ? EnumOS2.linux : EnumOS2.unknown;
    }

    public ISaveFormat getSaveLoader() {
        return this.saveLoader;
    }

    public void displayGuiScreen(GuiScreen var1) {
        if (!(this.currentScreen instanceof GuiUnused)) {
            if (this.currentScreen != null) {
                this.currentScreen.onGuiClosed();
            }
            if (var1 instanceof GuiMainMenu) {
                this.statFileWriter.func_27175_b();
            }
            this.statFileWriter.syncStats();
            if (var1 == null && this.theWorld == null) {
                var1 = new GuiMainMenu();
            } else if (var1 == null && this.thePlayer.health <= 0) {
                var1 = new GuiGameOver();
            }
            if (var1 instanceof GuiMainMenu) {
                this.ingameGUI.clearChatMessages();
            }
            this.currentScreen = var1;
            if (var1 != null) {
                this.setIngameNotInFocus();
                ScaledResolution var2 = new ScaledResolution(this.gameSettings, this.displayWidth, this.displayHeight);
                int var3 = var2.getScaledWidth();
                int var4 = var2.getScaledHeight();
                var1.setWorldAndResolution(this, var3, var4);
                this.skipRenderWorld = false;
            } else {
                this.setIngameFocus();
            }
        }
    }

    private void checkGLError(String var1) {
        int var2 = GL11.glGetError();
        if (var2 != 0) {
            String var3 = GLU.gluErrorString((int)var2);
            System.out.println("########## GL ERROR ##########");
            System.out.println("@ " + var1);
            System.out.println(String.valueOf(var2) + ": " + var3);
        }
    }

    public void shutdownMinecraftApplet() {
        try {
            this.statFileWriter.func_27175_b();
            this.statFileWriter.syncStats();
            if (this.mcApplet != null) {
                this.mcApplet.clearApplet();
            }
            try {
                if (this.downloadResourcesThread != null) {
                    this.downloadResourcesThread.closeMinecraft();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("Stopping!");
            try {
                this.changeWorld1(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                GLAllocation.deleteTexturesAndDisplayLists();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.sndManager.closeMinecraft();
            Mouse.destroy();
            Keyboard.destroy();
        }
        finally {
            Display.destroy();
            if (!this.hasCrashed) {
                System.exit(0);
            }
        }
        System.gc();
    }

    @Override
    public void run() {
        this.running = true;
        try {
            this.startGame();
        }
        catch (Exception var17) {
            var17.printStackTrace();
            this.onMinecraftCrash(new UnexpectedThrowable("Failed to start game", var17));
            return;
        }
        File test = new File("jar:file:/resources/sound/fallbig2.ogg!/");
        this.sndManager.addSound("sound.testsound", test);
        try {
            try {
                long var1 = System.currentTimeMillis();
                int var3 = 0;
                while (this.running) {
                    try {
                        if (this.mcApplet != null && !this.mcApplet.isActive()) {
                            break;
                        }
                        AxisAlignedBB.clearBoundingBoxPool();
                        Vec3D.initialize();
                        if (this.mcCanvas == null && Display.isCloseRequested()) {
                            this.shutdown();
                        }
                        if (this.isGamePaused && this.theWorld != null) {
                            float var4 = this.timer.renderPartialTicks;
                            this.timer.updateTimer();
                            this.timer.renderPartialTicks = var4;
                        } else {
                            this.timer.updateTimer();
                        }
                        long var23 = System.nanoTime();
                        int var6 = 0;
                        while (var6 < this.timer.elapsedTicks) {
                            ++this.ticksRan;
                            try {
                                this.runTick();
                            }
                            catch (MinecraftException var16) {
                                this.theWorld = null;
                                this.changeWorld1(null);
                                this.displayGuiScreen(new GuiConflictWarning());
                            }
                            ++var6;
                        }
                        long var24 = System.nanoTime() - var23;
                        this.checkGLError("Pre render");
                        RenderBlocks.distortion = this.gameSettings.blockDistortion;
                        this.sndManager.func_338_a(this.thePlayer, this.timer.renderPartialTicks);
                        GL11.glEnable((int)3553);
                        if (this.theWorld != null) {
                            this.theWorld.updatingLighting();
                        }
                        if (!Keyboard.isKeyDown((int)65)) {
                            Display.update();
                        }
                        if (this.thePlayer != null && this.thePlayer.isEntityInsideOpaqueBlock()) {
                            this.gameSettings.thirdPersonView = 0;
                        }
                        if (!this.skipRenderWorld) {
                            if (this.playerController != null) {
                                this.playerController.setPartialTime(this.timer.renderPartialTicks);
                            }
                            this.entityRenderer.updateCameraAndRender(this.timer.renderPartialTicks);
                        }
                        if (!Display.isActive()) {
                            if (this.fullscreen) {
                                this.toggleFullscreen();
                            }
                            Thread.sleep(10L);
                        }
                        if (this.gameSettings.showDebugInfo) {
                            this.displayDebugInfo(var24);
                        } else {
                            this.prevFrameTime = System.nanoTime();
                        }
                        this.guiAchievement.updateAchievementWindow();
                        Thread.yield();
                        if (Keyboard.isKeyDown((int)65)) {
                            Display.update();
                        }
                        this.screenshotListener();
                        if (!(this.mcCanvas == null || this.fullscreen || this.mcCanvas.getWidth() == this.displayWidth && this.mcCanvas.getHeight() == this.displayHeight)) {
                            this.displayWidth = this.mcCanvas.getWidth();
                            this.displayHeight = this.mcCanvas.getHeight();
                            if (this.displayWidth <= 0) {
                                this.displayWidth = 1;
                            }
                            if (this.displayHeight <= 0) {
                                this.displayHeight = 1;
                            }
                            this.resize(this.displayWidth, this.displayHeight);
                        }
                        this.checkGLError("Post render");
                        ++var3;
                        this.isGamePaused = !this.isMultiplayerWorld() && this.currentScreen != null && this.currentScreen.doesGuiPauseGame();
                        while (System.currentTimeMillis() >= var1 + 1000L) {
                            this.debug = String.valueOf(var3) + " fps, " + WorldRenderer.chunksUpdated + " chunk updates";
                            WorldRenderer.chunksUpdated = 0;
                            var1 += 1000L;
                            var3 = 0;
                        }
                    }
                    catch (MinecraftException var18) {
                        this.theWorld = null;
                        this.changeWorld1(null);
                        this.displayGuiScreen(new GuiConflictWarning());
                    }
                    catch (OutOfMemoryError var19) {
                        this.func_28002_e();
                        this.displayGuiScreen(new GuiErrorScreen());
                        System.gc();
                    }
                }
            }
            catch (MinecraftError var1) {
                this.shutdownMinecraftApplet();
            }
            catch (Throwable var21) {
                this.func_28002_e();
                var21.printStackTrace();
                this.onMinecraftCrash(new UnexpectedThrowable("Unexpected error", var21));
                this.shutdownMinecraftApplet();
            }
        }
        finally {
            this.shutdownMinecraftApplet();
        }
    }

    public void func_28002_e() {
        try {
            field_28006_b = new byte[0];
            this.renderGlobal.func_28137_f();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            AxisAlignedBB.func_28196_a();
            Vec3D.func_28215_a();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            this.changeWorld1(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    private void screenshotListener() {
        if (Keyboard.isKeyDown((int)60)) {
            if (!this.isTakingScreenshot) {
                this.isTakingScreenshot = true;
                this.ingameGUI.addChatMessage(ScreenShotHelper.saveScreenshot(minecraftDir, this.displayWidth, this.displayHeight));
            }
        } else {
            this.isTakingScreenshot = false;
        }
    }

    private void displayDebugInfo(long var1) {
        long var3 = 16666666L;
        if (this.prevFrameTime == -1L) {
            this.prevFrameTime = System.nanoTime();
        }
        long var5 = System.nanoTime();
        Minecraft.tickTimes[Minecraft.numRecordedFrameTimes & Minecraft.frameTimes.length - 1] = var1;
        Minecraft.frameTimes[Minecraft.numRecordedFrameTimes++ & Minecraft.frameTimes.length - 1] = var5 - this.prevFrameTime;
        this.prevFrameTime = var5;
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.displayWidth, (double)this.displayHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glLineWidth((float)1.0f);
        GL11.glDisable((int)3553);
        Tessellator var7 = Tessellator.instance;
        var7.startDrawing(7);
        int var8 = (int)(var3 / 200000L);
        var7.setColorOpaque_I(0x20000000);
        var7.addVertex(0.0, this.displayHeight - var8, 0.0);
        var7.addVertex(0.0, this.displayHeight, 0.0);
        var7.addVertex(frameTimes.length, this.displayHeight, 0.0);
        var7.addVertex(frameTimes.length, this.displayHeight - var8, 0.0);
        var7.setColorOpaque_I(0x20200000);
        var7.addVertex(0.0, this.displayHeight - var8 * 2, 0.0);
        var7.addVertex(0.0, this.displayHeight - var8, 0.0);
        var7.addVertex(frameTimes.length, this.displayHeight - var8, 0.0);
        var7.addVertex(frameTimes.length, this.displayHeight - var8 * 2, 0.0);
        var7.draw();
        long var9 = 0L;
        int var11 = 0;
        while (var11 < frameTimes.length) {
            var9 += frameTimes[var11];
            ++var11;
        }
        var11 = (int)(var9 / 200000L / (long)frameTimes.length);
        var7.startDrawing(7);
        var7.setColorOpaque_I(0x20400000);
        var7.addVertex(0.0, this.displayHeight - var11, 0.0);
        var7.addVertex(0.0, this.displayHeight, 0.0);
        var7.addVertex(frameTimes.length, this.displayHeight, 0.0);
        var7.addVertex(frameTimes.length, this.displayHeight - var11, 0.0);
        var7.draw();
        var7.startDrawing(1);
        int var12 = 0;
        while (var12 < frameTimes.length) {
            int var13 = (var12 - numRecordedFrameTimes & frameTimes.length - 1) * 255 / frameTimes.length;
            int var14 = var13 * var13 / 255;
            var14 = var14 * var14 / 255;
            int var15 = var14 * var14 / 255;
            var15 = var15 * var15 / 255;
            if (frameTimes[var12] > var3) {
                var7.setColorOpaque_I(-16777216 + var14 * 65536);
            } else {
                var7.setColorOpaque_I(-16777216 + var14 * 256);
            }
            long var16 = frameTimes[var12] / 200000L;
            long var18 = tickTimes[var12] / 200000L;
            var7.addVertex((float)var12 + 0.5f, (float)((long)this.displayHeight - var16) + 0.5f, 0.0);
            var7.addVertex((float)var12 + 0.5f, (float)this.displayHeight + 0.5f, 0.0);
            var7.setColorOpaque_I(-16777216 + var14 * 65536 + var14 * 256 + var14 * 1);
            var7.addVertex((float)var12 + 0.5f, (float)((long)this.displayHeight - var16) + 0.5f, 0.0);
            var7.addVertex((float)var12 + 0.5f, (float)((long)this.displayHeight - (var16 - var18)) + 0.5f, 0.0);
            ++var12;
        }
        var7.draw();
        GL11.glEnable((int)3553);
    }

    public void shutdown() {
        this.running = false;
    }

    public void setIngameFocus() {
        if (Display.isActive() && !this.inGameHasFocus) {
            this.inGameHasFocus = true;
            this.mouseHelper.grabMouseCursor();
            this.displayGuiScreen(null);
            this.leftClickCounter = 10000;
            this.mouseTicksRan = this.ticksRan + 10000;
        }
    }

    public void setIngameNotInFocus() {
        if (this.inGameHasFocus) {
            if (this.thePlayer != null) {
                this.thePlayer.resetPlayerKeyState();
            }
            this.inGameHasFocus = false;
            this.mouseHelper.ungrabMouseCursor();
        }
    }

    public void displayInGameMenu() {
        if (this.currentScreen == null) {
            this.displayGuiScreen(new GuiIngameMenu());
        }
    }

    private void func_6254_a(int var1, boolean var2) {
        if (!var2) {
            this.leftClickCounter = 0;
        }
        if (var1 != 0 || this.leftClickCounter <= 0 && this.thePlayer.getAction().equals((Object)EnumPlayerAction.NORMAL)) {
            if (var2 && this.objectMouseOver != null && this.objectMouseOver.typeOfHit == EnumMovingObjectType.TILE && var1 == 0) {
                int var3 = this.objectMouseOver.blockX;
                int var4 = this.objectMouseOver.blockY;
                int var5 = this.objectMouseOver.blockZ;
                this.playerController.sendBlockRemoving(var3, var4, var5, this.objectMouseOver.sideHit);
                this.effectRenderer.addBlockHitEffects(var3, var4, var5, this.objectMouseOver.sideHit);
            } else {
                this.playerController.resetBlockRemoving();
            }
        }
    }

    private void rmbReleased() {
        ItemStack heldItem = this.thePlayer.inventory.getCurrentItem();
        if (heldItem != null) {
            this.thePlayer.setAction(EnumPlayerAction.NORMAL);
        }
    }

    private void clickMouse(int var1) {
        if (!this.thePlayer.getAction().equals((Object)EnumPlayerAction.NORMAL)) {
            var1 = 2;
        }
        if (var1 != 0 || this.leftClickCounter <= 0) {
            ItemStack var9;
            if (var1 == 0) {
                this.thePlayer.swingItem();
            }
            boolean var2 = true;
            if (this.objectMouseOver == null) {
                if (var1 == 0 && !(this.playerController instanceof PlayerControllerTest)) {
                    this.leftClickCounter = 10;
                }
            } else if (this.objectMouseOver.typeOfHit == EnumMovingObjectType.ENTITY) {
                if (var1 == 0) {
                    this.playerController.attackEntity(this.thePlayer, this.objectMouseOver.entityHit);
                }
                if (var1 == 1) {
                    this.playerController.interactWithEntity(this.thePlayer, this.objectMouseOver.entityHit);
                }
            } else if (this.objectMouseOver.typeOfHit == EnumMovingObjectType.TILE) {
                int var3 = this.objectMouseOver.blockX;
                int var4 = this.objectMouseOver.blockY;
                int var5 = this.objectMouseOver.blockZ;
                int var6 = this.objectMouseOver.sideHit;
                if (var1 == 0) {
                    this.playerController.clickBlock(var3, var4, var5, this.objectMouseOver.sideHit);
                } else {
                    int var8;
                    ItemStack var7 = this.thePlayer.inventory.getCurrentItem();
                    int n = var8 = var7 != null ? var7.stackSize : 0;
                    if (this.playerController.sendPlaceBlock(this.thePlayer, this.theWorld, var7, var3, var4, var5, var6)) {
                        var2 = false;
                        this.thePlayer.swingItem();
                    }
                    if (var7 == null) {
                        return;
                    }
                    if (var7.stackSize == 0) {
                        this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.currentItem] = null;
                    } else if (var7.stackSize != var8) {
                        this.entityRenderer.itemRenderer.func_9449_b();
                    }
                }
            }
            if (var2 && var1 == 1 && (var9 = this.thePlayer.inventory.getCurrentItem()) != null && this.playerController.sendUseItem(this.thePlayer, this.theWorld, var9)) {
                this.entityRenderer.itemRenderer.func_9450_c();
            }
        }
    }

    public void toggleFullscreen() {
        try {
            boolean bl = this.fullscreen = !this.fullscreen;
            if (this.fullscreen) {
                Display.setDisplayMode((DisplayMode)Display.getDesktopDisplayMode());
                this.displayWidth = Display.getDisplayMode().getWidth();
                this.displayHeight = Display.getDisplayMode().getHeight();
                if (this.displayWidth <= 0) {
                    this.displayWidth = 1;
                }
                if (this.displayHeight <= 0) {
                    this.displayHeight = 1;
                }
            } else {
                if (this.mcCanvas != null) {
                    this.displayWidth = this.mcCanvas.getWidth();
                    this.displayHeight = this.mcCanvas.getHeight();
                } else {
                    this.displayWidth = this.tempDisplayWidth;
                    this.displayHeight = this.tempDisplayHeight;
                }
                if (this.displayWidth <= 0) {
                    this.displayWidth = 1;
                }
                if (this.displayHeight <= 0) {
                    this.displayHeight = 1;
                }
            }
            if (this.currentScreen != null) {
                this.resize(this.displayWidth, this.displayHeight);
            }
            Display.setFullscreen((boolean)this.fullscreen);
            Display.update();
        }
        catch (Exception var2) {
            var2.printStackTrace();
        }
    }

    private void resize(int var1, int var2) {
        if (var1 <= 0) {
            var1 = 1;
        }
        if (var2 <= 0) {
            var2 = 1;
        }
        this.displayWidth = var1;
        this.displayHeight = var2;
        if (this.currentScreen != null) {
            ScaledResolution var3 = new ScaledResolution(this.gameSettings, var1, var2);
            int var4 = var3.getScaledWidth();
            int var5 = var3.getScaledHeight();
            this.currentScreen.setWorldAndResolution(this, var4, var5);
        }
    }

    private void clickMiddleMouseButton() {
        if (this.objectMouseOver != null) {
            boolean var1 = this.thePlayer.capabilities.depleteItems;
            int var3 = 0;
            boolean var4 = false;
            int var2 = 0;
            if (this.objectMouseOver.typeOfHit == EnumMovingObjectType.TILE) {
                int var5 = this.objectMouseOver.blockX;
                int var6 = this.objectMouseOver.blockY;
                int var7 = this.objectMouseOver.blockZ;
                Block var8 = Block.blocksList[this.theWorld.getBlockId(var5, var6, var7)];
                if (var8 == null) {
                    return;
                }
                var2 = var8.idPicked(this.theWorld, var5, var6, var7);
                if (var2 == 0) {
                    return;
                }
                var4 = Item.itemsList[var2].getHasSubtypes();
                int var9 = var2 < 256 && !Block.blocksList[var8.blockID].randomBoolean() ? var2 : var8.blockID;
                var3 = Block.blocksList[var9].getDamageValue(this.theWorld, var5, var6, var7);
            } else {
                if (this.objectMouseOver.typeOfHit != EnumMovingObjectType.ENTITY || this.objectMouseOver.entityHit == null || !var1) {
                    return;
                }
                if (this.objectMouseOver.entityHit instanceof EntityPainting) {
                    var2 = Item.painting.itemID;
                } else if (this.objectMouseOver.entityHit instanceof EntityMinecart) {
                    EntityMinecart var11 = (EntityMinecart)this.objectMouseOver.entityHit;
                    var2 = var11.getMinecartType() == 2 ? Item.minecartPowered.itemID : (var11.getMinecartType() == 1 ? Item.minecartCrate.itemID : Item.minecartEmpty.itemID);
                } else if (this.objectMouseOver.entityHit instanceof EntityBoat) {
                    var2 = Item.boat.itemID;
                }
            }
            this.thePlayer.inventory.setCurrentItemNew(var2, var3, var4, var1);
            this.theWorld.playSoundAtEntity(this.thePlayer, "random.wood click", 1.0f, 1.0f);
            if (var1) {
                this.thePlayer.inventory.setCurrentItemNew(var2, var3, var4, var1);
                this.theWorld.playSoundAtEntity(this.thePlayer, "random.wood click", 1.0f, 1.0f);
                int var7 = this.thePlayer.inventorySlots.slots.size() - 9 + this.thePlayer.inventory.currentItem;
                this.playerController.sendSlotPacket(this.thePlayer.inventory.getStackInSlot(this.thePlayer.inventory.currentItem), var7);
            }
        }
    }

    private void func_28001_B() {
        new ThreadCheckHasPaid(this).start();
    }

    public void runTick() {
        int var3;
        IChunkProvider var1;
        if (this.ticksRan == 6000) {
            this.func_28001_B();
        }
        this.statFileWriter.func_27178_d();
        this.ingameGUI.updateTick();
        this.entityRenderer.getMouseOver(1.0f);
        if (this.thePlayer != null && (var1 = this.theWorld.getIChunkProvider()) instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate var2 = (ChunkProviderLoadOrGenerate)var1;
            var3 = MathHelper.floor_float((int)this.thePlayer.posX) >> 4;
            int var4 = MathHelper.floor_float((int)this.thePlayer.posZ) >> 4;
            var2.setCurrentChunkOver(var3, var4);
        }
        if (!this.isGamePaused && this.theWorld != null) {
            this.playerController.updateController();
        }
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/terrain.png"));
        if (!this.isGamePaused) {
            this.renderEngine.updateDynamicTextures();
        }
        if (this.currentScreen == null && this.thePlayer != null) {
            if (this.thePlayer.health <= 0) {
                this.displayGuiScreen(null);
            } else if (this.thePlayer.isPlayerSleeping() && this.theWorld != null && this.theWorld.multiplayerWorld) {
                this.displayGuiScreen(new GuiSleepMP(""));
            }
        } else if (this.currentScreen != null && this.currentScreen instanceof GuiSleepMP && !this.thePlayer.isPlayerSleeping()) {
            if (((GuiSleepMP)this.currentScreen).message != "") {
                this.displayGuiScreen(new GuiChat(((GuiSleepMP)this.currentScreen).message));
            } else {
                this.displayGuiScreen(null);
            }
        }
        if (this.currentScreen != null) {
            this.leftClickCounter = 10000;
            this.mouseTicksRan = this.ticksRan + 10000;
        }
        if (this.currentScreen != null) {
            this.currentScreen.handleInput();
            if (this.currentScreen != null) {
                this.currentScreen.field_25091_h.func_25088_a();
                this.currentScreen.updateScreen();
            }
        }
        if (this.currentScreen == null || this.currentScreen.field_948_f) {
            block0: while (true) {
                if (!Mouse.next()) {
                    if (this.leftClickCounter > 0) {
                        --this.leftClickCounter;
                    }
                    while (true) {
                        if (!Keyboard.next()) {
                            if (this.currentScreen == null) {
                                if (this.thePlayer.isUsingItem()) {
                                    if (!Mouse.isButtonDown((int)1)) {
                                        this.playerController.onStoppedUsingItem(this.thePlayer);
                                    }
                                    while (this.gameSettings.keyBindAttack.isPressed()) {
                                    }
                                    while (this.gameSettings.keyBindUseItem.isPressed()) {
                                    }
                                } else {
                                    if (Mouse.isButtonDown((int)0) && (float)(this.ticksRan - this.mouseTicksRan) >= this.timer.ticksPerSecond / 4.0f && this.inGameHasFocus) {
                                        this.clickMouse(0);
                                        this.mouseTicksRan = this.ticksRan;
                                    }
                                    if (!Mouse.isButtonDown((int)1) && this.inGameHasFocus) {
                                        this.rmbReleased();
                                    }
                                    if (Mouse.isButtonDown((int)1) && (float)(this.ticksRan - this.mouseTicksRan) >= this.timer.ticksPerSecond / 4.0f && this.inGameHasFocus) {
                                        this.clickMouse(1);
                                        this.mouseTicksRan = this.ticksRan;
                                    }
                                }
                            }
                            if (this.gameSettings.keyBindUseItem.pressed && (float)(this.ticksRan - this.mouseTicksRan) >= this.timer.ticksPerSecond / 4.0f && !this.thePlayer.isUsingItem()) {
                                this.clickMouse(1);
                            }
                            this.func_6254_a(0, this.currentScreen == null && Mouse.isButtonDown((int)0) && this.inGameHasFocus);
                            break block0;
                        }
                        this.thePlayer.handleKeyPress(Keyboard.getEventKey(), Keyboard.getEventKeyState());
                        if (!Keyboard.getEventKeyState()) continue;
                        if (Keyboard.getEventKey() == 87) {
                            this.toggleFullscreen();
                            continue;
                        }
                        if (this.currentScreen != null) {
                            this.currentScreen.handleKeyboardInput();
                        } else {
                            if (Keyboard.getEventKey() == 1) {
                                this.displayInGameMenu();
                            }
                            if (Keyboard.getEventKey() == 31 && Keyboard.isKeyDown((int)61)) {
                                this.forceReload();
                            }
                            if (Keyboard.getEventKey() == 59) {
                                boolean bl = this.gameSettings.hideGUI = !this.gameSettings.hideGUI;
                            }
                            if (Keyboard.getEventKey() == 61) {
                                boolean bl = this.gameSettings.showDebugInfo = !this.gameSettings.showDebugInfo;
                            }
                            if (Keyboard.getEventKey() == 63) {
                                ++this.gameSettings.thirdPersonView;
                                if (this.gameSettings.thirdPersonView > 2) {
                                    this.gameSettings.thirdPersonView = 0;
                                }
                            }
                            if (Keyboard.getEventKey() == 20 && Keyboard.isKeyDown((int)61)) {
                                this.renderEngine.refreshTextures();
                            }
                            if (Keyboard.getEventKey() == 66) {
                                boolean bl = this.gameSettings.smoothCamera = !this.gameSettings.smoothCamera;
                            }
                            if (Keyboard.getEventKey() == 47 && this.thePlayer.capabilities.allowFlying && !this.theWorld.multiplayerWorld) {
                                boolean bl = this.thePlayer.noClip = !this.thePlayer.noClip;
                                if (!this.thePlayer.noClip) {
                                    this.thePlayer.addChatMessage("No Clip disabled.");
                                } else if (this.thePlayer.noClip) {
                                    this.thePlayer.addChatMessage("No Clip enabled.");
                                }
                            }
                            if (Keyboard.getEventKey() == this.gameSettings.keyBindInventory.keyCode) {
                                this.displayGuiScreen(this.playerController.isInCreativeMode() ? new GuiContainerCreative(this.thePlayer) : new GuiInventory(this.thePlayer));
                            }
                            if (Keyboard.isKeyDown((int)29) && Keyboard.getEventKey() == this.gameSettings.keyBindDrop.keyCode && this.thePlayer.inventory.getCurrentItem() != null) {
                                this.thePlayer.dropCurrentItemStack();
                            }
                            if (Keyboard.getEventKey() == this.gameSettings.keyBindDrop.keyCode && !Keyboard.isKeyDown((int)29)) {
                                this.thePlayer.dropCurrentItem();
                            }
                            if (Keyboard.getEventKey() == 62) {
                                boolean bl = this.gameSettings.showKeys = !this.gameSettings.showKeys;
                            }
                            if (Keyboard.getEventKey() == 208) {
                                System.out.println("scheisse!  sound ticks are:" + this.sndManager.ticksBeforeMusic + ", " + (int)(GameSettings.musicInterval * 12000.0f));
                            }
                            if (this.isMultiplayerWorld() && Keyboard.getEventKey() == this.gameSettings.keyBindChat.keyCode || this.thePlayer.capabilities.allowFlying && Keyboard.getEventKey() == this.gameSettings.keyBindChat.keyCode) {
                                this.displayGuiScreen(new GuiChat(""));
                            }
                            if (this.isMultiplayerWorld() && Keyboard.getEventKey() == 53 || this.thePlayer.capabilities.allowFlying && Keyboard.getEventKey() == 53) {
                                this.displayGuiScreen(new GuiChat("/"));
                            }
                        }
                        int var6 = 0;
                        while (var6 < 9) {
                            if (Keyboard.getEventKey() == 2 + var6) {
                                this.thePlayer.inventory.currentItem = var6;
                            }
                            ++var6;
                        }
                        if (Keyboard.getEventKey() != this.gameSettings.keyBindToggleFog.keyCode) continue;
                        this.gameSettings.setOptionValue(EnumOptions.RENDER_DISTANCE, !Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54) ? 1 : -1);
                    }
                }
                long var5 = System.currentTimeMillis() - this.systemTime;
                if (var5 > 200L) continue;
                var3 = Mouse.getEventDWheel();
                if (var3 != 0 && !Keyboard.isKeyDown((int)46)) {
                    this.thePlayer.inventory.changeCurrentItem(var3);
                    if (this.gameSettings.field_22275_C) {
                        if (var3 > 0) {
                            var3 = 1;
                        }
                        if (var3 < 0) {
                            var3 = -1;
                        }
                        GameSettings var10000 = this.gameSettings;
                        var10000.field_22272_F += (float)var3 * 0.25f;
                    }
                }
                if (this.currentScreen == null) {
                    if (!this.inGameHasFocus && Mouse.getEventButtonState()) {
                        this.setIngameFocus();
                        continue;
                    }
                    if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState()) {
                        this.clickMouse(0);
                        this.mouseTicksRan = this.ticksRan;
                    }
                    if (Mouse.getEventButton() == 1 && Mouse.getEventButtonState()) {
                        this.clickMouse(1);
                        this.mouseTicksRan = this.ticksRan;
                    }
                    if (!(Mouse.getEventButton() == 2 && Mouse.getEventButtonState() || Mouse.getEventButton() == 3 && Mouse.getEventButtonState()) && (Mouse.getEventButton() != 4 || !Mouse.getEventButtonState())) continue;
                    this.clickMiddleMouseButton();
                    continue;
                }
                if (this.currentScreen == null) continue;
                this.currentScreen.handleMouseInput();
            }
        }
        if (this.theWorld != null) {
            if (this.thePlayer != null) {
                ++this.joinPlayerCounter;
                if (this.joinPlayerCounter == 30) {
                    this.joinPlayerCounter = 0;
                    this.theWorld.joinEntityInSurroundings(this.thePlayer);
                }
            }
            this.theWorld.difficultySetting = this.gameSettings.difficulty;
            this.theWorld.difficultySetting = this.theWorld.getWorldInfo().isHardcoreModeEnabled() ? 3 : this.gameSettings.difficulty;
            if (this.theWorld.multiplayerWorld) {
                this.theWorld.difficultySetting = 3;
            }
            if (!this.isGamePaused) {
                this.entityRenderer.updateRenderer();
            }
            if (!this.isGamePaused) {
                this.renderGlobal.updateClouds();
            }
            if (!this.isGamePaused) {
                if (this.theWorld.field_27172_i > 0) {
                    --this.theWorld.field_27172_i;
                }
                this.theWorld.updateEntities();
            }
            if (!this.isGamePaused || this.isMultiplayerWorld()) {
                this.theWorld.setAllowedMobSpawns(this.gameSettings.difficulty > 0, true);
                this.theWorld.tick();
            }
            if (!this.isGamePaused && this.theWorld != null) {
                this.theWorld.randomDisplayUpdates(MathHelper.floor_double(this.thePlayer.posX), MathHelper.floor_double(this.thePlayer.posY), MathHelper.floor_double(this.thePlayer.posZ));
            }
            if (!this.isGamePaused) {
                this.effectRenderer.updateEffects();
            }
        }
        this.systemTime = System.currentTimeMillis();
    }

    private void forceReload() {
        System.out.println("FORCING RELOAD!");
        this.sndManager = new SoundManager();
        this.sndManager.loadSoundSettings(this.gameSettings);
        this.downloadResourcesThread.reloadResources();
    }

    public boolean isMultiplayerWorld() {
        return this.theWorld != null && this.theWorld.multiplayerWorld;
    }

    public void startWorld(String var1, String var2, WorldSettings var3) {
        this.changeWorld1(null);
        System.gc();
        if (this.saveLoader.isOldMapFormat(var1)) {
            this.convertMapFormat(var1, var2);
        } else {
            ISaveHandler var5 = this.saveLoader.getSaveLoader(var1, false);
            World var6 = null;
            var6 = new World(var5, var2, var3);
            if (var6.isNewWorld) {
                this.statFileWriter.readStat(StatList.createWorldStat, 1);
                this.statFileWriter.readStat(StatList.startGameStat, 1);
                this.changeWorld2(var6, "Generating level");
            } else {
                this.statFileWriter.readStat(StatList.loadWorldStat, 1);
                this.statFileWriter.readStat(StatList.startGameStat, 1);
                this.changeWorld2(var6, "Loading level");
            }
        }
    }

    public void usePortal() {
        System.out.println("Toggling dimension!!");
        this.thePlayer.dimension = this.thePlayer.dimension == -1 ? 0 : -1;
        this.theWorld.setEntityDead(this.thePlayer);
        this.thePlayer.isDead = false;
        double var1 = this.thePlayer.posX;
        double var3 = this.thePlayer.posZ;
        double var5 = 8.0;
        if (this.thePlayer.dimension == -1) {
            this.thePlayer.setLocationAndAngles(var1 /= var5, this.thePlayer.posY, var3 /= var5, this.thePlayer.rotationYaw, this.thePlayer.rotationPitch);
            if (this.thePlayer.isEntityAlive()) {
                this.theWorld.updateEntityWithOptionalForce(this.thePlayer, false);
            }
            World var7 = null;
            var7 = new World(this.theWorld, WorldProvider.getProviderForDimension(-1));
            this.changeWorld(var7, "Entering the Nether", this.thePlayer);
        } else {
            this.thePlayer.setLocationAndAngles(var1 *= var5, this.thePlayer.posY, var3 *= var5, this.thePlayer.rotationYaw, this.thePlayer.rotationPitch);
            if (this.thePlayer.isEntityAlive()) {
                this.theWorld.updateEntityWithOptionalForce(this.thePlayer, false);
            }
            World var7 = null;
            var7 = new World(this.theWorld, WorldProvider.getProviderForDimension(0));
            this.changeWorld(var7, "Leaving the Nether", this.thePlayer);
        }
        this.thePlayer.worldObj = this.theWorld;
        if (this.thePlayer.isEntityAlive()) {
            this.thePlayer.setLocationAndAngles(var1, this.thePlayer.posY, var3, this.thePlayer.rotationYaw, this.thePlayer.rotationPitch);
            this.theWorld.updateEntityWithOptionalForce(this.thePlayer, false);
            new Teleporter().func_4107_a(this.theWorld, this.thePlayer);
        }
    }

    public void changeWorld1(World var1) {
        this.changeWorld2(var1, "");
    }

    public void changeWorld2(World var1, String var2) {
        this.changeWorld(var1, var2, null);
    }

    public void changeWorld(World var1, String var2, EntityPlayer var3) {
        this.statFileWriter.func_27175_b();
        this.statFileWriter.syncStats();
        this.renderViewEntity = null;
        this.loadingScreen.printText(var2);
        this.loadingScreen.displayLoadingString("");
        this.sndManager.playStreaming(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (this.theWorld != null) {
            this.theWorld.saveWorldIndirectly(this.loadingScreen);
        }
        this.theWorld = var1;
        if (var1 != null) {
            IChunkProvider var4;
            this.playerController.func_717_a(var1);
            if (!this.isMultiplayerWorld()) {
                if (var3 == null) {
                    this.thePlayer = (EntityPlayerSP)var1.func_4085_a(EntityPlayerSP.class);
                }
            } else if (this.thePlayer != null) {
                this.thePlayer.preparePlayerToSpawn();
                if (var1 != null) {
                    var1.entityJoinedWorld(this.thePlayer);
                }
            }
            if (!var1.multiplayerWorld) {
                this.func_6255_d(var2);
            }
            if (this.thePlayer == null) {
                this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(var1);
                this.thePlayer.preparePlayerToSpawn();
                this.playerController.flipPlayer(this.thePlayer);
            }
            this.thePlayer.movementInput = new MovementInputFromOptions(this.gameSettings);
            if (this.renderGlobal != null) {
                this.renderGlobal.changeWorld(var1);
            }
            if (this.effectRenderer != null) {
                this.effectRenderer.clearEffects(var1);
            }
            this.playerController.func_6473_b(this.thePlayer);
            if (var3 != null) {
                var1.emptyMethod1();
            }
            if ((var4 = var1.getIChunkProvider()) instanceof ChunkProviderLoadOrGenerate) {
                ChunkProviderLoadOrGenerate var5 = (ChunkProviderLoadOrGenerate)var4;
                int var6 = MathHelper.floor_float((int)this.thePlayer.posX) >> 4;
                int var7 = MathHelper.floor_float((int)this.thePlayer.posZ) >> 4;
                var5.setCurrentChunkOver(var6, var7);
            }
            var1.spawnPlayerWithLoadedChunks(this.thePlayer);
            if (var1.isNewWorld) {
                var1.saveWorldIndirectly(this.loadingScreen);
            }
            this.renderViewEntity = this.thePlayer;
        } else {
            this.thePlayer = null;
        }
        System.gc();
        this.systemTime = 0L;
    }

    private void convertMapFormat(String var1, String var2) {
        this.loadingScreen.printText("Converting World to " + this.saveLoader.func_22178_a());
        this.loadingScreen.displayLoadingString("This may take a while :)");
        this.saveLoader.convertMapFormat(var1, this.loadingScreen);
        this.startWorld(var1, var2, new WorldSettings(0L, 0, true, false));
    }

    private void func_6255_d(String var1) {
        this.loadingScreen.printText(var1);
        this.loadingScreen.displayLoadingString("Building terrain");
        int var2 = 128;
        int var3 = 0;
        int var4 = var2 * 2 / 16 + 1;
        var4 *= var4;
        IChunkProvider var5 = this.theWorld.getIChunkProvider();
        ChunkCoordinates var6 = this.theWorld.getSpawnPoint();
        if (this.thePlayer != null) {
            var6.x = (int)this.thePlayer.posX;
            var6.z = (int)this.thePlayer.posZ;
        }
        if (var5 instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate var7 = (ChunkProviderLoadOrGenerate)var5;
            var7.setCurrentChunkOver(var6.x >> 4, var6.z >> 4);
        }
        int var10 = -var2;
        while (var10 <= var2) {
            int var8 = -var2;
            while (var8 <= var2) {
                this.loadingScreen.setLoadingProgress(var3++ * 100 / var4);
                this.theWorld.getBlockId(var6.x + var10, 64, var6.z + var8);
                while (this.theWorld.updatingLighting()) {
                }
                var8 += 16;
            }
            var10 += 16;
        }
        this.loadingScreen.displayLoadingString("Simulating world for a bit");
        this.theWorld.func_656_j();
    }

    public void installResource(String var1, File var2) {
        int var3 = var1.indexOf("/");
        String var4 = var1.substring(0, var3);
        var1 = var1.substring(var3 + 1);
        if (var4.equalsIgnoreCase("sound")) {
            this.sndManager.addSound(var1, var2);
        } else if (var4.equalsIgnoreCase("newsound")) {
            this.sndManager.addSound(var1, var2);
        } else if (var4.equalsIgnoreCase("streaming")) {
            this.sndManager.addStreaming(var1, var2);
        } else if (var4.equalsIgnoreCase("music")) {
            this.sndManager.addMusic(var1, var2);
        } else if (var4.equalsIgnoreCase("newmusic")) {
            this.sndManager.addMusic(var1, var2);
        }
    }

    public OpenGlCapsChecker getOpenGlCapsChecker() {
        return this.glCapabilities;
    }

    public String frustumDebug() {
        return this.renderGlobal.getDebugInfoRenders();
    }

    public String entityDebug() {
        return this.renderGlobal.getDebugInfoEntities();
    }

    public String stringForChunks() {
        return this.theWorld.chunkString();
    }

    public String particleDebug() {
        return "Particles: " + this.effectRenderer.getStatistics() + ". Total Loaded Entities: " + this.theWorld.loadedEntityDebug();
    }

    public String graphicsCard() {
        return "GPU: " + GL11.glGetString((int)7937);
    }

    public void respawn(boolean var1, int var2) {
        IChunkProvider var6;
        if (!this.theWorld.multiplayerWorld && !this.theWorld.worldProvider.canRespawnHere()) {
            this.usePortal();
        }
        ChunkCoordinates var3 = null;
        ChunkCoordinates var4 = null;
        boolean var5 = true;
        if (this.thePlayer != null && !var1 && (var3 = this.thePlayer.getPlayerSpawnCoordinate()) != null && (var4 = EntityPlayer.func_25060_a(this.theWorld, var3)) == null) {
            this.thePlayer.addChatMessage("tile.bed.notValid");
        }
        if (var4 == null) {
            var4 = this.theWorld.getSpawnPoint();
            var5 = false;
        }
        if ((var6 = this.theWorld.getIChunkProvider()) instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate var7 = (ChunkProviderLoadOrGenerate)var6;
            var7.setCurrentChunkOver(var4.x >> 4, var4.z >> 4);
        }
        this.theWorld.setSpawnLocation();
        this.theWorld.updateEntityList();
        int var8 = 0;
        if (this.thePlayer != null) {
            var8 = this.thePlayer.entityId;
            this.theWorld.setEntityDead(this.thePlayer);
        }
        this.renderViewEntity = null;
        this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(this.theWorld);
        this.thePlayer.dimension = var2;
        this.renderViewEntity = this.thePlayer;
        this.thePlayer.preparePlayerToSpawn();
        if (var5) {
            this.thePlayer.setPlayerSpawnCoordinate(var3);
            this.thePlayer.setLocationAndAngles((float)var4.x + 0.5f, (float)var4.y + 0.1f, (float)var4.z + 0.5f, 0.0f, 0.0f);
        }
        this.playerController.flipPlayer(this.thePlayer);
        this.theWorld.spawnPlayerWithLoadedChunks(this.thePlayer);
        this.thePlayer.movementInput = new MovementInputFromOptions(this.gameSettings);
        this.thePlayer.entityId = var8;
        this.thePlayer.func_6420_o();
        this.playerController.func_6473_b(this.thePlayer);
        this.func_6255_d("Respawning");
        if (this.currentScreen instanceof GuiGameOver) {
            this.displayGuiScreen(null);
        }
    }

    public static void func_6269_a(String var0, String var1) {
        Minecraft.startMainThread(var0, var1, null);
    }

    public static void startMainThread(String var0, String var1, String var2) {
        boolean var3 = false;
        Frame var5 = new Frame("Minecraft");
        Canvas var6 = new Canvas();
        var5.setLayout(new BorderLayout());
        var5.add((Component)var6, "Center");
        var6.setPreferredSize(new Dimension(854, 480));
        var5.pack();
        var5.setLocationRelativeTo(null);
        MinecraftImpl var7 = new MinecraftImpl(var5, var6, null, 854, 480, var3, var5);
        Thread var8 = new Thread((Runnable)var7, "Minecraft main thread");
        var8.setPriority(10);
        var7.minecraftUri = "www.minecraft.net";
        var7.session = var0 != null && var1 != null ? new Session(var0, var1) : new Session("Player" + System.currentTimeMillis() % 1000L, "");
        if (var2 != null) {
            String[] var9 = var2.split(":");
            var7.setServer(var9[0], Integer.parseInt(var9[1]));
        }
        var5.setVisible(true);
        var5.addWindowListener(new GameWindowListener(var7, var8));
        var8.start();
    }

    public NetClientHandler getSendQueue() {
        return this.thePlayer instanceof EntityClientPlayerMP ? ((EntityClientPlayerMP)this.thePlayer).sendQueue : null;
    }

    public static void main(String[] var0) {
        String var1 = null;
        String var2 = null;
        var1 = "Player" + System.currentTimeMillis() % 1000L;
        if (var0.length > 0) {
            var1 = var0[0];
        }
        var2 = "-";
        if (var0.length > 1) {
            var2 = var0[1];
        }
        Minecraft.func_6269_a(var1, var2);
    }

    public static boolean isGuiEnabled() {
        return theMinecraft == null || !Minecraft.theMinecraft.gameSettings.hideGUI;
    }

    public static boolean isFancyGraphicsEnabled() {
        return theMinecraft != null && Minecraft.theMinecraft.gameSettings.fancyGraphics;
    }

    public static boolean isAmbientOcclusionEnabled() {
        return theMinecraft != null && Minecraft.theMinecraft.gameSettings.ambientOcclusion;
    }

    public static boolean isDebugInfoEnabled() {
        return theMinecraft != null && Minecraft.theMinecraft.gameSettings.showDebugInfo;
    }

    public boolean lineIsCommand(String var1) {
        return var1.startsWith("/");
    }

    public void func_40002_b(String s) {
        this.theWorld = null;
        this.changeWorld2(null, s);
    }
}

