/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.mitask.command.commands;

import net.minecraft.mitask.PlayerCommandHandler;
import net.minecraft.mitask.command.Command;
import net.minecraft.mitask.command.CommandErrorHandler;
import net.minecraft.src.client.player.EntityPlayerSP;

public class helpCommand
extends Command {
    public helpCommand(PlayerCommandHandler commandHandler) {
        super("help", false, false, null);
    }

    @Override
    public void onExecute(String[] args, EntityPlayerSP commandExecutor) {
        if (args.length > 1) {
            this.showCommandInfo(args[1], commandExecutor);
        } else {
            this.showCommandList(commandExecutor);
        }
    }

    private void showCommandList(EntityPlayerSP commandExecutor) {
        commandExecutor.addChatMessage("\u00a7eCommand list\u00a7f:");
        for (Command command : PlayerCommandHandler.commands) {
            if (command.isHidden()) {
                return;
            }
            String cmd = " - Command name: \u00a7e" + command.getName();
            commandExecutor.addChatMessage(cmd);
            cmd = "";
        }
    }

    private void showCommandInfo(String commandName, EntityPlayerSP commandExecutor) {
        if (commandName.equals("tp")) {
            CommandErrorHandler.commandUsageMessage("\u00a7e/tp <x> <y> <z>", commandExecutor);
            commandExecutor.addChatMessage("\u00a7dTeleports the player to specified coordinates.");
            commandExecutor.addChatMessage("\u00a77<\u00a7cx\u00a77>\u00a7d, \u00a77<\u00a7ay\u00a77>\u00a7d, \u00a7dand \u00a77<\u00a79z\u00a77>\u00a7d are doubles.");
            commandExecutor.addChatMessage("\u00a7dUse \u00a77~\u00a7d before a number to add to the players coordinates.");
            commandExecutor.addChatMessage("");
            commandExecutor.addChatMessage("\u00a7eExample usage:");
            commandExecutor.addChatMessage("\u00a77/tp ~10 ~-30 540");
            commandExecutor.addChatMessage("\u00a7dThis example would place the player 10 blocks further in the");
            commandExecutor.addChatMessage("\u00a7dX coordinate, whilst moving them downwards 30 blocks in the Y");
            commandExecutor.addChatMessage("\u00a7dcoordinate, and placing them at 540 on the Z coordinate.");
            return;
        }
        if (commandName.equals("playsound")) {
            CommandErrorHandler.commandUsageMessage("\u00a7e/playsound <string> <volume> <pitch>", commandExecutor);
            commandExecutor.addChatMessage("\u00a7dPlays a sound. Volume and pitch are floats valid from 0.0f-1.0f.");
            commandExecutor.addChatMessage("");
            commandExecutor.addChatMessage("\u00a7eExample usage:");
            commandExecutor.addChatMessage("\u00a77/playsound mob.fox.idle 1.0f 0.5f");
            commandExecutor.addChatMessage("\u00a7dThis example would play the fox idling sound effect at normal");
            commandExecutor.addChatMessage("\u00a7dvolume with a lowered pitch for the player that executed the");
            commandExecutor.addChatMessage("\u00a7dcommand.");
            return;
        }
        if (commandName.equals("mastersound")) {
            CommandErrorHandler.commandUsageMessage("\u00a7e/mastersound <x> <y> <z> <string> <volume> <pitch>", commandExecutor);
            commandExecutor.addChatMessage("\u00a7dPlays a sound at specified coordinates.  \u00a77<\u00a7cx\u00a77>\u00a7d, \u00a77<\u00a7ay\u00a77>\u00a7d, \u00a7dand \u00a77<\u00a79z\u00a77>\u00a7d are");
            commandExecutor.addChatMessage("\u00a7ddoubles.  Volume and pitch are floats valid from 0.0f-1.0f.");
            commandExecutor.addChatMessage("");
            commandExecutor.addChatMessage("\u00a7eExample usage:");
            commandExecutor.addChatMessage("\u00a77/mastersound 25 70 -40 item.bucket.fill 0.5f 1.0f");
            commandExecutor.addChatMessage("\u00a7dThis example would play the filling bucket sound effect at half");
            commandExecutor.addChatMessage("\u00a7dvolume with normal pitch at 25 on the X coordinate, 70 on the Y");
            commandExecutor.addChatMessage("\u00a7dcoordinate, and -40 on the Z coordinate.");
            return;
        }
        if (commandName.equals("time")) {
            CommandErrorHandler.commandUsageMessage("\u00a7e/test <add/set> <value>", commandExecutor);
            commandExecutor.addChatMessage("\u00a7dSets or adds to the worlds current time.");
            commandExecutor.addChatMessage("\u00a77Values can be ticks, but can also be strings.");
            commandExecutor.addChatMessage("\u00a77List of valid strings are: \u00a7dday\u00a77, \u00a7dnoon\u00a77, \u00a7dsunset\u00a77, and \u00a7dnight\u00a77");
            commandExecutor.addChatMessage("");
            commandExecutor.addChatMessage("\u00a7eExample usage #1:");
            commandExecutor.addChatMessage("\u00a77/time set noon");
            commandExecutor.addChatMessage("\u00a7dThis example would set the worlds current time to noon.");
            commandExecutor.addChatMessage("");
            commandExecutor.addChatMessage("\u00a7eExample usage #2:");
            commandExecutor.addChatMessage("\u00a77/time add 6000");
            commandExecutor.addChatMessage("\u00a7dThis example would add 6000 ticks to the worlds current time.");
            return;
        }
        commandExecutor.addChatMessage("error @ reindev spc b211128");
    }
}

