/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.mitask.command.commands;

import net.minecraft.mitask.PlayerCommandHandler;
import net.minecraft.mitask.command.Command;
import net.minecraft.mitask.command.CommandErrorHandler;
import net.minecraft.src.client.player.EntityPlayerSP;

public class timeCommand
extends Command {
    public timeCommand(PlayerCommandHandler commandHandler) {
        super("time", false, false, null);
    }

    @Override
    public void onExecute(String[] args, EntityPlayerSP commandExecutor) {
        if (args.length != 3) {
            CommandErrorHandler.commandUsageMessage("\u00a7e/time <add/set> <value>", commandExecutor);
            commandExecutor.addChatMessage("\u00a7dSets or adds to the worlds current time.");
            commandExecutor.addChatMessage("");
            commandExecutor.addChatMessage("\u00a7eFor an example usage, use \u00a77/help time\u00a7e.");
            return;
        }
        String type = args[1];
        String timeToInt = args[2];
        long time = 0L;
        try {
            time = Integer.parseInt(timeToInt);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if ("add".equalsIgnoreCase(type)) {
            commandExecutor.worldObj.setTimeViaCommand(commandExecutor.worldObj.getWorldTime() + time);
            commandExecutor.addChatMessage("Added " + time + " to the current time.");
        } else if ("set".equalsIgnoreCase(type) && "day".equalsIgnoreCase(timeToInt)) {
            commandExecutor.worldObj.setTimeViaCommand(0L);
            commandExecutor.addChatMessage("Set time to day.");
        } else if ("set".equalsIgnoreCase(type) && "noon".equalsIgnoreCase(timeToInt)) {
            commandExecutor.worldObj.setTimeViaCommand(6000L);
            commandExecutor.addChatMessage("Set time to noon.");
        } else if ("set".equalsIgnoreCase(type) && "sunset".equalsIgnoreCase(timeToInt)) {
            commandExecutor.worldObj.setTimeViaCommand(12000L);
            commandExecutor.addChatMessage("Set time to sunset.");
        } else if ("set".equalsIgnoreCase(type) && "night".equalsIgnoreCase(timeToInt)) {
            commandExecutor.worldObj.setTimeViaCommand(18000L);
            commandExecutor.addChatMessage("Set time to night.");
        } else if ("set".equalsIgnoreCase(type)) {
            commandExecutor.worldObj.setTimeViaCommand(time);
            commandExecutor.addChatMessage("Set time to " + time);
        }
    }
}

