/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.mitask.utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.mitask.PlayerCommandHandler;
import net.minecraft.mitask.command.Command;
import net.minecraft.src.client.gui.FontRenderer;
import net.minecraft.src.client.gui.Gui;
import net.minecraft.src.client.gui.GuiScreen;
import net.minecraft.src.client.packets.Packet252CommandList;

public class CommandHelperGUI {
    private GuiScreen gui;
    static List<String> commandsNames = new ArrayList<String>();

    public CommandHelperGUI(GuiScreen gui) {
        this.gui = gui;
    }

    public void render(String message, boolean multiplayer) {
        Minecraft mc = Minecraft.getInstance();
        FontRenderer fr = mc.fontRenderer;
        if (multiplayer) {
            CommandHelperGUI.setMPCommands(message);
        } else {
            CommandHelperGUI.setSPCommands(message);
        }
        Collections.sort(commandsNames);
        int count = 0;
        for (String command : commandsNames) {
            int offset = ++count * (fr.FONT_HEIGHT + 4);
            Gui.drawRect(8, this.gui.height - 20 - offset, fr.getStringWidth(command) + 11, this.gui.height - 16 - (offset - fr.FONT_HEIGHT), -1879048192);
            fr.drawString(command, 10, this.gui.height - 18 - offset, Color.WHITE.getRGB());
        }
    }

    private static void setSPCommands(String message) {
        commandsNames.clear();
        if (message != null) {
            for (Command command : PlayerCommandHandler.commands) {
                if (!command.getName().toLowerCase().startsWith(message)) continue;
                commandsNames.add(command.getName());
            }
        } else {
            for (Command command : PlayerCommandHandler.commands) {
                commandsNames.add(command.getName());
            }
        }
    }

    private static void setMPCommands(String message) {
        commandsNames.clear();
        if (message != null) {
            for (String command : Packet252CommandList.commands) {
                if (!command.toLowerCase().startsWith(message)) continue;
                commandsNames.add(command);
            }
        } else {
            for (String command : Packet252CommandList.commands) {
                commandsNames.add(command);
            }
        }
    }

    public static class CommandComparator
    implements Comparator<Command> {
        @Override
        public int compare(Command command1, Command command2) {
            FontRenderer fontRenderer = Minecraft.getInstance().fontRenderer;
            if (fontRenderer.getStringWidth(command1.getName()) > fontRenderer.getStringWidth(command2.getName())) {
                return -1;
            }
            if (fontRenderer.getStringWidth(command1.getName()) < fontRenderer.getStringWidth(command2.getName())) {
                return 1;
            }
            return 0;
        }
    }
}

