/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.src.game.nbt.NBTBase;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class CompressedStreamTools {
    public static NBTTagCompound func_1138_a(InputStream var0) throws IOException {
        NBTTagCompound var2;
        try (DataInputStream var1 = new DataInputStream(new GZIPInputStream(var0));){
            var2 = CompressedStreamTools.func_1141_a(var1);
        }
        return var2;
    }

    public static void writeGzippedCompoundToOutputStream(NBTTagCompound var0, OutputStream var1) throws IOException {
        try (DataOutputStream var2 = new DataOutputStream(new GZIPOutputStream(var1));){
            CompressedStreamTools.func_1139_a(var0, var2);
        }
    }

    public static NBTTagCompound func_1141_a(DataInput var0) throws IOException {
        NBTBase var1 = NBTBase.readTag(var0);
        if (var1 instanceof NBTTagCompound) {
            return (NBTTagCompound)var1;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void func_1139_a(NBTTagCompound var0, DataOutput var1) throws IOException {
        NBTBase.writeTag(var0, var1);
    }

    public static void func_35621_a(NBTTagCompound nbttagcompound, File file) throws IOException {
        File file1 = new File(file.getAbsolutePath() + "_tmp");
        if (file1.exists()) {
            file1.delete();
        }
        CompressedStreamTools.func_35620_b(nbttagcompound, file1);
        if (file.exists()) {
            file.delete();
        }
        if (file.exists()) {
            throw new IOException("Failed to delete " + file);
        }
        file1.renameTo(file);
    }

    public static void func_35620_b(NBTTagCompound nbttagcompound, File file) throws IOException {
        try (DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file));){
            CompressedStreamTools.writeTo(nbttagcompound, dataoutputstream);
        }
    }

    public static void writeTo(NBTTagCompound nbttagcompound, DataOutput dataoutput) throws IOException {
        NBTBase.writeTag(nbttagcompound, dataoutput);
    }

    public static NBTTagCompound func_35622_a(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        try (DataInputStream datainputstream = new DataInputStream(new FileInputStream(file));){
            NBTTagCompound nbttagcompound;
            NBTTagCompound nBTTagCompound = nbttagcompound = CompressedStreamTools.func_1141_a(datainputstream);
            return nBTTagCompound;
        }
    }

    public static byte[] func_40591_a(NBTTagCompound nbttagcompound) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        try (DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream(bytearrayoutputstream));){
            CompressedStreamTools.writeTo(nbttagcompound, dataoutputstream);
        }
        return bytearrayoutputstream.toByteArray();
    }

    public static NBTTagCompound func_40592_a(byte[] abyte0) throws IOException {
        try (DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(abyte0))));){
            NBTTagCompound nbttagcompound;
            NBTTagCompound nBTTagCompound = nbttagcompound = CompressedStreamTools.func_1141_a(datainputstream);
            return nBTTagCompound;
        }
    }
}

