/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.gui;

import net.minecraft.src.client.gui.Container;
import net.minecraft.src.client.gui.GuiScreen;
import net.minecraft.src.client.gui.ScaledResolution;
import net.minecraft.src.client.gui.Slot;
import net.minecraft.src.client.gui.StringTranslate;
import net.minecraft.src.client.renderer.RenderHelper;
import net.minecraft.src.client.renderer.entity.RenderItem;
import net.minecraft.src.game.effect.Effect;
import net.minecraft.src.game.entity.player.InventoryPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemArmor;
import net.minecraft.src.game.item.ItemBow;
import net.minecraft.src.game.item.ItemFireSword;
import net.minecraft.src.game.item.ItemFishingRod;
import net.minecraft.src.game.item.ItemFlintAndSteel;
import net.minecraft.src.game.item.ItemShears;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.item.ItemSword;
import net.minecraft.src.game.item.ItemTool;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class GuiContainer
extends GuiScreen {
    private static RenderItem itemRenderer = new RenderItem();
    protected int xSize = 176;
    protected int ySize = 166;
    public Container inventorySlots;
    public int tooltipColor = -1073741824;
    boolean mouseDown = false;

    public GuiContainer(Container var1) {
        this.inventorySlots = var1;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.mc.thePlayer.craftingInventory = this.inventorySlots;
    }

    @Override
    public void drawScreen(int width, int height, float var3) {
        int ySlot;
        int xSlot;
        this.drawDefaultBackground();
        int widthScaled = (this.width - this.xSize) / 2;
        int heightScaled = (this.height - this.ySize) / 2;
        this.drawGuiContainerBackgroundLayer(var3);
        ScaledResolution var5 = new ScaledResolution(this.mc.gameSettings, this.mc.displayWidth, this.mc.displayHeight);
        if (!this.mc.thePlayer.effects.isEmpty()) {
            int i = 0;
            while (i < this.mc.thePlayer.effects.size()) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/effects.png"));
                this.drawTexturedModalRect(var5.getScaledWidth() - 114, 2 + i * 26, 0, 224, 112, 24);
                this.drawTexturedModalRect(var5.getScaledWidth() - 110, 6 + i * 26, Effect.effectlist[((Integer)this.mc.thePlayer.effects.get((int)i)).intValue()].iconid % 16 * 16, Effect.effectlist[((Integer)this.mc.thePlayer.effects.get((int)i)).intValue()].iconid / 16 * 16, 16, 16);
                this.fontRenderer.drawStringWithShadow(StringTranslate.getInstance().translateNamedKey("effect." + Effect.effectlist[((Integer)this.mc.thePlayer.effects.get((int)i)).intValue()].name), var5.getScaledWidth() - 92, 5 + i * 26, -1);
                int seconds = this.mc.thePlayer.effecttimers[(Integer)this.mc.thePlayer.effects.get(i)] / 20;
                int minutes = seconds / 60;
                String time = "";
                time = (seconds %= 60) > 9 ? String.valueOf(minutes) + ":" + seconds : String.valueOf(minutes) + ":0" + seconds;
                this.fontRenderer.drawStringWithShadow(time, var5.getScaledWidth() - 26, 14 + i * 26, -1);
                if (this.mc.thePlayer.effectlevel[(Integer)this.mc.thePlayer.effects.get(i)] > 0) {
                    this.fontRenderer.drawStringWithShadow("Lv." + (this.mc.thePlayer.effectlevel[(Integer)this.mc.thePlayer.effects.get(i)] + 1), var5.getScaledWidth() - 92, 14 + i * 26, -1);
                }
                ++i;
            }
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.enableStandardItemLighting();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)widthScaled, (float)heightScaled, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        Slot getSlot = null;
        int var7 = 0;
        while (var7 < this.inventorySlots.slots.size()) {
            Slot slot = this.inventorySlots.slots.get(var7);
            this.drawSlotInventory(slot);
            if (this.getIsMouseOverSlot(slot, width, height)) {
                getSlot = slot;
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                xSlot = slot.xDisplayPosition;
                ySlot = slot.yDisplayPosition;
                this.drawGradientRect(xSlot, ySlot, xSlot + 16, ySlot + 16, -2130706433, -2130706433);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
            }
            ++var7;
        }
        InventoryPlayer playerInventory = this.mc.thePlayer.inventory;
        if (playerInventory.getItemStack() != null) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            itemRenderer.renderItemIntoGUI(this.fontRenderer, this.mc.renderEngine, playerInventory.getItemStack(), width - widthScaled - 8, height - heightScaled - 8);
            itemRenderer.renderItemOverlayIntoGUI(this.fontRenderer, this.mc.renderEngine, playerInventory.getItemStack(), width - widthScaled - 8, height - heightScaled - 8);
        }
        GL11.glDisable((int)32826);
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.drawGuiContainerForegroundLayer();
        if (playerInventory.getItemStack() == null && getSlot != null && getSlot.getHasStack()) {
            int itemdamage = getSlot.getStack().getMaxDamage() - getSlot.getStack().getItemDamage();
            String durability = "Durability: " + itemdamage + "/" + getSlot.getStack().getMaxDamage();
            String itemName = StringTranslate.getInstance().translateNamedKey(getSlot.getStack().getItemName()).trim();
            if (getSlot.getStack().itemID == Item.potion.itemID) {
                itemName = StringTranslate.getInstance().translateKey("item.potion." + getSlot.getStack().getItemDamage()).trim() + " " + itemName;
            }
            int y = 14;
            int color = 0xA0A0A0;
            boolean flag = false;
            if (itemName.length() > 0) {
                xSlot = width - widthScaled + 12;
                ySlot = height - heightScaled - 12;
                int getItemName = this.fontRenderer.getStringWidth(itemName);
                int getDurability = this.fontRenderer.getStringWidth(durability);
                this.tooltipColor = getSlot.getStack().getItem().getTooltipColor();
                if (this.mc.gameSettings.itemColorGradient) {
                    this.drawGradientRect(xSlot - 3, ySlot - 3, xSlot + getItemName + 3, ySlot + 8 + 3, this.tooltipColor, -1073741824);
                    this.fontRenderer.drawStringWithShadow(itemName, xSlot, ySlot, -1);
                    if (Keyboard.isKeyDown((int)29) && !flag && (getSlot.getStack().getItem() instanceof ItemTool || getSlot.getStack().getItem() instanceof ItemArmor || getSlot.getStack().getItem() instanceof ItemSword || getSlot.getStack().getItem() instanceof ItemFireSword || getSlot.getStack().getItem() instanceof ItemBow || getSlot.getStack().getItem() instanceof ItemFlintAndSteel || getSlot.getStack().getItem() instanceof ItemShears || getSlot.getStack().getItem() instanceof ItemFishingRod)) {
                        flag = true;
                        this.drawGradientRect(xSlot - 3, ySlot - 3 + y, xSlot + getDurability + 3, ySlot + 8 + 2 + y, -1073741824, -1073741824);
                        this.fontRenderer.drawStringWithShadow(durability, xSlot, ySlot + y, color);
                    } else {
                        flag = false;
                    }
                } else {
                    this.drawGradientRect(xSlot - 3, ySlot - 3, xSlot + getItemName + 3, ySlot + 8 + 3, -1073741824, this.tooltipColor);
                    this.fontRenderer.drawStringWithShadow(itemName, xSlot, ySlot, -1);
                    if (Keyboard.isKeyDown((int)29) && !flag && (getSlot.getStack().getItem() instanceof ItemTool || getSlot.getStack().getItem() instanceof ItemArmor || getSlot.getStack().getItem() instanceof ItemSword || getSlot.getStack().getItem() instanceof ItemFireSword || getSlot.getStack().getItem() instanceof ItemBow || getSlot.getStack().getItem() instanceof ItemFlintAndSteel || getSlot.getStack().getItem() instanceof ItemShears || getSlot.getStack().getItem() instanceof ItemFishingRod)) {
                        this.drawGradientRect(xSlot - 3, ySlot - 3 + y, xSlot + getDurability + 3, ySlot + 8 + 2 + y, -1073741824, -1073741824);
                        this.fontRenderer.drawStringWithShadow(durability, xSlot, ySlot + y, color);
                    }
                }
            }
        }
        GL11.glPopMatrix();
        super.drawScreen(width, height, var3);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    protected void drawGuiContainerForegroundLayer() {
    }

    protected abstract void drawGuiContainerBackgroundLayer(float var1);

    private void drawSlotInventory(Slot var1) {
        int var5;
        int var2 = var1.xDisplayPosition;
        int var3 = var1.yDisplayPosition;
        ItemStack var4 = var1.getStack();
        if (var4 == null && (var5 = var1.getBackgroundIconIndex()) >= 0) {
            GL11.glDisable((int)2896);
            this.mc.renderEngine.bindTexture(this.mc.renderEngine.getTexture("/gui/items.png"));
            this.drawTexturedModilRect(var2, var3, var5 % 16 * 16, var5 / 16 * 16, 16, 16);
            GL11.glEnable((int)2896);
            return;
        }
        itemRenderer.renderItemIntoGUI(this.fontRenderer, this.mc.renderEngine, var4, var2, var3);
        itemRenderer.renderItemOverlayIntoGUI(this.fontRenderer, this.mc.renderEngine, var4, var2, var3);
    }

    private Slot getSlotAtPosition(int var1, int var2) {
        int var3 = 0;
        while (var3 < this.inventorySlots.slots.size()) {
            Slot var4 = this.inventorySlots.slots.get(var3);
            if (this.getIsMouseOverSlot(var4, var1, var2)) {
                return var4;
            }
            ++var3;
        }
        return null;
    }

    private boolean getIsMouseOverSlot(Slot var1, int var2, int var3) {
        int var4 = (this.width - this.xSize) / 2;
        int var5 = (this.height - this.ySize) / 2;
        return (var2 -= var4) >= var1.xDisplayPosition - 1 && var2 < var1.xDisplayPosition + 16 + 1 && (var3 -= var5) >= var1.yDisplayPosition - 1 && var3 < var1.yDisplayPosition + 16 + 1;
    }

    @Override
    protected void mouseClicked(int var1, int var2, int var3) {
        this.mouseDown = true;
        super.mouseClicked(var1, var2, var3);
        if (var3 == 0 || var3 == 1) {
            Slot var4 = this.getSlotAtPosition(var1, var2);
            int var5 = (this.width - this.xSize) / 2;
            int var6 = (this.height - this.ySize) / 2;
            boolean var7 = var1 < var5 || var2 < var6 || var1 >= var5 + this.xSize || var2 >= var6 + this.ySize;
            int var8 = -1;
            if (var4 != null) {
                var8 = var4.slotNumber;
            }
            if (var7) {
                var8 = -999;
            }
            if (var8 != -1) {
                boolean var9 = var8 != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                this.func_35309_a(var4, var8, var3, var9);
            }
        }
    }

    protected void func_35309_a(Slot slot, int i, int j, boolean flag) {
        if (slot != null) {
            i = slot.slotNumber;
        }
        this.mc.playerController.func_27174_a(this.inventorySlots.windowId, i, j, flag, this.mc.thePlayer);
    }

    @Override
    protected void mouseMovedOrUp(int var1, int var2, int var3) {
        if (var3 == 0) {
            this.mouseDown = false;
        }
        super.mouseClicked(var1, var2, var3);
        if (this.mouseDown && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54))) {
            Slot var4 = this.getSlotAtPosition(var1, var2);
            int var5 = (this.width - this.xSize) / 2;
            int var6 = (this.height - this.ySize) / 2;
            boolean var7 = var1 < var5 || var2 < var6 || var1 >= var5 + this.xSize || var2 >= var6 + this.ySize;
            int var8 = -1;
            if (var4 != null) {
                var8 = var4.slotNumber;
            }
            if (var7) {
                var8 = -999;
            }
            if (var8 != -1) {
                boolean var9 = var8 != -999;
                this.mc.playerController.func_27174_a(this.inventorySlots.windowId, var8, 0, var9, this.mc.thePlayer);
            }
        }
    }

    @Override
    protected void keyTyped(char var1, int var2) {
        if (var2 == 1 || var2 == this.mc.gameSettings.keyBindInventory.keyCode) {
            this.mc.thePlayer.closeScreen();
        }
    }

    @Override
    public void onGuiClosed() {
        if (this.mc.thePlayer != null) {
            this.mc.playerController.func_20086_a(this.inventorySlots.windowId, this.mc.thePlayer);
        }
    }

    @Override
    public boolean doesGuiPauseGame() {
        return false;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (!this.mc.thePlayer.isEntityAlive() || this.mc.thePlayer.isDead) {
            this.mc.thePlayer.closeScreen();
        }
    }
}

