/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.gui;

import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.client.GameSettings;
import net.minecraft.src.client.gui.GuiButton;
import net.minecraft.src.client.renderer.Tessellator;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiSlot {
    public double pushBackground = 0.0;
    private final Minecraft mc;
    private final int width;
    private final int height;
    protected final int top;
    protected final int bottom;
    private final int right;
    private final int left;
    protected final int posZ;
    private int scrollUpButtonID;
    private int scrollDownButtonID;
    protected int field_35409_k;
    protected int field_35408_l;
    private float initialClickY = -2.0f;
    private float scrollMultiplier;
    private float amountScrolled;
    private int selectedElement = -1;
    private long lastClicked = 0L;
    private boolean field_25123_p = true;
    private boolean field_27262_q;
    private int field_27261_r;
    static Random random = new Random();

    public GuiSlot(Minecraft var1, int var2, int var3, int var4, int var5, int var6) {
        this.mc = var1;
        this.width = var2;
        this.height = var3;
        this.top = var4;
        this.bottom = var5;
        this.posZ = var6;
        this.left = 0;
        this.right = var2;
    }

    public void func_27258_a(boolean var1) {
        this.field_25123_p = var1;
    }

    protected void func_27259_a(boolean var1, int var2) {
        this.field_27262_q = var1;
        this.field_27261_r = var2;
        if (!var1) {
            this.field_27261_r = 0;
        }
    }

    protected abstract int getSize();

    protected abstract void elementClicked(int var1, boolean var2);

    protected abstract boolean isSelected(int var1);

    protected int getContentHeight() {
        return this.getSize() * this.posZ + this.field_27261_r;
    }

    protected abstract void drawBackground();

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, Tessellator var5);

    protected void func_27260_a(int var1, int var2, Tessellator var3) {
    }

    protected void func_27255_a(int var1, int var2) {
    }

    protected void func_27257_b(int var1, int var2) {
    }

    public int func_27256_c(int var1, int var2) {
        int var3 = this.width / 2 - 110;
        int var4 = this.width / 2 + 110;
        int var5 = var2 - this.top - this.field_27261_r + (int)this.amountScrolled - 4;
        int var6 = var5 / this.posZ;
        return var1 >= var3 && var1 <= var4 && var6 >= 0 && var5 >= 0 && var6 < this.getSize() ? var6 : -1;
    }

    public void registerScrollButtons(List<?> var1, int var2, int var3) {
        this.scrollUpButtonID = var2;
        this.scrollDownButtonID = var3;
    }

    private void bindAmountScrolled() {
        int var1 = this.getContentHeight() - (this.bottom - this.top - 4);
        if (var1 < 0) {
            var1 /= 2;
        }
        if (this.amountScrolled < 0.0f) {
            this.amountScrolled = 0.0f;
        }
        if (this.amountScrolled > (float)var1) {
            this.amountScrolled = var1;
        }
    }

    public void actionPerformed(GuiButton var1) {
        if (var1.enabled) {
            if (var1.id == this.scrollUpButtonID) {
                this.amountScrolled -= (float)(this.posZ * 2 / 3);
                this.initialClickY = -2.0f;
                this.bindAmountScrolled();
            } else if (var1.id == this.scrollDownButtonID) {
                this.amountScrolled += (float)(this.posZ * 2 / 3);
                this.initialClickY = -2.0f;
                this.bindAmountScrolled();
            }
        }
    }

    public void drawScreen(int var1, int var2, float var3) {
        int var14;
        int var13;
        int var19;
        int var11;
        int var10;
        int var9;
        this.pushBackground += 1.5E-4;
        this.field_35409_k = var1;
        this.field_35408_l = var2;
        this.drawBackground();
        int var4 = this.getSize();
        int var5 = this.width / 2 + 124;
        int var6 = var5 + 6;
        if (Mouse.isButtonDown((int)0)) {
            if (this.initialClickY == -1.0f) {
                boolean var7 = true;
                if (var2 >= this.top && var2 <= this.bottom) {
                    int var8 = this.width / 2 - 110;
                    var9 = this.width / 2 + 110;
                    var10 = var2 - this.top - this.field_27261_r + (int)this.amountScrolled - 4;
                    var11 = var10 / this.posZ;
                    if (var1 >= var8 && var1 <= var9 && var11 >= 0 && var10 >= 0 && var11 < var4) {
                        boolean var12 = var11 == this.selectedElement && System.currentTimeMillis() - this.lastClicked < 250L;
                        this.elementClicked(var11, var12);
                        this.selectedElement = var11;
                        this.lastClicked = System.currentTimeMillis();
                    } else if (var1 >= var8 && var1 <= var9 && var10 < 0) {
                        this.func_27255_a(var1 - var8, var2 - this.top + (int)this.amountScrolled - 4);
                        var7 = false;
                    }
                    if (var1 >= var5 && var1 <= var6) {
                        this.scrollMultiplier = -1.0f;
                        var19 = this.getContentHeight() - (this.bottom - this.top - 4);
                        if (var19 < 1) {
                            var19 = 1;
                        }
                        if ((var13 = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight())) < 32) {
                            var13 = 32;
                        }
                        if (var13 > this.bottom - this.top - 8) {
                            var13 = this.bottom - this.top - 8;
                        }
                        this.scrollMultiplier /= (float)(this.bottom - this.top - var13) / (float)var19;
                    } else {
                        this.scrollMultiplier = 1.0f;
                    }
                    this.initialClickY = var7 ? (float)var2 : -2.0f;
                } else {
                    this.initialClickY = -2.0f;
                }
            } else if (this.initialClickY >= 0.0f) {
                this.amountScrolled -= ((float)var2 - this.initialClickY) * this.scrollMultiplier;
                this.initialClickY = var2;
            }
        } else {
            this.initialClickY = -1.0f;
        }
        this.bindAmountScrolled();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator var16 = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/menu/ground/dirt.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float var17 = 32.0f;
        var16.startDrawingQuads();
        var16.setColorOpaque_I(0x202020);
        if (GameSettings.doesBackGroundMove) {
            var16.addVertexWithUV(this.left, this.bottom, 0.0, (float)this.left / var17, (double)((float)(this.bottom + (int)this.amountScrolled) / var17) + this.pushBackground);
            var16.addVertexWithUV(this.right, this.bottom, 0.0, (float)this.right / var17, (double)((float)(this.bottom + (int)this.amountScrolled) / var17) + this.pushBackground);
            var16.addVertexWithUV(this.right, this.top, 0.0, (float)this.right / var17, (double)((float)(this.top + (int)this.amountScrolled) / var17) + this.pushBackground);
            var16.addVertexWithUV(this.left, this.top, 0.0, (float)this.left / var17, (double)((float)(this.top + (int)this.amountScrolled) / var17) + this.pushBackground);
        } else {
            var16.addVertexWithUV(this.left, this.bottom, 0.0, (float)this.left / var17, (float)(this.bottom + (int)this.amountScrolled) / var17);
            var16.addVertexWithUV(this.right, this.bottom, 0.0, (float)this.right / var17, (float)(this.bottom + (int)this.amountScrolled) / var17);
            var16.addVertexWithUV(this.right, this.top, 0.0, (float)this.right / var17, (float)(this.top + (int)this.amountScrolled) / var17);
            var16.addVertexWithUV(this.left, this.top, 0.0, (float)this.left / var17, (float)(this.top + (int)this.amountScrolled) / var17);
        }
        var16.draw();
        var9 = this.width / 2 - 92 - 16;
        var10 = this.top + 4 - (int)this.amountScrolled;
        if (this.field_27262_q) {
            this.func_27260_a(var9, var10, var16);
        }
        var11 = 0;
        while (var11 < var4) {
            var19 = var10 + var11 * this.posZ + this.field_27261_r;
            var13 = this.posZ - 4;
            if (var19 <= this.bottom && var19 + var13 >= this.top) {
                if (this.field_25123_p && this.isSelected(var11)) {
                    var14 = this.width / 2 - 110;
                    int var15 = this.width / 2 + 110;
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3553);
                    var16.startDrawingQuads();
                    var16.setColorOpaque_I(0x808080);
                    var16.addVertexWithUV(var14, var19 + var13 + 2, 0.0, 0.0, 1.0);
                    var16.addVertexWithUV(var15, var19 + var13 + 2, 0.0, 1.0, 1.0);
                    var16.addVertexWithUV(var15, var19 - 2, 0.0, 1.0, 0.0);
                    var16.addVertexWithUV(var14, var19 - 2, 0.0, 0.0, 0.0);
                    var16.setColorOpaque_I(0);
                    var16.addVertexWithUV(var14 + 1, var19 + var13 + 1, 0.0, 0.0, 1.0);
                    var16.addVertexWithUV(var15 - 1, var19 + var13 + 1, 0.0, 1.0, 1.0);
                    var16.addVertexWithUV(var15 - 1, var19 - 1, 0.0, 1.0, 0.0);
                    var16.addVertexWithUV(var14 + 1, var19 - 1, 0.0, 0.0, 0.0);
                    var16.draw();
                    GL11.glEnable((int)3553);
                }
                this.drawSlot(var11, var9, var19, var13, var16);
            }
            ++var11;
        }
        GL11.glDisable((int)2929);
        int var18 = 4;
        this.overlayBackground(0, this.top, 255, 255);
        this.overlayBackground(this.bottom, this.height, 255, 255);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        var16.startDrawingQuads();
        var16.setColorRGBA_I(0, 0);
        var16.addVertexWithUV(this.left, this.top + var18, 0.0, 0.0, 1.0);
        var16.addVertexWithUV(this.right, this.top + var18, 0.0, 1.0, 1.0);
        var16.setColorRGBA_I(0, 255);
        var16.addVertexWithUV(this.right, this.top, 0.0, 1.0, 0.0);
        var16.addVertexWithUV(this.left, this.top, 0.0, 0.0, 0.0);
        var16.draw();
        var16.startDrawingQuads();
        var16.setColorRGBA_I(0, 255);
        var16.addVertexWithUV(this.left, this.bottom, 0.0, 0.0, 1.0);
        var16.addVertexWithUV(this.right, this.bottom, 0.0, 1.0, 1.0);
        var16.setColorRGBA_I(0, 0);
        var16.addVertexWithUV(this.right, this.bottom - var18, 0.0, 1.0, 0.0);
        var16.addVertexWithUV(this.left, this.bottom - var18, 0.0, 0.0, 0.0);
        var16.draw();
        var19 = this.getContentHeight() - (this.bottom - this.top - 4);
        if (var19 > 0) {
            var13 = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
            if (var13 < 32) {
                var13 = 32;
            }
            if (var13 > this.bottom - this.top - 8) {
                var13 = this.bottom - this.top - 8;
            }
            if ((var14 = (int)this.amountScrolled * (this.bottom - this.top - var13) / var19 + this.top) < this.top) {
                var14 = this.top;
            }
            var16.startDrawingQuads();
            var16.setColorRGBA_I(0, 255);
            var16.addVertexWithUV(var5, this.bottom, 0.0, 0.0, 1.0);
            var16.addVertexWithUV(var6, this.bottom, 0.0, 1.0, 1.0);
            var16.addVertexWithUV(var6, this.top, 0.0, 1.0, 0.0);
            var16.addVertexWithUV(var5, this.top, 0.0, 0.0, 0.0);
            var16.draw();
            var16.startDrawingQuads();
            var16.setColorRGBA_I(0x808080, 255);
            var16.addVertexWithUV(var5, var14 + var13, 0.0, 0.0, 1.0);
            var16.addVertexWithUV(var6, var14 + var13, 0.0, 1.0, 1.0);
            var16.addVertexWithUV(var6, var14, 0.0, 1.0, 0.0);
            var16.addVertexWithUV(var5, var14, 0.0, 0.0, 0.0);
            var16.draw();
            var16.startDrawingQuads();
            var16.setColorRGBA_I(0xC0C0C0, 255);
            var16.addVertexWithUV(var5, var14 + var13 - 1, 0.0, 0.0, 1.0);
            var16.addVertexWithUV(var6 - 1, var14 + var13 - 1, 0.0, 1.0, 1.0);
            var16.addVertexWithUV(var6 - 1, var14, 0.0, 1.0, 0.0);
            var16.addVertexWithUV(var5, var14, 0.0, 0.0, 0.0);
            var16.draw();
        }
        this.func_27257_b(var1, var2);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    private void overlayBackground(int var1, int var2, int var3, int var4) {
        Tessellator var5 = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/menu/ground/dirt.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float var6 = 32.0f;
        var5.startDrawingQuads();
        if (GameSettings.doesBackGroundMove) {
            var5.setColorRGBA_I(0x404040, var4);
            var5.addVertexWithUV(0.0, var2, 0.0, 0.0, (double)((float)var2 / var6) + this.pushBackground);
            var5.addVertexWithUV(this.width, var2, 0.0, (float)this.width / var6, (double)((float)var2 / var6) + this.pushBackground);
            var5.setColorRGBA_I(0x404040, var3);
            var5.addVertexWithUV(this.width, var1, 0.0, (float)this.width / var6, (double)((float)var1 / var6) + this.pushBackground);
            var5.addVertexWithUV(0.0, var1, 0.0, 0.0, (double)((float)var1 / var6) + this.pushBackground);
        } else {
            var5.setColorRGBA_I(0x404040, var4);
            var5.addVertexWithUV(0.0, var2, 0.0, 0.0, (float)var2 / var6);
            var5.addVertexWithUV(this.width, var2, 0.0, (float)this.width / var6, (float)var2 / var6);
            var5.setColorRGBA_I(0x404040, var3);
            var5.addVertexWithUV(this.width, var1, 0.0, (float)this.width / var6, (float)var1 / var6);
            var5.addVertexWithUV(0.0, var1, 0.0, 0.0, (float)var1 / var6);
        }
        var5.draw();
    }
}

