/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.model;

import net.minecraft.src.client.model.ModelBase;
import net.minecraft.src.client.model.ModelRenderer;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.animals.EntityFox;
import org.lwjgl.opengl.GL11;

public class ModelFox
extends ModelBase {
    public ModelRenderer foxHeadMain;
    public ModelRenderer foxBody;
    public ModelRenderer foxLeg1;
    public ModelRenderer foxLeg2;
    public ModelRenderer foxLeg3;
    public ModelRenderer foxLeg4;
    ModelRenderer foxRightEar;
    ModelRenderer foxLeftEar;
    ModelRenderer foxSnout;
    ModelRenderer foxFloofyTail;

    public ModelFox() {
        float translation = 0.0f;
        float unused = 14.5f;
        this.foxHeadMain = new ModelRenderer(0, 0);
        this.foxHeadMain.addBox(-3.0f, -3.0f, -3.0f, 8, 6, 6, translation);
        this.foxBody = new ModelRenderer(40, 0);
        this.foxBody.addBox(-4.0f, -7.125f, -3.0f, 6, 11, 6, translation);
        this.foxLeg1 = new ModelRenderer(0, 18);
        this.foxLeg1.addBox(-1.0f, 1.0f, -1.0f, 2, 6, 2, translation);
        this.foxLeg2 = new ModelRenderer(0, 18);
        this.foxLeg2.addBox(-1.0f, 1.0f, -1.0f, 2, 6, 2, translation);
        this.foxLeg3 = new ModelRenderer(0, 18);
        this.foxLeg3.addBox(-1.0f, 1.0f, -1.0f, 2, 6, 2, translation);
        this.foxLeg4 = new ModelRenderer(0, 18);
        this.foxLeg4.addBox(-1.0f, 1.0f, -1.0f, 2, 6, 2, translation);
        this.foxFloofyTail = new ModelRenderer(46, 18);
        this.foxFloofyTail.addBox(-2.0f, -1.0f, -5.0f, 4, 9, 5, translation);
        this.foxRightEar = new ModelRenderer(16, 14);
        this.foxRightEar.addBox(-2.5f, -4.875f, -1.0f, 2, 2, 1, translation);
        this.foxLeftEar = new ModelRenderer(23, 14);
        this.foxLeftEar.addBox(2.5f, -4.875f, -1.0f, 2, 2, 1, translation);
        this.foxSnout = new ModelRenderer(0, 12);
        this.foxSnout.addBox(-1.0f, 1.0f, -5.25f, 4, 2, 3, translation);
        this.foxSnout.setRotationPoint(-2.0f, unused, -6.5f);
        this.foxHeadMain.setRotationPoint(-2.0f, unused, -6.5f);
        this.foxRightEar.setRotationPoint(-2.0f, unused, -6.5f);
        this.foxLeftEar.setRotationPoint(-2.0f, unused, -6.5f);
    }

    @Override
    public void render(float var1, float var2, float var3, float var4, float var5, float translation) {
        super.render(var1, var2, var3, var4, var5, translation);
        this.setRotationAngles(var1, var2, var3, var4, var5, translation);
        this.foxHeadMain.renderWithRotation(translation);
        this.foxBody.render(translation);
        this.foxLeg1.render(translation);
        this.foxLeg2.render(translation);
        this.foxLeg3.render(translation);
        this.foxLeg4.render(translation);
        this.foxRightEar.renderWithRotation(translation);
        this.foxLeftEar.renderWithRotation(translation);
        this.foxSnout.renderWithRotation(translation);
        this.foxFloofyTail.renderWithRotation(translation);
    }

    @Override
    public void setLivingAnimations(EntityLiving entity, float xAngle, float yAngle, float zAngle) {
        float combinedAngles;
        EntityFox fox = (EntityFox)entity;
        if (fox.isWolfAngry()) {
            this.foxFloofyTail.rotateAngleY = 0.0f;
        } else if (!fox.isWolfSitting()) {
            this.foxFloofyTail.rotateAngleY = MathHelper.cos(xAngle * 0.6662f) * 1.4f * yAngle;
        }
        float headPos = 20.5f;
        float headPosTamed = 14.5f;
        if (fox.isWolfSitting()) {
            this.foxSnout.setRotationPoint(-6.5f, headPos, -3.0f);
            this.foxHeadMain.setRotationPoint(-6.5f, headPos, -3.0f);
            this.foxRightEar.setRotationPoint(-6.5f, headPos, -3.0f);
            this.foxLeftEar.setRotationPoint(-6.5f, headPos, -3.0f);
            this.foxBody.setRotationPoint(0.0f, 21.0f, 0.0f);
            this.foxFloofyTail.setRotationPoint(3.25f, 19.0f, 0.75f);
            this.foxLeg1.setRotationPoint(-4.0f, 20.5f, 1.5f);
            this.foxLeg2.setRotationPoint(-4.0f, 20.5f, 1.5f);
            this.foxLeg3.setRotationPoint(-4.0f, 20.5f, 1.5f);
            this.foxLeg4.setRotationPoint(-4.0f, 20.5f, 1.5f);
            this.foxHeadMain.rotateAngleX = 0.0f;
            this.foxHeadMain.rotateAngleY = -0.7f;
            this.foxBody.rotateAngleY = 1.39f;
            this.foxFloofyTail.rotateAngleY = 3.75f;
            this.foxBody.rotateAngleX = 1.5707964f;
            this.foxLeg1.rotateAngleY = -1.7f;
            this.foxLeg2.rotateAngleY = -1.7f;
            this.foxLeg3.rotateAngleY = -1.7f;
            this.foxLeg4.rotateAngleY = -1.7f;
            this.foxLeg1.rotateAngleX = 5.0f;
            this.foxLeg2.rotateAngleX = 5.0f;
            this.foxLeg3.rotateAngleX = 5.0f;
            this.foxLeg4.rotateAngleX = 5.0f;
        } else if (fox.isWolfAngry()) {
            this.foxSnout.setRotationPoint(-2.0f, headPosTamed, -6.5f);
            this.foxHeadMain.setRotationPoint(-2.0f, headPosTamed, -6.5f);
            this.foxRightEar.setRotationPoint(-2.0f, headPosTamed, -6.5f);
            this.foxLeftEar.setRotationPoint(-2.0f, headPosTamed, -6.5f);
            this.foxBody.setRotationPoint(0.0f, 16.0f, 2.0f);
            this.foxBody.rotateAngleX = 1.5707964f;
            this.foxBody.rotateAngleY = 0.0f;
            this.foxFloofyTail.setRotationPoint(-1.0f, 14.0f, 5.5f);
            this.foxLeg1.setRotationPoint(-2.5f, 17.0f, 5.0f);
            this.foxLeg2.setRotationPoint(0.5f, 17.0f, 5.0f);
            this.foxLeg3.setRotationPoint(-2.5f, 17.0f, -4.0f);
            this.foxLeg4.setRotationPoint(0.5f, 17.0f, -4.0f);
            this.foxLeg1.rotateAngleY = 0.0f;
            this.foxLeg2.rotateAngleY = 0.0f;
            this.foxLeg3.rotateAngleY = 0.0f;
            this.foxLeg4.rotateAngleY = 0.0f;
            this.foxLeg1.rotateAngleX = MathHelper.cos(xAngle * 0.6662f) * 1.4f * yAngle;
            this.foxLeg2.rotateAngleX = MathHelper.cos(xAngle * 0.6662f + (float)Math.PI) * 1.4f * yAngle;
            this.foxLeg3.rotateAngleX = MathHelper.cos(xAngle * 0.6662f + (float)Math.PI) * 1.4f * yAngle;
            this.foxLeg4.rotateAngleX = MathHelper.cos(xAngle * 0.6662f) * 1.4f * yAngle;
        } else if (fox.isWolfTamed() && !fox.isWolfSitting()) {
            this.foxSnout.setRotationPoint(-2.0f, headPosTamed, -6.5f);
            this.foxHeadMain.setRotationPoint(-2.0f, headPosTamed, -6.5f);
            this.foxRightEar.setRotationPoint(-2.0f, headPosTamed, -6.5f);
            this.foxLeftEar.setRotationPoint(-2.0f, headPosTamed, -6.5f);
            this.foxBody.setRotationPoint(0.0f, 16.0f, 2.0f);
            this.foxBody.rotateAngleX = 1.5707964f;
            this.foxBody.rotateAngleY = 0.0f;
            this.foxFloofyTail.setRotationPoint(-1.0f, 14.0f, 5.5f);
            this.foxLeg1.setRotationPoint(-2.5f, 17.0f, 5.0f);
            this.foxLeg2.setRotationPoint(0.5f, 17.0f, 5.0f);
            this.foxLeg3.setRotationPoint(-2.5f, 17.0f, -4.0f);
            this.foxLeg4.setRotationPoint(0.5f, 17.0f, -4.0f);
            this.foxLeg1.rotateAngleY = 0.0f;
            this.foxLeg2.rotateAngleY = 0.0f;
            this.foxLeg3.rotateAngleY = 0.0f;
            this.foxLeg4.rotateAngleY = 0.0f;
            this.foxLeg1.rotateAngleX = MathHelper.cos(xAngle * 0.6662f) * 1.4f * yAngle;
            this.foxLeg2.rotateAngleX = MathHelper.cos(xAngle * 0.6662f + (float)Math.PI) * 1.4f * yAngle;
            this.foxLeg3.rotateAngleX = MathHelper.cos(xAngle * 0.6662f + (float)Math.PI) * 1.4f * yAngle;
            this.foxLeg4.rotateAngleX = MathHelper.cos(xAngle * 0.6662f) * 1.4f * yAngle;
        } else {
            this.foxSnout.setRotationPoint(-2.0f, headPosTamed, -6.5f);
            this.foxHeadMain.setRotationPoint(-2.0f, headPosTamed, -6.5f);
            this.foxRightEar.setRotationPoint(-2.0f, headPosTamed, -6.5f);
            this.foxLeftEar.setRotationPoint(-2.0f, headPosTamed, -6.5f);
            this.foxBody.setRotationPoint(0.0f, 16.0f, 2.0f);
            this.foxBody.rotateAngleX = 1.5707964f;
            this.foxBody.rotateAngleY = 0.0f;
            this.foxFloofyTail.setRotationPoint(-1.0f, 14.0f, 8.0f);
            this.foxLeg1.setRotationPoint(-2.5f, 17.0f, 5.0f);
            this.foxLeg2.setRotationPoint(0.5f, 17.0f, 5.0f);
            this.foxLeg3.setRotationPoint(-2.5f, 17.0f, -4.0f);
            this.foxLeg4.setRotationPoint(0.5f, 17.0f, -4.0f);
            this.foxLeg1.rotateAngleY = 0.0f;
            this.foxLeg2.rotateAngleY = 0.0f;
            this.foxLeg3.rotateAngleY = 0.0f;
            this.foxLeg4.rotateAngleY = 0.0f;
            this.foxLeg1.rotateAngleX = MathHelper.cos(xAngle * 0.6662f) * 1.4f * yAngle;
            this.foxLeg2.rotateAngleX = MathHelper.cos(xAngle * 0.6662f + (float)Math.PI) * 1.4f * yAngle;
            this.foxLeg3.rotateAngleX = MathHelper.cos(xAngle * 0.6662f + (float)Math.PI) * 1.4f * yAngle;
            this.foxLeg4.rotateAngleX = MathHelper.cos(xAngle * 0.6662f) * 1.4f * yAngle;
        }
        this.foxHeadMain.rotateAngleZ = combinedAngles = fox.getInterestedAngle(zAngle) + fox.getShakeAngle(zAngle, 0.0f);
        this.foxRightEar.rotateAngleZ = combinedAngles;
        this.foxLeftEar.rotateAngleZ = combinedAngles;
        this.foxSnout.rotateAngleZ = combinedAngles;
        this.foxBody.rotateAngleZ = fox.getShakeAngle(zAngle, -0.16f);
        this.foxFloofyTail.rotateAngleZ = fox.getShakeAngle(zAngle, -0.2f);
        if (fox.getWolfShaking()) {
            float colorBrightness = fox.getEntityBrightness(zAngle) * fox.getShadingWhileShaking(zAngle);
            GL11.glColor3f((float)colorBrightness, (float)colorBrightness, (float)colorBrightness);
        }
    }

    @Override
    public void setRotationAngles(float var1, float var2, float xAngle, float yAngle, float zAngle, float var6) {
        super.setRotationAngles(var1, var2, xAngle, yAngle, zAngle, var6);
        this.foxHeadMain.rotateAngleX = zAngle / 57.295776f;
        this.foxRightEar.rotateAngleY = this.foxHeadMain.rotateAngleY = yAngle / 57.295776f;
        this.foxRightEar.rotateAngleX = this.foxHeadMain.rotateAngleX;
        this.foxLeftEar.rotateAngleY = this.foxHeadMain.rotateAngleY;
        this.foxLeftEar.rotateAngleX = this.foxHeadMain.rotateAngleX;
        this.foxSnout.rotateAngleY = this.foxHeadMain.rotateAngleY;
        this.foxSnout.rotateAngleX = this.foxHeadMain.rotateAngleX;
        this.foxFloofyTail.rotateAngleX = xAngle;
    }
}

