/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.renderer.block;

import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.src.client.renderer.block.TextureFX;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;

public class TextureGearsFX
extends TextureFX {
    private int gearsInt1 = 0;
    private int[] gearsIntArray1 = new int[1024];
    private int[] gearsIntArray2 = new int[1024];
    private int gearsInt2;

    public TextureGearsFX(int n) {
        super(Block.gear.blockIndexInTexture + 16 + n);
        this.gearsInt2 = (n << 1) - 1;
        this.gearsInt1 = 2;
        try {
            ImageIO.read(TextureGearsFX.class.getResource("/misc/blocks/gear/gear.png")).getRGB(0, 0, 32, 32, this.gearsIntArray1, 0, 32);
            ImageIO.read(TextureGearsFX.class.getResource("/misc/blocks/gear/gearmiddle.png")).getRGB(0, 0, 16, 16, this.gearsIntArray2, 0, 16);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public final void onTick() {
        this.gearsInt1 = this.gearsInt1 + this.gearsInt2 & 0x3F;
        float sin = MathHelper.sin((float)this.gearsInt1 / 64.0f * (float)Math.PI * 2.0f);
        float cos = MathHelper.cos((float)this.gearsInt1 / 64.0f * (float)Math.PI * 2.0f);
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                float n = ((float)i / 15.0f - 0.5f) * 31.0f;
                float n2 = ((float)j / 15.0f - 0.5f) * 31.0f;
                float n3 = cos * n - sin * n2;
                n = cos * n2 + sin * n;
                int n4 = (int)(n3 + 16.0f);
                int n5 = (int)(n + 16.0f);
                int n6 = 0;
                if (n4 >= 0 && n5 >= 0 && n4 < 32 && n5 < 32) {
                    n6 = this.gearsIntArray1[n4 + (n5 << 5)];
                    n5 = this.gearsIntArray2[i + (j << 4)];
                    if (n5 >>> 24 > 128) {
                        n6 = n5;
                    }
                }
                n5 = n6 >> 16 & 0xFF;
                n4 = n6 >> 8 & 0xFF;
                int n7 = n6 & 0xFF;
                n6 = n6 >>> 24 > 128 ? 255 : 0;
                int n8 = i + (j << 4);
                this.imageData[n8 << 2] = (byte)n5;
                this.imageData[(n8 << 2) + 1] = (byte)n4;
                this.imageData[(n8 << 2) + 2] = (byte)n7;
                this.imageData[(n8 << 2) + 3] = (byte)n6;
                ++j;
            }
            ++i;
        }
    }
}

