/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.renderer.entity;

import net.minecraft.src.client.GameSettings;
import net.minecraft.src.client.model.ModelBiped;
import net.minecraft.src.client.renderer.RenderBlocks;
import net.minecraft.src.client.renderer.entity.RenderLiving;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class RenderBiped
extends RenderLiving {
    protected ModelBiped modelBipedMain;

    public RenderBiped(ModelBiped var1, float var2) {
        super(var1, var2);
        this.modelBipedMain = var1;
    }

    @Override
    protected void renderEquippedItems(EntityLiving var1, float var2) {
        ItemStack itemstack = var1.getHeldItem();
        if (itemstack != null) {
            GL11.glPushMatrix();
            float var6 = var1.worldObj.getLightBrightness(MathHelper.floor_double(var1.posX), MathHelper.floor_double(var1.posY), MathHelper.floor_double(var1.posZ));
            int var7 = Item.itemsList[itemstack.itemID].getColorFromDamage(itemstack.getItemDamage());
            float var8 = (float)(var7 >> 16 & 0xFF) / 255.0f;
            float var9 = (float)(var7 >> 8 & 0xFF) / 255.0f;
            float var10 = (float)(var7 & 0xFF) / 255.0f;
            GL11.glColor4f((float)(var6 * var8), (float)(var6 * var9), (float)(var6 * var10), (float)1.0f);
            this.modelBipedMain.bipedRightArm.postRender(0.0625f);
            GL11.glTranslatef((float)-0.0625f, (float)0.4375f, (float)0.0625f);
            if (itemstack.itemID < 256 && RenderBlocks.renderItemIn3d(Block.blocksList[itemstack.itemID].getRenderType()) && GameSettings.itemRenderOld) {
                float scale = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(scale *= 0.75f), (float)(-scale), (float)scale);
            } else if (itemstack.itemID < 256 && RenderBlocks.renderItemIn3d(Block.blocksList[itemstack.itemID].getRenderType())) {
                float scale = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(scale *= 0.75f), (float)(-scale), (float)scale);
            } else if (itemstack.itemID == Item.bow.itemID) {
                float scale = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)0.125f, (float)0.3125f);
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)scale, (float)(-scale), (float)scale);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.modelBipedMain.aimedBow = true;
            } else if (Item.itemsList[itemstack.itemID].isArrow3D()) {
                float scale = 0.375f;
                if (Item.itemsList[itemstack.itemID].shouldRotateAroundWhenRendering()) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
                }
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.125f);
                GL11.glScalef((float)scale, (float)(-scale), (float)scale);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (Item.itemsList[itemstack.itemID].isFull3D()) {
                float scale = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
                GL11.glScalef((float)scale, (float)(-scale), (float)scale);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                float scale = 0.375f;
                GL11.glTranslatef((float)0.25f, (float)0.1875f, (float)-0.1875f);
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.renderManager.itemRenderer.renderItem(var1, itemstack, 0);
            GL11.glPopMatrix();
        }
    }
}

