/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.renderer.entity;

import java.util.Random;
import net.minecraft.src.client.GameSettings;
import net.minecraft.src.client.gui.FontRenderer;
import net.minecraft.src.client.renderer.RenderBlocks;
import net.minecraft.src.client.renderer.RenderEngine;
import net.minecraft.src.client.renderer.Tessellator;
import net.minecraft.src.client.renderer.entity.Render;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class RenderItem
extends Render {
    private RenderBlocks renderBlocks = new RenderBlocks();
    private Random random = new Random();
    public boolean field_27004_a = true;

    public RenderItem() {
        this.shadowSize = 0.0f;
        this.field_194_c = 0.75f;
    }

    public float hover(EntityItem var1, float var9) {
        if (GameSettings.doItemsHover) {
            return MathHelper.sin(((float)var1.age + var9) / 10.0f + var1.field_804_d) * 0.1f + 0.1f;
        }
        return 0.0f;
    }

    public void renderItemNoLiving(EntityItem var1, ItemStack itemstack, int i, float x, float y, float z) {
        GL11.glPushMatrix();
        if (itemstack.itemID < 256 && RenderBlocks.renderItemIn3d(Block.blocksList[itemstack.itemID].getRenderType())) {
            this.loadTexture("/terrain.png");
            this.renderBlocks.renderBlockOnInventory(Block.blocksList[itemstack.itemID], itemstack.getItemDamage(), var1.getEntityBrightness(1.0f));
        } else {
            float var17;
            float var16;
            float var15;
            if (itemstack.itemID < 256) {
                this.loadTexture("/terrain.png");
            } else {
                this.loadTexture("/gui/items.png");
            }
            Tessellator var3 = Tessellator.instance;
            int var4 = itemstack.getIconIndex();
            float var5 = ((float)(var4 % 16 * 16) + 0.0f) / 256.0f;
            float var6 = ((float)(var4 % 16 * 16) + 15.99f) / 256.0f;
            float var7 = ((float)(var4 / 16 * 16) + 0.0f) / 512.0f;
            float var8 = ((float)(var4 / 16 * 16) + 15.99f) / 512.0f;
            float var9 = 1.0f;
            float var10 = 0.0f;
            float var11 = 0.3f;
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)(-var10), (float)(-var11), (float)0.0f);
            float var12 = 1.5f;
            GL11.glScalef((float)var12, (float)var12, (float)var12);
            GL11.glRotated((double)180.0, (double)x, (double)y, (double)z);
            GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
            float var13 = 0.0625f;
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 0.0f, 1.0f);
            var3.addVertexWithUV(0.0, 0.0, 0.0, var6, var8);
            var3.addVertexWithUV(var9, 0.0, 0.0, var5, var8);
            var3.addVertexWithUV(var9, 1.0, 0.0, var5, var7);
            var3.addVertexWithUV(0.0, 1.0, 0.0, var6, var7);
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 0.0f, -1.0f);
            var3.addVertexWithUV(0.0, 1.0, 0.0f - var13, var6, var7);
            var3.addVertexWithUV(var9, 1.0, 0.0f - var13, var5, var7);
            var3.addVertexWithUV(var9, 0.0, 0.0f - var13, var5, var8);
            var3.addVertexWithUV(0.0, 0.0, 0.0f - var13, var6, var8);
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(-1.0f, 0.0f, 0.0f);
            int var14 = 0;
            while (var14 < 16) {
                var15 = (float)var14 / 16.0f;
                var16 = var6 + (var5 - var6) * var15 - 0.001953125f;
                var17 = var9 * var15;
                var3.addVertexWithUV(var17, 0.0, 0.0f - var13, var16, var8);
                var3.addVertexWithUV(var17, 0.0, 0.0, var16, var8);
                var3.addVertexWithUV(var17, 1.0, 0.0, var16, var7);
                var3.addVertexWithUV(var17, 1.0, 0.0f - var13, var16, var7);
                ++var14;
            }
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(1.0f, 0.0f, 0.0f);
            var14 = 0;
            while (var14 < 16) {
                var15 = (float)var14 / 16.0f;
                var16 = var6 + (var5 - var6) * var15 - 0.001953125f;
                var17 = var9 * var15 + 0.0625f;
                var3.addVertexWithUV(var17, 1.0, 0.0f - var13, var16, var7);
                var3.addVertexWithUV(var17, 1.0, 0.0, var16, var7);
                var3.addVertexWithUV(var17, 0.0, 0.0, var16, var8);
                var3.addVertexWithUV(var17, 0.0, 0.0f - var13, var16, var8);
                ++var14;
            }
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 1.0f, 0.0f);
            var14 = 0;
            while (var14 < 16) {
                var15 = (float)var14 / 16.0f;
                var16 = var8 + (var7 - var8) * var15 - 9.765625E-4f;
                var17 = var9 * var15 + 0.0625f;
                var3.addVertexWithUV(0.0, var17, 0.0, var6, var16);
                var3.addVertexWithUV(var9, var17, 0.0, var5, var16);
                var3.addVertexWithUV(var9, var17, 0.0f - var13, var5, var16);
                var3.addVertexWithUV(0.0, var17, 0.0f - var13, var6, var16);
                ++var14;
            }
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, -1.0f, 0.0f);
            var14 = 0;
            while (var14 < 16) {
                var15 = (float)var14 / 16.0f;
                var16 = var8 + (var7 - var8) * var15 - 9.765625E-4f;
                var17 = var9 * var15;
                var3.addVertexWithUV(var9, var17, 0.0, var5, var16);
                var3.addVertexWithUV(0.0, var17, 0.0, var6, var16);
                var3.addVertexWithUV(0.0, var17, 0.0f - var13, var6, var16);
                var3.addVertexWithUV(var9, var17, 0.0f - var13, var5, var16);
                ++var14;
            }
            var3.draw();
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
    }

    public void renderItemNoLivingPotion(EntityItem itemEntity, ItemStack itemstack, int i, float x, float y, float z) {
        GL11.glPushMatrix();
        float var27 = itemEntity.getEntityBrightness(itemEntity.entityBrightness);
        GL11.glColor4f((float)var27, (float)var27, (float)var27, (float)1.0f);
        if (itemstack.itemID < 256 && RenderBlocks.renderItemIn3d(Block.blocksList[itemstack.itemID].getRenderType())) {
            this.loadTexture("/terrain.png");
            this.renderBlocks.renderBlockOnInventory(Block.blocksList[itemstack.itemID], itemstack.getItemDamage(), itemEntity.getEntityBrightness(1.0f));
        } else {
            float var17;
            float var16;
            float var15;
            if (itemstack.itemID < 256) {
                this.loadTexture("/terrain.png");
            } else {
                this.loadTexture("/gui/items.png");
            }
            Tessellator var3 = Tessellator.instance;
            int var4 = 259;
            float var5 = ((float)(var4 % 16 * 16) + 0.0f) / 256.0f;
            float var6 = ((float)(var4 % 16 * 16) + 15.99f) / 256.0f;
            float var7 = ((float)(var4 / 16 * 16) + 0.0f) / 512.0f;
            float var8 = ((float)(var4 / 16 * 16) + 15.99f) / 512.0f;
            float var9 = 1.0f;
            float var10 = 0.0f;
            float var11 = 0.3f;
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)(-var10), (float)(-var11), (float)0.0f);
            float var12 = 1.5f;
            GL11.glScalef((float)var12, (float)var12, (float)var12);
            GL11.glRotated((double)180.0, (double)x, (double)y, (double)z);
            GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
            float var13 = 0.0625f;
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 0.0f, 1.0f);
            var3.addVertexWithUV(0.0, 0.0, 0.0, var6, var8);
            var3.addVertexWithUV(var9, 0.0, 0.0, var5, var8);
            var3.addVertexWithUV(var9, 1.0, 0.0, var5, var7);
            var3.addVertexWithUV(0.0, 1.0, 0.0, var6, var7);
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 0.0f, -1.0f);
            var3.addVertexWithUV(0.0, 1.0, 0.0f - var13, var6, var7);
            var3.addVertexWithUV(var9, 1.0, 0.0f - var13, var5, var7);
            var3.addVertexWithUV(var9, 0.0, 0.0f - var13, var5, var8);
            var3.addVertexWithUV(0.0, 0.0, 0.0f - var13, var6, var8);
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(-1.0f, 0.0f, 0.0f);
            int var14 = 0;
            while (var14 < 16) {
                var15 = (float)var14 / 16.0f;
                var16 = var6 + (var5 - var6) * var15 - 0.001953125f;
                var17 = var9 * var15;
                var3.addVertexWithUV(var17, 0.0, 0.0f - var13, var16, var8);
                var3.addVertexWithUV(var17, 0.0, 0.0, var16, var8);
                var3.addVertexWithUV(var17, 1.0, 0.0, var16, var7);
                var3.addVertexWithUV(var17, 1.0, 0.0f - var13, var16, var7);
                ++var14;
            }
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(1.0f, 0.0f, 0.0f);
            var14 = 0;
            while (var14 < 16) {
                var15 = (float)var14 / 16.0f;
                var16 = var6 + (var5 - var6) * var15 - 0.001953125f;
                var17 = var9 * var15 + 0.0625f;
                var3.addVertexWithUV(var17, 1.0, 0.0f - var13, var16, var7);
                var3.addVertexWithUV(var17, 1.0, 0.0, var16, var7);
                var3.addVertexWithUV(var17, 0.0, 0.0, var16, var8);
                var3.addVertexWithUV(var17, 0.0, 0.0f - var13, var16, var8);
                ++var14;
            }
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, 1.0f, 0.0f);
            var14 = 0;
            while (var14 < 16) {
                var15 = (float)var14 / 16.0f;
                var16 = var8 + (var7 - var8) * var15 - 9.765625E-4f;
                var17 = var9 * var15 + 0.0625f;
                var3.addVertexWithUV(0.0, var17, 0.0, var6, var16);
                var3.addVertexWithUV(var9, var17, 0.0, var5, var16);
                var3.addVertexWithUV(var9, var17, 0.0f - var13, var5, var16);
                var3.addVertexWithUV(0.0, var17, 0.0f - var13, var6, var16);
                ++var14;
            }
            var3.draw();
            var3.startDrawingQuads();
            var3.setNormal(0.0f, -1.0f, 0.0f);
            var14 = 0;
            while (var14 < 16) {
                var15 = (float)var14 / 16.0f;
                var16 = var8 + (var7 - var8) * var15 - 9.765625E-4f;
                var17 = var9 * var15;
                var3.addVertexWithUV(var9, var17, 0.0, var5, var16);
                var3.addVertexWithUV(0.0, var17, 0.0, var6, var16);
                var3.addVertexWithUV(0.0, var17, 0.0f - var13, var6, var16);
                var3.addVertexWithUV(var9, var17, 0.0f - var13, var5, var16);
                ++var14;
            }
            var3.draw();
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
    }

    public void doRenderItem(EntityItem itemEntity, double x, double y, double z, float yaw, float pitch) {
        this.random.setSeed(187L);
        ItemStack itemstack = itemEntity.item;
        GL11.glPushMatrix();
        float rotationage = (((float)itemEntity.age + pitch) / 20.0f + itemEntity.field_804_d) * 57.295776f;
        int stackSize = 1;
        if (itemEntity.item.stackSize > 1) {
            stackSize = 2;
        }
        if (itemEntity.item.stackSize > 5) {
            stackSize = 3;
        }
        if (itemEntity.item.stackSize > 20) {
            stackSize = 4;
        }
        GL11.glTranslatef((float)((float)x), (float)((float)y + this.hover(itemEntity, pitch)), (float)((float)z));
        GL11.glEnable((int)32826);
        if (itemstack.itemID < 256 && RenderBlocks.renderItemIn3d(Block.blocksList[itemstack.itemID].getRenderType())) {
            if (GameSettings.doItemsRotate) {
                GL11.glRotatef((float)rotationage, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (!GameSettings.doItemsRotate) {
                GL11.glRotatef((float)itemEntity.rotationYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            this.loadTexture("/terrain.png");
            float translation = 0.25f;
            if (!Block.blocksList[itemstack.itemID].renderAsNormalBlock() && itemstack.itemID != Block.slabSingleRock.blockID && Block.blocksList[itemstack.itemID].getRenderType() != 16) {
                translation = 0.25f;
            }
            GL11.glScalef((float)translation, (float)translation, (float)translation);
            int var29 = 0;
            while (var29 < stackSize) {
                GL11.glPushMatrix();
                if (var29 > 0) {
                    float minX = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / translation;
                    float maxX = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / translation;
                    float minY = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / translation;
                    GL11.glTranslatef((float)minX, (float)maxX, (float)minY);
                }
                this.renderBlocks.renderBlockOnInventory(Block.blocksList[itemstack.itemID], itemstack.getItemDamage(), itemEntity.getEntityBrightness(pitch));
                GL11.glPopMatrix();
                ++var29;
            }
        } else if (itemstack.itemID < 256 && RenderBlocks.renderItemIn3dCross(Block.blocksList[itemstack.itemID].getRenderAs3DItem()) && itemstack.itemID != Block.gear.blockID && itemstack.itemID != Block.ladder.blockID && itemstack.itemID != Block.torch.blockID && itemstack.itemID != Block.rail.blockID && GameSettings.flowerItems3D) {
            float var26;
            float var25;
            float var24;
            int var23;
            if (GameSettings.doItemsRotate) {
                GL11.glRotatef((float)rotationage, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (!GameSettings.doItemsRotate) {
                GL11.glRotatef((float)itemEntity.rotationYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            int itemTexture = itemstack.getIconIndex();
            if (itemstack.itemID < 256 && !Block.blocksList[itemstack.itemID].renderAsNormalBlock()) {
                this.loadTexture("/terrain.png");
            } else {
                this.loadTexture("/gui/items.png");
            }
            Tessellator instance = Tessellator.instance;
            float minX = (float)(itemTexture % 16 * 16 + 0) / 256.0f;
            float maxX = (float)(itemTexture % 16 * 16 + 16) / 256.0f;
            float minY = (float)(itemTexture / 16 * 16 + 0) / 512.0f;
            float maxY = (float)(itemTexture / 16 * 16 + 16) / 512.0f;
            float var20 = 1.0f;
            float var21 = 0.5f;
            float var22 = 0.25f;
            if (this.field_27004_a) {
                var23 = Item.itemsList[itemstack.itemID].getColorFromDamage(itemstack.getItemDamage());
                var24 = (float)(var23 >> 16 & 0xFF) / 255.0f;
                var25 = (float)(var23 >> 8 & 0xFF) / 255.0f;
                var26 = (float)(var23 & 0xFF) / 255.0f;
                float var27 = itemEntity.getEntityBrightness(pitch);
                GL11.glColor4f((float)(var24 * var27), (float)(var25 * var27), (float)(var26 * var27), (float)1.0f);
            }
            var23 = 0;
            while (var23 < stackSize) {
                GL11.glPushMatrix();
                if (var23 > 0) {
                    var24 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    var25 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    var26 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    GL11.glTranslatef((float)var24, (float)var25, (float)var26);
                }
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 1.0f, 0.0f);
                instance.addVertexWithUV(0.0f - var21, 0.0f - var22, 0.0, minX, maxY);
                instance.addVertexWithUV(var20 - var21, 0.0f - var22, 0.0, maxX, maxY);
                instance.addVertexWithUV(var20 - var21, 1.0f - var22, 0.0, maxX, minY);
                instance.addVertexWithUV(0.0f - var21, 1.0f - var22, 0.0, minX, minY);
                instance.draw();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                if (var23 > 0) {
                    var24 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    var25 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    var26 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    GL11.glTranslatef((float)var24, (float)var25, (float)var26);
                }
                GL11.glRotatef((float)360.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 1.0f, 0.0f);
                instance.addVertexWithUV(0.0f - var21, 0.0f - var22, 0.0, minX, maxY);
                instance.addVertexWithUV(var20 - var21, 0.0f - var22, 0.0, maxX, maxY);
                instance.addVertexWithUV(var20 - var21, 1.0f - var22, 0.0, maxX, minY);
                instance.addVertexWithUV(0.0f - var21, 1.0f - var22, 0.0, minX, minY);
                instance.draw();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                if (var23 > 0) {
                    var24 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    var25 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    var26 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    GL11.glTranslatef((float)var24, (float)var25, (float)var26);
                }
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 1.0f, 0.0f);
                instance.addVertexWithUV(0.0f - var21, 0.0f - var22, 0.0, minX, maxY);
                instance.addVertexWithUV(var20 - var21, 0.0f - var22, 0.0, maxX, maxY);
                instance.addVertexWithUV(var20 - var21, 1.0f - var22, 0.0, maxX, minY);
                instance.addVertexWithUV(0.0f - var21, 1.0f - var22, 0.0, minX, minY);
                instance.draw();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                if (var23 > 0) {
                    var24 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    var25 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    var26 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    GL11.glTranslatef((float)var24, (float)var25, (float)var26);
                }
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                instance.startDrawingQuads();
                instance.setNormal(0.0f, 1.0f, 0.0f);
                instance.addVertexWithUV(0.0f - var21, 0.0f - var22, 0.0, minX, maxY);
                instance.addVertexWithUV(var20 - var21, 0.0f - var22, 0.0, maxX, maxY);
                instance.addVertexWithUV(var20 - var21, 1.0f - var22, 0.0, maxX, minY);
                instance.addVertexWithUV(0.0f - var21, 1.0f - var22, 0.0, minX, minY);
                instance.draw();
                GL11.glPopMatrix();
                ++var23;
            }
        } else if (itemstack.itemID == Item.potion.itemID) {
            float var27;
            float var26;
            float var25;
            float var24;
            int var23;
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            int itemTexture = itemstack.getIconIndex();
            int potiontexture = 259;
            if (itemstack.itemID < 256) {
                this.loadTexture("/terrain.png");
            } else {
                this.loadTexture("/gui/items.png");
            }
            Tessellator var15 = Tessellator.instance;
            float minX = (float)(itemTexture % 16 * 16 + 0) / 256.0f;
            float maxX = (float)(itemTexture % 16 * 16 + 16) / 256.0f;
            float minY = (float)(itemTexture / 16 * 16 + 0) / 512.0f;
            float maxY = (float)(itemTexture / 16 * 16 + 16) / 512.0f;
            float minXPotion = (float)(potiontexture % 16 * 16 + 0) / 256.0f;
            float maxXPotion = (float)(potiontexture % 16 * 16 + 16) / 256.0f;
            float minYPotion = (float)(potiontexture / 16 * 16 + 0) / 512.0f;
            float maxYPotion = (float)(potiontexture / 16 * 16 + 16) / 512.0f;
            float var20 = 1.0f;
            float var21 = 0.5f;
            float var22 = 0.25f;
            float var130 = 0.0625f;
            if (this.field_27004_a) {
                var23 = Item.itemsList[itemstack.itemID].getColorFromDamage(itemstack.getItemDamage());
                var24 = (float)(var23 >> 16 & 0xFF) / 255.0f;
                var25 = (float)(var23 >> 8 & 0xFF) / 255.0f;
                var26 = (float)(var23 & 0xFF) / 255.0f;
                var27 = itemEntity.getEntityBrightness(pitch);
                GL11.glColor4f((float)(var24 * var27), (float)(var25 * var27), (float)(var26 * var27), (float)1.0f);
            }
            if (GameSettings.itemsIn3d == 0) {
                var23 = 0;
                while (var23 < stackSize) {
                    GL11.glPushMatrix();
                    if (var23 > 0) {
                        var24 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        var25 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        var26 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        GL11.glTranslatef((float)var24, (float)var25, (float)var26);
                    }
                    GL11.glRotatef((float)(180.0f - this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
                    var15.startDrawingQuads();
                    var15.setNormal(0.0f, 1.0f, 0.0f);
                    var15.addVertexWithUV(0.0f - var21, 0.0f - var22, 0.0, minX, maxY);
                    var15.addVertexWithUV(var20 - var21, 0.0f - var22, 0.0, maxX, maxY);
                    var15.addVertexWithUV(var20 - var21, 1.0f - var22, 0.0, maxX, minY);
                    var15.addVertexWithUV(0.0f - var21, 1.0f - var22, 0.0, minX, minY);
                    var15.draw();
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    if (var23 > 0) {
                        var24 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        var25 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        var26 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        GL11.glTranslatef((float)var24, (float)var25, (float)var26);
                    }
                    var15.startDrawingQuads();
                    var15.setNormal(0.0f, 1.0f, 0.0f);
                    GL11.glRotatef((float)(180.0f - this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
                    var27 = itemEntity.getEntityBrightness(itemEntity.entityBrightness);
                    GL11.glColor4f((float)var27, (float)var27, (float)var27, (float)1.0f);
                    var15.addVertexWithUV(0.0f - var21, 0.0f - var22, 0.0, minXPotion, maxYPotion);
                    var15.addVertexWithUV(var20 - var21, 0.0f - var22, 0.0, maxXPotion, maxYPotion);
                    var15.addVertexWithUV(var20 - var21, 1.0f - var22, 0.0, maxXPotion, minYPotion);
                    var15.addVertexWithUV(0.0f - var21, 1.0f - var22, 0.0, minXPotion, minYPotion);
                    var15.draw();
                    GL11.glPopMatrix();
                    ++var23;
                }
            } else if (GameSettings.itemsIn3d == 1 && itemstack.itemID == Item.potion.itemID) {
                GL11.glPushMatrix();
                GL11.glRotated((double)(180.0f - this.renderManager.playerViewY), (double)0.0, (double)1.0, (double)0.0);
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                GL11.glTranslated((double)-0.75, (double)0.0, (double)0.0);
                this.renderItemNoLiving(itemEntity, itemstack, 0, 0.0f, 1.0f, 0.0f);
                this.renderItemNoLivingPotion(itemEntity, itemstack, 0, 0.0f, 1.0f, 0.0f);
                GL11.glPopMatrix();
            } else if (GameSettings.itemsIn3d == 2 && itemstack.itemID == Item.potion.itemID) {
                GL11.glPushMatrix();
                GL11.glRotated((double)itemEntity.rotationYaw, (double)0.0, (double)1.0, (double)0.0);
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                GL11.glTranslated((double)-0.75, (double)0.0, (double)0.0);
                this.renderItemNoLiving(itemEntity, itemstack, 0, 0.0f, 1.0f, 0.0f);
                this.renderItemNoLivingPotion(itemEntity, itemstack, 0, 0.0f, 1.0f, 0.0f);
                GL11.glPopMatrix();
            } else if (GameSettings.itemsIn3d == 3 && itemstack.itemID == Item.potion.itemID) {
                GL11.glPushMatrix();
                GL11.glRotated((double)itemEntity.rotationYaw, (double)0.0, (double)1.0, (double)0.0);
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                GL11.glTranslated((double)-0.75, (double)-0.1, (double)-0.5);
                this.renderItemNoLiving(itemEntity, itemstack, 0, 0.0f, 1.0f, 1.0f);
                this.renderItemNoLivingPotion(itemEntity, itemstack, 0, 0.0f, 1.0f, 1.0f);
                GL11.glPopMatrix();
            } else if (GameSettings.itemsIn3d == 4 && itemstack.itemID == Item.potion.itemID) {
                GL11.glPushMatrix();
                GL11.glRotated((double)rotationage, (double)0.0, (double)1.0, (double)0.0);
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                GL11.glTranslated((double)-0.75, (double)0.0, (double)0.0);
                this.renderItemNoLiving(itemEntity, itemstack, 0, 0.0f, 1.0f, 0.0f);
                this.renderItemNoLivingPotion(itemEntity, itemstack, 0, 0.0f, 1.0f, 0.0f);
                GL11.glPopMatrix();
            } else if (GameSettings.itemsIn3d == 1) {
                GL11.glPushMatrix();
                GL11.glRotated((double)(180.0f - this.renderManager.playerViewY), (double)0.0, (double)1.0, (double)0.0);
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                GL11.glTranslated((double)-0.75, (double)0.0, (double)0.0);
                this.renderItemNoLiving(itemEntity, itemstack, 0, 0.0f, 1.0f, 0.0f);
                GL11.glPopMatrix();
            } else if (GameSettings.itemsIn3d == 2) {
                GL11.glPushMatrix();
                GL11.glRotated((double)itemEntity.rotationYaw, (double)0.0, (double)1.0, (double)0.0);
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                GL11.glTranslated((double)-0.75, (double)0.0, (double)0.0);
                this.renderItemNoLiving(itemEntity, itemstack, 0, 0.0f, 1.0f, 0.0f);
                GL11.glPopMatrix();
            } else if (GameSettings.itemsIn3d == 3) {
                GL11.glPushMatrix();
                GL11.glRotated((double)itemEntity.rotationYaw, (double)0.0, (double)1.0, (double)0.0);
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                GL11.glTranslated((double)-0.75, (double)-0.1, (double)-0.5);
                this.renderItemNoLiving(itemEntity, itemstack, 0, 0.0f, 1.0f, 1.0f);
                GL11.glPopMatrix();
            } else if (GameSettings.itemsIn3d == 4) {
                GL11.glPushMatrix();
                GL11.glRotated((double)rotationage, (double)0.0, (double)1.0, (double)0.0);
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                GL11.glTranslated((double)-0.75, (double)0.0, (double)0.0);
                this.renderItemNoLiving(itemEntity, itemstack, 0, 0.0f, 1.0f, 0.0f);
                GL11.glPopMatrix();
            }
        } else {
            float var26;
            float var25;
            float var24;
            int var23;
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            int var14 = itemstack.getIconIndex();
            if (itemstack.itemID < 256) {
                this.loadTexture("/terrain.png");
            } else {
                this.loadTexture("/gui/items.png");
            }
            Tessellator var15 = Tessellator.instance;
            float minX = (float)(var14 % 16 * 16 + 0) / 256.0f;
            float maxX = (float)(var14 % 16 * 16 + 16) / 256.0f;
            float minY = (float)(var14 / 16 * 16 + 0) / 512.0f;
            float maxY = (float)(var14 / 16 * 16 + 16) / 512.0f;
            float var20 = 1.0f;
            float var21 = 0.5f;
            float var22 = 0.25f;
            float var130 = 0.0625f;
            if (this.field_27004_a) {
                var23 = Item.itemsList[itemstack.itemID].getColorFromDamage(itemstack.getItemDamage());
                var24 = (float)(var23 >> 16 & 0xFF) / 255.0f;
                var25 = (float)(var23 >> 8 & 0xFF) / 255.0f;
                var26 = (float)(var23 & 0xFF) / 255.0f;
                float var27 = itemEntity.getEntityBrightness(pitch);
                GL11.glColor4f((float)(var24 * var27), (float)(var25 * var27), (float)(var26 * var27), (float)1.0f);
            }
            if (GameSettings.itemsIn3d == 0) {
                var23 = 0;
                while (var23 < stackSize) {
                    GL11.glPushMatrix();
                    if (var23 > 0) {
                        var24 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        var25 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        var26 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        GL11.glTranslatef((float)var24, (float)var25, (float)var26);
                    }
                    GL11.glRotatef((float)(180.0f - this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
                    var15.startDrawingQuads();
                    var15.setNormal(0.0f, 1.0f, 0.0f);
                    var15.addVertexWithUV(0.0f - var21, 0.0f - var22, 0.0, minX, maxY);
                    var15.addVertexWithUV(var20 - var21, 0.0f - var22, 0.0, maxX, maxY);
                    var15.addVertexWithUV(var20 - var21, 1.0f - var22, 0.0, maxX, minY);
                    var15.addVertexWithUV(0.0f - var21, 1.0f - var22, 0.0, minX, minY);
                    var15.draw();
                    GL11.glPopMatrix();
                    ++var23;
                }
            } else if (GameSettings.itemsIn3d == 1) {
                GL11.glPushMatrix();
                GL11.glRotated((double)(180.0f - this.renderManager.playerViewY), (double)0.0, (double)1.0, (double)0.0);
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                GL11.glTranslated((double)-0.75, (double)0.0, (double)0.0);
                this.renderItemNoLiving(itemEntity, itemstack, 0, 0.0f, 1.0f, 0.0f);
                GL11.glPopMatrix();
            } else if (GameSettings.itemsIn3d == 2) {
                GL11.glPushMatrix();
                GL11.glRotated((double)itemEntity.rotationYaw, (double)0.0, (double)1.0, (double)0.0);
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                GL11.glTranslated((double)-0.75, (double)0.0, (double)0.0);
                this.renderItemNoLiving(itemEntity, itemstack, 0, 0.0f, 1.0f, 0.0f);
                GL11.glPopMatrix();
            } else if (GameSettings.itemsIn3d == 3) {
                GL11.glPushMatrix();
                GL11.glRotated((double)itemEntity.rotationYaw, (double)0.0, (double)1.0, (double)0.0);
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                GL11.glTranslated((double)-0.75, (double)-0.1, (double)-0.5);
                this.renderItemNoLiving(itemEntity, itemstack, 0, 0.0f, 1.0f, 1.0f);
                GL11.glPopMatrix();
            } else if (GameSettings.itemsIn3d == 4) {
                GL11.glPushMatrix();
                GL11.glRotated((double)rotationage, (double)0.0, (double)1.0, (double)0.0);
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                GL11.glTranslated((double)-0.75, (double)0.0, (double)0.0);
                this.renderItemNoLiving(itemEntity, itemstack, 0, 0.0f, 1.0f, 0.0f);
                GL11.glPopMatrix();
            }
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public void drawItemIntoGui(FontRenderer var1, RenderEngine renderer, int item, int var4, int var5, int var6, int var7) {
        if (item < 256 && RenderBlocks.renderItemIn3d(Block.blocksList[item].getRenderType())) {
            renderer.bindTexture(renderer.getTexture("/terrain.png"));
            Block block = Block.blocksList[item];
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(var6 - 2), (float)(var7 + 3), (float)-3.0f);
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int color = Item.itemsList[item].getColorFromDamage(var4);
            float var11 = (float)(color >> 16 & 0xFF) / 255.0f;
            float var12 = (float)(color >> 8 & 0xFF) / 255.0f;
            float var13 = (float)(color & 0xFF) / 255.0f;
            if (this.field_27004_a) {
                GL11.glColor4f((float)var11, (float)var12, (float)var13, (float)1.0f);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderBlocks.field_31088_b = this.field_27004_a;
            this.renderBlocks.renderBlockOnInventory(block, var4, 1.0f);
            this.renderBlocks.field_31088_b = true;
            GL11.glPopMatrix();
        } else if (var5 >= 0) {
            GL11.glDisable((int)2896);
            if (item < 256) {
                renderer.bindTexture(renderer.getTexture("/terrain.png"));
            } else {
                renderer.bindTexture(renderer.getTexture("/gui/items.png"));
            }
            int var8 = Item.itemsList[item].getColorFromDamage(var4);
            float var9 = (float)(var8 >> 16 & 0xFF) / 255.0f;
            float var10 = (float)(var8 >> 8 & 0xFF) / 255.0f;
            float var11 = (float)(var8 & 0xFF) / 255.0f;
            if (this.field_27004_a) {
                GL11.glColor4f((float)var9, (float)var10, (float)var11, (float)1.0f);
            }
            this.renderTexturedQuadExtended(var6, var7, var5 % 16 * 16, var5 / 16 * 16, 16, 16);
            if (item == Item.potion.itemID) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.renderTexturedQuadExtended(var6, var7, 48, 256, 16, 16);
            }
            GL11.glEnable((int)2896);
        }
        GL11.glEnable((int)2884);
    }

    public void renderItemIntoGUI(FontRenderer var1, RenderEngine var2, ItemStack var3, int var4, int var5) {
        if (var3 != null) {
            this.drawItemIntoGui(var1, var2, var3.itemID, var3.getItemDamage(), var3.getIconIndex(), var4, var5);
        }
    }

    public void renderItemOverlayIntoGUI(FontRenderer var1, RenderEngine var2, ItemStack var3, int var4, int var5) {
        if (var3 != null) {
            if (var3.stackSize > 1) {
                String var6 = "" + var3.stackSize;
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                var1.drawStringWithShadow(var6, var4 + 19 - 2 - var1.getStringWidth(var6), var5 + 6 + 3, 0xFFFFFF);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
            }
            if (var3.isItemDamaged()) {
                int var11 = (int)Math.round(13.0 - (double)var3.getItemDamageForDisplay() * 13.0 / (double)var3.getMaxDamage());
                int var7 = (int)Math.round(255.0 - (double)var3.getItemDamageForDisplay() * 255.0 / (double)var3.getMaxDamage());
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)3553);
                Tessellator var8 = Tessellator.instance;
                int var9 = 255 - var7 << 16 | var7 << 8;
                int var10 = (255 - var7) / 4 << 16 | 0x3F00;
                this.renderQuad(var8, var4 + 2, var5 + 13, 13, 2, 0);
                this.renderQuad(var8, var4 + 2, var5 + 13, 12, 1, var10);
                this.renderQuad(var8, var4 + 2, var5 + 13, var11, 1, var9);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private void renderQuad(Tessellator var1, int var2, int var3, int var4, int var5, int var6) {
        var1.startDrawingQuads();
        var1.setColorOpaque_I(var6);
        var1.addVertex(var2 + 0, var3 + 0, 0.0);
        var1.addVertex(var2 + 0, var3 + var5, 0.0);
        var1.addVertex(var2 + var4, var3 + var5, 0.0);
        var1.addVertex(var2 + var4, var3 + 0, 0.0);
        var1.draw();
    }

    public void renderTexturedQuad(int var1, int var2, int var3, int var4, int var5, int var6) {
        float var7 = 0.0f;
        float var8 = 0.00390625f;
        float var9 = 0.00390625f;
        Tessellator var10 = Tessellator.instance;
        var10.startDrawingQuads();
        var10.addVertexWithUV(var1 + 0, var2 + var6, var7, (float)(var3 + 0) * var8, (float)(var4 + var6) * var9);
        var10.addVertexWithUV(var1 + var5, var2 + var6, var7, (float)(var3 + var5) * var8, (float)(var4 + var6) * var9);
        var10.addVertexWithUV(var1 + var5, var2 + 0, var7, (float)(var3 + var5) * var8, (float)(var4 + 0) * var9);
        var10.addVertexWithUV(var1 + 0, var2 + 0, var7, (float)(var3 + 0) * var8, (float)(var4 + 0) * var9);
        var10.draw();
    }

    public void renderTexturedQuadExtended(int var1, int var2, int var3, int var4, int var5, int var6) {
        float var7 = 0.0f;
        float var8 = 0.00390625f;
        float var9 = 0.001953125f;
        Tessellator var10 = Tessellator.instance;
        var10.startDrawingQuads();
        var10.addVertexWithUV(var1 + 0, var2 + var6, var7, (float)(var3 + 0) * var8, (float)(var4 + var6) * var9);
        var10.addVertexWithUV(var1 + var5, var2 + var6, var7, (float)(var3 + var5) * var8, (float)(var4 + var6) * var9);
        var10.addVertexWithUV(var1 + var5, var2 + 0, var7, (float)(var3 + var5) * var8, (float)(var4 + 0) * var9);
        var10.addVertexWithUV(var1 + 0, var2 + 0, var7, (float)(var3 + 0) * var8, (float)(var4 + 0) * var9);
        var10.draw();
    }

    @Override
    public void doRender(Entity var1, double var2, double var4, double var6, float var8, float var9) {
        this.doRenderItem((EntityItem)var1, var2, var4, var6, var8, var9);
    }

    public void renderItemCooldownIntoGUI(FontRenderer fontrenderer, RenderEngine renderer, ItemStack item, int width, int height) {
        if (item != null) {
            if (item.itemStackCooldown() > 1) {
                String itemcount = "~" + item.itemStackCooldown() / 20;
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                fontrenderer.drawStringWithShadow(itemcount, width + 19 - 2 - fontrenderer.getStringWidth(itemcount), height, 0xFFFFFF);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
            }
            if (item.isItemDamaged()) {
                int var11 = (int)Math.round(13.0 - (double)item.getItemDamageForDisplay() * 13.0 / (double)item.getMaxDamage());
                int var7 = (int)Math.round(255.0 - (double)item.getItemDamageForDisplay() * 255.0 / (double)item.getMaxDamage());
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)3553);
                Tessellator instance = Tessellator.instance;
                int var9 = 255 - var7 << 16 | var7 << 8;
                int var10 = (255 - var7) / 4 << 16 | 0x3F00;
                this.renderQuad(instance, width + 2, height + 13, 13, 2, 0);
                this.renderQuad(instance, width + 2, height + 13, 12, 1, var10);
                this.renderQuad(instance, width + 2, height + 13, var11, 1, var9);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

