/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.renderer.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.src.client.gui.FontRenderer;
import net.minecraft.src.client.model.ModelBase;
import net.minecraft.src.client.renderer.Tessellator;
import net.minecraft.src.client.renderer.entity.Render;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityLiving;
import org.lwjgl.opengl.GL11;

public class RenderLiving
extends Render {
    protected ModelBase mainModel;
    protected ModelBase renderPassModel;

    public RenderLiving(ModelBase var1, float var2) {
        this.mainModel = var1;
        this.shadowSize = var2;
    }

    public void setRenderPassModel(ModelBase var1) {
        this.renderPassModel = var1;
    }

    public void doRenderLiving(EntityLiving var1, double var2, double var4, double var6, float var8, float var9) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        this.mainModel.onGround = this.func_167_c(var1, var9);
        if (this.renderPassModel != null) {
            this.renderPassModel.onGround = this.mainModel.onGround;
        }
        this.mainModel.isRiding = var1.isRiding();
        if (this.renderPassModel != null) {
            this.renderPassModel.isRiding = this.mainModel.isRiding;
        }
        try {
            float var10 = var1.prevRenderYawOffset + (var1.renderYawOffset - var1.prevRenderYawOffset) * var9;
            float var11 = var1.prevRotationYaw + (var1.rotationYaw - var1.prevRotationYaw) * var9;
            float var12 = var1.prevRotationPitch + (var1.rotationPitch - var1.prevRotationPitch) * var9;
            this.func_22012_b(var1, var2, var4, var6);
            float var13 = this.func_170_d(var1, var9);
            this.rotateCorpse(var1, var13, var10, var9);
            float var14 = 0.0625f;
            GL11.glEnable((int)32826);
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
            this.preRenderCallback(var1, var9);
            GL11.glTranslatef((float)0.0f, (float)(-24.0f * var14 - 0.0078125f), (float)0.0f);
            float var15 = var1.field_705_Q + (var1.field_704_R - var1.field_705_Q) * var9;
            float var16 = var1.field_703_S - var1.field_704_R * (1.0f - var9);
            if (var15 > 1.0f) {
                var15 = 1.0f;
            }
            this.loadDownloadableImageTexture(var1.skinUrl, var1.getEntityTexture());
            GL11.glEnable((int)3008);
            this.mainModel.setLivingAnimations(var1, var16, var15, var9);
            this.mainModel.render(var16, var15, var13, var11 - var10, var12, var14);
            int var17 = 0;
            while (var17 < 4) {
                if (this.shouldRenderPass(var1, var17, var9)) {
                    this.renderPassModel.render(var16, var15, var13, var11 - var10, var12, var14);
                    GL11.glDisable((int)3042);
                    GL11.glEnable((int)3008);
                }
                ++var17;
            }
            this.renderEquippedItems(var1, var9);
            float var25 = var1.getEntityBrightness(var9);
            int var18 = this.getColorMultiplier(var1, var25, var9);
            if ((var18 >> 24 & 0xFF) > 0 || var1.hurtTime > 0 || var1.deathTime > 0) {
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDepthFunc((int)514);
                if (var1.hurtTime > 0 || var1.deathTime > 0) {
                    GL11.glColor4f((float)var25, (float)0.0f, (float)0.0f, (float)0.4f);
                    this.mainModel.render(var16, var15, var13, var11 - var10, var12, var14);
                    int var19 = 0;
                    while (var19 < 4) {
                        if (this.func_27005_b(var1, var19, var9)) {
                            GL11.glColor4f((float)var25, (float)0.0f, (float)0.0f, (float)0.4f);
                            this.renderPassModel.render(var16, var15, var13, var11 - var10, var12, var14);
                        }
                        ++var19;
                    }
                }
                if ((var18 >> 24 & 0xFF) > 0) {
                    float var26 = (float)(var18 >> 16 & 0xFF) / 255.0f;
                    float var20 = (float)(var18 >> 8 & 0xFF) / 255.0f;
                    float var21 = (float)(var18 & 0xFF) / 255.0f;
                    float var22 = (float)(var18 >> 24 & 0xFF) / 255.0f;
                    GL11.glColor4f((float)var26, (float)var20, (float)var21, (float)var22);
                    this.mainModel.render(var16, var15, var13, var11 - var10, var12, var14);
                    int var23 = 0;
                    while (var23 < 4) {
                        if (this.func_27005_b(var1, var23, var9)) {
                            GL11.glColor4f((float)var26, (float)var20, (float)var21, (float)var22);
                            this.renderPassModel.render(var16, var15, var13, var11 - var10, var12, var14);
                        }
                        ++var23;
                    }
                }
                GL11.glDepthFunc((int)515);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
            }
            GL11.glDisable((int)32826);
        }
        catch (Exception var24) {
            var24.printStackTrace();
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        this.passSpecialRender(var1, var2, var4, var6);
    }

    protected void func_22012_b(EntityLiving var1, double var2, double var4, double var6) {
        GL11.glTranslatef((float)((float)var2), (float)((float)var4), (float)((float)var6));
    }

    protected void rotateCorpse(EntityLiving var1, float var2, float var3, float var4) {
        GL11.glRotatef((float)(180.0f - var3), (float)0.0f, (float)1.0f, (float)0.0f);
        if (var1.deathTime > 0) {
            float var5 = ((float)var1.deathTime + var4 - 1.0f) / 20.0f * 1.6f;
            if ((var5 = MathHelper.sqrt_float(var5)) > 1.0f) {
                var5 = 1.0f;
            }
            GL11.glRotatef((float)(var5 * this.getDeathMaxRotation(var1)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected float func_167_c(EntityLiving var1, float var2) {
        return var1.getSwingProgress(var2);
    }

    protected float func_170_d(EntityLiving var1, float var2) {
        return (float)var1.ticksExisted + var2;
    }

    protected void renderEquippedItems(EntityLiving var1, float var2) {
    }

    protected boolean func_27005_b(EntityLiving var1, int var2, float var3) {
        return this.shouldRenderPass(var1, var2, var3);
    }

    protected boolean shouldRenderPass(EntityLiving var1, int var2, float var3) {
        return false;
    }

    protected float getDeathMaxRotation(EntityLiving var1) {
        return 90.0f;
    }

    protected int getColorMultiplier(EntityLiving var1, float var2, float var3) {
        return 0;
    }

    protected void preRenderCallback(EntityLiving var1, float var2) {
    }

    protected void passSpecialRender(EntityLiving var1, double var2, double var4, double var6) {
        if (Minecraft.isDebugInfoEnabled()) {
            this.renderLivingLabel(var1, Integer.toString(var1.entityId), var2, var4, var6, 64);
        }
    }

    protected void renderLivingLabel(EntityLiving var1, String var2, double var3, double var5, double var7, int var9) {
        float var10 = var1.getDistanceToEntity(this.renderManager.livingPlayer);
        if (var10 <= (float)var9) {
            FontRenderer var11 = this.getFontRendererFromRenderManager();
            float var12 = 1.6f;
            float var13 = 0.016666668f * var12;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)var3 + 0.0f), (float)((float)var5 + 2.3f), (float)((float)var7));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-var13), (float)(-var13), (float)var13);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            Tessellator var14 = Tessellator.instance;
            int var15 = 0;
            if (var2.equals("deadmau5")) {
                var15 = -10;
            }
            GL11.glDisable((int)3553);
            var14.startDrawingQuads();
            int var16 = var11.getStringWidth(var2) / 2;
            var14.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
            var14.addVertex(-var16 - 1, -1 + var15, 0.0);
            var14.addVertex(-var16 - 1, 8 + var15, 0.0);
            var14.addVertex(var16 + 1, 8 + var15, 0.0);
            var14.addVertex(var16 + 1, -1 + var15, 0.0);
            var14.draw();
            GL11.glEnable((int)3553);
            var11.drawString(var2, -var11.getStringWidth(var2) / 2, var15, 0x20FFFFFF);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            var11.drawString(var2, -var11.getStringWidth(var2) / 2, var15, -1);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    @Override
    public void doRender(Entity var1, double var2, double var4, double var6, float var8, float var9) {
        this.doRenderLiving((EntityLiving)var1, var2, var4, var6, var8, var9);
    }
}

