/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.renderer.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.src.client.gui.FontRenderer;
import net.minecraft.src.client.model.ModelBase2;
import net.minecraft.src.client.renderer.Tessellator;
import net.minecraft.src.client.renderer.entity.OpenGlHelper;
import net.minecraft.src.client.renderer.entity.Render;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityLiving;
import org.lwjgl.opengl.GL11;

public class RenderLiving2
extends Render {
    protected ModelBase2 mainModel;
    protected ModelBase2 renderPassModel;

    public RenderLiving2(ModelBase2 modelbase, float f) {
        this.mainModel = modelbase;
        this.shadowSize = f;
    }

    public void setRenderPassModel(ModelBase2 modelbase) {
        this.renderPassModel = modelbase;
    }

    public void doRenderLiving(EntityLiving entityliving, double d, double d1, double d2, float f, float f1) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        this.mainModel.onGround = this.renderSwingProgress(entityliving, f1);
        if (this.renderPassModel != null) {
            this.renderPassModel.onGround = this.mainModel.onGround;
        }
        this.mainModel.isRiding = entityliving.isRiding();
        if (this.renderPassModel != null) {
            this.renderPassModel.isRiding = this.mainModel.isRiding;
        }
        this.mainModel.field_40301_k = entityliving.func_40127_l();
        if (this.renderPassModel != null) {
            this.renderPassModel.field_40301_k = this.mainModel.field_40301_k;
        }
        try {
            float f2 = entityliving.prevRenderYawOffset + (entityliving.renderYawOffset - entityliving.prevRenderYawOffset) * f1;
            float f3 = entityliving.prevRotationYaw + (entityliving.rotationYaw - entityliving.prevRotationYaw) * f1;
            float f4 = entityliving.prevRotationPitch + (entityliving.rotationPitch - entityliving.prevRotationPitch) * f1;
            this.renderLivingAt(entityliving, d, d1, d2);
            float f5 = this.handleRotationFloat(entityliving, f1);
            this.rotateCorpse(entityliving, f5, f2, f1);
            float f6 = 0.0625f;
            GL11.glEnable((int)32826);
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
            this.preRenderCallback(entityliving, f1);
            GL11.glTranslatef((float)0.0f, (float)(-24.0f * f6 - 0.0078125f), (float)0.0f);
            float f7 = entityliving.field_705_Q + (entityliving.field_704_R - entityliving.field_705_Q) * f1;
            float f8 = entityliving.field_703_S - entityliving.field_704_R * (1.0f - f1);
            if (entityliving.func_40127_l()) {
                f8 *= 3.0f;
            }
            if (f7 > 1.0f) {
                f7 = 1.0f;
            }
            GL11.glEnable((int)3008);
            this.mainModel.setLivingAnimations(entityliving, f8, f7, f1);
            this.func_40270_a(entityliving, f8, f7, f5, f3 - f2, f4, f6);
            int i = 0;
            while (i < 4) {
                int j = this.shouldRenderPass(entityliving, i, f1);
                if (j > 0) {
                    this.renderPassModel.render(entityliving, f8, f7, f5, f3 - f2, f4, f6);
                    if (j == 15) {
                        float f10 = (float)entityliving.ticksExisted + f1;
                        GL11.glEnable((int)3042);
                        float f12 = 0.5f;
                        GL11.glColor4f((float)f12, (float)f12, (float)f12, (float)1.0f);
                        GL11.glDepthFunc((int)514);
                        GL11.glDepthMask((boolean)false);
                        int i1 = 0;
                        while (i1 < 2) {
                            GL11.glDisable((int)2896);
                            float f15 = 0.76f;
                            GL11.glColor4f((float)(0.5f * f15), (float)(0.25f * f15), (float)(0.8f * f15), (float)1.0f);
                            GL11.glBlendFunc((int)768, (int)1);
                            GL11.glMatrixMode((int)5890);
                            GL11.glLoadIdentity();
                            float f17 = f10 * (0.001f + (float)i1 * 0.003f) * 20.0f;
                            float f18 = 0.3333333f;
                            GL11.glScalef((float)f18, (float)f18, (float)f18);
                            GL11.glRotatef((float)(30.0f - (float)i1 * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                            GL11.glTranslatef((float)0.0f, (float)f17, (float)0.0f);
                            GL11.glMatrixMode((int)5888);
                            this.renderPassModel.render(entityliving, f8, f7, f5, f3 - f2, f4, f6);
                            ++i1;
                        }
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glMatrixMode((int)5890);
                        GL11.glDepthMask((boolean)true);
                        GL11.glLoadIdentity();
                        GL11.glMatrixMode((int)5888);
                        GL11.glEnable((int)2896);
                        GL11.glDisable((int)3042);
                        GL11.glDepthFunc((int)515);
                    }
                    GL11.glDisable((int)3042);
                    GL11.glEnable((int)3008);
                }
                ++i;
            }
            this.renderEquippedItems(entityliving, f1);
            float f9 = entityliving.getEntityBrightness(f1);
            int k = this.getColorMultiplier(entityliving, f9, f1);
            OpenGlHelper.setActiveTexture(OpenGlHelper.lightmapTexUnit);
            GL11.glDisable((int)3553);
            OpenGlHelper.setActiveTexture(OpenGlHelper.defaultTexUnit);
            if ((k >> 24 & 0xFF) > 0 || entityliving.hurtTime > 0 || entityliving.deathTime > 0) {
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDepthFunc((int)514);
                if (entityliving.hurtTime > 0 || entityliving.deathTime > 0) {
                    GL11.glColor4f((float)f9, (float)0.0f, (float)0.0f, (float)0.4f);
                    this.mainModel.render(entityliving, f8, f7, f5, f3 - f2, f4, f6);
                    int l = 0;
                    while (l < 4) {
                        if (this.inheritRenderPass(entityliving, l, f1) >= 0) {
                            GL11.glColor4f((float)f9, (float)0.0f, (float)0.0f, (float)0.4f);
                            this.renderPassModel.render(entityliving, f8, f7, f5, f3 - f2, f4, f6);
                        }
                        ++l;
                    }
                }
                if ((k >> 24 & 0xFF) > 0) {
                    float f11 = (float)(k >> 16 & 0xFF) / 255.0f;
                    float f13 = (float)(k >> 8 & 0xFF) / 255.0f;
                    float f14 = (float)(k & 0xFF) / 255.0f;
                    float f16 = (float)(k >> 24 & 0xFF) / 255.0f;
                    GL11.glColor4f((float)f11, (float)f13, (float)f14, (float)f16);
                    this.mainModel.render(entityliving, f8, f7, f5, f3 - f2, f4, f6);
                    int j1 = 0;
                    while (j1 < 4) {
                        if (this.inheritRenderPass(entityliving, j1, f1) >= 0) {
                            GL11.glColor4f((float)f11, (float)f13, (float)f14, (float)f16);
                            this.renderPassModel.render(entityliving, f8, f7, f5, f3 - f2, f4, f6);
                        }
                        ++j1;
                    }
                }
                GL11.glDepthFunc((int)515);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
            }
            GL11.glDisable((int)32826);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        OpenGlHelper.setActiveTexture(OpenGlHelper.lightmapTexUnit);
        GL11.glEnable((int)3553);
        OpenGlHelper.setActiveTexture(OpenGlHelper.defaultTexUnit);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        this.passSpecialRender(entityliving, d, d1, d2);
    }

    protected void func_40270_a(EntityLiving entityliving, float f, float f1, float f2, float f3, float f4, float f5) {
        this.loadDownloadableImageTexture(entityliving.skinUrl, entityliving.getEntityTexture());
        this.mainModel.render(entityliving, f, f1, f2, f3, f4, f5);
    }

    protected void renderLivingAt(EntityLiving entityliving, double d, double d1, double d2) {
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
    }

    protected void rotateCorpse(EntityLiving entityliving, float f, float f1, float f2) {
        GL11.glRotatef((float)(180.0f - f1), (float)0.0f, (float)1.0f, (float)0.0f);
        if (entityliving.deathTime > 0) {
            float f3 = ((float)entityliving.deathTime + f2 - 1.0f) / 20.0f * 1.6f;
            if ((f3 = MathHelper.sqrt_float(f3)) > 1.0f) {
                f3 = 1.0f;
            }
            GL11.glRotatef((float)(f3 * this.getDeathMaxRotation(entityliving)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected float renderSwingProgress(EntityLiving entityliving, float f) {
        return entityliving.getSwingProgress(f);
    }

    protected float handleRotationFloat(EntityLiving entityliving, float f) {
        return (float)entityliving.ticksExisted + f;
    }

    protected void renderEquippedItems(EntityLiving entityliving, float f) {
    }

    protected int inheritRenderPass(EntityLiving entityliving, int i, float f) {
        return this.shouldRenderPass(entityliving, i, f);
    }

    protected int shouldRenderPass(EntityLiving entityliving, int i, float f) {
        return -1;
    }

    protected float getDeathMaxRotation(EntityLiving entityliving) {
        return 90.0f;
    }

    protected int getColorMultiplier(EntityLiving entityliving, float f, float f1) {
        return 0;
    }

    protected void preRenderCallback(EntityLiving entityliving, float f) {
    }

    protected void passSpecialRender(EntityLiving entityliving, double d, double d1, double d2) {
        if (!Minecraft.isDebugInfoEnabled()) {
            // empty if block
        }
    }

    protected void renderLivingLabel(EntityLiving entityliving, String s, double d, double d1, double d2, int i) {
        float f = entityliving.getDistanceToEntity(this.renderManager.livingPlayer);
        if (f > (float)i) {
            return;
        }
        FontRenderer fontrenderer = this.getFontRendererFromRenderManager();
        float f1 = 1.6f;
        float f2 = 0.01666667f * f1;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d + 0.0f), (float)((float)d1 + 2.3f), (float)((float)d2));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-f2), (float)(-f2), (float)f2);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.instance;
        int byte0 = 0;
        if (s.equals("deadmau5")) {
            byte0 = -10;
        }
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        int j = fontrenderer.getStringWidth(s) / 2;
        tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
        tessellator.addVertex(-j - 1, -1 + byte0, 0.0);
        tessellator.addVertex(-j - 1, 8 + byte0, 0.0);
        tessellator.addVertex(j + 1, 8 + byte0, 0.0);
        tessellator.addVertex(j + 1, -1 + byte0, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
        fontrenderer.drawString(s, -fontrenderer.getStringWidth(s) / 2, byte0, 0x20FFFFFF);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        fontrenderer.drawString(s, -fontrenderer.getStringWidth(s) / 2, byte0, -1);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    @Override
    public void doRender(Entity entity, double d, double d1, double d2, float f, float f1) {
        this.doRenderLiving((EntityLiving)entity, d, d1, d2, f, f1);
    }
}

