/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.achievements;

import net.minecraft.src.game.achievements.AchievementList;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.stats.IStatStringFormat;
import net.minecraft.src.game.stats.StatBase;
import net.minecraft.src.game.stats.StatCollector;

public class Achievement
extends StatBase {
    public final int displayColumn;
    public final int displayRow;
    public final Achievement parentAchievement;
    private final String achievementDescription;
    private IStatStringFormat statStringFormatter;
    public final ItemStack theItemStack;
    private boolean isSpecial;

    public Achievement(int var1, String var2, int var3, int var4, Item var5, Achievement var6) {
        this(var1, var2, var3, var4, new ItemStack(var5), var6);
    }

    public Achievement(int var1, String var2, int var3, int var4, Block var5, Achievement var6) {
        this(var1, var2, var3, var4, new ItemStack(var5), var6);
    }

    public Achievement(int var1, String var2, int var3, int var4, ItemStack var5, Achievement var6) {
        super(0x500000 + var1, StatCollector.translateToLocal("achievement." + var2));
        this.theItemStack = var5;
        this.achievementDescription = StatCollector.translateToLocal("achievement." + var2 + ".desc");
        this.displayColumn = var3;
        this.displayRow = var4;
        if (var3 < AchievementList.minDisplayColumn) {
            AchievementList.minDisplayColumn = var3;
        }
        if (var4 < AchievementList.minDisplayRow) {
            AchievementList.minDisplayRow = var4;
        }
        if (var3 > AchievementList.maxDisplayColumn) {
            AchievementList.maxDisplayColumn = var3;
        }
        if (var4 > AchievementList.maxDisplayRow) {
            AchievementList.maxDisplayRow = var4;
        }
        this.parentAchievement = var6;
    }

    public Achievement func_27089_a() {
        this.field_27088_g = true;
        return this;
    }

    public Achievement setSpecial() {
        this.isSpecial = true;
        return this;
    }

    public Achievement registerAchievement() {
        super.registerStat();
        AchievementList.achievementList.add(this);
        return this;
    }

    @Override
    public boolean func_25067_a() {
        return true;
    }

    public String getDescription() {
        return this.statStringFormatter != null ? this.statStringFormatter.formatString(this.achievementDescription) : this.achievementDescription;
    }

    public Achievement setStatStringFormatter(IStatStringFormat var1) {
        this.statStringFormatter = var1;
        return this;
    }

    public boolean getSpecial() {
        return this.isSpecial;
    }

    @Override
    public StatBase registerStat() {
        return this.registerAchievement();
    }

    @Override
    public StatBase func_27082_h() {
        return this.func_27089_a();
    }
}

