/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockContainer;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.block.tileentity.TileEntityCauldron;
import net.minecraft.src.game.effect.Effect;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;

public class BlockCauldron
extends BlockContainer {
    public static int[] effectvalue = new int[]{283, 269, 326, 245, 349, 238, 293, 300, 253, 224, 219, 276, 235, 209, 365, 239, 269, 370, 346, 275, 345, 304, 312, 292, 240, 306, 395, 264, 302, 301, 209, 239, 214, 311, 385, 309, 275, 238, 346, 214, 369, 268, 252};
    public static int[] effectitem = new int[]{Item.sugar.itemID, Block.sponge.blockID, Block.dandelion.blockID, Block.roseRed.blockID, Block.roseCyan.blockID, Block.paeonia.blockID, Block.marigold.blockID, Block.deadBush.blockID, Block.shrub.blockID, Block.sapling.blockID, Block.saplingCrimson.blockID, Block.saplingFir.blockID, Block.mushroomRed.blockID, Block.mushroomBrown.blockID, Block.mushroomGlowing.blockID, Block.tallGrass.blockID, Block.fern.blockID, Block.cobweb.blockID, Block.caveRoots.blockID, Item.coal.itemID, Block.netherRoots.blockID, Item.diamond.itemID, Item.feather.itemID, Item.silk.itemID, Item.gunpowder.itemID, Item.flint.itemID, Item.seeds.itemID, Item.wheat.itemID, Item.clay.itemID, Item.egg.itemID, Item.snowball.itemID, Item.slimeBall.itemID, Item.bone.itemID, Item.leather.itemID, Item.potato.itemID, Item.carrotSeeds.itemID, Item.reed.itemID, Item.ash.itemID, Item.lightStoneDust.itemID, Item.waterlily.itemID, Item.lilypad.itemID, Item.cheddarCheese.itemID};

    protected BlockCauldron(int var1) {
        super(var1, Material.rock);
        this.blockIndexInTexture = 271;
    }

    @Override
    public int idDropped(int var1, Random var2) {
        return Block.cauldron.blockID;
    }

    @Override
    public int idPicked(World par1World, int par2, int par3, int par4) {
        return Block.cauldron.blockID;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 69;
    }

    @Override
    public void randomDisplayTick(World var1, int var2, int var3, int var4, Random var5) {
    }

    @Override
    public boolean blockActivated(World var1, int var2, int var3, int var4, EntityPlayer var5) {
        if (var5.isSneaking()) {
            return false;
        }
        TileEntityCauldron cauld = (TileEntityCauldron)var1.getBlockTileEntity(var2, var3, var4);
        if (!cauld.holdingpotion) {
            ItemStack stack = var5.getCurrentEquippedItem();
            if (stack != null && stack.itemID == Item.bucketWater.itemID) {
                cauld.holdingpotion = true;
                if (!var5.capabilities.depleteItems && !var1.multiplayerWorld) {
                    stack.itemID = Item.bucketEmpty.itemID;
                }
                var1.markBlockNeedsUpdate(var2, var3, var4);
                return true;
            }
        } else {
            ItemStack stack = var5.getCurrentEquippedItem();
            if (stack != null) {
                if (stack.getItem().itemID == Item.bottle.itemID && cauld.recipestage > 1) {
                    if (!var1.multiplayerWorld) {
                        var5.dropPlayerItem(new ItemStack(Item.potion, 1, cauld.curpotion));
                    }
                    cauld.curpotion = 0;
                    cauld.recipestage = 0;
                    cauld.previtem = 0;
                    cauld.holdingpotion = false;
                    var1.markBlockNeedsUpdate(var2, var3, var4);
                    return true;
                }
                int i = 0;
                while (i < effectitem.length) {
                    if (stack.getItem().itemID == effectitem[i] && cauld.previtem != stack.getItem().itemID) {
                        cauld.curpotion = Effect.convertDenseToLoose((Effect.convertLooseToDense(cauld.curpotion) + effectvalue[i]) % 225);
                        ++cauld.recipestage;
                        cauld.previtem = stack.getItem().itemID;
                        if (cauld.recipestage > 7) {
                            Random random = new Random();
                            int j = 0;
                            while (j < 500) {
                                float var7 = (float)var2 + 0.5f;
                                float var8 = 0.0f + random.nextFloat() - 0.5f;
                                float var81 = 0.0f + random.nextFloat() - 0.5f;
                                float var9 = (float)var4 + 0.5f;
                                var1.spawnParticle("smoke", var7 + var8, (double)var3 + 1.0, var9 + var81, random.nextDouble() - 0.5, random.nextDouble() - 0.5, random.nextDouble() - 0.5);
                                ++j;
                            }
                            cauld.curpotion = 0;
                            cauld.recipestage = 0;
                            cauld.previtem = 0;
                            cauld.holdingpotion = false;
                            var1.playSoundEffect(var2, var3, var4, "random.explode", 2.0f, 1.0f);
                        }
                        var1.markBlockNeedsUpdate(var2, var3, var4);
                        if (!var5.capabilities.depleteItems && !var1.multiplayerWorld) {
                            --stack.stackSize;
                        }
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityCauldron();
    }
}

